/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.BreakdownTypeSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BreakdownType BreakdownType}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class BreakdownTypeByKeyFluentHelper
    extends
    FluentHelperByKey<BreakdownTypeByKeyFluentHelper, BreakdownType, BreakdownTypeSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BreakdownType
     * BreakdownType} entity with the provided key field values. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BreakdownType}
     * @param servicePath
     *            Service path to be used to fetch a single {@code BreakdownType}
     * @param breakdownType
     *            Breakdown Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public BreakdownTypeByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String breakdownType )
    {
        super(servicePath, entityCollection);
        this.key.put("BreakdownType", breakdownType);
    }

    @Override
    @Nonnull
    protected Class<BreakdownType> getEntityClass()
    {
        return BreakdownType.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
