/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BreakdownTypeTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.BreakdownTypeTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.BreakdownTypeTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Breakdown Type - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BreakdownTypeTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BreakdownTypeText extends VdmEntity<BreakdownTypeText>
{

    /**
     * Selector for all available fields of BreakdownTypeText.
     *
     */
    public final static BreakdownTypeTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BreakdownTypeTextField<String> LANGUAGE = new BreakdownTypeTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownType</b>
     * </p>
     *
     * @return Breakdown Type
     */
    @Key
    @SerializedName( "BreakdownType" )
    @JsonProperty( "BreakdownType" )
    @Nullable
    @ODataField( odataName = "BreakdownType" )
    private String breakdownType;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownType</b> field to query operations.
     *
     */
    public final static BreakdownTypeTextField<String> BREAKDOWN_TYPE =
        new BreakdownTypeTextField<String>("BreakdownType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownTypeText</b>
     * </p>
     *
     * @return Breakdown Type Description
     */
    @SerializedName( "BreakdownTypeText" )
    @JsonProperty( "BreakdownTypeText" )
    @Nullable
    @ODataField( odataName = "BreakdownTypeText" )
    private String breakdownTypeText;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownTypeText</b> field to query operations.
     *
     */
    public final static BreakdownTypeTextField<String> BREAKDOWN_TYPE_TEXT =
        new BreakdownTypeTextField<String>("BreakdownTypeText");
    /**
     * Navigation property <b>to_CnsldtnBreakdownType</b> for <b>BreakdownTypeText</b> to single <b>BreakdownType</b>.
     *
     */
    @SerializedName( "to_CnsldtnBreakdownType" )
    @JsonProperty( "to_CnsldtnBreakdownType" )
    @ODataField( odataName = "to_CnsldtnBreakdownType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BreakdownType toCnsldtnBreakdownType;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnBreakdownType</b> navigation property to query
     * operations.
     *
     */
    public final static BreakdownTypeTextOneToOneLink<BreakdownType> TO_CNSLDTN_BREAKDOWN_TYPE =
        new BreakdownTypeTextOneToOneLink<BreakdownType>("to_CnsldtnBreakdownType");

    @Nonnull
    @Override
    public Class<BreakdownTypeText> getType()
    {
        return BreakdownTypeText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownType</b>
     * </p>
     *
     * @param breakdownType
     *            Breakdown Type
     */
    public void setBreakdownType( @Nullable final String breakdownType )
    {
        rememberChangedField("BreakdownType", this.breakdownType);
        this.breakdownType = breakdownType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownTypeText</b>
     * </p>
     *
     * @param breakdownTypeText
     *            Breakdown Type Description
     */
    public void setBreakdownTypeText( @Nullable final String breakdownTypeText )
    {
        rememberChangedField("BreakdownTypeText", this.breakdownTypeText);
        this.breakdownTypeText = breakdownTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BreakdownTypeText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("BreakdownType", getBreakdownType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("BreakdownType", getBreakdownType());
        values.put("BreakdownTypeText", getBreakdownTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("BreakdownType") ) {
                final Object value = values.remove("BreakdownType");
                if( (value == null) || (!value.equals(getBreakdownType())) ) {
                    setBreakdownType(((String) value));
                }
            }
            if( values.containsKey("BreakdownTypeText") ) {
                final Object value = values.remove("BreakdownTypeText");
                if( (value == null) || (!value.equals(getBreakdownTypeText())) ) {
                    setBreakdownTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnBreakdownType") ) {
                final Object value = (values).remove("to_CnsldtnBreakdownType");
                if( value instanceof Map ) {
                    if( toCnsldtnBreakdownType == null ) {
                        toCnsldtnBreakdownType = new BreakdownType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnBreakdownType.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BreakdownTypeTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BreakdownTypeTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BreakdownTypeTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BreakdownTypeTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnBreakdownType != null ) {
            (values).put("to_CnsldtnBreakdownType", toCnsldtnBreakdownType);
        }
        return values;
    }

    /**
     * Fetches the <b>BreakdownType</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnBreakdownType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BreakdownType</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BreakdownType fetchCnsldtnBreakdownType()
    {
        return fetchFieldAsSingle("to_CnsldtnBreakdownType", BreakdownType.class);
    }

    /**
     * Retrieval of associated <b>BreakdownType</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnBreakdownType</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBreakdownType</b> of a queried <b>BreakdownTypeText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BreakdownType</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BreakdownType getCnsldtnBreakdownTypeOrFetch()
    {
        if( toCnsldtnBreakdownType == null ) {
            toCnsldtnBreakdownType = fetchCnsldtnBreakdownType();
        }
        return toCnsldtnBreakdownType;
    }

    /**
     * Retrieval of associated <b>BreakdownType</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnBreakdownType</b>.
     * <p>
     * If the navigation property for an entity <b>BreakdownTypeText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnBreakdownType</b> is already loaded, the result
     *         will contain the <b>BreakdownType</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BreakdownType> getCnsldtnBreakdownTypeIfPresent()
    {
        return Option.of(toCnsldtnBreakdownType);
    }

    /**
     * Overwrites the associated <b>BreakdownType</b> entity for the loaded navigation property
     * <b>to_CnsldtnBreakdownType</b>.
     *
     * @param value
     *            New <b>BreakdownType</b> entity.
     */
    public void setCnsldtnBreakdownType( final BreakdownType value )
    {
        toCnsldtnBreakdownType = value;
    }

    /**
     * Helper class to allow for fluent creation of BreakdownTypeText instances.
     *
     */
    public final static class BreakdownTypeTextBuilder
    {

        private BreakdownType toCnsldtnBreakdownType;

        private BreakdownTypeText.BreakdownTypeTextBuilder toCnsldtnBreakdownType( final BreakdownType value )
        {
            toCnsldtnBreakdownType = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnBreakdownType</b> for <b>BreakdownTypeText</b> to single
         * <b>BreakdownType</b>.
         *
         * @param value
         *            The BreakdownType to build this BreakdownTypeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BreakdownTypeText.BreakdownTypeTextBuilder cnsldtnBreakdownType( final BreakdownType value )
        {
            return toCnsldtnBreakdownType(value);
        }

    }

}
