/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BusinessAreaField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.BusinessAreaLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.BusinessAreaSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Business Area
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BusinessAreaType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusinessArea extends VdmEntity<BusinessArea>
{

    /**
     * Selector for all available fields of BusinessArea.
     *
     */
    public final static BusinessAreaSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Consolidation Business Area
     */
    @Key
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static BusinessAreaField<String> BUSINESS_AREA = new BusinessAreaField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea_Text</b>
     * </p>
     *
     * @return Business Area Description
     */
    @SerializedName( "BusinessArea_Text" )
    @JsonProperty( "BusinessArea_Text" )
    @Nullable
    @ODataField( odataName = "BusinessArea_Text" )
    private String businessArea_Text;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea_Text</b> field to query operations.
     *
     */
    public final static BusinessAreaField<String> BUSINESS_AREA_TEXT =
        new BusinessAreaField<String>("BusinessArea_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static BusinessAreaField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new BusinessAreaField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnBusinessAreaHier</b> for <b>BusinessArea</b> to multiple
     * <b>BusinessAreaHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnBusinessAreaHier" )
    @JsonProperty( "to_CnsldtnBusinessAreaHier" )
    @ODataField( odataName = "to_CnsldtnBusinessAreaHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusinessAreaHier> toCnsldtnBusinessAreaHier;
    /**
     * Navigation property <b>to_CnsldtnBusinessAreaT</b> for <b>BusinessArea</b> to multiple <b>BusinessAreaText</b>.
     *
     */
    @SerializedName( "to_CnsldtnBusinessAreaT" )
    @JsonProperty( "to_CnsldtnBusinessAreaT" )
    @ODataField( odataName = "to_CnsldtnBusinessAreaT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusinessAreaText> toCnsldtnBusinessAreaT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnBusinessAreaHier</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessAreaLink<BusinessAreaHier> TO_CNSLDTN_BUSINESS_AREA_HIER =
        new BusinessAreaLink<BusinessAreaHier>("to_CnsldtnBusinessAreaHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnBusinessAreaT</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessAreaLink<BusinessAreaText> TO_CNSLDTN_BUSINESS_AREA_T =
        new BusinessAreaLink<BusinessAreaText>("to_CnsldtnBusinessAreaT");

    @Nonnull
    @Override
    public Class<BusinessArea> getType()
    {
        return BusinessArea.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Consolidation Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea_Text</b>
     * </p>
     *
     * @param businessArea_Text
     *            Business Area Description
     */
    public void setBusinessArea_Text( @Nullable final String businessArea_Text )
    {
        rememberChangedField("BusinessArea_Text", this.businessArea_Text);
        this.businessArea_Text = businessArea_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BusinessArea";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessArea", getBusinessArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessArea", getBusinessArea());
        values.put("BusinessArea_Text", getBusinessArea_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("BusinessArea_Text") ) {
                final Object value = values.remove("BusinessArea_Text");
                if( (value == null) || (!value.equals(getBusinessArea_Text())) ) {
                    setBusinessArea_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnBusinessAreaHier") ) {
                final Object value = (values).remove("to_CnsldtnBusinessAreaHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnBusinessAreaHier == null ) {
                        toCnsldtnBusinessAreaHier = Lists.newArrayList();
                    } else {
                        toCnsldtnBusinessAreaHier = Lists.newArrayList(toCnsldtnBusinessAreaHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusinessAreaHier entity;
                        if( toCnsldtnBusinessAreaHier.size() > i ) {
                            entity = toCnsldtnBusinessAreaHier.get(i);
                        } else {
                            entity = new BusinessAreaHier();
                            toCnsldtnBusinessAreaHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnBusinessAreaT") ) {
                final Object value = (values).remove("to_CnsldtnBusinessAreaT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnBusinessAreaT == null ) {
                        toCnsldtnBusinessAreaT = Lists.newArrayList();
                    } else {
                        toCnsldtnBusinessAreaT = Lists.newArrayList(toCnsldtnBusinessAreaT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusinessAreaText entity;
                        if( toCnsldtnBusinessAreaT.size() > i ) {
                            entity = toCnsldtnBusinessAreaT.get(i);
                        } else {
                            entity = new BusinessAreaText();
                            toCnsldtnBusinessAreaT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusinessAreaField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusinessAreaField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusinessAreaField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusinessAreaField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnBusinessAreaHier != null ) {
            (values).put("to_CnsldtnBusinessAreaHier", toCnsldtnBusinessAreaHier);
        }
        if( toCnsldtnBusinessAreaT != null ) {
            (values).put("to_CnsldtnBusinessAreaT", toCnsldtnBusinessAreaT);
        }
        return values;
    }

    /**
     * Fetches the <b>BusinessAreaHier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnBusinessAreaHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusinessAreaHier</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessAreaHier> fetchCnsldtnBusinessAreaHier()
    {
        return fetchFieldAsList("to_CnsldtnBusinessAreaHier", BusinessAreaHier.class);
    }

    /**
     * Retrieval of associated <b>BusinessAreaHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnBusinessAreaHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBusinessAreaHier</b> of a queried <b>BusinessArea</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessAreaHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessAreaHier> getCnsldtnBusinessAreaHierOrFetch()
    {
        if( toCnsldtnBusinessAreaHier == null ) {
            toCnsldtnBusinessAreaHier = fetchCnsldtnBusinessAreaHier();
        }
        return toCnsldtnBusinessAreaHier;
    }

    /**
     * Retrieval of associated <b>BusinessAreaHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnBusinessAreaHier</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessArea</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnBusinessAreaHier</b> is already loaded, the
     *         result will contain the <b>BusinessAreaHier</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusinessAreaHier>> getCnsldtnBusinessAreaHierIfPresent()
    {
        return Option.of(toCnsldtnBusinessAreaHier);
    }

    /**
     * Overwrites the list of associated <b>BusinessAreaHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnBusinessAreaHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBusinessAreaHier</b> of a queried <b>BusinessArea</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusinessAreaHier</b> entities.
     */
    public void setCnsldtnBusinessAreaHier( @Nonnull final List<BusinessAreaHier> value )
    {
        if( toCnsldtnBusinessAreaHier == null ) {
            toCnsldtnBusinessAreaHier = Lists.newArrayList();
        }
        toCnsldtnBusinessAreaHier.clear();
        toCnsldtnBusinessAreaHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusinessAreaHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnBusinessAreaHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBusinessAreaHier</b> of a queried <b>BusinessArea</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusinessAreaHier</b> entities.
     */
    public void addCnsldtnBusinessAreaHier( BusinessAreaHier... entity )
    {
        if( toCnsldtnBusinessAreaHier == null ) {
            toCnsldtnBusinessAreaHier = Lists.newArrayList();
        }
        toCnsldtnBusinessAreaHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusinessAreaText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnBusinessAreaT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusinessAreaText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessAreaText> fetchCnsldtnBusinessAreaT()
    {
        return fetchFieldAsList("to_CnsldtnBusinessAreaT", BusinessAreaText.class);
    }

    /**
     * Retrieval of associated <b>BusinessAreaText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnBusinessAreaT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBusinessAreaT</b> of a queried <b>BusinessArea</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessAreaText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessAreaText> getCnsldtnBusinessAreaTOrFetch()
    {
        if( toCnsldtnBusinessAreaT == null ) {
            toCnsldtnBusinessAreaT = fetchCnsldtnBusinessAreaT();
        }
        return toCnsldtnBusinessAreaT;
    }

    /**
     * Retrieval of associated <b>BusinessAreaText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnBusinessAreaT</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessArea</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnBusinessAreaT</b> is already loaded, the result
     *         will contain the <b>BusinessAreaText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusinessAreaText>> getCnsldtnBusinessAreaTIfPresent()
    {
        return Option.of(toCnsldtnBusinessAreaT);
    }

    /**
     * Overwrites the list of associated <b>BusinessAreaText</b> entities for the loaded navigation property
     * <b>to_CnsldtnBusinessAreaT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBusinessAreaT</b> of a queried <b>BusinessArea</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusinessAreaText</b> entities.
     */
    public void setCnsldtnBusinessAreaT( @Nonnull final List<BusinessAreaText> value )
    {
        if( toCnsldtnBusinessAreaT == null ) {
            toCnsldtnBusinessAreaT = Lists.newArrayList();
        }
        toCnsldtnBusinessAreaT.clear();
        toCnsldtnBusinessAreaT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusinessAreaText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnBusinessAreaT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBusinessAreaT</b> of a queried <b>BusinessArea</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusinessAreaText</b> entities.
     */
    public void addCnsldtnBusinessAreaT( BusinessAreaText... entity )
    {
        if( toCnsldtnBusinessAreaT == null ) {
            toCnsldtnBusinessAreaT = Lists.newArrayList();
        }
        toCnsldtnBusinessAreaT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BusinessArea instances.
     *
     */
    public final static class BusinessAreaBuilder
    {

        private List<BusinessAreaHier> toCnsldtnBusinessAreaHier = Lists.newArrayList();
        private List<BusinessAreaText> toCnsldtnBusinessAreaT = Lists.newArrayList();

        private BusinessArea.BusinessAreaBuilder toCnsldtnBusinessAreaHier( final List<BusinessAreaHier> value )
        {
            toCnsldtnBusinessAreaHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnBusinessAreaHier</b> for <b>BusinessArea</b> to multiple
         * <b>BusinessAreaHier</b>.
         *
         * @param value
         *            The BusinessAreaHiers to build this BusinessArea with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessArea.BusinessAreaBuilder cnsldtnBusinessAreaHier( BusinessAreaHier... value )
        {
            return toCnsldtnBusinessAreaHier(Lists.newArrayList(value));
        }

        private BusinessArea.BusinessAreaBuilder toCnsldtnBusinessAreaT( final List<BusinessAreaText> value )
        {
            toCnsldtnBusinessAreaT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnBusinessAreaT</b> for <b>BusinessArea</b> to multiple
         * <b>BusinessAreaText</b>.
         *
         * @param value
         *            The BusinessAreaTexts to build this BusinessArea with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessArea.BusinessAreaBuilder cnsldtnBusinessAreaT( BusinessAreaText... value )
        {
            return toCnsldtnBusinessAreaT(Lists.newArrayList(value));
        }

    }

}
