/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ChartOfAccountsTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ChartOfAccountsTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ChartOfAccountsTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined G/L Chart of Accounts - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ChartOfAccountsTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChartOfAccountsText extends VdmEntity<ChartOfAccountsText>
{

    /**
     * Selector for all available fields of ChartOfAccountsText.
     *
     */
    public final static ChartOfAccountsTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ChartOfAccountsTextField<String> LANGUAGE = new ChartOfAccountsTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return G/L Chart of Accounts
     */
    @Key
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static ChartOfAccountsTextField<String> CHART_OF_ACCOUNTS =
        new ChartOfAccountsTextField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccountsText</b>
     * </p>
     *
     * @return G/L Chart of Accounts Description
     */
    @SerializedName( "ChartOfAccountsText" )
    @JsonProperty( "ChartOfAccountsText" )
    @Nullable
    @ODataField( odataName = "ChartOfAccountsText" )
    private String chartOfAccountsText;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccountsText</b> field to query operations.
     *
     */
    public final static ChartOfAccountsTextField<String> CHART_OF_ACCOUNTS_TEXT =
        new ChartOfAccountsTextField<String>("ChartOfAccountsText");
    /**
     * Navigation property <b>to_CnsldtnGLChartOfAccounts</b> for <b>ChartOfAccountsText</b> to single
     * <b>ChartOfAccounts</b>.
     *
     */
    @SerializedName( "to_CnsldtnGLChartOfAccounts" )
    @JsonProperty( "to_CnsldtnGLChartOfAccounts" )
    @ODataField( odataName = "to_CnsldtnGLChartOfAccounts" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ChartOfAccounts toCnsldtnGLChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnGLChartOfAccounts</b> navigation property to query
     * operations.
     *
     */
    public final static ChartOfAccountsTextOneToOneLink<ChartOfAccounts> TO_CNSLDTN_GL_CHART_OF_ACCOUNTS =
        new ChartOfAccountsTextOneToOneLink<ChartOfAccounts>("to_CnsldtnGLChartOfAccounts");

    @Nonnull
    @Override
    public Class<ChartOfAccountsText> getType()
    {
        return ChartOfAccountsText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            G/L Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccountsText</b>
     * </p>
     *
     * @param chartOfAccountsText
     *            G/L Chart of Accounts Description
     */
    public void setChartOfAccountsText( @Nullable final String chartOfAccountsText )
    {
        rememberChangedField("ChartOfAccountsText", this.chartOfAccountsText);
        this.chartOfAccountsText = chartOfAccountsText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ChartOfAccountsText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("ChartOfAccounts", getChartOfAccounts());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("ChartOfAccountsText", getChartOfAccountsText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccountsText") ) {
                final Object value = values.remove("ChartOfAccountsText");
                if( (value == null) || (!value.equals(getChartOfAccountsText())) ) {
                    setChartOfAccountsText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnGLChartOfAccounts") ) {
                final Object value = (values).remove("to_CnsldtnGLChartOfAccounts");
                if( value instanceof Map ) {
                    if( toCnsldtnGLChartOfAccounts == null ) {
                        toCnsldtnGLChartOfAccounts = new ChartOfAccounts();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnGLChartOfAccounts.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ChartOfAccountsTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ChartOfAccountsTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChartOfAccountsTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChartOfAccountsTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnGLChartOfAccounts != null ) {
            (values).put("to_CnsldtnGLChartOfAccounts", toCnsldtnGLChartOfAccounts);
        }
        return values;
    }

    /**
     * Fetches the <b>ChartOfAccounts</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnGLChartOfAccounts</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ChartOfAccounts</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ChartOfAccounts fetchCnsldtnGLChartOfAccounts()
    {
        return fetchFieldAsSingle("to_CnsldtnGLChartOfAccounts", ChartOfAccounts.class);
    }

    /**
     * Retrieval of associated <b>ChartOfAccounts</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnGLChartOfAccounts</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGLChartOfAccounts</b> of a queried <b>ChartOfAccountsText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChartOfAccounts</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ChartOfAccounts getCnsldtnGLChartOfAccountsOrFetch()
    {
        if( toCnsldtnGLChartOfAccounts == null ) {
            toCnsldtnGLChartOfAccounts = fetchCnsldtnGLChartOfAccounts();
        }
        return toCnsldtnGLChartOfAccounts;
    }

    /**
     * Retrieval of associated <b>ChartOfAccounts</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnGLChartOfAccounts</b>.
     * <p>
     * If the navigation property for an entity <b>ChartOfAccountsText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnGLChartOfAccounts</b> is already loaded, the
     *         result will contain the <b>ChartOfAccounts</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ChartOfAccounts> getCnsldtnGLChartOfAccountsIfPresent()
    {
        return Option.of(toCnsldtnGLChartOfAccounts);
    }

    /**
     * Overwrites the associated <b>ChartOfAccounts</b> entity for the loaded navigation property
     * <b>to_CnsldtnGLChartOfAccounts</b>.
     *
     * @param value
     *            New <b>ChartOfAccounts</b> entity.
     */
    public void setCnsldtnGLChartOfAccounts( final ChartOfAccounts value )
    {
        toCnsldtnGLChartOfAccounts = value;
    }

    /**
     * Helper class to allow for fluent creation of ChartOfAccountsText instances.
     *
     */
    public final static class ChartOfAccountsTextBuilder
    {

        private ChartOfAccounts toCnsldtnGLChartOfAccounts;

        private ChartOfAccountsText.ChartOfAccountsTextBuilder toCnsldtnGLChartOfAccounts( final ChartOfAccounts value )
        {
            toCnsldtnGLChartOfAccounts = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnGLChartOfAccounts</b> for <b>ChartOfAccountsText</b> to single
         * <b>ChartOfAccounts</b>.
         *
         * @param value
         *            The ChartOfAccounts to build this ChartOfAccountsText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChartOfAccountsText.ChartOfAccountsTextBuilder cnsldtnGLChartOfAccounts( final ChartOfAccounts value )
        {
            return toCnsldtnGLChartOfAccounts(value);
        }

    }

}
