/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CnsldtnInvesteeUnitField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CnsldtnInvesteeUnitLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CnsldtnInvesteeUnitSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Investee Consolidation Unit
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CnsldtnInvesteeUnitType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CnsldtnInvesteeUnit extends VdmEntity<CnsldtnInvesteeUnit>
{

    /**
     * Selector for all available fields of CnsldtnInvesteeUnit.
     *
     */
    public final static CnsldtnInvesteeUnitSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @return Consolidation Unit
     */
    @Key
    @SerializedName( "ConsolidationUnit" )
    @JsonProperty( "ConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit" )
    private String consolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitField<String> CONSOLIDATION_UNIT =
        new CnsldtnInvesteeUnitField<String>("ConsolidationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit_Text</b>
     * </p>
     *
     * @return Investee Unit Description
     */
    @SerializedName( "ConsolidationUnit_Text" )
    @JsonProperty( "ConsolidationUnit_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit_Text" )
    private String consolidationUnit_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit_Text</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitField<String> CONSOLIDATION_UNIT_TEXT =
        new CnsldtnInvesteeUnitField<String>("ConsolidationUnit_Text");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLocalCurrency</b>
     * </p>
     *
     * @return Consolidation Local Currency
     */
    @SerializedName( "ConsolidationUnitLocalCurrency" )
    @JsonProperty( "ConsolidationUnitLocalCurrency" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitLocalCurrency" )
    private String consolidationUnitLocalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitLocalCurrency</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitField<String> CONSOLIDATION_UNIT_LOCAL_CURRENCY =
        new CnsldtnInvesteeUnitField<String>("ConsolidationUnitLocalCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLocalCurrency_Text</b>
     * </p>
     *
     * @return Transaction Currency Description
     */
    @SerializedName( "ConsolidationUnitLocalCurrency_Text" )
    @JsonProperty( "ConsolidationUnitLocalCurrency_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitLocalCurrency_Text" )
    private String consolidationUnitLocalCurrency_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitLocalCurrency_Text</b> field to query
     * operations.
     *
     */
    public final static CnsldtnInvesteeUnitField<String> CONSOLIDATION_UNIT_LOCAL_CURRENCY_TEXT =
        new CnsldtnInvesteeUnitField<String>("ConsolidationUnitLocalCurrency_Text");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region in Consolidation
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitField<String> COUNTRY = new CnsldtnInvesteeUnitField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Country_Text</b>
     * </p>
     *
     * @return Customer/Supplier Country/Region Description
     */
    @SerializedName( "Country_Text" )
    @JsonProperty( "Country_Text" )
    @Nullable
    @ODataField( odataName = "Country_Text" )
    private String country_Text;
    /**
     * Use with available fluent helpers to apply the <b>Country_Text</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitField<String> COUNTRY_TEXT =
        new CnsldtnInvesteeUnitField<String>("Country_Text");
    /**
     * Navigation property <b>to_CnsldtnInvesteeUnitHier</b> for <b>CnsldtnInvesteeUnit</b> to multiple
     * <b>CnsldtnInvesteeUnitHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnInvesteeUnitHier" )
    @JsonProperty( "to_CnsldtnInvesteeUnitHier" )
    @ODataField( odataName = "to_CnsldtnInvesteeUnitHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CnsldtnInvesteeUnitHier> toCnsldtnInvesteeUnitHier;
    /**
     * Navigation property <b>to_CnsldtnInvesteeUnitT</b> for <b>CnsldtnInvesteeUnit</b> to multiple
     * <b>CnsldtnInvesteeUnitText</b>.
     *
     */
    @SerializedName( "to_CnsldtnInvesteeUnitT" )
    @JsonProperty( "to_CnsldtnInvesteeUnitT" )
    @ODataField( odataName = "to_CnsldtnInvesteeUnitT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CnsldtnInvesteeUnitText> toCnsldtnInvesteeUnitT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnInvesteeUnitHier</b> navigation property to query
     * operations.
     *
     */
    public final static CnsldtnInvesteeUnitLink<CnsldtnInvesteeUnitHier> TO_CNSLDTN_INVESTEE_UNIT_HIER =
        new CnsldtnInvesteeUnitLink<CnsldtnInvesteeUnitHier>("to_CnsldtnInvesteeUnitHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnInvesteeUnitT</b> navigation property to query
     * operations.
     *
     */
    public final static CnsldtnInvesteeUnitLink<CnsldtnInvesteeUnitText> TO_CNSLDTN_INVESTEE_UNIT_T =
        new CnsldtnInvesteeUnitLink<CnsldtnInvesteeUnitText>("to_CnsldtnInvesteeUnitT");

    @Nonnull
    @Override
    public Class<CnsldtnInvesteeUnit> getType()
    {
        return CnsldtnInvesteeUnit.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @param consolidationUnit
     *            Consolidation Unit
     */
    public void setConsolidationUnit( @Nullable final String consolidationUnit )
    {
        rememberChangedField("ConsolidationUnit", this.consolidationUnit);
        this.consolidationUnit = consolidationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit_Text</b>
     * </p>
     *
     * @param consolidationUnit_Text
     *            Investee Unit Description
     */
    public void setConsolidationUnit_Text( @Nullable final String consolidationUnit_Text )
    {
        rememberChangedField("ConsolidationUnit_Text", this.consolidationUnit_Text);
        this.consolidationUnit_Text = consolidationUnit_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLocalCurrency</b>
     * </p>
     *
     * @param consolidationUnitLocalCurrency
     *            Consolidation Local Currency
     */
    public void setConsolidationUnitLocalCurrency( @Nullable final String consolidationUnitLocalCurrency )
    {
        rememberChangedField("ConsolidationUnitLocalCurrency", this.consolidationUnitLocalCurrency);
        this.consolidationUnitLocalCurrency = consolidationUnitLocalCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLocalCurrency_Text</b>
     * </p>
     *
     * @param consolidationUnitLocalCurrency_Text
     *            Transaction Currency Description
     */
    public void setConsolidationUnitLocalCurrency_Text( @Nullable final String consolidationUnitLocalCurrency_Text )
    {
        rememberChangedField("ConsolidationUnitLocalCurrency_Text", this.consolidationUnitLocalCurrency_Text);
        this.consolidationUnitLocalCurrency_Text = consolidationUnitLocalCurrency_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region in Consolidation
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Country_Text</b>
     * </p>
     *
     * @param country_Text
     *            Customer/Supplier Country/Region Description
     */
    public void setCountry_Text( @Nullable final String country_Text )
    {
        rememberChangedField("Country_Text", this.country_Text);
        this.country_Text = country_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CnsldtnInvesteeUnit";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationUnit", getConsolidationUnit());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationUnit", getConsolidationUnit());
        values.put("ConsolidationUnit_Text", getConsolidationUnit_Text());
        values.put("ConsolidationUnitLocalCurrency", getConsolidationUnitLocalCurrency());
        values.put("ConsolidationUnitLocalCurrency_Text", getConsolidationUnitLocalCurrency_Text());
        values.put("Country", getCountry());
        values.put("Country_Text", getCountry_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationUnit") ) {
                final Object value = values.remove("ConsolidationUnit");
                if( (value == null) || (!value.equals(getConsolidationUnit())) ) {
                    setConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnit_Text") ) {
                final Object value = values.remove("ConsolidationUnit_Text");
                if( (value == null) || (!value.equals(getConsolidationUnit_Text())) ) {
                    setConsolidationUnit_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitLocalCurrency") ) {
                final Object value = values.remove("ConsolidationUnitLocalCurrency");
                if( (value == null) || (!value.equals(getConsolidationUnitLocalCurrency())) ) {
                    setConsolidationUnitLocalCurrency(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitLocalCurrency_Text") ) {
                final Object value = values.remove("ConsolidationUnitLocalCurrency_Text");
                if( (value == null) || (!value.equals(getConsolidationUnitLocalCurrency_Text())) ) {
                    setConsolidationUnitLocalCurrency_Text(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("Country_Text") ) {
                final Object value = values.remove("Country_Text");
                if( (value == null) || (!value.equals(getCountry_Text())) ) {
                    setCountry_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnInvesteeUnitHier") ) {
                final Object value = (values).remove("to_CnsldtnInvesteeUnitHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnInvesteeUnitHier == null ) {
                        toCnsldtnInvesteeUnitHier = Lists.newArrayList();
                    } else {
                        toCnsldtnInvesteeUnitHier = Lists.newArrayList(toCnsldtnInvesteeUnitHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CnsldtnInvesteeUnitHier entity;
                        if( toCnsldtnInvesteeUnitHier.size() > i ) {
                            entity = toCnsldtnInvesteeUnitHier.get(i);
                        } else {
                            entity = new CnsldtnInvesteeUnitHier();
                            toCnsldtnInvesteeUnitHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnInvesteeUnitT") ) {
                final Object value = (values).remove("to_CnsldtnInvesteeUnitT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnInvesteeUnitT == null ) {
                        toCnsldtnInvesteeUnitT = Lists.newArrayList();
                    } else {
                        toCnsldtnInvesteeUnitT = Lists.newArrayList(toCnsldtnInvesteeUnitT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CnsldtnInvesteeUnitText entity;
                        if( toCnsldtnInvesteeUnitT.size() > i ) {
                            entity = toCnsldtnInvesteeUnitT.get(i);
                        } else {
                            entity = new CnsldtnInvesteeUnitText();
                            toCnsldtnInvesteeUnitT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CnsldtnInvesteeUnitField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CnsldtnInvesteeUnitField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CnsldtnInvesteeUnitField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CnsldtnInvesteeUnitField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnInvesteeUnitHier != null ) {
            (values).put("to_CnsldtnInvesteeUnitHier", toCnsldtnInvesteeUnitHier);
        }
        if( toCnsldtnInvesteeUnitT != null ) {
            (values).put("to_CnsldtnInvesteeUnitT", toCnsldtnInvesteeUnitT);
        }
        return values;
    }

    /**
     * Fetches the <b>CnsldtnInvesteeUnitHier</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnInvesteeUnitHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CnsldtnInvesteeUnitHier</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CnsldtnInvesteeUnitHier> fetchCnsldtnInvesteeUnitHier()
    {
        return fetchFieldAsList("to_CnsldtnInvesteeUnitHier", CnsldtnInvesteeUnitHier.class);
    }

    /**
     * Retrieval of associated <b>CnsldtnInvesteeUnitHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnInvesteeUnitHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInvesteeUnitHier</b> of a queried <b>CnsldtnInvesteeUnit</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CnsldtnInvesteeUnitHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CnsldtnInvesteeUnitHier> getCnsldtnInvesteeUnitHierOrFetch()
    {
        if( toCnsldtnInvesteeUnitHier == null ) {
            toCnsldtnInvesteeUnitHier = fetchCnsldtnInvesteeUnitHier();
        }
        return toCnsldtnInvesteeUnitHier;
    }

    /**
     * Retrieval of associated <b>CnsldtnInvesteeUnitHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnInvesteeUnitHier</b>.
     * <p>
     * If the navigation property for an entity <b>CnsldtnInvesteeUnit</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnInvesteeUnitHier</b> is already loaded, the
     *         result will contain the <b>CnsldtnInvesteeUnitHier</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CnsldtnInvesteeUnitHier>> getCnsldtnInvesteeUnitHierIfPresent()
    {
        return Option.of(toCnsldtnInvesteeUnitHier);
    }

    /**
     * Overwrites the list of associated <b>CnsldtnInvesteeUnitHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnInvesteeUnitHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInvesteeUnitHier</b> of a queried <b>CnsldtnInvesteeUnit</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CnsldtnInvesteeUnitHier</b> entities.
     */
    public void setCnsldtnInvesteeUnitHier( @Nonnull final List<CnsldtnInvesteeUnitHier> value )
    {
        if( toCnsldtnInvesteeUnitHier == null ) {
            toCnsldtnInvesteeUnitHier = Lists.newArrayList();
        }
        toCnsldtnInvesteeUnitHier.clear();
        toCnsldtnInvesteeUnitHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CnsldtnInvesteeUnitHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnInvesteeUnitHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInvesteeUnitHier</b> of a queried <b>CnsldtnInvesteeUnit</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CnsldtnInvesteeUnitHier</b> entities.
     */
    public void addCnsldtnInvesteeUnitHier( CnsldtnInvesteeUnitHier... entity )
    {
        if( toCnsldtnInvesteeUnitHier == null ) {
            toCnsldtnInvesteeUnitHier = Lists.newArrayList();
        }
        toCnsldtnInvesteeUnitHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CnsldtnInvesteeUnitText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnInvesteeUnitT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CnsldtnInvesteeUnitText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CnsldtnInvesteeUnitText> fetchCnsldtnInvesteeUnitT()
    {
        return fetchFieldAsList("to_CnsldtnInvesteeUnitT", CnsldtnInvesteeUnitText.class);
    }

    /**
     * Retrieval of associated <b>CnsldtnInvesteeUnitText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnInvesteeUnitT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInvesteeUnitT</b> of a queried <b>CnsldtnInvesteeUnit</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CnsldtnInvesteeUnitText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CnsldtnInvesteeUnitText> getCnsldtnInvesteeUnitTOrFetch()
    {
        if( toCnsldtnInvesteeUnitT == null ) {
            toCnsldtnInvesteeUnitT = fetchCnsldtnInvesteeUnitT();
        }
        return toCnsldtnInvesteeUnitT;
    }

    /**
     * Retrieval of associated <b>CnsldtnInvesteeUnitText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnInvesteeUnitT</b>.
     * <p>
     * If the navigation property for an entity <b>CnsldtnInvesteeUnit</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnInvesteeUnitT</b> is already loaded, the result
     *         will contain the <b>CnsldtnInvesteeUnitText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CnsldtnInvesteeUnitText>> getCnsldtnInvesteeUnitTIfPresent()
    {
        return Option.of(toCnsldtnInvesteeUnitT);
    }

    /**
     * Overwrites the list of associated <b>CnsldtnInvesteeUnitText</b> entities for the loaded navigation property
     * <b>to_CnsldtnInvesteeUnitT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInvesteeUnitT</b> of a queried <b>CnsldtnInvesteeUnit</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CnsldtnInvesteeUnitText</b> entities.
     */
    public void setCnsldtnInvesteeUnitT( @Nonnull final List<CnsldtnInvesteeUnitText> value )
    {
        if( toCnsldtnInvesteeUnitT == null ) {
            toCnsldtnInvesteeUnitT = Lists.newArrayList();
        }
        toCnsldtnInvesteeUnitT.clear();
        toCnsldtnInvesteeUnitT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CnsldtnInvesteeUnitText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnInvesteeUnitT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInvesteeUnitT</b> of a queried <b>CnsldtnInvesteeUnit</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CnsldtnInvesteeUnitText</b> entities.
     */
    public void addCnsldtnInvesteeUnitT( CnsldtnInvesteeUnitText... entity )
    {
        if( toCnsldtnInvesteeUnitT == null ) {
            toCnsldtnInvesteeUnitT = Lists.newArrayList();
        }
        toCnsldtnInvesteeUnitT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CnsldtnInvesteeUnit instances.
     *
     */
    public final static class CnsldtnInvesteeUnitBuilder
    {

        private List<CnsldtnInvesteeUnitHier> toCnsldtnInvesteeUnitHier = Lists.newArrayList();
        private List<CnsldtnInvesteeUnitText> toCnsldtnInvesteeUnitT = Lists.newArrayList();

        private CnsldtnInvesteeUnit.CnsldtnInvesteeUnitBuilder toCnsldtnInvesteeUnitHier(
            final List<CnsldtnInvesteeUnitHier> value )
        {
            toCnsldtnInvesteeUnitHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnInvesteeUnitHier</b> for <b>CnsldtnInvesteeUnit</b> to multiple
         * <b>CnsldtnInvesteeUnitHier</b>.
         *
         * @param value
         *            The CnsldtnInvesteeUnitHiers to build this CnsldtnInvesteeUnit with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CnsldtnInvesteeUnit.CnsldtnInvesteeUnitBuilder cnsldtnInvesteeUnitHier(
            CnsldtnInvesteeUnitHier... value )
        {
            return toCnsldtnInvesteeUnitHier(Lists.newArrayList(value));
        }

        private CnsldtnInvesteeUnit.CnsldtnInvesteeUnitBuilder toCnsldtnInvesteeUnitT(
            final List<CnsldtnInvesteeUnitText> value )
        {
            toCnsldtnInvesteeUnitT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnInvesteeUnitT</b> for <b>CnsldtnInvesteeUnit</b> to multiple
         * <b>CnsldtnInvesteeUnitText</b>.
         *
         * @param value
         *            The CnsldtnInvesteeUnitTexts to build this CnsldtnInvesteeUnit with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CnsldtnInvesteeUnit.CnsldtnInvesteeUnitBuilder cnsldtnInvesteeUnitT( CnsldtnInvesteeUnitText... value )
        {
            return toCnsldtnInvesteeUnitT(Lists.newArrayList(value));
        }

    }

}
