/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CnsldtnInvesteeUnitSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnInvesteeUnit
 * CnsldtnInvesteeUnit} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class CnsldtnInvesteeUnitByKeyFluentHelper
    extends
    FluentHelperByKey<CnsldtnInvesteeUnitByKeyFluentHelper, CnsldtnInvesteeUnit, CnsldtnInvesteeUnitSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnInvesteeUnit
     * CnsldtnInvesteeUnit} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CnsldtnInvesteeUnit}
     * @param servicePath
     *            Service path to be used to fetch a single {@code CnsldtnInvesteeUnit}
     * @param consolidationUnit
     *            Consolidation Unit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     */
    public CnsldtnInvesteeUnitByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String consolidationUnit )
    {
        super(servicePath, entityCollection);
        this.key.put("ConsolidationUnit", consolidationUnit);
    }

    @Override
    @Nonnull
    protected Class<CnsldtnInvesteeUnit> getEntityClass()
    {
        return CnsldtnInvesteeUnit.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
