/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CnsldtnInvesteeUnitHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CnsldtnInvesteeUnitHierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CnsldtnInvesteeUnitHierOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CnsldtnInvesteeUnitHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Investee Consolidation Unit Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CnsldtnInvesteeUnitHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CnsldtnInvesteeUnitHier extends VdmEntity<CnsldtnInvesteeUnitHier>
{

    /**
     * Selector for all available fields of CnsldtnInvesteeUnitHier.
     *
     */
    public final static CnsldtnInvesteeUnitHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitHierarchy</b>
     * </p>
     *
     * @return Hierarchy ID
     */
    @Key
    @SerializedName( "ConsolidationUnitHierarchy" )
    @JsonProperty( "ConsolidationUnitHierarchy" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitHierarchy" )
    private String consolidationUnitHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitHierarchy</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitHierField<String> CONSOLIDATION_UNIT_HIERARCHY =
        new CnsldtnInvesteeUnitHierField<String>("ConsolidationUnitHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Hierarchy node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitHierField<String> HIERARCHY_NODE =
        new CnsldtnInvesteeUnitHierField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Hierarchy node description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitHierField<String> HIERARCHY_NODE_TEXT =
        new CnsldtnInvesteeUnitHierField<String>("HierarchyNode_Text");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid To Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitHierField<LocalDateTime> VALIDITY_END_DATE =
        new CnsldtnInvesteeUnitHierField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitHierField<LocalDateTime> VALIDITY_START_DATE =
        new CnsldtnInvesteeUnitHierField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Hierarchy parent node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitHierField<String> PARENT_NODE =
        new CnsldtnInvesteeUnitHierField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @return Consolidation Unit
     */
    @SerializedName( "ConsolidationUnit" )
    @JsonProperty( "ConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit" )
    private String consolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitHierField<String> CONSOLIDATION_UNIT =
        new CnsldtnInvesteeUnitHierField<String>("ConsolidationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit_Text</b>
     * </p>
     *
     * @return Investee Unit Description
     */
    @SerializedName( "ConsolidationUnit_Text" )
    @JsonProperty( "ConsolidationUnit_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit_Text" )
    private String consolidationUnit_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit_Text</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitHierField<String> CONSOLIDATION_UNIT_TEXT =
        new CnsldtnInvesteeUnitHierField<String>("ConsolidationUnit_Text");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return Hierarchy Sequence Number
     */
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitHierField<String> SEQUENCE_NUMBER =
        new CnsldtnInvesteeUnitHierField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitHierField<String> HIERARCHY_NODE_LEVEL =
        new CnsldtnInvesteeUnitHierField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Hierarchy node type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitHierField<String> NODE_TYPE =
        new CnsldtnInvesteeUnitHierField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnInvesteeUnit</b> for <b>CnsldtnInvesteeUnitHier</b> to single
     * <b>CnsldtnInvesteeUnit</b>.
     *
     */
    @SerializedName( "to_CnsldtnInvesteeUnit" )
    @JsonProperty( "to_CnsldtnInvesteeUnit" )
    @ODataField( odataName = "to_CnsldtnInvesteeUnit" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CnsldtnInvesteeUnit toCnsldtnInvesteeUnit;
    /**
     * Navigation property <b>to_CnsldtnInvesteeUnitHierT</b> for <b>CnsldtnInvesteeUnitHier</b> to multiple
     * <b>CnsldtnInvesteeUnitHierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnInvesteeUnitHierT" )
    @JsonProperty( "to_CnsldtnInvesteeUnitHierT" )
    @ODataField( odataName = "to_CnsldtnInvesteeUnitHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CnsldtnInvesteeUnitHierText> toCnsldtnInvesteeUnitHierT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnInvesteeUnit</b> navigation property to query
     * operations.
     *
     */
    public final static CnsldtnInvesteeUnitHierOneToOneLink<CnsldtnInvesteeUnit> TO_CNSLDTN_INVESTEE_UNIT =
        new CnsldtnInvesteeUnitHierOneToOneLink<CnsldtnInvesteeUnit>("to_CnsldtnInvesteeUnit");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnInvesteeUnitHierT</b> navigation property to query
     * operations.
     *
     */
    public final static CnsldtnInvesteeUnitHierLink<CnsldtnInvesteeUnitHierText> TO_CNSLDTN_INVESTEE_UNIT_HIER_T =
        new CnsldtnInvesteeUnitHierLink<CnsldtnInvesteeUnitHierText>("to_CnsldtnInvesteeUnitHierT");

    @Nonnull
    @Override
    public Class<CnsldtnInvesteeUnitHier> getType()
    {
        return CnsldtnInvesteeUnitHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitHierarchy</b>
     * </p>
     *
     * @param consolidationUnitHierarchy
     *            Hierarchy ID
     */
    public void setConsolidationUnitHierarchy( @Nullable final String consolidationUnitHierarchy )
    {
        rememberChangedField("ConsolidationUnitHierarchy", this.consolidationUnitHierarchy);
        this.consolidationUnitHierarchy = consolidationUnitHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Hierarchy node description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Hierarchy parent node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @param consolidationUnit
     *            Consolidation Unit
     */
    public void setConsolidationUnit( @Nullable final String consolidationUnit )
    {
        rememberChangedField("ConsolidationUnit", this.consolidationUnit);
        this.consolidationUnit = consolidationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit_Text</b>
     * </p>
     *
     * @param consolidationUnit_Text
     *            Investee Unit Description
     */
    public void setConsolidationUnit_Text( @Nullable final String consolidationUnit_Text )
    {
        rememberChangedField("ConsolidationUnit_Text", this.consolidationUnit_Text);
        this.consolidationUnit_Text = consolidationUnit_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            Hierarchy Sequence Number
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CnsldtnInvesteeUnitHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationUnitHierarchy", getConsolidationUnitHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationUnitHierarchy", getConsolidationUnitHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ParentNode", getParentNode());
        values.put("ConsolidationUnit", getConsolidationUnit());
        values.put("ConsolidationUnit_Text", getConsolidationUnit_Text());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationUnitHierarchy") ) {
                final Object value = values.remove("ConsolidationUnitHierarchy");
                if( (value == null) || (!value.equals(getConsolidationUnitHierarchy())) ) {
                    setConsolidationUnitHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnit") ) {
                final Object value = values.remove("ConsolidationUnit");
                if( (value == null) || (!value.equals(getConsolidationUnit())) ) {
                    setConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnit_Text") ) {
                final Object value = values.remove("ConsolidationUnit_Text");
                if( (value == null) || (!value.equals(getConsolidationUnit_Text())) ) {
                    setConsolidationUnit_Text(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnInvesteeUnit") ) {
                final Object value = (values).remove("to_CnsldtnInvesteeUnit");
                if( value instanceof Map ) {
                    if( toCnsldtnInvesteeUnit == null ) {
                        toCnsldtnInvesteeUnit = new CnsldtnInvesteeUnit();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnInvesteeUnit.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnInvesteeUnitHierT") ) {
                final Object value = (values).remove("to_CnsldtnInvesteeUnitHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnInvesteeUnitHierT == null ) {
                        toCnsldtnInvesteeUnitHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnInvesteeUnitHierT = Lists.newArrayList(toCnsldtnInvesteeUnitHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CnsldtnInvesteeUnitHierText entity;
                        if( toCnsldtnInvesteeUnitHierT.size() > i ) {
                            entity = toCnsldtnInvesteeUnitHierT.get(i);
                        } else {
                            entity = new CnsldtnInvesteeUnitHierText();
                            toCnsldtnInvesteeUnitHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CnsldtnInvesteeUnitHierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CnsldtnInvesteeUnitHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CnsldtnInvesteeUnitHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CnsldtnInvesteeUnitHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnInvesteeUnit != null ) {
            (values).put("to_CnsldtnInvesteeUnit", toCnsldtnInvesteeUnit);
        }
        if( toCnsldtnInvesteeUnitHierT != null ) {
            (values).put("to_CnsldtnInvesteeUnitHierT", toCnsldtnInvesteeUnitHierT);
        }
        return values;
    }

    /**
     * Fetches the <b>CnsldtnInvesteeUnit</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnInvesteeUnit</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CnsldtnInvesteeUnit</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CnsldtnInvesteeUnit fetchCnsldtnInvesteeUnit()
    {
        return fetchFieldAsSingle("to_CnsldtnInvesteeUnit", CnsldtnInvesteeUnit.class);
    }

    /**
     * Retrieval of associated <b>CnsldtnInvesteeUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnInvesteeUnit</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInvesteeUnit</b> of a queried <b>CnsldtnInvesteeUnitHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CnsldtnInvesteeUnit</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CnsldtnInvesteeUnit getCnsldtnInvesteeUnitOrFetch()
    {
        if( toCnsldtnInvesteeUnit == null ) {
            toCnsldtnInvesteeUnit = fetchCnsldtnInvesteeUnit();
        }
        return toCnsldtnInvesteeUnit;
    }

    /**
     * Retrieval of associated <b>CnsldtnInvesteeUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnInvesteeUnit</b>.
     * <p>
     * If the navigation property for an entity <b>CnsldtnInvesteeUnitHier</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnInvesteeUnit</b> is already loaded, the result
     *         will contain the <b>CnsldtnInvesteeUnit</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CnsldtnInvesteeUnit> getCnsldtnInvesteeUnitIfPresent()
    {
        return Option.of(toCnsldtnInvesteeUnit);
    }

    /**
     * Overwrites the associated <b>CnsldtnInvesteeUnit</b> entity for the loaded navigation property
     * <b>to_CnsldtnInvesteeUnit</b>.
     *
     * @param value
     *            New <b>CnsldtnInvesteeUnit</b> entity.
     */
    public void setCnsldtnInvesteeUnit( final CnsldtnInvesteeUnit value )
    {
        toCnsldtnInvesteeUnit = value;
    }

    /**
     * Fetches the <b>CnsldtnInvesteeUnitHierText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnInvesteeUnitHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CnsldtnInvesteeUnitHierText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CnsldtnInvesteeUnitHierText> fetchCnsldtnInvesteeUnitHierT()
    {
        return fetchFieldAsList("to_CnsldtnInvesteeUnitHierT", CnsldtnInvesteeUnitHierText.class);
    }

    /**
     * Retrieval of associated <b>CnsldtnInvesteeUnitHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnInvesteeUnitHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInvesteeUnitHierT</b> of a queried <b>CnsldtnInvesteeUnitHier</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CnsldtnInvesteeUnitHierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CnsldtnInvesteeUnitHierText> getCnsldtnInvesteeUnitHierTOrFetch()
    {
        if( toCnsldtnInvesteeUnitHierT == null ) {
            toCnsldtnInvesteeUnitHierT = fetchCnsldtnInvesteeUnitHierT();
        }
        return toCnsldtnInvesteeUnitHierT;
    }

    /**
     * Retrieval of associated <b>CnsldtnInvesteeUnitHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnInvesteeUnitHierT</b>.
     * <p>
     * If the navigation property for an entity <b>CnsldtnInvesteeUnitHier</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnInvesteeUnitHierT</b> is already loaded, the
     *         result will contain the <b>CnsldtnInvesteeUnitHierText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CnsldtnInvesteeUnitHierText>> getCnsldtnInvesteeUnitHierTIfPresent()
    {
        return Option.of(toCnsldtnInvesteeUnitHierT);
    }

    /**
     * Overwrites the list of associated <b>CnsldtnInvesteeUnitHierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnInvesteeUnitHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInvesteeUnitHierT</b> of a queried <b>CnsldtnInvesteeUnitHier</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CnsldtnInvesteeUnitHierText</b> entities.
     */
    public void setCnsldtnInvesteeUnitHierT( @Nonnull final List<CnsldtnInvesteeUnitHierText> value )
    {
        if( toCnsldtnInvesteeUnitHierT == null ) {
            toCnsldtnInvesteeUnitHierT = Lists.newArrayList();
        }
        toCnsldtnInvesteeUnitHierT.clear();
        toCnsldtnInvesteeUnitHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CnsldtnInvesteeUnitHierText</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnInvesteeUnitHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInvesteeUnitHierT</b> of a queried <b>CnsldtnInvesteeUnitHier</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CnsldtnInvesteeUnitHierText</b> entities.
     */
    public void addCnsldtnInvesteeUnitHierT( CnsldtnInvesteeUnitHierText... entity )
    {
        if( toCnsldtnInvesteeUnitHierT == null ) {
            toCnsldtnInvesteeUnitHierT = Lists.newArrayList();
        }
        toCnsldtnInvesteeUnitHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CnsldtnInvesteeUnitHier instances.
     *
     */
    public final static class CnsldtnInvesteeUnitHierBuilder
    {

        private CnsldtnInvesteeUnit toCnsldtnInvesteeUnit;
        private List<CnsldtnInvesteeUnitHierText> toCnsldtnInvesteeUnitHierT = Lists.newArrayList();

        private CnsldtnInvesteeUnitHier.CnsldtnInvesteeUnitHierBuilder toCnsldtnInvesteeUnit(
            final CnsldtnInvesteeUnit value )
        {
            toCnsldtnInvesteeUnit = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnInvesteeUnit</b> for <b>CnsldtnInvesteeUnitHier</b> to single
         * <b>CnsldtnInvesteeUnit</b>.
         *
         * @param value
         *            The CnsldtnInvesteeUnit to build this CnsldtnInvesteeUnitHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CnsldtnInvesteeUnitHier.CnsldtnInvesteeUnitHierBuilder cnsldtnInvesteeUnit(
            final CnsldtnInvesteeUnit value )
        {
            return toCnsldtnInvesteeUnit(value);
        }

        private CnsldtnInvesteeUnitHier.CnsldtnInvesteeUnitHierBuilder toCnsldtnInvesteeUnitHierT(
            final List<CnsldtnInvesteeUnitHierText> value )
        {
            toCnsldtnInvesteeUnitHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnInvesteeUnitHierT</b> for <b>CnsldtnInvesteeUnitHier</b> to multiple
         * <b>CnsldtnInvesteeUnitHierText</b>.
         *
         * @param value
         *            The CnsldtnInvesteeUnitHierTexts to build this CnsldtnInvesteeUnitHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CnsldtnInvesteeUnitHier.CnsldtnInvesteeUnitHierBuilder cnsldtnInvesteeUnitHierT(
            CnsldtnInvesteeUnitHierText... value )
        {
            return toCnsldtnInvesteeUnitHierT(Lists.newArrayList(value));
        }

    }

}
