/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CnsldtnInvesteeUnitTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CnsldtnInvesteeUnitTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CnsldtnInvesteeUnitTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Investee Consolidation Unit - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CnsldtnInvesteeUnitTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CnsldtnInvesteeUnitText extends VdmEntity<CnsldtnInvesteeUnitText>
{

    /**
     * Selector for all available fields of CnsldtnInvesteeUnitText.
     *
     */
    public final static CnsldtnInvesteeUnitTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @return Consolidation Unit
     */
    @Key
    @SerializedName( "ConsolidationUnit" )
    @JsonProperty( "ConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit" )
    private String consolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitTextField<String> CONSOLIDATION_UNIT =
        new CnsldtnInvesteeUnitTextField<String>("ConsolidationUnit");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitTextField<String> LANGUAGE =
        new CnsldtnInvesteeUnitTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitText</b>
     * </p>
     *
     * @return Investee Unit Description
     */
    @SerializedName( "ConsolidationUnitText" )
    @JsonProperty( "ConsolidationUnitText" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitText" )
    private String consolidationUnitText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitText</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitTextField<String> CONSOLIDATION_UNIT_TEXT =
        new CnsldtnInvesteeUnitTextField<String>("ConsolidationUnitText");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLongText</b>
     * </p>
     *
     * @return Investee Unit Long Description
     */
    @SerializedName( "ConsolidationUnitLongText" )
    @JsonProperty( "ConsolidationUnitLongText" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitLongText" )
    private String consolidationUnitLongText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitLongText</b> field to query operations.
     *
     */
    public final static CnsldtnInvesteeUnitTextField<String> CONSOLIDATION_UNIT_LONG_TEXT =
        new CnsldtnInvesteeUnitTextField<String>("ConsolidationUnitLongText");
    /**
     * Navigation property <b>to_CnsldtnInvesteeUnit</b> for <b>CnsldtnInvesteeUnitText</b> to single
     * <b>CnsldtnInvesteeUnit</b>.
     *
     */
    @SerializedName( "to_CnsldtnInvesteeUnit" )
    @JsonProperty( "to_CnsldtnInvesteeUnit" )
    @ODataField( odataName = "to_CnsldtnInvesteeUnit" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CnsldtnInvesteeUnit toCnsldtnInvesteeUnit;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnInvesteeUnit</b> navigation property to query
     * operations.
     *
     */
    public final static CnsldtnInvesteeUnitTextOneToOneLink<CnsldtnInvesteeUnit> TO_CNSLDTN_INVESTEE_UNIT =
        new CnsldtnInvesteeUnitTextOneToOneLink<CnsldtnInvesteeUnit>("to_CnsldtnInvesteeUnit");

    @Nonnull
    @Override
    public Class<CnsldtnInvesteeUnitText> getType()
    {
        return CnsldtnInvesteeUnitText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @param consolidationUnit
     *            Consolidation Unit
     */
    public void setConsolidationUnit( @Nullable final String consolidationUnit )
    {
        rememberChangedField("ConsolidationUnit", this.consolidationUnit);
        this.consolidationUnit = consolidationUnit;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitText</b>
     * </p>
     *
     * @param consolidationUnitText
     *            Investee Unit Description
     */
    public void setConsolidationUnitText( @Nullable final String consolidationUnitText )
    {
        rememberChangedField("ConsolidationUnitText", this.consolidationUnitText);
        this.consolidationUnitText = consolidationUnitText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLongText</b>
     * </p>
     *
     * @param consolidationUnitLongText
     *            Investee Unit Long Description
     */
    public void setConsolidationUnitLongText( @Nullable final String consolidationUnitLongText )
    {
        rememberChangedField("ConsolidationUnitLongText", this.consolidationUnitLongText);
        this.consolidationUnitLongText = consolidationUnitLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CnsldtnInvesteeUnitText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationUnit", getConsolidationUnit());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationUnit", getConsolidationUnit());
        values.put("Language", getLanguage());
        values.put("ConsolidationUnitText", getConsolidationUnitText());
        values.put("ConsolidationUnitLongText", getConsolidationUnitLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationUnit") ) {
                final Object value = values.remove("ConsolidationUnit");
                if( (value == null) || (!value.equals(getConsolidationUnit())) ) {
                    setConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitText") ) {
                final Object value = values.remove("ConsolidationUnitText");
                if( (value == null) || (!value.equals(getConsolidationUnitText())) ) {
                    setConsolidationUnitText(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitLongText") ) {
                final Object value = values.remove("ConsolidationUnitLongText");
                if( (value == null) || (!value.equals(getConsolidationUnitLongText())) ) {
                    setConsolidationUnitLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnInvesteeUnit") ) {
                final Object value = (values).remove("to_CnsldtnInvesteeUnit");
                if( value instanceof Map ) {
                    if( toCnsldtnInvesteeUnit == null ) {
                        toCnsldtnInvesteeUnit = new CnsldtnInvesteeUnit();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnInvesteeUnit.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CnsldtnInvesteeUnitTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CnsldtnInvesteeUnitTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CnsldtnInvesteeUnitTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CnsldtnInvesteeUnitTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnInvesteeUnit != null ) {
            (values).put("to_CnsldtnInvesteeUnit", toCnsldtnInvesteeUnit);
        }
        return values;
    }

    /**
     * Fetches the <b>CnsldtnInvesteeUnit</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnInvesteeUnit</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CnsldtnInvesteeUnit</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CnsldtnInvesteeUnit fetchCnsldtnInvesteeUnit()
    {
        return fetchFieldAsSingle("to_CnsldtnInvesteeUnit", CnsldtnInvesteeUnit.class);
    }

    /**
     * Retrieval of associated <b>CnsldtnInvesteeUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnInvesteeUnit</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInvesteeUnit</b> of a queried <b>CnsldtnInvesteeUnitText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CnsldtnInvesteeUnit</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CnsldtnInvesteeUnit getCnsldtnInvesteeUnitOrFetch()
    {
        if( toCnsldtnInvesteeUnit == null ) {
            toCnsldtnInvesteeUnit = fetchCnsldtnInvesteeUnit();
        }
        return toCnsldtnInvesteeUnit;
    }

    /**
     * Retrieval of associated <b>CnsldtnInvesteeUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnInvesteeUnit</b>.
     * <p>
     * If the navigation property for an entity <b>CnsldtnInvesteeUnitText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnInvesteeUnit</b> is already loaded, the result
     *         will contain the <b>CnsldtnInvesteeUnit</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CnsldtnInvesteeUnit> getCnsldtnInvesteeUnitIfPresent()
    {
        return Option.of(toCnsldtnInvesteeUnit);
    }

    /**
     * Overwrites the associated <b>CnsldtnInvesteeUnit</b> entity for the loaded navigation property
     * <b>to_CnsldtnInvesteeUnit</b>.
     *
     * @param value
     *            New <b>CnsldtnInvesteeUnit</b> entity.
     */
    public void setCnsldtnInvesteeUnit( final CnsldtnInvesteeUnit value )
    {
        toCnsldtnInvesteeUnit = value;
    }

    /**
     * Helper class to allow for fluent creation of CnsldtnInvesteeUnitText instances.
     *
     */
    public final static class CnsldtnInvesteeUnitTextBuilder
    {

        private CnsldtnInvesteeUnit toCnsldtnInvesteeUnit;

        private CnsldtnInvesteeUnitText.CnsldtnInvesteeUnitTextBuilder toCnsldtnInvesteeUnit(
            final CnsldtnInvesteeUnit value )
        {
            toCnsldtnInvesteeUnit = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnInvesteeUnit</b> for <b>CnsldtnInvesteeUnitText</b> to single
         * <b>CnsldtnInvesteeUnit</b>.
         *
         * @param value
         *            The CnsldtnInvesteeUnit to build this CnsldtnInvesteeUnitText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CnsldtnInvesteeUnitText.CnsldtnInvesteeUnitTextBuilder cnsldtnInvesteeUnit(
            final CnsldtnInvesteeUnit value )
        {
            return toCnsldtnInvesteeUnit(value);
        }

    }

}
