/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CnsldtnOfInvestmentsActivityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CnsldtnOfInvestmentsActivityLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CnsldtnOfInvestmentsActivitySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation of Investments Activity
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CnsldtnOfInvestmentsActivityType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CnsldtnOfInvestmentsActivity extends VdmEntity<CnsldtnOfInvestmentsActivity>
{

    /**
     * Selector for all available fields of CnsldtnOfInvestmentsActivity.
     *
     */
    public final static CnsldtnOfInvestmentsActivitySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityType</b>
     * </p>
     *
     * @return Consolidation of Investments Activity
     */
    @Key
    @SerializedName( "InvestmentActivityType" )
    @JsonProperty( "InvestmentActivityType" )
    @Nullable
    @ODataField( odataName = "InvestmentActivityType" )
    private String investmentActivityType;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentActivityType</b> field to query operations.
     *
     */
    public final static CnsldtnOfInvestmentsActivityField<String> INVESTMENT_ACTIVITY_TYPE =
        new CnsldtnOfInvestmentsActivityField<String>("InvestmentActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityType_Text</b>
     * </p>
     *
     * @return Cnsldtn of Investments Activity Description
     */
    @SerializedName( "InvestmentActivityType_Text" )
    @JsonProperty( "InvestmentActivityType_Text" )
    @Nullable
    @ODataField( odataName = "InvestmentActivityType_Text" )
    private String investmentActivityType_Text;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentActivityType_Text</b> field to query operations.
     *
     */
    public final static CnsldtnOfInvestmentsActivityField<String> INVESTMENT_ACTIVITY_TYPE_TEXT =
        new CnsldtnOfInvestmentsActivityField<String>("InvestmentActivityType_Text");
    /**
     * Navigation property <b>to_CnsldtnOfInvestmentsActyT</b> for <b>CnsldtnOfInvestmentsActivity</b> to multiple
     * <b>CnsldtnOfInvestmentsActyText</b>.
     *
     */
    @SerializedName( "to_CnsldtnOfInvestmentsActyT" )
    @JsonProperty( "to_CnsldtnOfInvestmentsActyT" )
    @ODataField( odataName = "to_CnsldtnOfInvestmentsActyT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CnsldtnOfInvestmentsActyText> toCnsldtnOfInvestmentsActyT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnOfInvestmentsActyT</b> navigation property to query
     * operations.
     *
     */
    public final static CnsldtnOfInvestmentsActivityLink<CnsldtnOfInvestmentsActyText> TO_CNSLDTN_OF_INVESTMENTS_ACTY_T =
        new CnsldtnOfInvestmentsActivityLink<CnsldtnOfInvestmentsActyText>("to_CnsldtnOfInvestmentsActyT");

    @Nonnull
    @Override
    public Class<CnsldtnOfInvestmentsActivity> getType()
    {
        return CnsldtnOfInvestmentsActivity.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityType</b>
     * </p>
     *
     * @param investmentActivityType
     *            Consolidation of Investments Activity
     */
    public void setInvestmentActivityType( @Nullable final String investmentActivityType )
    {
        rememberChangedField("InvestmentActivityType", this.investmentActivityType);
        this.investmentActivityType = investmentActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityType_Text</b>
     * </p>
     *
     * @param investmentActivityType_Text
     *            Cnsldtn of Investments Activity Description
     */
    public void setInvestmentActivityType_Text( @Nullable final String investmentActivityType_Text )
    {
        rememberChangedField("InvestmentActivityType_Text", this.investmentActivityType_Text);
        this.investmentActivityType_Text = investmentActivityType_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CnsldtnOfInvestmentsActivity";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InvestmentActivityType", getInvestmentActivityType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InvestmentActivityType", getInvestmentActivityType());
        values.put("InvestmentActivityType_Text", getInvestmentActivityType_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InvestmentActivityType") ) {
                final Object value = values.remove("InvestmentActivityType");
                if( (value == null) || (!value.equals(getInvestmentActivityType())) ) {
                    setInvestmentActivityType(((String) value));
                }
            }
            if( values.containsKey("InvestmentActivityType_Text") ) {
                final Object value = values.remove("InvestmentActivityType_Text");
                if( (value == null) || (!value.equals(getInvestmentActivityType_Text())) ) {
                    setInvestmentActivityType_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnOfInvestmentsActyT") ) {
                final Object value = (values).remove("to_CnsldtnOfInvestmentsActyT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnOfInvestmentsActyT == null ) {
                        toCnsldtnOfInvestmentsActyT = Lists.newArrayList();
                    } else {
                        toCnsldtnOfInvestmentsActyT = Lists.newArrayList(toCnsldtnOfInvestmentsActyT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CnsldtnOfInvestmentsActyText entity;
                        if( toCnsldtnOfInvestmentsActyT.size() > i ) {
                            entity = toCnsldtnOfInvestmentsActyT.get(i);
                        } else {
                            entity = new CnsldtnOfInvestmentsActyText();
                            toCnsldtnOfInvestmentsActyT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CnsldtnOfInvestmentsActivityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CnsldtnOfInvestmentsActivityField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CnsldtnOfInvestmentsActivityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CnsldtnOfInvestmentsActivityField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnOfInvestmentsActyT != null ) {
            (values).put("to_CnsldtnOfInvestmentsActyT", toCnsldtnOfInvestmentsActyT);
        }
        return values;
    }

    /**
     * Fetches the <b>CnsldtnOfInvestmentsActyText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnOfInvestmentsActyT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CnsldtnOfInvestmentsActyText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CnsldtnOfInvestmentsActyText> fetchCnsldtnOfInvestmentsActyT()
    {
        return fetchFieldAsList("to_CnsldtnOfInvestmentsActyT", CnsldtnOfInvestmentsActyText.class);
    }

    /**
     * Retrieval of associated <b>CnsldtnOfInvestmentsActyText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnOfInvestmentsActyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnOfInvestmentsActyT</b> of a queried <b>CnsldtnOfInvestmentsActivity</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CnsldtnOfInvestmentsActyText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CnsldtnOfInvestmentsActyText> getCnsldtnOfInvestmentsActyTOrFetch()
    {
        if( toCnsldtnOfInvestmentsActyT == null ) {
            toCnsldtnOfInvestmentsActyT = fetchCnsldtnOfInvestmentsActyT();
        }
        return toCnsldtnOfInvestmentsActyT;
    }

    /**
     * Retrieval of associated <b>CnsldtnOfInvestmentsActyText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnOfInvestmentsActyT</b>.
     * <p>
     * If the navigation property for an entity <b>CnsldtnOfInvestmentsActivity</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnOfInvestmentsActyT</b> is already loaded, the
     *         result will contain the <b>CnsldtnOfInvestmentsActyText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CnsldtnOfInvestmentsActyText>> getCnsldtnOfInvestmentsActyTIfPresent()
    {
        return Option.of(toCnsldtnOfInvestmentsActyT);
    }

    /**
     * Overwrites the list of associated <b>CnsldtnOfInvestmentsActyText</b> entities for the loaded navigation property
     * <b>to_CnsldtnOfInvestmentsActyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnOfInvestmentsActyT</b> of a queried <b>CnsldtnOfInvestmentsActivity</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CnsldtnOfInvestmentsActyText</b> entities.
     */
    public void setCnsldtnOfInvestmentsActyT( @Nonnull final List<CnsldtnOfInvestmentsActyText> value )
    {
        if( toCnsldtnOfInvestmentsActyT == null ) {
            toCnsldtnOfInvestmentsActyT = Lists.newArrayList();
        }
        toCnsldtnOfInvestmentsActyT.clear();
        toCnsldtnOfInvestmentsActyT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CnsldtnOfInvestmentsActyText</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnOfInvestmentsActyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnOfInvestmentsActyT</b> of a queried <b>CnsldtnOfInvestmentsActivity</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CnsldtnOfInvestmentsActyText</b> entities.
     */
    public void addCnsldtnOfInvestmentsActyT( CnsldtnOfInvestmentsActyText... entity )
    {
        if( toCnsldtnOfInvestmentsActyT == null ) {
            toCnsldtnOfInvestmentsActyT = Lists.newArrayList();
        }
        toCnsldtnOfInvestmentsActyT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CnsldtnOfInvestmentsActivity instances.
     *
     */
    public final static class CnsldtnOfInvestmentsActivityBuilder
    {

        private List<CnsldtnOfInvestmentsActyText> toCnsldtnOfInvestmentsActyT = Lists.newArrayList();

        private CnsldtnOfInvestmentsActivity.CnsldtnOfInvestmentsActivityBuilder toCnsldtnOfInvestmentsActyT(
            final List<CnsldtnOfInvestmentsActyText> value )
        {
            toCnsldtnOfInvestmentsActyT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnOfInvestmentsActyT</b> for <b>CnsldtnOfInvestmentsActivity</b> to multiple
         * <b>CnsldtnOfInvestmentsActyText</b>.
         *
         * @param value
         *            The CnsldtnOfInvestmentsActyTexts to build this CnsldtnOfInvestmentsActivity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CnsldtnOfInvestmentsActivity.CnsldtnOfInvestmentsActivityBuilder cnsldtnOfInvestmentsActyT(
            CnsldtnOfInvestmentsActyText... value )
        {
            return toCnsldtnOfInvestmentsActyT(Lists.newArrayList(value));
        }

    }

}
