/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CnsldtnOfInvestmentsActyTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CnsldtnOfInvestmentsActyTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Investment Activity Type Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CnsldtnOfInvestmentsActyTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CnsldtnOfInvestmentsActyText extends VdmEntity<CnsldtnOfInvestmentsActyText>
{

    /**
     * Selector for all available fields of CnsldtnOfInvestmentsActyText.
     *
     */
    public final static CnsldtnOfInvestmentsActyTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CnsldtnOfInvestmentsActyTextField<String> LANGUAGE =
        new CnsldtnOfInvestmentsActyTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityType</b>
     * </p>
     *
     * @return Consolidation of Investments Activity
     */
    @Key
    @SerializedName( "InvestmentActivityType" )
    @JsonProperty( "InvestmentActivityType" )
    @Nullable
    @ODataField( odataName = "InvestmentActivityType" )
    private String investmentActivityType;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentActivityType</b> field to query operations.
     *
     */
    public final static CnsldtnOfInvestmentsActyTextField<String> INVESTMENT_ACTIVITY_TYPE =
        new CnsldtnOfInvestmentsActyTextField<String>("InvestmentActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityTypeText</b>
     * </p>
     *
     * @return Cnsldtn of Investments Activity Description
     */
    @SerializedName( "InvestmentActivityTypeText" )
    @JsonProperty( "InvestmentActivityTypeText" )
    @Nullable
    @ODataField( odataName = "InvestmentActivityTypeText" )
    private String investmentActivityTypeText;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentActivityTypeText</b> field to query operations.
     *
     */
    public final static CnsldtnOfInvestmentsActyTextField<String> INVESTMENT_ACTIVITY_TYPE_TEXT =
        new CnsldtnOfInvestmentsActyTextField<String>("InvestmentActivityTypeText");

    @Nonnull
    @Override
    public Class<CnsldtnOfInvestmentsActyText> getType()
    {
        return CnsldtnOfInvestmentsActyText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityType</b>
     * </p>
     *
     * @param investmentActivityType
     *            Consolidation of Investments Activity
     */
    public void setInvestmentActivityType( @Nullable final String investmentActivityType )
    {
        rememberChangedField("InvestmentActivityType", this.investmentActivityType);
        this.investmentActivityType = investmentActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityTypeText</b>
     * </p>
     *
     * @param investmentActivityTypeText
     *            Cnsldtn of Investments Activity Description
     */
    public void setInvestmentActivityTypeText( @Nullable final String investmentActivityTypeText )
    {
        rememberChangedField("InvestmentActivityTypeText", this.investmentActivityTypeText);
        this.investmentActivityTypeText = investmentActivityTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CnsldtnOfInvestmentsActyText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("InvestmentActivityType", getInvestmentActivityType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("InvestmentActivityType", getInvestmentActivityType());
        values.put("InvestmentActivityTypeText", getInvestmentActivityTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("InvestmentActivityType") ) {
                final Object value = values.remove("InvestmentActivityType");
                if( (value == null) || (!value.equals(getInvestmentActivityType())) ) {
                    setInvestmentActivityType(((String) value));
                }
            }
            if( values.containsKey("InvestmentActivityTypeText") ) {
                final Object value = values.remove("InvestmentActivityTypeText");
                if( (value == null) || (!value.equals(getInvestmentActivityTypeText())) ) {
                    setInvestmentActivityTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CnsldtnOfInvestmentsActyTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CnsldtnOfInvestmentsActyTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CnsldtnOfInvestmentsActyTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CnsldtnOfInvestmentsActyTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

}
