/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CnsldtnUnitForElimTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CnsldtnUnitForElimTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CnsldtnUnitForElimTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Unit for Elimination - Txt
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CnsldtnUnitForElimTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CnsldtnUnitForElimText extends VdmEntity<CnsldtnUnitForElimText>
{

    /**
     * Selector for all available fields of CnsldtnUnitForElimText.
     *
     */
    public final static CnsldtnUnitForElimTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @return Consolidation Elimination Member
     */
    @Key
    @SerializedName( "ConsolidationUnit" )
    @JsonProperty( "ConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit" )
    private String consolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit</b> field to query operations.
     *
     */
    public final static CnsldtnUnitForElimTextField<String> CONSOLIDATION_UNIT =
        new CnsldtnUnitForElimTextField<String>("ConsolidationUnit");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CnsldtnUnitForElimTextField<String> LANGUAGE =
        new CnsldtnUnitForElimTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnUnitForElimText</b>
     * </p>
     *
     * @return Consolidation Unit for Elimination Description
     */
    @SerializedName( "CnsldtnUnitForElimText" )
    @JsonProperty( "CnsldtnUnitForElimText" )
    @Nullable
    @ODataField( odataName = "CnsldtnUnitForElimText" )
    private String cnsldtnUnitForElimText;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnUnitForElimText</b> field to query operations.
     *
     */
    public final static CnsldtnUnitForElimTextField<String> CNSLDTN_UNIT_FOR_ELIM_TEXT =
        new CnsldtnUnitForElimTextField<String>("CnsldtnUnitForElimText");
    /**
     * Navigation property <b>to_CnsldtnUnitElim</b> for <b>CnsldtnUnitForElimText</b> to single
     * <b>CnsldtnUnitForElimination</b>.
     *
     */
    @SerializedName( "to_CnsldtnUnitElim" )
    @JsonProperty( "to_CnsldtnUnitElim" )
    @ODataField( odataName = "to_CnsldtnUnitElim" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CnsldtnUnitForElimination toCnsldtnUnitElim;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnUnitElim</b> navigation property to query operations.
     *
     */
    public final static CnsldtnUnitForElimTextOneToOneLink<CnsldtnUnitForElimination> TO_CNSLDTN_UNIT_ELIM =
        new CnsldtnUnitForElimTextOneToOneLink<CnsldtnUnitForElimination>("to_CnsldtnUnitElim");

    @Nonnull
    @Override
    public Class<CnsldtnUnitForElimText> getType()
    {
        return CnsldtnUnitForElimText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @param consolidationUnit
     *            Consolidation Elimination Member
     */
    public void setConsolidationUnit( @Nullable final String consolidationUnit )
    {
        rememberChangedField("ConsolidationUnit", this.consolidationUnit);
        this.consolidationUnit = consolidationUnit;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnUnitForElimText</b>
     * </p>
     *
     * @param cnsldtnUnitForElimText
     *            Consolidation Unit for Elimination Description
     */
    public void setCnsldtnUnitForElimText( @Nullable final String cnsldtnUnitForElimText )
    {
        rememberChangedField("CnsldtnUnitForElimText", this.cnsldtnUnitForElimText);
        this.cnsldtnUnitForElimText = cnsldtnUnitForElimText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CnsldtnUnitForElimText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationUnit", getConsolidationUnit());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationUnit", getConsolidationUnit());
        values.put("Language", getLanguage());
        values.put("CnsldtnUnitForElimText", getCnsldtnUnitForElimText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationUnit") ) {
                final Object value = values.remove("ConsolidationUnit");
                if( (value == null) || (!value.equals(getConsolidationUnit())) ) {
                    setConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("CnsldtnUnitForElimText") ) {
                final Object value = values.remove("CnsldtnUnitForElimText");
                if( (value == null) || (!value.equals(getCnsldtnUnitForElimText())) ) {
                    setCnsldtnUnitForElimText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnUnitElim") ) {
                final Object value = (values).remove("to_CnsldtnUnitElim");
                if( value instanceof Map ) {
                    if( toCnsldtnUnitElim == null ) {
                        toCnsldtnUnitElim = new CnsldtnUnitForElimination();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnUnitElim.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CnsldtnUnitForElimTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CnsldtnUnitForElimTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CnsldtnUnitForElimTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CnsldtnUnitForElimTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnUnitElim != null ) {
            (values).put("to_CnsldtnUnitElim", toCnsldtnUnitElim);
        }
        return values;
    }

    /**
     * Fetches the <b>CnsldtnUnitForElimination</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnUnitElim</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CnsldtnUnitForElimination</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CnsldtnUnitForElimination fetchCnsldtnUnitElim()
    {
        return fetchFieldAsSingle("to_CnsldtnUnitElim", CnsldtnUnitForElimination.class);
    }

    /**
     * Retrieval of associated <b>CnsldtnUnitForElimination</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitElim</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitElim</b> of a queried <b>CnsldtnUnitForElimText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CnsldtnUnitForElimination</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CnsldtnUnitForElimination getCnsldtnUnitElimOrFetch()
    {
        if( toCnsldtnUnitElim == null ) {
            toCnsldtnUnitElim = fetchCnsldtnUnitElim();
        }
        return toCnsldtnUnitElim;
    }

    /**
     * Retrieval of associated <b>CnsldtnUnitForElimination</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitElim</b>.
     * <p>
     * If the navigation property for an entity <b>CnsldtnUnitForElimText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnUnitElim</b> is already loaded, the result will
     *         contain the <b>CnsldtnUnitForElimination</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CnsldtnUnitForElimination> getCnsldtnUnitElimIfPresent()
    {
        return Option.of(toCnsldtnUnitElim);
    }

    /**
     * Overwrites the associated <b>CnsldtnUnitForElimination</b> entity for the loaded navigation property
     * <b>to_CnsldtnUnitElim</b>.
     *
     * @param value
     *            New <b>CnsldtnUnitForElimination</b> entity.
     */
    public void setCnsldtnUnitElim( final CnsldtnUnitForElimination value )
    {
        toCnsldtnUnitElim = value;
    }

    /**
     * Helper class to allow for fluent creation of CnsldtnUnitForElimText instances.
     *
     */
    public final static class CnsldtnUnitForElimTextBuilder
    {

        private CnsldtnUnitForElimination toCnsldtnUnitElim;

        private CnsldtnUnitForElimText.CnsldtnUnitForElimTextBuilder toCnsldtnUnitElim(
            final CnsldtnUnitForElimination value )
        {
            toCnsldtnUnitElim = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnUnitElim</b> for <b>CnsldtnUnitForElimText</b> to single
         * <b>CnsldtnUnitForElimination</b>.
         *
         * @param value
         *            The CnsldtnUnitForElimination to build this CnsldtnUnitForElimText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CnsldtnUnitForElimText.CnsldtnUnitForElimTextBuilder cnsldtnUnitElim(
            final CnsldtnUnitForElimination value )
        {
            return toCnsldtnUnitElim(value);
        }

    }

}
