/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CnsldtnUnitForEliminationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CnsldtnUnitForEliminationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CnsldtnUnitForEliminationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Unit for Elimination
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CnsldtnUnitForEliminationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CnsldtnUnitForElimination extends VdmEntity<CnsldtnUnitForElimination>
{

    /**
     * Selector for all available fields of CnsldtnUnitForElimination.
     *
     */
    public final static CnsldtnUnitForEliminationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @return Consolidation Elimination Member
     */
    @Key
    @SerializedName( "ConsolidationUnit" )
    @JsonProperty( "ConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit" )
    private String consolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit</b> field to query operations.
     *
     */
    public final static CnsldtnUnitForEliminationField<String> CONSOLIDATION_UNIT =
        new CnsldtnUnitForEliminationField<String>("ConsolidationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit_Text</b>
     * </p>
     *
     * @return Consolidation Unit for Elimination Description
     */
    @SerializedName( "ConsolidationUnit_Text" )
    @JsonProperty( "ConsolidationUnit_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit_Text" )
    private String consolidationUnit_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit_Text</b> field to query operations.
     *
     */
    public final static CnsldtnUnitForEliminationField<String> CONSOLIDATION_UNIT_TEXT =
        new CnsldtnUnitForEliminationField<String>("ConsolidationUnit_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static CnsldtnUnitForEliminationField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new CnsldtnUnitForEliminationField<String>("AdditionalMasterDataSource");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLocalCurrency</b>
     * </p>
     *
     * @return Consolidation Local Currency
     */
    @SerializedName( "ConsolidationUnitLocalCurrency" )
    @JsonProperty( "ConsolidationUnitLocalCurrency" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitLocalCurrency" )
    private String consolidationUnitLocalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitLocalCurrency</b> field to query operations.
     *
     */
    public final static CnsldtnUnitForEliminationField<String> CONSOLIDATION_UNIT_LOCAL_CURRENCY =
        new CnsldtnUnitForEliminationField<String>("ConsolidationUnitLocalCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLocalCurrency_Text</b>
     * </p>
     *
     * @return Transaction Currency Description
     */
    @SerializedName( "ConsolidationUnitLocalCurrency_Text" )
    @JsonProperty( "ConsolidationUnitLocalCurrency_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitLocalCurrency_Text" )
    private String consolidationUnitLocalCurrency_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitLocalCurrency_Text</b> field to query
     * operations.
     *
     */
    public final static CnsldtnUnitForEliminationField<String> CONSOLIDATION_UNIT_LOCAL_CURRENCY_TEXT =
        new CnsldtnUnitForEliminationField<String>("ConsolidationUnitLocalCurrency_Text");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static CnsldtnUnitForEliminationField<String> COUNTRY =
        new CnsldtnUnitForEliminationField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Country_Text</b>
     * </p>
     *
     * @return Customer/Supplier Country/Region Description
     */
    @SerializedName( "Country_Text" )
    @JsonProperty( "Country_Text" )
    @Nullable
    @ODataField( odataName = "Country_Text" )
    private String country_Text;
    /**
     * Use with available fluent helpers to apply the <b>Country_Text</b> field to query operations.
     *
     */
    public final static CnsldtnUnitForEliminationField<String> COUNTRY_TEXT =
        new CnsldtnUnitForEliminationField<String>("Country_Text");
    /**
     * Navigation property <b>to_CnsldtnUnitForEliminationT</b> for <b>CnsldtnUnitForElimination</b> to multiple
     * <b>CnsldtnUnitForElimText</b>.
     *
     */
    @SerializedName( "to_CnsldtnUnitForEliminationT" )
    @JsonProperty( "to_CnsldtnUnitForEliminationT" )
    @ODataField( odataName = "to_CnsldtnUnitForEliminationT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CnsldtnUnitForElimText> toCnsldtnUnitForEliminationT;
    /**
     * Navigation property <b>to_CnsldtnUnitHierForElim</b> for <b>CnsldtnUnitForElimination</b> to multiple
     * <b>CnsldtnUnitHierForElim</b>.
     *
     */
    @SerializedName( "to_CnsldtnUnitHierForElim" )
    @JsonProperty( "to_CnsldtnUnitHierForElim" )
    @ODataField( odataName = "to_CnsldtnUnitHierForElim" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CnsldtnUnitHierForElim> toCnsldtnUnitHierForElim;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnUnitForEliminationT</b> navigation property to query
     * operations.
     *
     */
    public final static CnsldtnUnitForEliminationLink<CnsldtnUnitForElimText> TO_CNSLDTN_UNIT_FOR_ELIMINATION_T =
        new CnsldtnUnitForEliminationLink<CnsldtnUnitForElimText>("to_CnsldtnUnitForEliminationT");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnUnitHierForElim</b> navigation property to query
     * operations.
     *
     */
    public final static CnsldtnUnitForEliminationLink<CnsldtnUnitHierForElim> TO_CNSLDTN_UNIT_HIER_FOR_ELIM =
        new CnsldtnUnitForEliminationLink<CnsldtnUnitHierForElim>("to_CnsldtnUnitHierForElim");

    @Nonnull
    @Override
    public Class<CnsldtnUnitForElimination> getType()
    {
        return CnsldtnUnitForElimination.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @param consolidationUnit
     *            Consolidation Elimination Member
     */
    public void setConsolidationUnit( @Nullable final String consolidationUnit )
    {
        rememberChangedField("ConsolidationUnit", this.consolidationUnit);
        this.consolidationUnit = consolidationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit_Text</b>
     * </p>
     *
     * @param consolidationUnit_Text
     *            Consolidation Unit for Elimination Description
     */
    public void setConsolidationUnit_Text( @Nullable final String consolidationUnit_Text )
    {
        rememberChangedField("ConsolidationUnit_Text", this.consolidationUnit_Text);
        this.consolidationUnit_Text = consolidationUnit_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLocalCurrency</b>
     * </p>
     *
     * @param consolidationUnitLocalCurrency
     *            Consolidation Local Currency
     */
    public void setConsolidationUnitLocalCurrency( @Nullable final String consolidationUnitLocalCurrency )
    {
        rememberChangedField("ConsolidationUnitLocalCurrency", this.consolidationUnitLocalCurrency);
        this.consolidationUnitLocalCurrency = consolidationUnitLocalCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLocalCurrency_Text</b>
     * </p>
     *
     * @param consolidationUnitLocalCurrency_Text
     *            Transaction Currency Description
     */
    public void setConsolidationUnitLocalCurrency_Text( @Nullable final String consolidationUnitLocalCurrency_Text )
    {
        rememberChangedField("ConsolidationUnitLocalCurrency_Text", this.consolidationUnitLocalCurrency_Text);
        this.consolidationUnitLocalCurrency_Text = consolidationUnitLocalCurrency_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Country_Text</b>
     * </p>
     *
     * @param country_Text
     *            Customer/Supplier Country/Region Description
     */
    public void setCountry_Text( @Nullable final String country_Text )
    {
        rememberChangedField("Country_Text", this.country_Text);
        this.country_Text = country_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CnsldtnUnitForElimination";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationUnit", getConsolidationUnit());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationUnit", getConsolidationUnit());
        values.put("ConsolidationUnit_Text", getConsolidationUnit_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        values.put("ConsolidationUnitLocalCurrency", getConsolidationUnitLocalCurrency());
        values.put("ConsolidationUnitLocalCurrency_Text", getConsolidationUnitLocalCurrency_Text());
        values.put("Country", getCountry());
        values.put("Country_Text", getCountry_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationUnit") ) {
                final Object value = values.remove("ConsolidationUnit");
                if( (value == null) || (!value.equals(getConsolidationUnit())) ) {
                    setConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnit_Text") ) {
                final Object value = values.remove("ConsolidationUnit_Text");
                if( (value == null) || (!value.equals(getConsolidationUnit_Text())) ) {
                    setConsolidationUnit_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitLocalCurrency") ) {
                final Object value = values.remove("ConsolidationUnitLocalCurrency");
                if( (value == null) || (!value.equals(getConsolidationUnitLocalCurrency())) ) {
                    setConsolidationUnitLocalCurrency(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitLocalCurrency_Text") ) {
                final Object value = values.remove("ConsolidationUnitLocalCurrency_Text");
                if( (value == null) || (!value.equals(getConsolidationUnitLocalCurrency_Text())) ) {
                    setConsolidationUnitLocalCurrency_Text(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("Country_Text") ) {
                final Object value = values.remove("Country_Text");
                if( (value == null) || (!value.equals(getCountry_Text())) ) {
                    setCountry_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnUnitForEliminationT") ) {
                final Object value = (values).remove("to_CnsldtnUnitForEliminationT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnUnitForEliminationT == null ) {
                        toCnsldtnUnitForEliminationT = Lists.newArrayList();
                    } else {
                        toCnsldtnUnitForEliminationT = Lists.newArrayList(toCnsldtnUnitForEliminationT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CnsldtnUnitForElimText entity;
                        if( toCnsldtnUnitForEliminationT.size() > i ) {
                            entity = toCnsldtnUnitForEliminationT.get(i);
                        } else {
                            entity = new CnsldtnUnitForElimText();
                            toCnsldtnUnitForEliminationT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnUnitHierForElim") ) {
                final Object value = (values).remove("to_CnsldtnUnitHierForElim");
                if( value instanceof Iterable ) {
                    if( toCnsldtnUnitHierForElim == null ) {
                        toCnsldtnUnitHierForElim = Lists.newArrayList();
                    } else {
                        toCnsldtnUnitHierForElim = Lists.newArrayList(toCnsldtnUnitHierForElim);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CnsldtnUnitHierForElim entity;
                        if( toCnsldtnUnitHierForElim.size() > i ) {
                            entity = toCnsldtnUnitHierForElim.get(i);
                        } else {
                            entity = new CnsldtnUnitHierForElim();
                            toCnsldtnUnitHierForElim.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CnsldtnUnitForEliminationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CnsldtnUnitForEliminationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CnsldtnUnitForEliminationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CnsldtnUnitForEliminationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnUnitForEliminationT != null ) {
            (values).put("to_CnsldtnUnitForEliminationT", toCnsldtnUnitForEliminationT);
        }
        if( toCnsldtnUnitHierForElim != null ) {
            (values).put("to_CnsldtnUnitHierForElim", toCnsldtnUnitHierForElim);
        }
        return values;
    }

    /**
     * Fetches the <b>CnsldtnUnitForElimText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnUnitForEliminationT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CnsldtnUnitForElimText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CnsldtnUnitForElimText> fetchCnsldtnUnitForEliminationT()
    {
        return fetchFieldAsList("to_CnsldtnUnitForEliminationT", CnsldtnUnitForElimText.class);
    }

    /**
     * Retrieval of associated <b>CnsldtnUnitForElimText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitForEliminationT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitForEliminationT</b> of a queried <b>CnsldtnUnitForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CnsldtnUnitForElimText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CnsldtnUnitForElimText> getCnsldtnUnitForEliminationTOrFetch()
    {
        if( toCnsldtnUnitForEliminationT == null ) {
            toCnsldtnUnitForEliminationT = fetchCnsldtnUnitForEliminationT();
        }
        return toCnsldtnUnitForEliminationT;
    }

    /**
     * Retrieval of associated <b>CnsldtnUnitForElimText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitForEliminationT</b>.
     * <p>
     * If the navigation property for an entity <b>CnsldtnUnitForElimination</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnUnitForEliminationT</b> is already loaded, the
     *         result will contain the <b>CnsldtnUnitForElimText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CnsldtnUnitForElimText>> getCnsldtnUnitForEliminationTIfPresent()
    {
        return Option.of(toCnsldtnUnitForEliminationT);
    }

    /**
     * Overwrites the list of associated <b>CnsldtnUnitForElimText</b> entities for the loaded navigation property
     * <b>to_CnsldtnUnitForEliminationT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitForEliminationT</b> of a queried <b>CnsldtnUnitForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CnsldtnUnitForElimText</b> entities.
     */
    public void setCnsldtnUnitForEliminationT( @Nonnull final List<CnsldtnUnitForElimText> value )
    {
        if( toCnsldtnUnitForEliminationT == null ) {
            toCnsldtnUnitForEliminationT = Lists.newArrayList();
        }
        toCnsldtnUnitForEliminationT.clear();
        toCnsldtnUnitForEliminationT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CnsldtnUnitForElimText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitForEliminationT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitForEliminationT</b> of a queried <b>CnsldtnUnitForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CnsldtnUnitForElimText</b> entities.
     */
    public void addCnsldtnUnitForEliminationT( CnsldtnUnitForElimText... entity )
    {
        if( toCnsldtnUnitForEliminationT == null ) {
            toCnsldtnUnitForEliminationT = Lists.newArrayList();
        }
        toCnsldtnUnitForEliminationT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CnsldtnUnitHierForElim</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnUnitHierForElim</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CnsldtnUnitHierForElim</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CnsldtnUnitHierForElim> fetchCnsldtnUnitHierForElim()
    {
        return fetchFieldAsList("to_CnsldtnUnitHierForElim", CnsldtnUnitHierForElim.class);
    }

    /**
     * Retrieval of associated <b>CnsldtnUnitHierForElim</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitHierForElim</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitHierForElim</b> of a queried <b>CnsldtnUnitForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CnsldtnUnitHierForElim</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CnsldtnUnitHierForElim> getCnsldtnUnitHierForElimOrFetch()
    {
        if( toCnsldtnUnitHierForElim == null ) {
            toCnsldtnUnitHierForElim = fetchCnsldtnUnitHierForElim();
        }
        return toCnsldtnUnitHierForElim;
    }

    /**
     * Retrieval of associated <b>CnsldtnUnitHierForElim</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitHierForElim</b>.
     * <p>
     * If the navigation property for an entity <b>CnsldtnUnitForElimination</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnUnitHierForElim</b> is already loaded, the result
     *         will contain the <b>CnsldtnUnitHierForElim</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CnsldtnUnitHierForElim>> getCnsldtnUnitHierForElimIfPresent()
    {
        return Option.of(toCnsldtnUnitHierForElim);
    }

    /**
     * Overwrites the list of associated <b>CnsldtnUnitHierForElim</b> entities for the loaded navigation property
     * <b>to_CnsldtnUnitHierForElim</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitHierForElim</b> of a queried <b>CnsldtnUnitForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CnsldtnUnitHierForElim</b> entities.
     */
    public void setCnsldtnUnitHierForElim( @Nonnull final List<CnsldtnUnitHierForElim> value )
    {
        if( toCnsldtnUnitHierForElim == null ) {
            toCnsldtnUnitHierForElim = Lists.newArrayList();
        }
        toCnsldtnUnitHierForElim.clear();
        toCnsldtnUnitHierForElim.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CnsldtnUnitHierForElim</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitHierForElim</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitHierForElim</b> of a queried <b>CnsldtnUnitForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CnsldtnUnitHierForElim</b> entities.
     */
    public void addCnsldtnUnitHierForElim( CnsldtnUnitHierForElim... entity )
    {
        if( toCnsldtnUnitHierForElim == null ) {
            toCnsldtnUnitHierForElim = Lists.newArrayList();
        }
        toCnsldtnUnitHierForElim.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CnsldtnUnitForElimination instances.
     *
     */
    public final static class CnsldtnUnitForEliminationBuilder
    {

        private List<CnsldtnUnitForElimText> toCnsldtnUnitForEliminationT = Lists.newArrayList();
        private List<CnsldtnUnitHierForElim> toCnsldtnUnitHierForElim = Lists.newArrayList();

        private CnsldtnUnitForElimination.CnsldtnUnitForEliminationBuilder toCnsldtnUnitForEliminationT(
            final List<CnsldtnUnitForElimText> value )
        {
            toCnsldtnUnitForEliminationT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnUnitForEliminationT</b> for <b>CnsldtnUnitForElimination</b> to multiple
         * <b>CnsldtnUnitForElimText</b>.
         *
         * @param value
         *            The CnsldtnUnitForElimTexts to build this CnsldtnUnitForElimination with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CnsldtnUnitForElimination.CnsldtnUnitForEliminationBuilder cnsldtnUnitForEliminationT(
            CnsldtnUnitForElimText... value )
        {
            return toCnsldtnUnitForEliminationT(Lists.newArrayList(value));
        }

        private CnsldtnUnitForElimination.CnsldtnUnitForEliminationBuilder toCnsldtnUnitHierForElim(
            final List<CnsldtnUnitHierForElim> value )
        {
            toCnsldtnUnitHierForElim.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnUnitHierForElim</b> for <b>CnsldtnUnitForElimination</b> to multiple
         * <b>CnsldtnUnitHierForElim</b>.
         *
         * @param value
         *            The CnsldtnUnitHierForElims to build this CnsldtnUnitForElimination with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CnsldtnUnitForElimination.CnsldtnUnitForEliminationBuilder cnsldtnUnitHierForElim(
            CnsldtnUnitHierForElim... value )
        {
            return toCnsldtnUnitHierForElim(Lists.newArrayList(value));
        }

    }

}
