/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationAllMDAttribTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationAllMDAttribTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationAllMDAttribTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * All Master Data Attribute - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationAllMDAttribTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationAllMDAttribText extends VdmEntity<ConsolidationAllMDAttribText>
{

    /**
     * Selector for all available fields of ConsolidationAllMDAttribText.
     *
     */
    public final static ConsolidationAllMDAttribTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeName</b>
     * </p>
     *
     * @return Characteristic Attribute
     */
    @Key
    @SerializedName( "ConsolidationAttributeName" )
    @JsonProperty( "ConsolidationAttributeName" )
    @Nullable
    @ODataField( odataName = "ConsolidationAttributeName" )
    private String consolidationAttributeName;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationAttributeName</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDAttribTextField<String> CONSOLIDATION_ATTRIBUTE_NAME =
        new ConsolidationAllMDAttribTextField<String>("ConsolidationAttributeName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationMDCharcName</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @Key
    @SerializedName( "ConsolidationMDCharcName" )
    @JsonProperty( "ConsolidationMDCharcName" )
    @Nullable
    @ODataField( odataName = "ConsolidationMDCharcName" )
    private String consolidationMDCharcName;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationMDCharcName</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDAttribTextField<String> CONSOLIDATION_MD_CHARC_NAME =
        new ConsolidationAllMDAttribTextField<String>("ConsolidationMDCharcName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDAttribTextField<String> LANGUAGE =
        new ConsolidationAllMDAttribTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeMedText</b>
     * </p>
     *
     * @return Medium Field Label
     */
    @SerializedName( "ConsolidationAttributeMedText" )
    @JsonProperty( "ConsolidationAttributeMedText" )
    @Nullable
    @ODataField( odataName = "ConsolidationAttributeMedText" )
    private String consolidationAttributeMedText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationAttributeMedText</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDAttribTextField<String> CONSOLIDATION_ATTRIBUTE_MED_TEXT =
        new ConsolidationAllMDAttribTextField<String>("ConsolidationAttributeMedText");
    /**
     * Navigation property <b>to_CnsldtnAllMD</b> for <b>ConsolidationAllMDAttribText</b> to single
     * <b>ConsolidationAllMasterData</b>.
     *
     */
    @SerializedName( "to_CnsldtnAllMD" )
    @JsonProperty( "to_CnsldtnAllMD" )
    @ODataField( odataName = "to_CnsldtnAllMD" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConsolidationAllMasterData toCnsldtnAllMD;
    /**
     * Navigation property <b>to_CnsldtnAllMDAttribute</b> for <b>ConsolidationAllMDAttribText</b> to single
     * <b>ConsolidationAllMDAttribute</b>.
     *
     */
    @SerializedName( "to_CnsldtnAllMDAttribute" )
    @JsonProperty( "to_CnsldtnAllMDAttribute" )
    @ODataField( odataName = "to_CnsldtnAllMDAttribute" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConsolidationAllMDAttribute toCnsldtnAllMDAttribute;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnAllMD</b> navigation property to query operations.
     *
     */
    public final static ConsolidationAllMDAttribTextOneToOneLink<ConsolidationAllMasterData> TO_CNSLDTN_ALL_MD =
        new ConsolidationAllMDAttribTextOneToOneLink<ConsolidationAllMasterData>("to_CnsldtnAllMD");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnAllMDAttribute</b> navigation property to query
     * operations.
     *
     */
    public final static ConsolidationAllMDAttribTextOneToOneLink<ConsolidationAllMDAttribute> TO_CNSLDTN_ALL_MD_ATTRIBUTE =
        new ConsolidationAllMDAttribTextOneToOneLink<ConsolidationAllMDAttribute>("to_CnsldtnAllMDAttribute");

    @Nonnull
    @Override
    public Class<ConsolidationAllMDAttribText> getType()
    {
        return ConsolidationAllMDAttribText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeName</b>
     * </p>
     *
     * @param consolidationAttributeName
     *            Characteristic Attribute
     */
    public void setConsolidationAttributeName( @Nullable final String consolidationAttributeName )
    {
        rememberChangedField("ConsolidationAttributeName", this.consolidationAttributeName);
        this.consolidationAttributeName = consolidationAttributeName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationMDCharcName</b>
     * </p>
     *
     * @param consolidationMDCharcName
     *            Characteristic Name
     */
    public void setConsolidationMDCharcName( @Nullable final String consolidationMDCharcName )
    {
        rememberChangedField("ConsolidationMDCharcName", this.consolidationMDCharcName);
        this.consolidationMDCharcName = consolidationMDCharcName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeMedText</b>
     * </p>
     *
     * @param consolidationAttributeMedText
     *            Medium Field Label
     */
    public void setConsolidationAttributeMedText( @Nullable final String consolidationAttributeMedText )
    {
        rememberChangedField("ConsolidationAttributeMedText", this.consolidationAttributeMedText);
        this.consolidationAttributeMedText = consolidationAttributeMedText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationAllMDAttribText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationAttributeName", getConsolidationAttributeName());
        result.put("ConsolidationMDCharcName", getConsolidationMDCharcName());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationAttributeName", getConsolidationAttributeName());
        values.put("ConsolidationMDCharcName", getConsolidationMDCharcName());
        values.put("Language", getLanguage());
        values.put("ConsolidationAttributeMedText", getConsolidationAttributeMedText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationAttributeName") ) {
                final Object value = values.remove("ConsolidationAttributeName");
                if( (value == null) || (!value.equals(getConsolidationAttributeName())) ) {
                    setConsolidationAttributeName(((String) value));
                }
            }
            if( values.containsKey("ConsolidationMDCharcName") ) {
                final Object value = values.remove("ConsolidationMDCharcName");
                if( (value == null) || (!value.equals(getConsolidationMDCharcName())) ) {
                    setConsolidationMDCharcName(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationAttributeMedText") ) {
                final Object value = values.remove("ConsolidationAttributeMedText");
                if( (value == null) || (!value.equals(getConsolidationAttributeMedText())) ) {
                    setConsolidationAttributeMedText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnAllMD") ) {
                final Object value = (values).remove("to_CnsldtnAllMD");
                if( value instanceof Map ) {
                    if( toCnsldtnAllMD == null ) {
                        toCnsldtnAllMD = new ConsolidationAllMasterData();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnAllMD.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnAllMDAttribute") ) {
                final Object value = (values).remove("to_CnsldtnAllMDAttribute");
                if( value instanceof Map ) {
                    if( toCnsldtnAllMDAttribute == null ) {
                        toCnsldtnAllMDAttribute = new ConsolidationAllMDAttribute();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnAllMDAttribute.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ConsolidationAllMDAttribTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationAllMDAttribTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationAllMDAttribTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationAllMDAttribTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnAllMD != null ) {
            (values).put("to_CnsldtnAllMD", toCnsldtnAllMD);
        }
        if( toCnsldtnAllMDAttribute != null ) {
            (values).put("to_CnsldtnAllMDAttribute", toCnsldtnAllMDAttribute);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationAllMasterData</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnAllMD</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ConsolidationAllMasterData</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationAllMasterData fetchCnsldtnAllMD()
    {
        return fetchFieldAsSingle("to_CnsldtnAllMD", ConsolidationAllMasterData.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationAllMasterData</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnAllMD</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnAllMD</b> of a queried <b>ConsolidationAllMDAttribText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationAllMasterData</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationAllMasterData getCnsldtnAllMDOrFetch()
    {
        if( toCnsldtnAllMD == null ) {
            toCnsldtnAllMD = fetchCnsldtnAllMD();
        }
        return toCnsldtnAllMD;
    }

    /**
     * Retrieval of associated <b>ConsolidationAllMasterData</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnAllMD</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationAllMDAttribText</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnAllMD</b> is already loaded, the result will
     *         contain the <b>ConsolidationAllMasterData</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConsolidationAllMasterData> getCnsldtnAllMDIfPresent()
    {
        return Option.of(toCnsldtnAllMD);
    }

    /**
     * Overwrites the associated <b>ConsolidationAllMasterData</b> entity for the loaded navigation property
     * <b>to_CnsldtnAllMD</b>.
     *
     * @param value
     *            New <b>ConsolidationAllMasterData</b> entity.
     */
    public void setCnsldtnAllMD( final ConsolidationAllMasterData value )
    {
        toCnsldtnAllMD = value;
    }

    /**
     * Fetches the <b>ConsolidationAllMDAttribute</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnAllMDAttribute</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ConsolidationAllMDAttribute</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationAllMDAttribute fetchCnsldtnAllMDAttribute()
    {
        return fetchFieldAsSingle("to_CnsldtnAllMDAttribute", ConsolidationAllMDAttribute.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationAllMDAttribute</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnAllMDAttribute</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnAllMDAttribute</b> of a queried <b>ConsolidationAllMDAttribText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationAllMDAttribute</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationAllMDAttribute getCnsldtnAllMDAttributeOrFetch()
    {
        if( toCnsldtnAllMDAttribute == null ) {
            toCnsldtnAllMDAttribute = fetchCnsldtnAllMDAttribute();
        }
        return toCnsldtnAllMDAttribute;
    }

    /**
     * Retrieval of associated <b>ConsolidationAllMDAttribute</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnAllMDAttribute</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationAllMDAttribText</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnAllMDAttribute</b> is already loaded, the result
     *         will contain the <b>ConsolidationAllMDAttribute</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConsolidationAllMDAttribute> getCnsldtnAllMDAttributeIfPresent()
    {
        return Option.of(toCnsldtnAllMDAttribute);
    }

    /**
     * Overwrites the associated <b>ConsolidationAllMDAttribute</b> entity for the loaded navigation property
     * <b>to_CnsldtnAllMDAttribute</b>.
     *
     * @param value
     *            New <b>ConsolidationAllMDAttribute</b> entity.
     */
    public void setCnsldtnAllMDAttribute( final ConsolidationAllMDAttribute value )
    {
        toCnsldtnAllMDAttribute = value;
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationAllMDAttribText instances.
     *
     */
    public final static class ConsolidationAllMDAttribTextBuilder
    {

        private ConsolidationAllMasterData toCnsldtnAllMD;
        private ConsolidationAllMDAttribute toCnsldtnAllMDAttribute;

        private ConsolidationAllMDAttribText.ConsolidationAllMDAttribTextBuilder toCnsldtnAllMD(
            final ConsolidationAllMasterData value )
        {
            toCnsldtnAllMD = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnAllMD</b> for <b>ConsolidationAllMDAttribText</b> to single
         * <b>ConsolidationAllMasterData</b>.
         *
         * @param value
         *            The ConsolidationAllMasterData to build this ConsolidationAllMDAttribText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationAllMDAttribText.ConsolidationAllMDAttribTextBuilder cnsldtnAllMD(
            final ConsolidationAllMasterData value )
        {
            return toCnsldtnAllMD(value);
        }

        private ConsolidationAllMDAttribText.ConsolidationAllMDAttribTextBuilder toCnsldtnAllMDAttribute(
            final ConsolidationAllMDAttribute value )
        {
            toCnsldtnAllMDAttribute = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnAllMDAttribute</b> for <b>ConsolidationAllMDAttribText</b> to single
         * <b>ConsolidationAllMDAttribute</b>.
         *
         * @param value
         *            The ConsolidationAllMDAttribute to build this ConsolidationAllMDAttribText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationAllMDAttribText.ConsolidationAllMDAttribTextBuilder cnsldtnAllMDAttribute(
            final ConsolidationAllMDAttribute value )
        {
            return toCnsldtnAllMDAttribute(value);
        }

    }

}
