/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationAllMDAttributeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationAllMDAttributeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationAllMDAttributeOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationAllMDAttributeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * All Master Data Attribute
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationAllMDAttributeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationAllMDAttribute extends VdmEntity<ConsolidationAllMDAttribute>
{

    /**
     * Selector for all available fields of ConsolidationAllMDAttribute.
     *
     */
    public final static ConsolidationAllMDAttributeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeName</b>
     * </p>
     *
     * @return Characteristic Attribute
     */
    @Key
    @SerializedName( "ConsolidationAttributeName" )
    @JsonProperty( "ConsolidationAttributeName" )
    @Nullable
    @ODataField( odataName = "ConsolidationAttributeName" )
    private String consolidationAttributeName;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationAttributeName</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDAttributeField<String> CONSOLIDATION_ATTRIBUTE_NAME =
        new ConsolidationAllMDAttributeField<String>("ConsolidationAttributeName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeName_Text</b>
     * </p>
     *
     * @return Medium Field Label
     */
    @SerializedName( "ConsolidationAttributeName_Text" )
    @JsonProperty( "ConsolidationAttributeName_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationAttributeName_Text" )
    private String consolidationAttributeName_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationAttributeName_Text</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDAttributeField<String> CONSOLIDATION_ATTRIBUTE_NAME_TEXT =
        new ConsolidationAllMDAttributeField<String>("ConsolidationAttributeName_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationMDCharcName</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @Key
    @SerializedName( "ConsolidationMDCharcName" )
    @JsonProperty( "ConsolidationMDCharcName" )
    @Nullable
    @ODataField( odataName = "ConsolidationMDCharcName" )
    private String consolidationMDCharcName;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationMDCharcName</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDAttributeField<String> CONSOLIDATION_MD_CHARC_NAME =
        new ConsolidationAllMDAttributeField<String>("ConsolidationMDCharcName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeSuprord</b>
     * </p>
     *
     * @return Superordinate Field
     */
    @SerializedName( "ConsolidationAttributeSuprord" )
    @JsonProperty( "ConsolidationAttributeSuprord" )
    @Nullable
    @ODataField( odataName = "ConsolidationAttributeSuprord" )
    private String consolidationAttributeSuprord;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationAttributeSuprord</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDAttributeField<String> CONSOLIDATION_ATTRIBUTE_SUPRORD =
        new ConsolidationAllMDAttributeField<String>("ConsolidationAttributeSuprord");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeSuprord2</b>
     * </p>
     *
     * @return Superordinate Field
     */
    @SerializedName( "ConsolidationAttributeSuprord2" )
    @JsonProperty( "ConsolidationAttributeSuprord2" )
    @Nullable
    @ODataField( odataName = "ConsolidationAttributeSuprord2" )
    private String consolidationAttributeSuprord2;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationAttributeSuprord2</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDAttributeField<String> CONSOLIDATION_ATTRIBUTE_SUPRORD2 =
        new ConsolidationAllMDAttributeField<String>("ConsolidationAttributeSuprord2");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeSuprord3</b>
     * </p>
     *
     * @return Superordinate Field
     */
    @SerializedName( "ConsolidationAttributeSuprord3" )
    @JsonProperty( "ConsolidationAttributeSuprord3" )
    @Nullable
    @ODataField( odataName = "ConsolidationAttributeSuprord3" )
    private String consolidationAttributeSuprord3;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationAttributeSuprord3</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDAttributeField<String> CONSOLIDATION_ATTRIBUTE_SUPRORD3 =
        new ConsolidationAllMDAttributeField<String>("ConsolidationAttributeSuprord3");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeSuprord4</b>
     * </p>
     *
     * @return Superordinate Field
     */
    @SerializedName( "ConsolidationAttributeSuprord4" )
    @JsonProperty( "ConsolidationAttributeSuprord4" )
    @Nullable
    @ODataField( odataName = "ConsolidationAttributeSuprord4" )
    private String consolidationAttributeSuprord4;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationAttributeSuprord4</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDAttributeField<String> CONSOLIDATION_ATTRIBUTE_SUPRORD4 =
        new ConsolidationAllMDAttributeField<String>("ConsolidationAttributeSuprord4");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeMultiVal</b>
     * </p>
     *
     * @return Multiple Values for Consolidation Characteristic Attribute
     */
    @SerializedName( "ConsolidationAttributeMultiVal" )
    @JsonProperty( "ConsolidationAttributeMultiVal" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConsolidationAttributeMultiVal" )
    private Boolean consolidationAttributeMultiVal;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationAttributeMultiVal</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDAttributeField<Boolean> CONSOLIDATION_ATTRIBUTE_MULTI_VAL =
        new ConsolidationAllMDAttributeField<Boolean>("ConsolidationAttributeMultiVal");
    /**
     * Navigation property <b>to_CnsldtnAllMD</b> for <b>ConsolidationAllMDAttribute</b> to single
     * <b>ConsolidationAllMasterData</b>.
     *
     */
    @SerializedName( "to_CnsldtnAllMD" )
    @JsonProperty( "to_CnsldtnAllMD" )
    @ODataField( odataName = "to_CnsldtnAllMD" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConsolidationAllMasterData toCnsldtnAllMD;
    /**
     * Navigation property <b>to_CnsldtnAllMDAttribT</b> for <b>ConsolidationAllMDAttribute</b> to multiple
     * <b>ConsolidationAllMDAttribText</b>.
     *
     */
    @SerializedName( "to_CnsldtnAllMDAttribT" )
    @JsonProperty( "to_CnsldtnAllMDAttribT" )
    @ODataField( odataName = "to_CnsldtnAllMDAttribT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConsolidationAllMDAttribText> toCnsldtnAllMDAttribT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnAllMD</b> navigation property to query operations.
     *
     */
    public final static ConsolidationAllMDAttributeOneToOneLink<ConsolidationAllMasterData> TO_CNSLDTN_ALL_MD =
        new ConsolidationAllMDAttributeOneToOneLink<ConsolidationAllMasterData>("to_CnsldtnAllMD");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnAllMDAttribT</b> navigation property to query
     * operations.
     *
     */
    public final static ConsolidationAllMDAttributeLink<ConsolidationAllMDAttribText> TO_CNSLDTN_ALL_MD_ATTRIB_T =
        new ConsolidationAllMDAttributeLink<ConsolidationAllMDAttribText>("to_CnsldtnAllMDAttribT");

    @Nonnull
    @Override
    public Class<ConsolidationAllMDAttribute> getType()
    {
        return ConsolidationAllMDAttribute.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeName</b>
     * </p>
     *
     * @param consolidationAttributeName
     *            Characteristic Attribute
     */
    public void setConsolidationAttributeName( @Nullable final String consolidationAttributeName )
    {
        rememberChangedField("ConsolidationAttributeName", this.consolidationAttributeName);
        this.consolidationAttributeName = consolidationAttributeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeName_Text</b>
     * </p>
     *
     * @param consolidationAttributeName_Text
     *            Medium Field Label
     */
    public void setConsolidationAttributeName_Text( @Nullable final String consolidationAttributeName_Text )
    {
        rememberChangedField("ConsolidationAttributeName_Text", this.consolidationAttributeName_Text);
        this.consolidationAttributeName_Text = consolidationAttributeName_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationMDCharcName</b>
     * </p>
     *
     * @param consolidationMDCharcName
     *            Characteristic Name
     */
    public void setConsolidationMDCharcName( @Nullable final String consolidationMDCharcName )
    {
        rememberChangedField("ConsolidationMDCharcName", this.consolidationMDCharcName);
        this.consolidationMDCharcName = consolidationMDCharcName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeSuprord</b>
     * </p>
     *
     * @param consolidationAttributeSuprord
     *            Superordinate Field
     */
    public void setConsolidationAttributeSuprord( @Nullable final String consolidationAttributeSuprord )
    {
        rememberChangedField("ConsolidationAttributeSuprord", this.consolidationAttributeSuprord);
        this.consolidationAttributeSuprord = consolidationAttributeSuprord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeSuprord2</b>
     * </p>
     *
     * @param consolidationAttributeSuprord2
     *            Superordinate Field
     */
    public void setConsolidationAttributeSuprord2( @Nullable final String consolidationAttributeSuprord2 )
    {
        rememberChangedField("ConsolidationAttributeSuprord2", this.consolidationAttributeSuprord2);
        this.consolidationAttributeSuprord2 = consolidationAttributeSuprord2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeSuprord3</b>
     * </p>
     *
     * @param consolidationAttributeSuprord3
     *            Superordinate Field
     */
    public void setConsolidationAttributeSuprord3( @Nullable final String consolidationAttributeSuprord3 )
    {
        rememberChangedField("ConsolidationAttributeSuprord3", this.consolidationAttributeSuprord3);
        this.consolidationAttributeSuprord3 = consolidationAttributeSuprord3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeSuprord4</b>
     * </p>
     *
     * @param consolidationAttributeSuprord4
     *            Superordinate Field
     */
    public void setConsolidationAttributeSuprord4( @Nullable final String consolidationAttributeSuprord4 )
    {
        rememberChangedField("ConsolidationAttributeSuprord4", this.consolidationAttributeSuprord4);
        this.consolidationAttributeSuprord4 = consolidationAttributeSuprord4;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAttributeMultiVal</b>
     * </p>
     *
     * @param consolidationAttributeMultiVal
     *            Multiple Values for Consolidation Characteristic Attribute
     */
    public void setConsolidationAttributeMultiVal( @Nullable final Boolean consolidationAttributeMultiVal )
    {
        rememberChangedField("ConsolidationAttributeMultiVal", this.consolidationAttributeMultiVal);
        this.consolidationAttributeMultiVal = consolidationAttributeMultiVal;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationAllMDAttribute";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationAttributeName", getConsolidationAttributeName());
        result.put("ConsolidationMDCharcName", getConsolidationMDCharcName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationAttributeName", getConsolidationAttributeName());
        values.put("ConsolidationAttributeName_Text", getConsolidationAttributeName_Text());
        values.put("ConsolidationMDCharcName", getConsolidationMDCharcName());
        values.put("ConsolidationAttributeSuprord", getConsolidationAttributeSuprord());
        values.put("ConsolidationAttributeSuprord2", getConsolidationAttributeSuprord2());
        values.put("ConsolidationAttributeSuprord3", getConsolidationAttributeSuprord3());
        values.put("ConsolidationAttributeSuprord4", getConsolidationAttributeSuprord4());
        values.put("ConsolidationAttributeMultiVal", getConsolidationAttributeMultiVal());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationAttributeName") ) {
                final Object value = values.remove("ConsolidationAttributeName");
                if( (value == null) || (!value.equals(getConsolidationAttributeName())) ) {
                    setConsolidationAttributeName(((String) value));
                }
            }
            if( values.containsKey("ConsolidationAttributeName_Text") ) {
                final Object value = values.remove("ConsolidationAttributeName_Text");
                if( (value == null) || (!value.equals(getConsolidationAttributeName_Text())) ) {
                    setConsolidationAttributeName_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationMDCharcName") ) {
                final Object value = values.remove("ConsolidationMDCharcName");
                if( (value == null) || (!value.equals(getConsolidationMDCharcName())) ) {
                    setConsolidationMDCharcName(((String) value));
                }
            }
            if( values.containsKey("ConsolidationAttributeSuprord") ) {
                final Object value = values.remove("ConsolidationAttributeSuprord");
                if( (value == null) || (!value.equals(getConsolidationAttributeSuprord())) ) {
                    setConsolidationAttributeSuprord(((String) value));
                }
            }
            if( values.containsKey("ConsolidationAttributeSuprord2") ) {
                final Object value = values.remove("ConsolidationAttributeSuprord2");
                if( (value == null) || (!value.equals(getConsolidationAttributeSuprord2())) ) {
                    setConsolidationAttributeSuprord2(((String) value));
                }
            }
            if( values.containsKey("ConsolidationAttributeSuprord3") ) {
                final Object value = values.remove("ConsolidationAttributeSuprord3");
                if( (value == null) || (!value.equals(getConsolidationAttributeSuprord3())) ) {
                    setConsolidationAttributeSuprord3(((String) value));
                }
            }
            if( values.containsKey("ConsolidationAttributeSuprord4") ) {
                final Object value = values.remove("ConsolidationAttributeSuprord4");
                if( (value == null) || (!value.equals(getConsolidationAttributeSuprord4())) ) {
                    setConsolidationAttributeSuprord4(((String) value));
                }
            }
            if( values.containsKey("ConsolidationAttributeMultiVal") ) {
                final Object value = values.remove("ConsolidationAttributeMultiVal");
                if( (value == null) || (!value.equals(getConsolidationAttributeMultiVal())) ) {
                    setConsolidationAttributeMultiVal(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnAllMD") ) {
                final Object value = (values).remove("to_CnsldtnAllMD");
                if( value instanceof Map ) {
                    if( toCnsldtnAllMD == null ) {
                        toCnsldtnAllMD = new ConsolidationAllMasterData();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnAllMD.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnAllMDAttribT") ) {
                final Object value = (values).remove("to_CnsldtnAllMDAttribT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnAllMDAttribT == null ) {
                        toCnsldtnAllMDAttribT = Lists.newArrayList();
                    } else {
                        toCnsldtnAllMDAttribT = Lists.newArrayList(toCnsldtnAllMDAttribT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConsolidationAllMDAttribText entity;
                        if( toCnsldtnAllMDAttribT.size() > i ) {
                            entity = toCnsldtnAllMDAttribT.get(i);
                        } else {
                            entity = new ConsolidationAllMDAttribText();
                            toCnsldtnAllMDAttribT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ConsolidationAllMDAttributeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationAllMDAttributeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationAllMDAttributeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationAllMDAttributeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnAllMD != null ) {
            (values).put("to_CnsldtnAllMD", toCnsldtnAllMD);
        }
        if( toCnsldtnAllMDAttribT != null ) {
            (values).put("to_CnsldtnAllMDAttribT", toCnsldtnAllMDAttribT);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationAllMasterData</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnAllMD</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ConsolidationAllMasterData</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationAllMasterData fetchCnsldtnAllMD()
    {
        return fetchFieldAsSingle("to_CnsldtnAllMD", ConsolidationAllMasterData.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationAllMasterData</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnAllMD</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnAllMD</b> of a queried <b>ConsolidationAllMDAttribute</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationAllMasterData</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationAllMasterData getCnsldtnAllMDOrFetch()
    {
        if( toCnsldtnAllMD == null ) {
            toCnsldtnAllMD = fetchCnsldtnAllMD();
        }
        return toCnsldtnAllMD;
    }

    /**
     * Retrieval of associated <b>ConsolidationAllMasterData</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnAllMD</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationAllMDAttribute</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnAllMD</b> is already loaded, the result will
     *         contain the <b>ConsolidationAllMasterData</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConsolidationAllMasterData> getCnsldtnAllMDIfPresent()
    {
        return Option.of(toCnsldtnAllMD);
    }

    /**
     * Overwrites the associated <b>ConsolidationAllMasterData</b> entity for the loaded navigation property
     * <b>to_CnsldtnAllMD</b>.
     *
     * @param value
     *            New <b>ConsolidationAllMasterData</b> entity.
     */
    public void setCnsldtnAllMD( final ConsolidationAllMasterData value )
    {
        toCnsldtnAllMD = value;
    }

    /**
     * Fetches the <b>ConsolidationAllMDAttribText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnAllMDAttribT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ConsolidationAllMDAttribText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationAllMDAttribText> fetchCnsldtnAllMDAttribT()
    {
        return fetchFieldAsList("to_CnsldtnAllMDAttribT", ConsolidationAllMDAttribText.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationAllMDAttribText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnAllMDAttribT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnAllMDAttribT</b> of a queried <b>ConsolidationAllMDAttribute</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationAllMDAttribText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationAllMDAttribText> getCnsldtnAllMDAttribTOrFetch()
    {
        if( toCnsldtnAllMDAttribT == null ) {
            toCnsldtnAllMDAttribT = fetchCnsldtnAllMDAttribT();
        }
        return toCnsldtnAllMDAttribT;
    }

    /**
     * Retrieval of associated <b>ConsolidationAllMDAttribText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnAllMDAttribT</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationAllMDAttribute</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnAllMDAttribT</b> is already loaded, the result
     *         will contain the <b>ConsolidationAllMDAttribText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ConsolidationAllMDAttribText>> getCnsldtnAllMDAttribTIfPresent()
    {
        return Option.of(toCnsldtnAllMDAttribT);
    }

    /**
     * Overwrites the list of associated <b>ConsolidationAllMDAttribText</b> entities for the loaded navigation property
     * <b>to_CnsldtnAllMDAttribT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnAllMDAttribT</b> of a queried <b>ConsolidationAllMDAttribute</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ConsolidationAllMDAttribText</b> entities.
     */
    public void setCnsldtnAllMDAttribT( @Nonnull final List<ConsolidationAllMDAttribText> value )
    {
        if( toCnsldtnAllMDAttribT == null ) {
            toCnsldtnAllMDAttribT = Lists.newArrayList();
        }
        toCnsldtnAllMDAttribT.clear();
        toCnsldtnAllMDAttribT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConsolidationAllMDAttribText</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnAllMDAttribT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnAllMDAttribT</b> of a queried <b>ConsolidationAllMDAttribute</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ConsolidationAllMDAttribText</b> entities.
     */
    public void addCnsldtnAllMDAttribT( ConsolidationAllMDAttribText... entity )
    {
        if( toCnsldtnAllMDAttribT == null ) {
            toCnsldtnAllMDAttribT = Lists.newArrayList();
        }
        toCnsldtnAllMDAttribT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationAllMDAttribute instances.
     *
     */
    public final static class ConsolidationAllMDAttributeBuilder
    {

        private ConsolidationAllMasterData toCnsldtnAllMD;
        private List<ConsolidationAllMDAttribText> toCnsldtnAllMDAttribT = Lists.newArrayList();

        private ConsolidationAllMDAttribute.ConsolidationAllMDAttributeBuilder toCnsldtnAllMD(
            final ConsolidationAllMasterData value )
        {
            toCnsldtnAllMD = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnAllMD</b> for <b>ConsolidationAllMDAttribute</b> to single
         * <b>ConsolidationAllMasterData</b>.
         *
         * @param value
         *            The ConsolidationAllMasterData to build this ConsolidationAllMDAttribute with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationAllMDAttribute.ConsolidationAllMDAttributeBuilder cnsldtnAllMD(
            final ConsolidationAllMasterData value )
        {
            return toCnsldtnAllMD(value);
        }

        private ConsolidationAllMDAttribute.ConsolidationAllMDAttributeBuilder toCnsldtnAllMDAttribT(
            final List<ConsolidationAllMDAttribText> value )
        {
            toCnsldtnAllMDAttribT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnAllMDAttribT</b> for <b>ConsolidationAllMDAttribute</b> to multiple
         * <b>ConsolidationAllMDAttribText</b>.
         *
         * @param value
         *            The ConsolidationAllMDAttribTexts to build this ConsolidationAllMDAttribute with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationAllMDAttribute.ConsolidationAllMDAttributeBuilder cnsldtnAllMDAttribT(
            ConsolidationAllMDAttribText... value )
        {
            return toCnsldtnAllMDAttribT(Lists.newArrayList(value));
        }

    }

}
