/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationAllMDAttributeSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribute
 * ConsolidationAllMDAttribute} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ConsolidationAllMDAttributeByKeyFluentHelper
    extends
    FluentHelperByKey<ConsolidationAllMDAttributeByKeyFluentHelper, ConsolidationAllMDAttribute, ConsolidationAllMDAttributeSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribute
     * ConsolidationAllMDAttribute} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ConsolidationAllMDAttribute}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ConsolidationAllMDAttribute}
     * @param consolidationAttributeName
     *            Characteristic Attribute
     *            <p>
     *            Constraints: Not nullable, Maximum length: 36
     *            </p>
     * @param consolidationMDCharcName
     *            Characteristic Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     */
    public ConsolidationAllMDAttributeByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String consolidationAttributeName,
        final String consolidationMDCharcName )
    {
        super(servicePath, entityCollection);
        this.key.put("ConsolidationAttributeName", consolidationAttributeName);
        this.key.put("ConsolidationMDCharcName", consolidationMDCharcName);
    }

    @Override
    @Nonnull
    protected Class<ConsolidationAllMDAttribute> getEntityClass()
    {
        return ConsolidationAllMDAttribute.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
