/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationAllMDTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationAllMDTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationAllMDTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * All Master Data - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationAllMDTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationAllMDText extends VdmEntity<ConsolidationAllMDText>
{

    /**
     * Selector for all available fields of ConsolidationAllMDText.
     *
     */
    public final static ConsolidationAllMDTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCharcFieldName</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @Key
    @SerializedName( "AdditionalCharcFieldName" )
    @JsonProperty( "AdditionalCharcFieldName" )
    @Nullable
    @ODataField( odataName = "AdditionalCharcFieldName" )
    private String additionalCharcFieldName;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCharcFieldName</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDTextField<String> ADDITIONAL_CHARC_FIELD_NAME =
        new ConsolidationAllMDTextField<String>("AdditionalCharcFieldName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDTextField<String> LANGUAGE =
        new ConsolidationAllMDTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationMDMedText</b>
     * </p>
     *
     * @return Medium Field Label
     */
    @SerializedName( "ConsolidationMDMedText" )
    @JsonProperty( "ConsolidationMDMedText" )
    @Nullable
    @ODataField( odataName = "ConsolidationMDMedText" )
    private String consolidationMDMedText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationMDMedText</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDTextField<String> CONSOLIDATION_MD_MED_TEXT =
        new ConsolidationAllMDTextField<String>("ConsolidationMDMedText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationMDLongText</b>
     * </p>
     *
     * @return Long Field Label
     */
    @SerializedName( "ConsolidationMDLongText" )
    @JsonProperty( "ConsolidationMDLongText" )
    @Nullable
    @ODataField( odataName = "ConsolidationMDLongText" )
    private String consolidationMDLongText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationMDLongText</b> field to query operations.
     *
     */
    public final static ConsolidationAllMDTextField<String> CONSOLIDATION_MD_LONG_TEXT =
        new ConsolidationAllMDTextField<String>("ConsolidationMDLongText");
    /**
     * Navigation property <b>to_CnsldtnAllMD</b> for <b>ConsolidationAllMDText</b> to single
     * <b>ConsolidationAllMasterData</b>.
     *
     */
    @SerializedName( "to_CnsldtnAllMD" )
    @JsonProperty( "to_CnsldtnAllMD" )
    @ODataField( odataName = "to_CnsldtnAllMD" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConsolidationAllMasterData toCnsldtnAllMD;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnAllMD</b> navigation property to query operations.
     *
     */
    public final static ConsolidationAllMDTextOneToOneLink<ConsolidationAllMasterData> TO_CNSLDTN_ALL_MD =
        new ConsolidationAllMDTextOneToOneLink<ConsolidationAllMasterData>("to_CnsldtnAllMD");

    @Nonnull
    @Override
    public Class<ConsolidationAllMDText> getType()
    {
        return ConsolidationAllMDText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCharcFieldName</b>
     * </p>
     *
     * @param additionalCharcFieldName
     *            Characteristic Name
     */
    public void setAdditionalCharcFieldName( @Nullable final String additionalCharcFieldName )
    {
        rememberChangedField("AdditionalCharcFieldName", this.additionalCharcFieldName);
        this.additionalCharcFieldName = additionalCharcFieldName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationMDMedText</b>
     * </p>
     *
     * @param consolidationMDMedText
     *            Medium Field Label
     */
    public void setConsolidationMDMedText( @Nullable final String consolidationMDMedText )
    {
        rememberChangedField("ConsolidationMDMedText", this.consolidationMDMedText);
        this.consolidationMDMedText = consolidationMDMedText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationMDLongText</b>
     * </p>
     *
     * @param consolidationMDLongText
     *            Long Field Label
     */
    public void setConsolidationMDLongText( @Nullable final String consolidationMDLongText )
    {
        rememberChangedField("ConsolidationMDLongText", this.consolidationMDLongText);
        this.consolidationMDLongText = consolidationMDLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationAllMDText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AdditionalCharcFieldName", getAdditionalCharcFieldName());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AdditionalCharcFieldName", getAdditionalCharcFieldName());
        values.put("Language", getLanguage());
        values.put("ConsolidationMDMedText", getConsolidationMDMedText());
        values.put("ConsolidationMDLongText", getConsolidationMDLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AdditionalCharcFieldName") ) {
                final Object value = values.remove("AdditionalCharcFieldName");
                if( (value == null) || (!value.equals(getAdditionalCharcFieldName())) ) {
                    setAdditionalCharcFieldName(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationMDMedText") ) {
                final Object value = values.remove("ConsolidationMDMedText");
                if( (value == null) || (!value.equals(getConsolidationMDMedText())) ) {
                    setConsolidationMDMedText(((String) value));
                }
            }
            if( values.containsKey("ConsolidationMDLongText") ) {
                final Object value = values.remove("ConsolidationMDLongText");
                if( (value == null) || (!value.equals(getConsolidationMDLongText())) ) {
                    setConsolidationMDLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnAllMD") ) {
                final Object value = (values).remove("to_CnsldtnAllMD");
                if( value instanceof Map ) {
                    if( toCnsldtnAllMD == null ) {
                        toCnsldtnAllMD = new ConsolidationAllMasterData();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnAllMD.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationAllMDTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationAllMDTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationAllMDTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationAllMDTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnAllMD != null ) {
            (values).put("to_CnsldtnAllMD", toCnsldtnAllMD);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationAllMasterData</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnAllMD</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ConsolidationAllMasterData</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationAllMasterData fetchCnsldtnAllMD()
    {
        return fetchFieldAsSingle("to_CnsldtnAllMD", ConsolidationAllMasterData.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationAllMasterData</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnAllMD</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnAllMD</b> of a queried <b>ConsolidationAllMDText</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationAllMasterData</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationAllMasterData getCnsldtnAllMDOrFetch()
    {
        if( toCnsldtnAllMD == null ) {
            toCnsldtnAllMD = fetchCnsldtnAllMD();
        }
        return toCnsldtnAllMD;
    }

    /**
     * Retrieval of associated <b>ConsolidationAllMasterData</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnAllMD</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationAllMDText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnAllMD</b> is already loaded, the result will
     *         contain the <b>ConsolidationAllMasterData</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConsolidationAllMasterData> getCnsldtnAllMDIfPresent()
    {
        return Option.of(toCnsldtnAllMD);
    }

    /**
     * Overwrites the associated <b>ConsolidationAllMasterData</b> entity for the loaded navigation property
     * <b>to_CnsldtnAllMD</b>.
     *
     * @param value
     *            New <b>ConsolidationAllMasterData</b> entity.
     */
    public void setCnsldtnAllMD( final ConsolidationAllMasterData value )
    {
        toCnsldtnAllMD = value;
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationAllMDText instances.
     *
     */
    public final static class ConsolidationAllMDTextBuilder
    {

        private ConsolidationAllMasterData toCnsldtnAllMD;

        private ConsolidationAllMDText.ConsolidationAllMDTextBuilder toCnsldtnAllMD(
            final ConsolidationAllMasterData value )
        {
            toCnsldtnAllMD = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnAllMD</b> for <b>ConsolidationAllMDText</b> to single
         * <b>ConsolidationAllMasterData</b>.
         *
         * @param value
         *            The ConsolidationAllMasterData to build this ConsolidationAllMDText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationAllMDText.ConsolidationAllMDTextBuilder cnsldtnAllMD(
            final ConsolidationAllMasterData value )
        {
            return toCnsldtnAllMD(value);
        }

    }

}
