/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationAllMDTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDText
 * ConsolidationAllMDText} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class ConsolidationAllMDTextByKeyFluentHelper
    extends
    FluentHelperByKey<ConsolidationAllMDTextByKeyFluentHelper, ConsolidationAllMDText, ConsolidationAllMDTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDText
     * ConsolidationAllMDText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ConsolidationAllMDText}
     * @param additionalCharcFieldName
     *            Characteristic Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ConsolidationAllMDText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public ConsolidationAllMDTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String additionalCharcFieldName,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("AdditionalCharcFieldName", additionalCharcFieldName);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<ConsolidationAllMDText> getEntityClass()
    {
        return ConsolidationAllMDText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
