/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationAllMasterDataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationAllMasterDataLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationAllMasterDataSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * All Master Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationAllMasterDataType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationAllMasterData extends VdmEntity<ConsolidationAllMasterData>
{

    /**
     * Selector for all available fields of ConsolidationAllMasterData.
     *
     */
    public final static ConsolidationAllMasterDataSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCharcFieldName</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @Key
    @SerializedName( "AdditionalCharcFieldName" )
    @JsonProperty( "AdditionalCharcFieldName" )
    @Nullable
    @ODataField( odataName = "AdditionalCharcFieldName" )
    private String additionalCharcFieldName;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCharcFieldName</b> field to query operations.
     *
     */
    public final static ConsolidationAllMasterDataField<String> ADDITIONAL_CHARC_FIELD_NAME =
        new ConsolidationAllMasterDataField<String>("AdditionalCharcFieldName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCharcFieldName_Text</b>
     * </p>
     *
     * @return Medium Field Label
     */
    @SerializedName( "AdditionalCharcFieldName_Text" )
    @JsonProperty( "AdditionalCharcFieldName_Text" )
    @Nullable
    @ODataField( odataName = "AdditionalCharcFieldName_Text" )
    private String additionalCharcFieldName_Text;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCharcFieldName_Text</b> field to query operations.
     *
     */
    public final static ConsolidationAllMasterDataField<String> ADDITIONAL_CHARC_FIELD_NAME_TEXT =
        new ConsolidationAllMasterDataField<String>("AdditionalCharcFieldName_Text");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCharcIsInUse</b>
     * </p>
     *
     * @return Enable as Input Field
     */
    @SerializedName( "AdditionalCharcIsInUse" )
    @JsonProperty( "AdditionalCharcIsInUse" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AdditionalCharcIsInUse" )
    private Boolean additionalCharcIsInUse;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCharcIsInUse</b> field to query operations.
     *
     */
    public final static ConsolidationAllMasterDataField<Boolean> ADDITIONAL_CHARC_IS_IN_USE =
        new ConsolidationAllMasterDataField<Boolean>("AdditionalCharcIsInUse");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataIsInUse</b>
     * </p>
     *
     * @return Enable master data in Group Reporting
     */
    @SerializedName( "AdditionalMasterDataIsInUse" )
    @JsonProperty( "AdditionalMasterDataIsInUse" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AdditionalMasterDataIsInUse" )
    private Boolean additionalMasterDataIsInUse;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataIsInUse</b> field to query operations.
     *
     */
    public final static ConsolidationAllMasterDataField<Boolean> ADDITIONAL_MASTER_DATA_IS_IN_USE =
        new ConsolidationAllMasterDataField<Boolean>("AdditionalMasterDataIsInUse");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMDHierarchyIsInUse</b>
     * </p>
     *
     * @return Enable Master Data Hierarchy in Group Reporting
     */
    @SerializedName( "AdditionalMDHierarchyIsInUse" )
    @JsonProperty( "AdditionalMDHierarchyIsInUse" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AdditionalMDHierarchyIsInUse" )
    private Boolean additionalMDHierarchyIsInUse;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMDHierarchyIsInUse</b> field to query operations.
     *
     */
    public final static ConsolidationAllMasterDataField<Boolean> ADDITIONAL_MD_HIERARCHY_IS_IN_USE =
        new ConsolidationAllMasterDataField<Boolean>("AdditionalMDHierarchyIsInUse");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationMDPairedFldName</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @SerializedName( "ConsolidationMDPairedFldName" )
    @JsonProperty( "ConsolidationMDPairedFldName" )
    @Nullable
    @ODataField( odataName = "ConsolidationMDPairedFldName" )
    private String consolidationMDPairedFldName;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationMDPairedFldName</b> field to query operations.
     *
     */
    public final static ConsolidationAllMasterDataField<String> CONSOLIDATION_MD_PAIRED_FLD_NAME =
        new ConsolidationAllMasterDataField<String>("ConsolidationMDPairedFldName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationMDSuprordFldName</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @SerializedName( "ConsolidationMDSuprordFldName" )
    @JsonProperty( "ConsolidationMDSuprordFldName" )
    @Nullable
    @ODataField( odataName = "ConsolidationMDSuprordFldName" )
    private String consolidationMDSuprordFldName;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationMDSuprordFldName</b> field to query operations.
     *
     */
    public final static ConsolidationAllMasterDataField<String> CONSOLIDATION_MD_SUPRORD_FLD_NAME =
        new ConsolidationAllMasterDataField<String>("ConsolidationMDSuprordFldName");
    /**
     * Navigation property <b>to_CnsldtnAllCharcsAttribute</b> for <b>ConsolidationAllMasterData</b> to multiple
     * <b>ConsolidationAllMDAttribute</b>.
     *
     */
    @SerializedName( "to_CnsldtnAllCharcsAttribute" )
    @JsonProperty( "to_CnsldtnAllCharcsAttribute" )
    @ODataField( odataName = "to_CnsldtnAllCharcsAttribute" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConsolidationAllMDAttribute> toCnsldtnAllCharcsAttribute;
    /**
     * Navigation property <b>to_CnsldtnAllMDT</b> for <b>ConsolidationAllMasterData</b> to multiple
     * <b>ConsolidationAllMDText</b>.
     *
     */
    @SerializedName( "to_CnsldtnAllMDT" )
    @JsonProperty( "to_CnsldtnAllMDT" )
    @ODataField( odataName = "to_CnsldtnAllMDT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConsolidationAllMDText> toCnsldtnAllMDT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnAllCharcsAttribute</b> navigation property to query
     * operations.
     *
     */
    public final static ConsolidationAllMasterDataLink<ConsolidationAllMDAttribute> TO_CNSLDTN_ALL_CHARCS_ATTRIBUTE =
        new ConsolidationAllMasterDataLink<ConsolidationAllMDAttribute>("to_CnsldtnAllCharcsAttribute");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnAllMDT</b> navigation property to query operations.
     *
     */
    public final static ConsolidationAllMasterDataLink<ConsolidationAllMDText> TO_CNSLDTN_ALL_MDT =
        new ConsolidationAllMasterDataLink<ConsolidationAllMDText>("to_CnsldtnAllMDT");

    @Nonnull
    @Override
    public Class<ConsolidationAllMasterData> getType()
    {
        return ConsolidationAllMasterData.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCharcFieldName</b>
     * </p>
     *
     * @param additionalCharcFieldName
     *            Characteristic Name
     */
    public void setAdditionalCharcFieldName( @Nullable final String additionalCharcFieldName )
    {
        rememberChangedField("AdditionalCharcFieldName", this.additionalCharcFieldName);
        this.additionalCharcFieldName = additionalCharcFieldName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCharcFieldName_Text</b>
     * </p>
     *
     * @param additionalCharcFieldName_Text
     *            Medium Field Label
     */
    public void setAdditionalCharcFieldName_Text( @Nullable final String additionalCharcFieldName_Text )
    {
        rememberChangedField("AdditionalCharcFieldName_Text", this.additionalCharcFieldName_Text);
        this.additionalCharcFieldName_Text = additionalCharcFieldName_Text;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCharcIsInUse</b>
     * </p>
     *
     * @param additionalCharcIsInUse
     *            Enable as Input Field
     */
    public void setAdditionalCharcIsInUse( @Nullable final Boolean additionalCharcIsInUse )
    {
        rememberChangedField("AdditionalCharcIsInUse", this.additionalCharcIsInUse);
        this.additionalCharcIsInUse = additionalCharcIsInUse;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataIsInUse</b>
     * </p>
     *
     * @param additionalMasterDataIsInUse
     *            Enable master data in Group Reporting
     */
    public void setAdditionalMasterDataIsInUse( @Nullable final Boolean additionalMasterDataIsInUse )
    {
        rememberChangedField("AdditionalMasterDataIsInUse", this.additionalMasterDataIsInUse);
        this.additionalMasterDataIsInUse = additionalMasterDataIsInUse;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMDHierarchyIsInUse</b>
     * </p>
     *
     * @param additionalMDHierarchyIsInUse
     *            Enable Master Data Hierarchy in Group Reporting
     */
    public void setAdditionalMDHierarchyIsInUse( @Nullable final Boolean additionalMDHierarchyIsInUse )
    {
        rememberChangedField("AdditionalMDHierarchyIsInUse", this.additionalMDHierarchyIsInUse);
        this.additionalMDHierarchyIsInUse = additionalMDHierarchyIsInUse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationMDPairedFldName</b>
     * </p>
     *
     * @param consolidationMDPairedFldName
     *            Characteristic Name
     */
    public void setConsolidationMDPairedFldName( @Nullable final String consolidationMDPairedFldName )
    {
        rememberChangedField("ConsolidationMDPairedFldName", this.consolidationMDPairedFldName);
        this.consolidationMDPairedFldName = consolidationMDPairedFldName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationMDSuprordFldName</b>
     * </p>
     *
     * @param consolidationMDSuprordFldName
     *            Characteristic Name
     */
    public void setConsolidationMDSuprordFldName( @Nullable final String consolidationMDSuprordFldName )
    {
        rememberChangedField("ConsolidationMDSuprordFldName", this.consolidationMDSuprordFldName);
        this.consolidationMDSuprordFldName = consolidationMDSuprordFldName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationAllMasterData";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AdditionalCharcFieldName", getAdditionalCharcFieldName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AdditionalCharcFieldName", getAdditionalCharcFieldName());
        values.put("AdditionalCharcFieldName_Text", getAdditionalCharcFieldName_Text());
        values.put("AdditionalCharcIsInUse", getAdditionalCharcIsInUse());
        values.put("AdditionalMasterDataIsInUse", getAdditionalMasterDataIsInUse());
        values.put("AdditionalMDHierarchyIsInUse", getAdditionalMDHierarchyIsInUse());
        values.put("ConsolidationMDPairedFldName", getConsolidationMDPairedFldName());
        values.put("ConsolidationMDSuprordFldName", getConsolidationMDSuprordFldName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AdditionalCharcFieldName") ) {
                final Object value = values.remove("AdditionalCharcFieldName");
                if( (value == null) || (!value.equals(getAdditionalCharcFieldName())) ) {
                    setAdditionalCharcFieldName(((String) value));
                }
            }
            if( values.containsKey("AdditionalCharcFieldName_Text") ) {
                final Object value = values.remove("AdditionalCharcFieldName_Text");
                if( (value == null) || (!value.equals(getAdditionalCharcFieldName_Text())) ) {
                    setAdditionalCharcFieldName_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalCharcIsInUse") ) {
                final Object value = values.remove("AdditionalCharcIsInUse");
                if( (value == null) || (!value.equals(getAdditionalCharcIsInUse())) ) {
                    setAdditionalCharcIsInUse(((Boolean) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataIsInUse") ) {
                final Object value = values.remove("AdditionalMasterDataIsInUse");
                if( (value == null) || (!value.equals(getAdditionalMasterDataIsInUse())) ) {
                    setAdditionalMasterDataIsInUse(((Boolean) value));
                }
            }
            if( values.containsKey("AdditionalMDHierarchyIsInUse") ) {
                final Object value = values.remove("AdditionalMDHierarchyIsInUse");
                if( (value == null) || (!value.equals(getAdditionalMDHierarchyIsInUse())) ) {
                    setAdditionalMDHierarchyIsInUse(((Boolean) value));
                }
            }
            if( values.containsKey("ConsolidationMDPairedFldName") ) {
                final Object value = values.remove("ConsolidationMDPairedFldName");
                if( (value == null) || (!value.equals(getConsolidationMDPairedFldName())) ) {
                    setConsolidationMDPairedFldName(((String) value));
                }
            }
            if( values.containsKey("ConsolidationMDSuprordFldName") ) {
                final Object value = values.remove("ConsolidationMDSuprordFldName");
                if( (value == null) || (!value.equals(getConsolidationMDSuprordFldName())) ) {
                    setConsolidationMDSuprordFldName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnAllCharcsAttribute") ) {
                final Object value = (values).remove("to_CnsldtnAllCharcsAttribute");
                if( value instanceof Iterable ) {
                    if( toCnsldtnAllCharcsAttribute == null ) {
                        toCnsldtnAllCharcsAttribute = Lists.newArrayList();
                    } else {
                        toCnsldtnAllCharcsAttribute = Lists.newArrayList(toCnsldtnAllCharcsAttribute);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConsolidationAllMDAttribute entity;
                        if( toCnsldtnAllCharcsAttribute.size() > i ) {
                            entity = toCnsldtnAllCharcsAttribute.get(i);
                        } else {
                            entity = new ConsolidationAllMDAttribute();
                            toCnsldtnAllCharcsAttribute.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnAllMDT") ) {
                final Object value = (values).remove("to_CnsldtnAllMDT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnAllMDT == null ) {
                        toCnsldtnAllMDT = Lists.newArrayList();
                    } else {
                        toCnsldtnAllMDT = Lists.newArrayList(toCnsldtnAllMDT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConsolidationAllMDText entity;
                        if( toCnsldtnAllMDT.size() > i ) {
                            entity = toCnsldtnAllMDT.get(i);
                        } else {
                            entity = new ConsolidationAllMDText();
                            toCnsldtnAllMDT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ConsolidationAllMasterDataField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationAllMasterDataField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationAllMasterDataField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationAllMasterDataField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnAllCharcsAttribute != null ) {
            (values).put("to_CnsldtnAllCharcsAttribute", toCnsldtnAllCharcsAttribute);
        }
        if( toCnsldtnAllMDT != null ) {
            (values).put("to_CnsldtnAllMDT", toCnsldtnAllMDT);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationAllMDAttribute</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnAllCharcsAttribute</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ConsolidationAllMDAttribute</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationAllMDAttribute> fetchCnsldtnAllCharcsAttribute()
    {
        return fetchFieldAsList("to_CnsldtnAllCharcsAttribute", ConsolidationAllMDAttribute.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationAllMDAttribute</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnAllCharcsAttribute</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnAllCharcsAttribute</b> of a queried <b>ConsolidationAllMasterData</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationAllMDAttribute</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationAllMDAttribute> getCnsldtnAllCharcsAttributeOrFetch()
    {
        if( toCnsldtnAllCharcsAttribute == null ) {
            toCnsldtnAllCharcsAttribute = fetchCnsldtnAllCharcsAttribute();
        }
        return toCnsldtnAllCharcsAttribute;
    }

    /**
     * Retrieval of associated <b>ConsolidationAllMDAttribute</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnAllCharcsAttribute</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationAllMasterData</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnAllCharcsAttribute</b> is already loaded, the
     *         result will contain the <b>ConsolidationAllMDAttribute</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ConsolidationAllMDAttribute>> getCnsldtnAllCharcsAttributeIfPresent()
    {
        return Option.of(toCnsldtnAllCharcsAttribute);
    }

    /**
     * Overwrites the list of associated <b>ConsolidationAllMDAttribute</b> entities for the loaded navigation property
     * <b>to_CnsldtnAllCharcsAttribute</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnAllCharcsAttribute</b> of a queried <b>ConsolidationAllMasterData</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ConsolidationAllMDAttribute</b> entities.
     */
    public void setCnsldtnAllCharcsAttribute( @Nonnull final List<ConsolidationAllMDAttribute> value )
    {
        if( toCnsldtnAllCharcsAttribute == null ) {
            toCnsldtnAllCharcsAttribute = Lists.newArrayList();
        }
        toCnsldtnAllCharcsAttribute.clear();
        toCnsldtnAllCharcsAttribute.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConsolidationAllMDAttribute</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnAllCharcsAttribute</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnAllCharcsAttribute</b> of a queried <b>ConsolidationAllMasterData</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ConsolidationAllMDAttribute</b> entities.
     */
    public void addCnsldtnAllCharcsAttribute( ConsolidationAllMDAttribute... entity )
    {
        if( toCnsldtnAllCharcsAttribute == null ) {
            toCnsldtnAllCharcsAttribute = Lists.newArrayList();
        }
        toCnsldtnAllCharcsAttribute.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ConsolidationAllMDText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnAllMDT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ConsolidationAllMDText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationAllMDText> fetchCnsldtnAllMDT()
    {
        return fetchFieldAsList("to_CnsldtnAllMDT", ConsolidationAllMDText.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationAllMDText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnAllMDT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnAllMDT</b> of a queried <b>ConsolidationAllMasterData</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationAllMDText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationAllMDText> getCnsldtnAllMDTOrFetch()
    {
        if( toCnsldtnAllMDT == null ) {
            toCnsldtnAllMDT = fetchCnsldtnAllMDT();
        }
        return toCnsldtnAllMDT;
    }

    /**
     * Retrieval of associated <b>ConsolidationAllMDText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnAllMDT</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationAllMasterData</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnAllMDT</b> is already loaded, the result will
     *         contain the <b>ConsolidationAllMDText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ConsolidationAllMDText>> getCnsldtnAllMDTIfPresent()
    {
        return Option.of(toCnsldtnAllMDT);
    }

    /**
     * Overwrites the list of associated <b>ConsolidationAllMDText</b> entities for the loaded navigation property
     * <b>to_CnsldtnAllMDT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnAllMDT</b> of a queried <b>ConsolidationAllMasterData</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ConsolidationAllMDText</b> entities.
     */
    public void setCnsldtnAllMDT( @Nonnull final List<ConsolidationAllMDText> value )
    {
        if( toCnsldtnAllMDT == null ) {
            toCnsldtnAllMDT = Lists.newArrayList();
        }
        toCnsldtnAllMDT.clear();
        toCnsldtnAllMDT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConsolidationAllMDText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnAllMDT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnAllMDT</b> of a queried <b>ConsolidationAllMasterData</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ConsolidationAllMDText</b> entities.
     */
    public void addCnsldtnAllMDT( ConsolidationAllMDText... entity )
    {
        if( toCnsldtnAllMDT == null ) {
            toCnsldtnAllMDT = Lists.newArrayList();
        }
        toCnsldtnAllMDT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationAllMasterData instances.
     *
     */
    public final static class ConsolidationAllMasterDataBuilder
    {

        private List<ConsolidationAllMDAttribute> toCnsldtnAllCharcsAttribute = Lists.newArrayList();
        private List<ConsolidationAllMDText> toCnsldtnAllMDT = Lists.newArrayList();

        private ConsolidationAllMasterData.ConsolidationAllMasterDataBuilder toCnsldtnAllCharcsAttribute(
            final List<ConsolidationAllMDAttribute> value )
        {
            toCnsldtnAllCharcsAttribute.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnAllCharcsAttribute</b> for <b>ConsolidationAllMasterData</b> to multiple
         * <b>ConsolidationAllMDAttribute</b>.
         *
         * @param value
         *            The ConsolidationAllMDAttributes to build this ConsolidationAllMasterData with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationAllMasterData.ConsolidationAllMasterDataBuilder cnsldtnAllCharcsAttribute(
            ConsolidationAllMDAttribute... value )
        {
            return toCnsldtnAllCharcsAttribute(Lists.newArrayList(value));
        }

        private ConsolidationAllMasterData.ConsolidationAllMasterDataBuilder toCnsldtnAllMDT(
            final List<ConsolidationAllMDText> value )
        {
            toCnsldtnAllMDT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnAllMDT</b> for <b>ConsolidationAllMasterData</b> to multiple
         * <b>ConsolidationAllMDText</b>.
         *
         * @param value
         *            The ConsolidationAllMDTexts to build this ConsolidationAllMasterData with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationAllMasterData.ConsolidationAllMasterDataBuilder cnsldtnAllMDT(
            ConsolidationAllMDText... value )
        {
            return toCnsldtnAllMDT(Lists.newArrayList(value));
        }

    }

}
