/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationChtAcctsTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationChtAcctsTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationChtAcctsTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Chart of Accounts Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationChtAcctsTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationChtAcctsText extends VdmEntity<ConsolidationChtAcctsText>
{

    /**
     * Selector for all available fields of ConsolidationChtAcctsText.
     *
     */
    public final static ConsolidationChtAcctsTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static ConsolidationChtAcctsTextField<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new ConsolidationChtAcctsTextField<String>("ConsolidationChartOfAccounts");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ConsolidationChtAcctsTextField<String> LANGUAGE =
        new ConsolidationChtAcctsTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAcctsText</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAcctsText" )
    @JsonProperty( "ConsolidationChartOfAcctsText" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAcctsText" )
    private String consolidationChartOfAcctsText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAcctsText</b> field to query operations.
     *
     */
    public final static ConsolidationChtAcctsTextField<String> CONSOLIDATION_CHART_OF_ACCTS_TEXT =
        new ConsolidationChtAcctsTextField<String>("ConsolidationChartOfAcctsText");
    /**
     * Navigation property <b>to_CnsldtnChartOfAccounts</b> for <b>ConsolidationChtAcctsText</b> to single
     * <b>ConsolidationChartOfAccounts</b>.
     *
     */
    @SerializedName( "to_CnsldtnChartOfAccounts" )
    @JsonProperty( "to_CnsldtnChartOfAccounts" )
    @ODataField( odataName = "to_CnsldtnChartOfAccounts" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConsolidationChartOfAccounts toCnsldtnChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnChartOfAccounts</b> navigation property to query
     * operations.
     *
     */
    public final static ConsolidationChtAcctsTextOneToOneLink<ConsolidationChartOfAccounts> TO_CNSLDTN_CHART_OF_ACCOUNTS =
        new ConsolidationChtAcctsTextOneToOneLink<ConsolidationChartOfAccounts>("to_CnsldtnChartOfAccounts");

    @Nonnull
    @Override
    public Class<ConsolidationChtAcctsText> getType()
    {
        return ConsolidationChtAcctsText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAcctsText</b>
     * </p>
     *
     * @param consolidationChartOfAcctsText
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAcctsText( @Nullable final String consolidationChartOfAcctsText )
    {
        rememberChangedField("ConsolidationChartOfAcctsText", this.consolidationChartOfAcctsText);
        this.consolidationChartOfAcctsText = consolidationChartOfAcctsText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationChtAcctsText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("Language", getLanguage());
        values.put("ConsolidationChartOfAcctsText", getConsolidationChartOfAcctsText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAcctsText") ) {
                final Object value = values.remove("ConsolidationChartOfAcctsText");
                if( (value == null) || (!value.equals(getConsolidationChartOfAcctsText())) ) {
                    setConsolidationChartOfAcctsText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnChartOfAccounts") ) {
                final Object value = (values).remove("to_CnsldtnChartOfAccounts");
                if( value instanceof Map ) {
                    if( toCnsldtnChartOfAccounts == null ) {
                        toCnsldtnChartOfAccounts = new ConsolidationChartOfAccounts();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnChartOfAccounts.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationChtAcctsTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationChtAcctsTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationChtAcctsTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationChtAcctsTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnChartOfAccounts != null ) {
            (values).put("to_CnsldtnChartOfAccounts", toCnsldtnChartOfAccounts);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationChartOfAccounts</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnChartOfAccounts</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ConsolidationChartOfAccounts</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationChartOfAccounts fetchCnsldtnChartOfAccounts()
    {
        return fetchFieldAsSingle("to_CnsldtnChartOfAccounts", ConsolidationChartOfAccounts.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationChartOfAccounts</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnChartOfAccounts</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnChartOfAccounts</b> of a queried <b>ConsolidationChtAcctsText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationChartOfAccounts</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationChartOfAccounts getCnsldtnChartOfAccountsOrFetch()
    {
        if( toCnsldtnChartOfAccounts == null ) {
            toCnsldtnChartOfAccounts = fetchCnsldtnChartOfAccounts();
        }
        return toCnsldtnChartOfAccounts;
    }

    /**
     * Retrieval of associated <b>ConsolidationChartOfAccounts</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnChartOfAccounts</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationChtAcctsText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnChartOfAccounts</b> is already loaded, the result
     *         will contain the <b>ConsolidationChartOfAccounts</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConsolidationChartOfAccounts> getCnsldtnChartOfAccountsIfPresent()
    {
        return Option.of(toCnsldtnChartOfAccounts);
    }

    /**
     * Overwrites the associated <b>ConsolidationChartOfAccounts</b> entity for the loaded navigation property
     * <b>to_CnsldtnChartOfAccounts</b>.
     *
     * @param value
     *            New <b>ConsolidationChartOfAccounts</b> entity.
     */
    public void setCnsldtnChartOfAccounts( final ConsolidationChartOfAccounts value )
    {
        toCnsldtnChartOfAccounts = value;
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationChtAcctsText instances.
     *
     */
    public final static class ConsolidationChtAcctsTextBuilder
    {

        private ConsolidationChartOfAccounts toCnsldtnChartOfAccounts;

        private ConsolidationChtAcctsText.ConsolidationChtAcctsTextBuilder toCnsldtnChartOfAccounts(
            final ConsolidationChartOfAccounts value )
        {
            toCnsldtnChartOfAccounts = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnChartOfAccounts</b> for <b>ConsolidationChtAcctsText</b> to single
         * <b>ConsolidationChartOfAccounts</b>.
         *
         * @param value
         *            The ConsolidationChartOfAccounts to build this ConsolidationChtAcctsText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationChtAcctsText.ConsolidationChtAcctsTextBuilder cnsldtnChartOfAccounts(
            final ConsolidationChartOfAccounts value )
        {
            return toCnsldtnChartOfAccounts(value);
        }

    }

}
