/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationDocTypeTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationDocTypeTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationDocTypeTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Document Type - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationDocTypeTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationDocTypeText extends VdmEntity<ConsolidationDocTypeText>
{

    /**
     * Selector for all available fields of ConsolidationDocTypeText.
     *
     */
    public final static ConsolidationDocTypeTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @Key
    @SerializedName( "ConsolidationDocumentType" )
    @JsonProperty( "ConsolidationDocumentType" )
    @Nullable
    @ODataField( odataName = "ConsolidationDocumentType" )
    private String consolidationDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationDocumentType</b> field to query operations.
     *
     */
    public final static ConsolidationDocTypeTextField<String> CONSOLIDATION_DOCUMENT_TYPE =
        new ConsolidationDocTypeTextField<String>("ConsolidationDocumentType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ConsolidationDocTypeTextField<String> LANGUAGE =
        new ConsolidationDocTypeTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentTypeText</b>
     * </p>
     *
     * @return Document Type Description
     */
    @SerializedName( "ConsolidationDocumentTypeText" )
    @JsonProperty( "ConsolidationDocumentTypeText" )
    @Nullable
    @ODataField( odataName = "ConsolidationDocumentTypeText" )
    private String consolidationDocumentTypeText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationDocumentTypeText</b> field to query operations.
     *
     */
    public final static ConsolidationDocTypeTextField<String> CONSOLIDATION_DOCUMENT_TYPE_TEXT =
        new ConsolidationDocTypeTextField<String>("ConsolidationDocumentTypeText");
    /**
     * Navigation property <b>to_CnsldtnDocumentType</b> for <b>ConsolidationDocTypeText</b> to single
     * <b>ConsolidationDocumentType</b>.
     *
     */
    @SerializedName( "to_CnsldtnDocumentType" )
    @JsonProperty( "to_CnsldtnDocumentType" )
    @ODataField( odataName = "to_CnsldtnDocumentType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConsolidationDocumentType toCnsldtnDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnDocumentType</b> navigation property to query
     * operations.
     *
     */
    public final static ConsolidationDocTypeTextOneToOneLink<ConsolidationDocumentType> TO_CNSLDTN_DOCUMENT_TYPE =
        new ConsolidationDocTypeTextOneToOneLink<ConsolidationDocumentType>("to_CnsldtnDocumentType");

    @Nonnull
    @Override
    public Class<ConsolidationDocTypeText> getType()
    {
        return ConsolidationDocTypeText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentType</b>
     * </p>
     *
     * @param consolidationDocumentType
     *            Document Type
     */
    public void setConsolidationDocumentType( @Nullable final String consolidationDocumentType )
    {
        rememberChangedField("ConsolidationDocumentType", this.consolidationDocumentType);
        this.consolidationDocumentType = consolidationDocumentType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentTypeText</b>
     * </p>
     *
     * @param consolidationDocumentTypeText
     *            Document Type Description
     */
    public void setConsolidationDocumentTypeText( @Nullable final String consolidationDocumentTypeText )
    {
        rememberChangedField("ConsolidationDocumentTypeText", this.consolidationDocumentTypeText);
        this.consolidationDocumentTypeText = consolidationDocumentTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationDocTypeText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationDocumentType", getConsolidationDocumentType());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationDocumentType", getConsolidationDocumentType());
        values.put("Language", getLanguage());
        values.put("ConsolidationDocumentTypeText", getConsolidationDocumentTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationDocumentType") ) {
                final Object value = values.remove("ConsolidationDocumentType");
                if( (value == null) || (!value.equals(getConsolidationDocumentType())) ) {
                    setConsolidationDocumentType(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationDocumentTypeText") ) {
                final Object value = values.remove("ConsolidationDocumentTypeText");
                if( (value == null) || (!value.equals(getConsolidationDocumentTypeText())) ) {
                    setConsolidationDocumentTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnDocumentType") ) {
                final Object value = (values).remove("to_CnsldtnDocumentType");
                if( value instanceof Map ) {
                    if( toCnsldtnDocumentType == null ) {
                        toCnsldtnDocumentType = new ConsolidationDocumentType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnDocumentType.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationDocTypeTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationDocTypeTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationDocTypeTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationDocTypeTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnDocumentType != null ) {
            (values).put("to_CnsldtnDocumentType", toCnsldtnDocumentType);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationDocumentType</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnDocumentType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ConsolidationDocumentType</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationDocumentType fetchCnsldtnDocumentType()
    {
        return fetchFieldAsSingle("to_CnsldtnDocumentType", ConsolidationDocumentType.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationDocumentType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnDocumentType</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDocumentType</b> of a queried <b>ConsolidationDocTypeText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationDocumentType</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationDocumentType getCnsldtnDocumentTypeOrFetch()
    {
        if( toCnsldtnDocumentType == null ) {
            toCnsldtnDocumentType = fetchCnsldtnDocumentType();
        }
        return toCnsldtnDocumentType;
    }

    /**
     * Retrieval of associated <b>ConsolidationDocumentType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnDocumentType</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationDocTypeText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnDocumentType</b> is already loaded, the result
     *         will contain the <b>ConsolidationDocumentType</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConsolidationDocumentType> getCnsldtnDocumentTypeIfPresent()
    {
        return Option.of(toCnsldtnDocumentType);
    }

    /**
     * Overwrites the associated <b>ConsolidationDocumentType</b> entity for the loaded navigation property
     * <b>to_CnsldtnDocumentType</b>.
     *
     * @param value
     *            New <b>ConsolidationDocumentType</b> entity.
     */
    public void setCnsldtnDocumentType( final ConsolidationDocumentType value )
    {
        toCnsldtnDocumentType = value;
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationDocTypeText instances.
     *
     */
    public final static class ConsolidationDocTypeTextBuilder
    {

        private ConsolidationDocumentType toCnsldtnDocumentType;

        private ConsolidationDocTypeText.ConsolidationDocTypeTextBuilder toCnsldtnDocumentType(
            final ConsolidationDocumentType value )
        {
            toCnsldtnDocumentType = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnDocumentType</b> for <b>ConsolidationDocTypeText</b> to single
         * <b>ConsolidationDocumentType</b>.
         *
         * @param value
         *            The ConsolidationDocumentType to build this ConsolidationDocTypeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationDocTypeText.ConsolidationDocTypeTextBuilder cnsldtnDocumentType(
            final ConsolidationDocumentType value )
        {
            return toCnsldtnDocumentType(value);
        }

    }

}
