/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationDocumentTypeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationDocumentTypeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationDocumentTypeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Document Type
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationDocumentTypeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationDocumentType extends VdmEntity<ConsolidationDocumentType>
{

    /**
     * Selector for all available fields of ConsolidationDocumentType.
     *
     */
    public final static ConsolidationDocumentTypeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @Key
    @SerializedName( "ConsolidationDocumentType" )
    @JsonProperty( "ConsolidationDocumentType" )
    @Nullable
    @ODataField( odataName = "ConsolidationDocumentType" )
    private String consolidationDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationDocumentType</b> field to query operations.
     *
     */
    public final static ConsolidationDocumentTypeField<String> CONSOLIDATION_DOCUMENT_TYPE =
        new ConsolidationDocumentTypeField<String>("ConsolidationDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentType_Text</b>
     * </p>
     *
     * @return Document Type Description
     */
    @SerializedName( "ConsolidationDocumentType_Text" )
    @JsonProperty( "ConsolidationDocumentType_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationDocumentType_Text" )
    private String consolidationDocumentType_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationDocumentType_Text</b> field to query operations.
     *
     */
    public final static ConsolidationDocumentTypeField<String> CONSOLIDATION_DOCUMENT_TYPE_TEXT =
        new ConsolidationDocumentTypeField<String>("ConsolidationDocumentType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevel</b>
     * </p>
     *
     * @return Posting Level
     */
    @SerializedName( "PostingLevel" )
    @JsonProperty( "PostingLevel" )
    @Nullable
    @ODataField( odataName = "PostingLevel" )
    private String postingLevel;
    /**
     * Use with available fluent helpers to apply the <b>PostingLevel</b> field to query operations.
     *
     */
    public final static ConsolidationDocumentTypeField<String> POSTING_LEVEL =
        new ConsolidationDocumentTypeField<String>("PostingLevel");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevel_Text</b>
     * </p>
     *
     * @return Document Type Description
     */
    @SerializedName( "PostingLevel_Text" )
    @JsonProperty( "PostingLevel_Text" )
    @Nullable
    @ODataField( odataName = "PostingLevel_Text" )
    private String postingLevel_Text;
    /**
     * Use with available fluent helpers to apply the <b>PostingLevel_Text</b> field to query operations.
     *
     */
    public final static ConsolidationDocumentTypeField<String> POSTING_LEVEL_TEXT =
        new ConsolidationDocumentTypeField<String>("PostingLevel_Text");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationBalanceCheck</b>
     * </p>
     *
     * @return Balance check for consolidation document
     */
    @SerializedName( "ConsolidationBalanceCheck" )
    @JsonProperty( "ConsolidationBalanceCheck" )
    @Nullable
    @ODataField( odataName = "ConsolidationBalanceCheck" )
    private String consolidationBalanceCheck;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationBalanceCheck</b> field to query operations.
     *
     */
    public final static ConsolidationDocumentTypeField<String> CONSOLIDATION_BALANCE_CHECK =
        new ConsolidationDocumentTypeField<String>("ConsolidationBalanceCheck");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationBalanceCheck_Text</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "ConsolidationBalanceCheck_Text" )
    @JsonProperty( "ConsolidationBalanceCheck_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationBalanceCheck_Text" )
    private String consolidationBalanceCheck_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationBalanceCheck_Text</b> field to query operations.
     *
     */
    public final static ConsolidationDocumentTypeField<String> CONSOLIDATION_BALANCE_CHECK_TEXT =
        new ConsolidationDocumentTypeField<String>("ConsolidationBalanceCheck_Text");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationPostgItemAutoFlag</b>
     * </p>
     *
     * @return Manual Posting
     */
    @SerializedName( "ConsolidationPostgItemAutoFlag" )
    @JsonProperty( "ConsolidationPostgItemAutoFlag" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConsolidationPostgItemAutoFlag" )
    private Boolean consolidationPostgItemAutoFlag;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationPostgItemAutoFlag</b> field to query operations.
     *
     */
    public final static ConsolidationDocumentTypeField<Boolean> CONSOLIDATION_POSTG_ITEM_AUTO_FLAG =
        new ConsolidationDocumentTypeField<Boolean>("ConsolidationPostgItemAutoFlag");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDocumentPostInTransCurrency</b>
     * </p>
     *
     * @return Post in transaction currency
     */
    @SerializedName( "IsDocumentPostInTransCurrency" )
    @JsonProperty( "IsDocumentPostInTransCurrency" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDocumentPostInTransCurrency" )
    private Boolean isDocumentPostInTransCurrency;
    /**
     * Use with available fluent helpers to apply the <b>IsDocumentPostInTransCurrency</b> field to query operations.
     *
     */
    public final static ConsolidationDocumentTypeField<Boolean> IS_DOCUMENT_POST_IN_TRANS_CURRENCY =
        new ConsolidationDocumentTypeField<Boolean>("IsDocumentPostInTransCurrency");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDocumentPostInLocalCurrency</b>
     * </p>
     *
     * @return Post in local currency
     */
    @SerializedName( "IsDocumentPostInLocalCurrency" )
    @JsonProperty( "IsDocumentPostInLocalCurrency" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDocumentPostInLocalCurrency" )
    private Boolean isDocumentPostInLocalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>IsDocumentPostInLocalCurrency</b> field to query operations.
     *
     */
    public final static ConsolidationDocumentTypeField<Boolean> IS_DOCUMENT_POST_IN_LOCAL_CURRENCY =
        new ConsolidationDocumentTypeField<Boolean>("IsDocumentPostInLocalCurrency");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDocumentPostInGroupCurrency</b>
     * </p>
     *
     * @return Post in group currency
     */
    @SerializedName( "IsDocumentPostInGroupCurrency" )
    @JsonProperty( "IsDocumentPostInGroupCurrency" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDocumentPostInGroupCurrency" )
    private Boolean isDocumentPostInGroupCurrency;
    /**
     * Use with available fluent helpers to apply the <b>IsDocumentPostInGroupCurrency</b> field to query operations.
     *
     */
    public final static ConsolidationDocumentTypeField<Boolean> IS_DOCUMENT_POST_IN_GROUP_CURRENCY =
        new ConsolidationDocumentTypeField<Boolean>("IsDocumentPostInGroupCurrency");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocHasCreditDeferredTax</b>
     * </p>
     *
     * @return Credit deferred income taxes
     */
    @SerializedName( "DocHasCreditDeferredTax" )
    @JsonProperty( "DocHasCreditDeferredTax" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DocHasCreditDeferredTax" )
    private Boolean docHasCreditDeferredTax;
    /**
     * Use with available fluent helpers to apply the <b>DocHasCreditDeferredTax</b> field to query operations.
     *
     */
    public final static ConsolidationDocumentTypeField<Boolean> DOC_HAS_CREDIT_DEFERRED_TAX =
        new ConsolidationDocumentTypeField<Boolean>("DocHasCreditDeferredTax");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocHasDebitDeferredTax</b>
     * </p>
     *
     * @return Debit deferred income taxes
     */
    @SerializedName( "DocHasDebitDeferredTax" )
    @JsonProperty( "DocHasDebitDeferredTax" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DocHasDebitDeferredTax" )
    private Boolean docHasDebitDeferredTax;
    /**
     * Use with available fluent helpers to apply the <b>DocHasDebitDeferredTax</b> field to query operations.
     *
     */
    public final static ConsolidationDocumentTypeField<Boolean> DOC_HAS_DEBIT_DEFERRED_TAX =
        new ConsolidationDocumentTypeField<Boolean>("DocHasDebitDeferredTax");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DocumentTypeBusinessAppl</b>
     * </p>
     *
     * @return Business application
     */
    @SerializedName( "DocumentTypeBusinessAppl" )
    @JsonProperty( "DocumentTypeBusinessAppl" )
    @Nullable
    @ODataField( odataName = "DocumentTypeBusinessAppl" )
    private String documentTypeBusinessAppl;
    /**
     * Use with available fluent helpers to apply the <b>DocumentTypeBusinessAppl</b> field to query operations.
     *
     */
    public final static ConsolidationDocumentTypeField<String> DOCUMENT_TYPE_BUSINESS_APPL =
        new ConsolidationDocumentTypeField<String>("DocumentTypeBusinessAppl");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DocumentTypeBusinessAppl_Text</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "DocumentTypeBusinessAppl_Text" )
    @JsonProperty( "DocumentTypeBusinessAppl_Text" )
    @Nullable
    @ODataField( odataName = "DocumentTypeBusinessAppl_Text" )
    private String documentTypeBusinessAppl_Text;
    /**
     * Use with available fluent helpers to apply the <b>DocumentTypeBusinessAppl_Text</b> field to query operations.
     *
     */
    public final static ConsolidationDocumentTypeField<String> DOCUMENT_TYPE_BUSINESS_APPL_TEXT =
        new ConsolidationDocumentTypeField<String>("DocumentTypeBusinessAppl_Text");
    /**
     * Navigation property <b>to_CnsldtnDocumentTypeHier</b> for <b>ConsolidationDocumentType</b> to multiple
     * <b>DocumentTypeHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnDocumentTypeHier" )
    @JsonProperty( "to_CnsldtnDocumentTypeHier" )
    @ODataField( odataName = "to_CnsldtnDocumentTypeHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DocumentTypeHier> toCnsldtnDocumentTypeHier;
    /**
     * Navigation property <b>to_CnsldtnDocumentTypeT</b> for <b>ConsolidationDocumentType</b> to multiple
     * <b>ConsolidationDocTypeText</b>.
     *
     */
    @SerializedName( "to_CnsldtnDocumentTypeT" )
    @JsonProperty( "to_CnsldtnDocumentTypeT" )
    @ODataField( odataName = "to_CnsldtnDocumentTypeT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConsolidationDocTypeText> toCnsldtnDocumentTypeT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnDocumentTypeHier</b> navigation property to query
     * operations.
     *
     */
    public final static ConsolidationDocumentTypeLink<DocumentTypeHier> TO_CNSLDTN_DOCUMENT_TYPE_HIER =
        new ConsolidationDocumentTypeLink<DocumentTypeHier>("to_CnsldtnDocumentTypeHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnDocumentTypeT</b> navigation property to query
     * operations.
     *
     */
    public final static ConsolidationDocumentTypeLink<ConsolidationDocTypeText> TO_CNSLDTN_DOCUMENT_TYPE_T =
        new ConsolidationDocumentTypeLink<ConsolidationDocTypeText>("to_CnsldtnDocumentTypeT");

    @Nonnull
    @Override
    public Class<ConsolidationDocumentType> getType()
    {
        return ConsolidationDocumentType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentType</b>
     * </p>
     *
     * @param consolidationDocumentType
     *            Document Type
     */
    public void setConsolidationDocumentType( @Nullable final String consolidationDocumentType )
    {
        rememberChangedField("ConsolidationDocumentType", this.consolidationDocumentType);
        this.consolidationDocumentType = consolidationDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentType_Text</b>
     * </p>
     *
     * @param consolidationDocumentType_Text
     *            Document Type Description
     */
    public void setConsolidationDocumentType_Text( @Nullable final String consolidationDocumentType_Text )
    {
        rememberChangedField("ConsolidationDocumentType_Text", this.consolidationDocumentType_Text);
        this.consolidationDocumentType_Text = consolidationDocumentType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevel</b>
     * </p>
     *
     * @param postingLevel
     *            Posting Level
     */
    public void setPostingLevel( @Nullable final String postingLevel )
    {
        rememberChangedField("PostingLevel", this.postingLevel);
        this.postingLevel = postingLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevel_Text</b>
     * </p>
     *
     * @param postingLevel_Text
     *            Document Type Description
     */
    public void setPostingLevel_Text( @Nullable final String postingLevel_Text )
    {
        rememberChangedField("PostingLevel_Text", this.postingLevel_Text);
        this.postingLevel_Text = postingLevel_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationBalanceCheck</b>
     * </p>
     *
     * @param consolidationBalanceCheck
     *            Balance check for consolidation document
     */
    public void setConsolidationBalanceCheck( @Nullable final String consolidationBalanceCheck )
    {
        rememberChangedField("ConsolidationBalanceCheck", this.consolidationBalanceCheck);
        this.consolidationBalanceCheck = consolidationBalanceCheck;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationBalanceCheck_Text</b>
     * </p>
     *
     * @param consolidationBalanceCheck_Text
     *            Short Text for Fixed Values
     */
    public void setConsolidationBalanceCheck_Text( @Nullable final String consolidationBalanceCheck_Text )
    {
        rememberChangedField("ConsolidationBalanceCheck_Text", this.consolidationBalanceCheck_Text);
        this.consolidationBalanceCheck_Text = consolidationBalanceCheck_Text;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationPostgItemAutoFlag</b>
     * </p>
     *
     * @param consolidationPostgItemAutoFlag
     *            Manual Posting
     */
    public void setConsolidationPostgItemAutoFlag( @Nullable final Boolean consolidationPostgItemAutoFlag )
    {
        rememberChangedField("ConsolidationPostgItemAutoFlag", this.consolidationPostgItemAutoFlag);
        this.consolidationPostgItemAutoFlag = consolidationPostgItemAutoFlag;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDocumentPostInTransCurrency</b>
     * </p>
     *
     * @param isDocumentPostInTransCurrency
     *            Post in transaction currency
     */
    public void setIsDocumentPostInTransCurrency( @Nullable final Boolean isDocumentPostInTransCurrency )
    {
        rememberChangedField("IsDocumentPostInTransCurrency", this.isDocumentPostInTransCurrency);
        this.isDocumentPostInTransCurrency = isDocumentPostInTransCurrency;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDocumentPostInLocalCurrency</b>
     * </p>
     *
     * @param isDocumentPostInLocalCurrency
     *            Post in local currency
     */
    public void setIsDocumentPostInLocalCurrency( @Nullable final Boolean isDocumentPostInLocalCurrency )
    {
        rememberChangedField("IsDocumentPostInLocalCurrency", this.isDocumentPostInLocalCurrency);
        this.isDocumentPostInLocalCurrency = isDocumentPostInLocalCurrency;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDocumentPostInGroupCurrency</b>
     * </p>
     *
     * @param isDocumentPostInGroupCurrency
     *            Post in group currency
     */
    public void setIsDocumentPostInGroupCurrency( @Nullable final Boolean isDocumentPostInGroupCurrency )
    {
        rememberChangedField("IsDocumentPostInGroupCurrency", this.isDocumentPostInGroupCurrency);
        this.isDocumentPostInGroupCurrency = isDocumentPostInGroupCurrency;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocHasCreditDeferredTax</b>
     * </p>
     *
     * @param docHasCreditDeferredTax
     *            Credit deferred income taxes
     */
    public void setDocHasCreditDeferredTax( @Nullable final Boolean docHasCreditDeferredTax )
    {
        rememberChangedField("DocHasCreditDeferredTax", this.docHasCreditDeferredTax);
        this.docHasCreditDeferredTax = docHasCreditDeferredTax;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocHasDebitDeferredTax</b>
     * </p>
     *
     * @param docHasDebitDeferredTax
     *            Debit deferred income taxes
     */
    public void setDocHasDebitDeferredTax( @Nullable final Boolean docHasDebitDeferredTax )
    {
        rememberChangedField("DocHasDebitDeferredTax", this.docHasDebitDeferredTax);
        this.docHasDebitDeferredTax = docHasDebitDeferredTax;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DocumentTypeBusinessAppl</b>
     * </p>
     *
     * @param documentTypeBusinessAppl
     *            Business application
     */
    public void setDocumentTypeBusinessAppl( @Nullable final String documentTypeBusinessAppl )
    {
        rememberChangedField("DocumentTypeBusinessAppl", this.documentTypeBusinessAppl);
        this.documentTypeBusinessAppl = documentTypeBusinessAppl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DocumentTypeBusinessAppl_Text</b>
     * </p>
     *
     * @param documentTypeBusinessAppl_Text
     *            Short Text for Fixed Values
     */
    public void setDocumentTypeBusinessAppl_Text( @Nullable final String documentTypeBusinessAppl_Text )
    {
        rememberChangedField("DocumentTypeBusinessAppl_Text", this.documentTypeBusinessAppl_Text);
        this.documentTypeBusinessAppl_Text = documentTypeBusinessAppl_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationDocumentType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationDocumentType", getConsolidationDocumentType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationDocumentType", getConsolidationDocumentType());
        values.put("ConsolidationDocumentType_Text", getConsolidationDocumentType_Text());
        values.put("PostingLevel", getPostingLevel());
        values.put("PostingLevel_Text", getPostingLevel_Text());
        values.put("ConsolidationBalanceCheck", getConsolidationBalanceCheck());
        values.put("ConsolidationBalanceCheck_Text", getConsolidationBalanceCheck_Text());
        values.put("ConsolidationPostgItemAutoFlag", getConsolidationPostgItemAutoFlag());
        values.put("IsDocumentPostInTransCurrency", getIsDocumentPostInTransCurrency());
        values.put("IsDocumentPostInLocalCurrency", getIsDocumentPostInLocalCurrency());
        values.put("IsDocumentPostInGroupCurrency", getIsDocumentPostInGroupCurrency());
        values.put("DocHasCreditDeferredTax", getDocHasCreditDeferredTax());
        values.put("DocHasDebitDeferredTax", getDocHasDebitDeferredTax());
        values.put("DocumentTypeBusinessAppl", getDocumentTypeBusinessAppl());
        values.put("DocumentTypeBusinessAppl_Text", getDocumentTypeBusinessAppl_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationDocumentType") ) {
                final Object value = values.remove("ConsolidationDocumentType");
                if( (value == null) || (!value.equals(getConsolidationDocumentType())) ) {
                    setConsolidationDocumentType(((String) value));
                }
            }
            if( values.containsKey("ConsolidationDocumentType_Text") ) {
                final Object value = values.remove("ConsolidationDocumentType_Text");
                if( (value == null) || (!value.equals(getConsolidationDocumentType_Text())) ) {
                    setConsolidationDocumentType_Text(((String) value));
                }
            }
            if( values.containsKey("PostingLevel") ) {
                final Object value = values.remove("PostingLevel");
                if( (value == null) || (!value.equals(getPostingLevel())) ) {
                    setPostingLevel(((String) value));
                }
            }
            if( values.containsKey("PostingLevel_Text") ) {
                final Object value = values.remove("PostingLevel_Text");
                if( (value == null) || (!value.equals(getPostingLevel_Text())) ) {
                    setPostingLevel_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationBalanceCheck") ) {
                final Object value = values.remove("ConsolidationBalanceCheck");
                if( (value == null) || (!value.equals(getConsolidationBalanceCheck())) ) {
                    setConsolidationBalanceCheck(((String) value));
                }
            }
            if( values.containsKey("ConsolidationBalanceCheck_Text") ) {
                final Object value = values.remove("ConsolidationBalanceCheck_Text");
                if( (value == null) || (!value.equals(getConsolidationBalanceCheck_Text())) ) {
                    setConsolidationBalanceCheck_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationPostgItemAutoFlag") ) {
                final Object value = values.remove("ConsolidationPostgItemAutoFlag");
                if( (value == null) || (!value.equals(getConsolidationPostgItemAutoFlag())) ) {
                    setConsolidationPostgItemAutoFlag(((Boolean) value));
                }
            }
            if( values.containsKey("IsDocumentPostInTransCurrency") ) {
                final Object value = values.remove("IsDocumentPostInTransCurrency");
                if( (value == null) || (!value.equals(getIsDocumentPostInTransCurrency())) ) {
                    setIsDocumentPostInTransCurrency(((Boolean) value));
                }
            }
            if( values.containsKey("IsDocumentPostInLocalCurrency") ) {
                final Object value = values.remove("IsDocumentPostInLocalCurrency");
                if( (value == null) || (!value.equals(getIsDocumentPostInLocalCurrency())) ) {
                    setIsDocumentPostInLocalCurrency(((Boolean) value));
                }
            }
            if( values.containsKey("IsDocumentPostInGroupCurrency") ) {
                final Object value = values.remove("IsDocumentPostInGroupCurrency");
                if( (value == null) || (!value.equals(getIsDocumentPostInGroupCurrency())) ) {
                    setIsDocumentPostInGroupCurrency(((Boolean) value));
                }
            }
            if( values.containsKey("DocHasCreditDeferredTax") ) {
                final Object value = values.remove("DocHasCreditDeferredTax");
                if( (value == null) || (!value.equals(getDocHasCreditDeferredTax())) ) {
                    setDocHasCreditDeferredTax(((Boolean) value));
                }
            }
            if( values.containsKey("DocHasDebitDeferredTax") ) {
                final Object value = values.remove("DocHasDebitDeferredTax");
                if( (value == null) || (!value.equals(getDocHasDebitDeferredTax())) ) {
                    setDocHasDebitDeferredTax(((Boolean) value));
                }
            }
            if( values.containsKey("DocumentTypeBusinessAppl") ) {
                final Object value = values.remove("DocumentTypeBusinessAppl");
                if( (value == null) || (!value.equals(getDocumentTypeBusinessAppl())) ) {
                    setDocumentTypeBusinessAppl(((String) value));
                }
            }
            if( values.containsKey("DocumentTypeBusinessAppl_Text") ) {
                final Object value = values.remove("DocumentTypeBusinessAppl_Text");
                if( (value == null) || (!value.equals(getDocumentTypeBusinessAppl_Text())) ) {
                    setDocumentTypeBusinessAppl_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnDocumentTypeHier") ) {
                final Object value = (values).remove("to_CnsldtnDocumentTypeHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnDocumentTypeHier == null ) {
                        toCnsldtnDocumentTypeHier = Lists.newArrayList();
                    } else {
                        toCnsldtnDocumentTypeHier = Lists.newArrayList(toCnsldtnDocumentTypeHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DocumentTypeHier entity;
                        if( toCnsldtnDocumentTypeHier.size() > i ) {
                            entity = toCnsldtnDocumentTypeHier.get(i);
                        } else {
                            entity = new DocumentTypeHier();
                            toCnsldtnDocumentTypeHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnDocumentTypeT") ) {
                final Object value = (values).remove("to_CnsldtnDocumentTypeT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnDocumentTypeT == null ) {
                        toCnsldtnDocumentTypeT = Lists.newArrayList();
                    } else {
                        toCnsldtnDocumentTypeT = Lists.newArrayList(toCnsldtnDocumentTypeT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConsolidationDocTypeText entity;
                        if( toCnsldtnDocumentTypeT.size() > i ) {
                            entity = toCnsldtnDocumentTypeT.get(i);
                        } else {
                            entity = new ConsolidationDocTypeText();
                            toCnsldtnDocumentTypeT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationDocumentTypeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationDocumentTypeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationDocumentTypeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationDocumentTypeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnDocumentTypeHier != null ) {
            (values).put("to_CnsldtnDocumentTypeHier", toCnsldtnDocumentTypeHier);
        }
        if( toCnsldtnDocumentTypeT != null ) {
            (values).put("to_CnsldtnDocumentTypeT", toCnsldtnDocumentTypeT);
        }
        return values;
    }

    /**
     * Fetches the <b>DocumentTypeHier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnDocumentTypeHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DocumentTypeHier</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocumentTypeHier> fetchCnsldtnDocumentTypeHier()
    {
        return fetchFieldAsList("to_CnsldtnDocumentTypeHier", DocumentTypeHier.class);
    }

    /**
     * Retrieval of associated <b>DocumentTypeHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnDocumentTypeHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDocumentTypeHier</b> of a queried <b>ConsolidationDocumentType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DocumentTypeHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocumentTypeHier> getCnsldtnDocumentTypeHierOrFetch()
    {
        if( toCnsldtnDocumentTypeHier == null ) {
            toCnsldtnDocumentTypeHier = fetchCnsldtnDocumentTypeHier();
        }
        return toCnsldtnDocumentTypeHier;
    }

    /**
     * Retrieval of associated <b>DocumentTypeHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnDocumentTypeHier</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationDocumentType</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnDocumentTypeHier</b> is already loaded, the
     *         result will contain the <b>DocumentTypeHier</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DocumentTypeHier>> getCnsldtnDocumentTypeHierIfPresent()
    {
        return Option.of(toCnsldtnDocumentTypeHier);
    }

    /**
     * Overwrites the list of associated <b>DocumentTypeHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnDocumentTypeHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDocumentTypeHier</b> of a queried <b>ConsolidationDocumentType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DocumentTypeHier</b> entities.
     */
    public void setCnsldtnDocumentTypeHier( @Nonnull final List<DocumentTypeHier> value )
    {
        if( toCnsldtnDocumentTypeHier == null ) {
            toCnsldtnDocumentTypeHier = Lists.newArrayList();
        }
        toCnsldtnDocumentTypeHier.clear();
        toCnsldtnDocumentTypeHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DocumentTypeHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnDocumentTypeHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDocumentTypeHier</b> of a queried <b>ConsolidationDocumentType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DocumentTypeHier</b> entities.
     */
    public void addCnsldtnDocumentTypeHier( DocumentTypeHier... entity )
    {
        if( toCnsldtnDocumentTypeHier == null ) {
            toCnsldtnDocumentTypeHier = Lists.newArrayList();
        }
        toCnsldtnDocumentTypeHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ConsolidationDocTypeText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnDocumentTypeT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ConsolidationDocTypeText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationDocTypeText> fetchCnsldtnDocumentTypeT()
    {
        return fetchFieldAsList("to_CnsldtnDocumentTypeT", ConsolidationDocTypeText.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationDocTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnDocumentTypeT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDocumentTypeT</b> of a queried <b>ConsolidationDocumentType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationDocTypeText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationDocTypeText> getCnsldtnDocumentTypeTOrFetch()
    {
        if( toCnsldtnDocumentTypeT == null ) {
            toCnsldtnDocumentTypeT = fetchCnsldtnDocumentTypeT();
        }
        return toCnsldtnDocumentTypeT;
    }

    /**
     * Retrieval of associated <b>ConsolidationDocTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnDocumentTypeT</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationDocumentType</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnDocumentTypeT</b> is already loaded, the result
     *         will contain the <b>ConsolidationDocTypeText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ConsolidationDocTypeText>> getCnsldtnDocumentTypeTIfPresent()
    {
        return Option.of(toCnsldtnDocumentTypeT);
    }

    /**
     * Overwrites the list of associated <b>ConsolidationDocTypeText</b> entities for the loaded navigation property
     * <b>to_CnsldtnDocumentTypeT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDocumentTypeT</b> of a queried <b>ConsolidationDocumentType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ConsolidationDocTypeText</b> entities.
     */
    public void setCnsldtnDocumentTypeT( @Nonnull final List<ConsolidationDocTypeText> value )
    {
        if( toCnsldtnDocumentTypeT == null ) {
            toCnsldtnDocumentTypeT = Lists.newArrayList();
        }
        toCnsldtnDocumentTypeT.clear();
        toCnsldtnDocumentTypeT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConsolidationDocTypeText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnDocumentTypeT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDocumentTypeT</b> of a queried <b>ConsolidationDocumentType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ConsolidationDocTypeText</b> entities.
     */
    public void addCnsldtnDocumentTypeT( ConsolidationDocTypeText... entity )
    {
        if( toCnsldtnDocumentTypeT == null ) {
            toCnsldtnDocumentTypeT = Lists.newArrayList();
        }
        toCnsldtnDocumentTypeT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationDocumentType instances.
     *
     */
    public final static class ConsolidationDocumentTypeBuilder
    {

        private List<DocumentTypeHier> toCnsldtnDocumentTypeHier = Lists.newArrayList();
        private List<ConsolidationDocTypeText> toCnsldtnDocumentTypeT = Lists.newArrayList();

        private ConsolidationDocumentType.ConsolidationDocumentTypeBuilder toCnsldtnDocumentTypeHier(
            final List<DocumentTypeHier> value )
        {
            toCnsldtnDocumentTypeHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnDocumentTypeHier</b> for <b>ConsolidationDocumentType</b> to multiple
         * <b>DocumentTypeHier</b>.
         *
         * @param value
         *            The DocumentTypeHiers to build this ConsolidationDocumentType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationDocumentType.ConsolidationDocumentTypeBuilder cnsldtnDocumentTypeHier(
            DocumentTypeHier... value )
        {
            return toCnsldtnDocumentTypeHier(Lists.newArrayList(value));
        }

        private ConsolidationDocumentType.ConsolidationDocumentTypeBuilder toCnsldtnDocumentTypeT(
            final List<ConsolidationDocTypeText> value )
        {
            toCnsldtnDocumentTypeT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnDocumentTypeT</b> for <b>ConsolidationDocumentType</b> to multiple
         * <b>ConsolidationDocTypeText</b>.
         *
         * @param value
         *            The ConsolidationDocTypeTexts to build this ConsolidationDocumentType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationDocumentType.ConsolidationDocumentTypeBuilder cnsldtnDocumentTypeT(
            ConsolidationDocTypeText... value )
        {
            return toCnsldtnDocumentTypeT(Lists.newArrayList(value));
        }

    }

}
