/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationGroupField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationGroupLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationGroupSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Group
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationGroupType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationGroup extends VdmEntity<ConsolidationGroup>
{

    /**
     * Selector for all available fields of ConsolidationGroup.
     *
     */
    public final static ConsolidationGroupSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationGroup</b>
     * </p>
     *
     * @return Consolidation Group
     */
    @Key
    @SerializedName( "ConsolidationGroup" )
    @JsonProperty( "ConsolidationGroup" )
    @Nullable
    @ODataField( odataName = "ConsolidationGroup" )
    private String consolidationGroup;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationGroup</b> field to query operations.
     *
     */
    public final static ConsolidationGroupField<String> CONSOLIDATION_GROUP =
        new ConsolidationGroupField<String>("ConsolidationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationGroup_Text</b>
     * </p>
     *
     * @return Consolidation Group Description
     */
    @SerializedName( "ConsolidationGroup_Text" )
    @JsonProperty( "ConsolidationGroup_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationGroup_Text" )
    private String consolidationGroup_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationGroup_Text</b> field to query operations.
     *
     */
    public final static ConsolidationGroupField<String> CONSOLIDATION_GROUP_TEXT =
        new ConsolidationGroupField<String>("ConsolidationGroup_Text");
    /**
     * Navigation property <b>to_CnsldtnGroupT</b> for <b>ConsolidationGroup</b> to multiple
     * <b>ConsolidationGroupText</b>.
     *
     */
    @SerializedName( "to_CnsldtnGroupT" )
    @JsonProperty( "to_CnsldtnGroupT" )
    @ODataField( odataName = "to_CnsldtnGroupT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConsolidationGroupText> toCnsldtnGroupT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnGroupT</b> navigation property to query operations.
     *
     */
    public final static ConsolidationGroupLink<ConsolidationGroupText> TO_CNSLDTN_GROUP_T =
        new ConsolidationGroupLink<ConsolidationGroupText>("to_CnsldtnGroupT");

    @Nonnull
    @Override
    public Class<ConsolidationGroup> getType()
    {
        return ConsolidationGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationGroup</b>
     * </p>
     *
     * @param consolidationGroup
     *            Consolidation Group
     */
    public void setConsolidationGroup( @Nullable final String consolidationGroup )
    {
        rememberChangedField("ConsolidationGroup", this.consolidationGroup);
        this.consolidationGroup = consolidationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationGroup_Text</b>
     * </p>
     *
     * @param consolidationGroup_Text
     *            Consolidation Group Description
     */
    public void setConsolidationGroup_Text( @Nullable final String consolidationGroup_Text )
    {
        rememberChangedField("ConsolidationGroup_Text", this.consolidationGroup_Text);
        this.consolidationGroup_Text = consolidationGroup_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationGroup";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationGroup", getConsolidationGroup());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationGroup", getConsolidationGroup());
        values.put("ConsolidationGroup_Text", getConsolidationGroup_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationGroup") ) {
                final Object value = values.remove("ConsolidationGroup");
                if( (value == null) || (!value.equals(getConsolidationGroup())) ) {
                    setConsolidationGroup(((String) value));
                }
            }
            if( values.containsKey("ConsolidationGroup_Text") ) {
                final Object value = values.remove("ConsolidationGroup_Text");
                if( (value == null) || (!value.equals(getConsolidationGroup_Text())) ) {
                    setConsolidationGroup_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnGroupT") ) {
                final Object value = (values).remove("to_CnsldtnGroupT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnGroupT == null ) {
                        toCnsldtnGroupT = Lists.newArrayList();
                    } else {
                        toCnsldtnGroupT = Lists.newArrayList(toCnsldtnGroupT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConsolidationGroupText entity;
                        if( toCnsldtnGroupT.size() > i ) {
                            entity = toCnsldtnGroupT.get(i);
                        } else {
                            entity = new ConsolidationGroupText();
                            toCnsldtnGroupT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationGroupField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationGroupField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationGroupField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationGroupField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnGroupT != null ) {
            (values).put("to_CnsldtnGroupT", toCnsldtnGroupT);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationGroupText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnGroupT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ConsolidationGroupText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationGroupText> fetchCnsldtnGroupT()
    {
        return fetchFieldAsList("to_CnsldtnGroupT", ConsolidationGroupText.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationGroupText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnGroupT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGroupT</b> of a queried <b>ConsolidationGroup</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationGroupText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationGroupText> getCnsldtnGroupTOrFetch()
    {
        if( toCnsldtnGroupT == null ) {
            toCnsldtnGroupT = fetchCnsldtnGroupT();
        }
        return toCnsldtnGroupT;
    }

    /**
     * Retrieval of associated <b>ConsolidationGroupText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnGroupT</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationGroup</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnGroupT</b> is already loaded, the result will
     *         contain the <b>ConsolidationGroupText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ConsolidationGroupText>> getCnsldtnGroupTIfPresent()
    {
        return Option.of(toCnsldtnGroupT);
    }

    /**
     * Overwrites the list of associated <b>ConsolidationGroupText</b> entities for the loaded navigation property
     * <b>to_CnsldtnGroupT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGroupT</b> of a queried <b>ConsolidationGroup</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ConsolidationGroupText</b> entities.
     */
    public void setCnsldtnGroupT( @Nonnull final List<ConsolidationGroupText> value )
    {
        if( toCnsldtnGroupT == null ) {
            toCnsldtnGroupT = Lists.newArrayList();
        }
        toCnsldtnGroupT.clear();
        toCnsldtnGroupT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConsolidationGroupText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnGroupT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGroupT</b> of a queried <b>ConsolidationGroup</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ConsolidationGroupText</b> entities.
     */
    public void addCnsldtnGroupT( ConsolidationGroupText... entity )
    {
        if( toCnsldtnGroupT == null ) {
            toCnsldtnGroupT = Lists.newArrayList();
        }
        toCnsldtnGroupT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationGroup instances.
     *
     */
    public final static class ConsolidationGroupBuilder
    {

        private List<ConsolidationGroupText> toCnsldtnGroupT = Lists.newArrayList();

        private ConsolidationGroup.ConsolidationGroupBuilder toCnsldtnGroupT( final List<ConsolidationGroupText> value )
        {
            toCnsldtnGroupT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnGroupT</b> for <b>ConsolidationGroup</b> to multiple
         * <b>ConsolidationGroupText</b>.
         *
         * @param value
         *            The ConsolidationGroupTexts to build this ConsolidationGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationGroup.ConsolidationGroupBuilder cnsldtnGroupT( ConsolidationGroupText... value )
        {
            return toCnsldtnGroupT(Lists.newArrayList(value));
        }

    }

}
