/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationGroupSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationGroup
 * ConsolidationGroup} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class ConsolidationGroupByKeyFluentHelper
    extends
    FluentHelperByKey<ConsolidationGroupByKeyFluentHelper, ConsolidationGroup, ConsolidationGroupSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationGroup
     * ConsolidationGroup} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ConsolidationGroup}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ConsolidationGroup}
     * @param consolidationGroup
     *            Consolidation Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     */
    public ConsolidationGroupByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String consolidationGroup )
    {
        super(servicePath, entityCollection);
        this.key.put("ConsolidationGroup", consolidationGroup);
    }

    @Override
    @Nonnull
    protected Class<ConsolidationGroup> getEntityClass()
    {
        return ConsolidationGroup.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
