/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationGroupTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationGroupTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationGroupTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Group Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationGroupTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationGroupText extends VdmEntity<ConsolidationGroupText>
{

    /**
     * Selector for all available fields of ConsolidationGroupText.
     *
     */
    public final static ConsolidationGroupTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationGroup</b>
     * </p>
     *
     * @return Consolidation Group
     */
    @Key
    @SerializedName( "ConsolidationGroup" )
    @JsonProperty( "ConsolidationGroup" )
    @Nullable
    @ODataField( odataName = "ConsolidationGroup" )
    private String consolidationGroup;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationGroup</b> field to query operations.
     *
     */
    public final static ConsolidationGroupTextField<String> CONSOLIDATION_GROUP =
        new ConsolidationGroupTextField<String>("ConsolidationGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ConsolidationGroupTextField<String> LANGUAGE =
        new ConsolidationGroupTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationGroupText</b>
     * </p>
     *
     * @return Consolidation Group Description
     */
    @SerializedName( "ConsolidationGroupText" )
    @JsonProperty( "ConsolidationGroupText" )
    @Nullable
    @ODataField( odataName = "ConsolidationGroupText" )
    private String consolidationGroupText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationGroupText</b> field to query operations.
     *
     */
    public final static ConsolidationGroupTextField<String> CONSOLIDATION_GROUP_TEXT =
        new ConsolidationGroupTextField<String>("ConsolidationGroupText");
    /**
     * Navigation property <b>to_CnsldtnGroup</b> for <b>ConsolidationGroupText</b> to single <b>ConsolidationGroup</b>.
     *
     */
    @SerializedName( "to_CnsldtnGroup" )
    @JsonProperty( "to_CnsldtnGroup" )
    @ODataField( odataName = "to_CnsldtnGroup" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConsolidationGroup toCnsldtnGroup;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnGroup</b> navigation property to query operations.
     *
     */
    public final static ConsolidationGroupTextOneToOneLink<ConsolidationGroup> TO_CNSLDTN_GROUP =
        new ConsolidationGroupTextOneToOneLink<ConsolidationGroup>("to_CnsldtnGroup");

    @Nonnull
    @Override
    public Class<ConsolidationGroupText> getType()
    {
        return ConsolidationGroupText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationGroup</b>
     * </p>
     *
     * @param consolidationGroup
     *            Consolidation Group
     */
    public void setConsolidationGroup( @Nullable final String consolidationGroup )
    {
        rememberChangedField("ConsolidationGroup", this.consolidationGroup);
        this.consolidationGroup = consolidationGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationGroupText</b>
     * </p>
     *
     * @param consolidationGroupText
     *            Consolidation Group Description
     */
    public void setConsolidationGroupText( @Nullable final String consolidationGroupText )
    {
        rememberChangedField("ConsolidationGroupText", this.consolidationGroupText);
        this.consolidationGroupText = consolidationGroupText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationGroupText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationGroup", getConsolidationGroup());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationGroup", getConsolidationGroup());
        values.put("Language", getLanguage());
        values.put("ConsolidationGroupText", getConsolidationGroupText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationGroup") ) {
                final Object value = values.remove("ConsolidationGroup");
                if( (value == null) || (!value.equals(getConsolidationGroup())) ) {
                    setConsolidationGroup(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationGroupText") ) {
                final Object value = values.remove("ConsolidationGroupText");
                if( (value == null) || (!value.equals(getConsolidationGroupText())) ) {
                    setConsolidationGroupText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnGroup") ) {
                final Object value = (values).remove("to_CnsldtnGroup");
                if( value instanceof Map ) {
                    if( toCnsldtnGroup == null ) {
                        toCnsldtnGroup = new ConsolidationGroup();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnGroup.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationGroupTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationGroupTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationGroupTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationGroupTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnGroup != null ) {
            (values).put("to_CnsldtnGroup", toCnsldtnGroup);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationGroup</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnGroup</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ConsolidationGroup</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationGroup fetchCnsldtnGroup()
    {
        return fetchFieldAsSingle("to_CnsldtnGroup", ConsolidationGroup.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnGroup</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGroup</b> of a queried <b>ConsolidationGroupText</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationGroup</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationGroup getCnsldtnGroupOrFetch()
    {
        if( toCnsldtnGroup == null ) {
            toCnsldtnGroup = fetchCnsldtnGroup();
        }
        return toCnsldtnGroup;
    }

    /**
     * Retrieval of associated <b>ConsolidationGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnGroup</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationGroupText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnGroup</b> is already loaded, the result will
     *         contain the <b>ConsolidationGroup</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConsolidationGroup> getCnsldtnGroupIfPresent()
    {
        return Option.of(toCnsldtnGroup);
    }

    /**
     * Overwrites the associated <b>ConsolidationGroup</b> entity for the loaded navigation property
     * <b>to_CnsldtnGroup</b>.
     *
     * @param value
     *            New <b>ConsolidationGroup</b> entity.
     */
    public void setCnsldtnGroup( final ConsolidationGroup value )
    {
        toCnsldtnGroup = value;
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationGroupText instances.
     *
     */
    public final static class ConsolidationGroupTextBuilder
    {

        private ConsolidationGroup toCnsldtnGroup;

        private ConsolidationGroupText.ConsolidationGroupTextBuilder toCnsldtnGroup( final ConsolidationGroup value )
        {
            toCnsldtnGroup = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnGroup</b> for <b>ConsolidationGroupText</b> to single
         * <b>ConsolidationGroup</b>.
         *
         * @param value
         *            The ConsolidationGroup to build this ConsolidationGroupText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationGroupText.ConsolidationGroupTextBuilder cnsldtnGroup( final ConsolidationGroup value )
        {
            return toCnsldtnGroup(value);
        }

    }

}
