/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationLedgerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationLedgerLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationLedgerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Ledger
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationLedgerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationLedger extends VdmEntity<ConsolidationLedger>
{

    /**
     * Selector for all available fields of ConsolidationLedger.
     *
     */
    public final static ConsolidationLedgerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationLedger</b>
     * </p>
     *
     * @return Ledger
     */
    @Key
    @SerializedName( "ConsolidationLedger" )
    @JsonProperty( "ConsolidationLedger" )
    @Nullable
    @ODataField( odataName = "ConsolidationLedger" )
    private String consolidationLedger;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationLedger</b> field to query operations.
     *
     */
    public final static ConsolidationLedgerField<String> CONSOLIDATION_LEDGER =
        new ConsolidationLedgerField<String>("ConsolidationLedger");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationLedger_Text</b>
     * </p>
     *
     * @return Consolidation Ledger Description
     */
    @SerializedName( "ConsolidationLedger_Text" )
    @JsonProperty( "ConsolidationLedger_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationLedger_Text" )
    private String consolidationLedger_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationLedger_Text</b> field to query operations.
     *
     */
    public final static ConsolidationLedgerField<String> CONSOLIDATION_LEDGER_TEXT =
        new ConsolidationLedgerField<String>("ConsolidationLedger_Text");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GroupCurrency</b>
     * </p>
     *
     * @return Group Currency
     */
    @SerializedName( "GroupCurrency" )
    @JsonProperty( "GroupCurrency" )
    @Nullable
    @ODataField( odataName = "GroupCurrency" )
    private String groupCurrency;
    /**
     * Use with available fluent helpers to apply the <b>GroupCurrency</b> field to query operations.
     *
     */
    public final static ConsolidationLedgerField<String> GROUP_CURRENCY =
        new ConsolidationLedgerField<String>("GroupCurrency");
    /**
     * Navigation property <b>to_CnsldtnLedgerT</b> for <b>ConsolidationLedger</b> to multiple
     * <b>ConsolidationLedgerText</b>.
     *
     */
    @SerializedName( "to_CnsldtnLedgerT" )
    @JsonProperty( "to_CnsldtnLedgerT" )
    @ODataField( odataName = "to_CnsldtnLedgerT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConsolidationLedgerText> toCnsldtnLedgerT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnLedgerT</b> navigation property to query operations.
     *
     */
    public final static ConsolidationLedgerLink<ConsolidationLedgerText> TO_CNSLDTN_LEDGER_T =
        new ConsolidationLedgerLink<ConsolidationLedgerText>("to_CnsldtnLedgerT");

    @Nonnull
    @Override
    public Class<ConsolidationLedger> getType()
    {
        return ConsolidationLedger.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationLedger</b>
     * </p>
     *
     * @param consolidationLedger
     *            Ledger
     */
    public void setConsolidationLedger( @Nullable final String consolidationLedger )
    {
        rememberChangedField("ConsolidationLedger", this.consolidationLedger);
        this.consolidationLedger = consolidationLedger;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationLedger_Text</b>
     * </p>
     *
     * @param consolidationLedger_Text
     *            Consolidation Ledger Description
     */
    public void setConsolidationLedger_Text( @Nullable final String consolidationLedger_Text )
    {
        rememberChangedField("ConsolidationLedger_Text", this.consolidationLedger_Text);
        this.consolidationLedger_Text = consolidationLedger_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GroupCurrency</b>
     * </p>
     *
     * @param groupCurrency
     *            Group Currency
     */
    public void setGroupCurrency( @Nullable final String groupCurrency )
    {
        rememberChangedField("GroupCurrency", this.groupCurrency);
        this.groupCurrency = groupCurrency;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationLedger";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationLedger", getConsolidationLedger());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationLedger", getConsolidationLedger());
        values.put("ConsolidationLedger_Text", getConsolidationLedger_Text());
        values.put("GroupCurrency", getGroupCurrency());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationLedger") ) {
                final Object value = values.remove("ConsolidationLedger");
                if( (value == null) || (!value.equals(getConsolidationLedger())) ) {
                    setConsolidationLedger(((String) value));
                }
            }
            if( values.containsKey("ConsolidationLedger_Text") ) {
                final Object value = values.remove("ConsolidationLedger_Text");
                if( (value == null) || (!value.equals(getConsolidationLedger_Text())) ) {
                    setConsolidationLedger_Text(((String) value));
                }
            }
            if( values.containsKey("GroupCurrency") ) {
                final Object value = values.remove("GroupCurrency");
                if( (value == null) || (!value.equals(getGroupCurrency())) ) {
                    setGroupCurrency(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnLedgerT") ) {
                final Object value = (values).remove("to_CnsldtnLedgerT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnLedgerT == null ) {
                        toCnsldtnLedgerT = Lists.newArrayList();
                    } else {
                        toCnsldtnLedgerT = Lists.newArrayList(toCnsldtnLedgerT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConsolidationLedgerText entity;
                        if( toCnsldtnLedgerT.size() > i ) {
                            entity = toCnsldtnLedgerT.get(i);
                        } else {
                            entity = new ConsolidationLedgerText();
                            toCnsldtnLedgerT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationLedgerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationLedgerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationLedgerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationLedgerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnLedgerT != null ) {
            (values).put("to_CnsldtnLedgerT", toCnsldtnLedgerT);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationLedgerText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnLedgerT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ConsolidationLedgerText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationLedgerText> fetchCnsldtnLedgerT()
    {
        return fetchFieldAsList("to_CnsldtnLedgerT", ConsolidationLedgerText.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationLedgerText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnLedgerT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnLedgerT</b> of a queried <b>ConsolidationLedger</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationLedgerText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationLedgerText> getCnsldtnLedgerTOrFetch()
    {
        if( toCnsldtnLedgerT == null ) {
            toCnsldtnLedgerT = fetchCnsldtnLedgerT();
        }
        return toCnsldtnLedgerT;
    }

    /**
     * Retrieval of associated <b>ConsolidationLedgerText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnLedgerT</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationLedger</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnLedgerT</b> is already loaded, the result will
     *         contain the <b>ConsolidationLedgerText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ConsolidationLedgerText>> getCnsldtnLedgerTIfPresent()
    {
        return Option.of(toCnsldtnLedgerT);
    }

    /**
     * Overwrites the list of associated <b>ConsolidationLedgerText</b> entities for the loaded navigation property
     * <b>to_CnsldtnLedgerT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnLedgerT</b> of a queried <b>ConsolidationLedger</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ConsolidationLedgerText</b> entities.
     */
    public void setCnsldtnLedgerT( @Nonnull final List<ConsolidationLedgerText> value )
    {
        if( toCnsldtnLedgerT == null ) {
            toCnsldtnLedgerT = Lists.newArrayList();
        }
        toCnsldtnLedgerT.clear();
        toCnsldtnLedgerT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConsolidationLedgerText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnLedgerT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnLedgerT</b> of a queried <b>ConsolidationLedger</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ConsolidationLedgerText</b> entities.
     */
    public void addCnsldtnLedgerT( ConsolidationLedgerText... entity )
    {
        if( toCnsldtnLedgerT == null ) {
            toCnsldtnLedgerT = Lists.newArrayList();
        }
        toCnsldtnLedgerT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationLedger instances.
     *
     */
    public final static class ConsolidationLedgerBuilder
    {

        private List<ConsolidationLedgerText> toCnsldtnLedgerT = Lists.newArrayList();

        private ConsolidationLedger.ConsolidationLedgerBuilder toCnsldtnLedgerT(
            final List<ConsolidationLedgerText> value )
        {
            toCnsldtnLedgerT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnLedgerT</b> for <b>ConsolidationLedger</b> to multiple
         * <b>ConsolidationLedgerText</b>.
         *
         * @param value
         *            The ConsolidationLedgerTexts to build this ConsolidationLedger with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationLedger.ConsolidationLedgerBuilder cnsldtnLedgerT( ConsolidationLedgerText... value )
        {
            return toCnsldtnLedgerT(Lists.newArrayList(value));
        }

    }

}
