/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationLedgerTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationLedgerTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationLedgerTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Ledger Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationLedgerTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationLedgerText extends VdmEntity<ConsolidationLedgerText>
{

    /**
     * Selector for all available fields of ConsolidationLedgerText.
     *
     */
    public final static ConsolidationLedgerTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationLedger</b>
     * </p>
     *
     * @return Ledger
     */
    @Key
    @SerializedName( "ConsolidationLedger" )
    @JsonProperty( "ConsolidationLedger" )
    @Nullable
    @ODataField( odataName = "ConsolidationLedger" )
    private String consolidationLedger;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationLedger</b> field to query operations.
     *
     */
    public final static ConsolidationLedgerTextField<String> CONSOLIDATION_LEDGER =
        new ConsolidationLedgerTextField<String>("ConsolidationLedger");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ConsolidationLedgerTextField<String> LANGUAGE =
        new ConsolidationLedgerTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationLedgerText</b>
     * </p>
     *
     * @return Consolidation Ledger Description
     */
    @SerializedName( "ConsolidationLedgerText" )
    @JsonProperty( "ConsolidationLedgerText" )
    @Nullable
    @ODataField( odataName = "ConsolidationLedgerText" )
    private String consolidationLedgerText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationLedgerText</b> field to query operations.
     *
     */
    public final static ConsolidationLedgerTextField<String> CONSOLIDATION_LEDGER_TEXT =
        new ConsolidationLedgerTextField<String>("ConsolidationLedgerText");
    /**
     * Navigation property <b>to_CnsldtnLedger</b> for <b>ConsolidationLedgerText</b> to single
     * <b>ConsolidationLedger</b>.
     *
     */
    @SerializedName( "to_CnsldtnLedger" )
    @JsonProperty( "to_CnsldtnLedger" )
    @ODataField( odataName = "to_CnsldtnLedger" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConsolidationLedger toCnsldtnLedger;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnLedger</b> navigation property to query operations.
     *
     */
    public final static ConsolidationLedgerTextOneToOneLink<ConsolidationLedger> TO_CNSLDTN_LEDGER =
        new ConsolidationLedgerTextOneToOneLink<ConsolidationLedger>("to_CnsldtnLedger");

    @Nonnull
    @Override
    public Class<ConsolidationLedgerText> getType()
    {
        return ConsolidationLedgerText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationLedger</b>
     * </p>
     *
     * @param consolidationLedger
     *            Ledger
     */
    public void setConsolidationLedger( @Nullable final String consolidationLedger )
    {
        rememberChangedField("ConsolidationLedger", this.consolidationLedger);
        this.consolidationLedger = consolidationLedger;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationLedgerText</b>
     * </p>
     *
     * @param consolidationLedgerText
     *            Consolidation Ledger Description
     */
    public void setConsolidationLedgerText( @Nullable final String consolidationLedgerText )
    {
        rememberChangedField("ConsolidationLedgerText", this.consolidationLedgerText);
        this.consolidationLedgerText = consolidationLedgerText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationLedgerText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationLedger", getConsolidationLedger());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationLedger", getConsolidationLedger());
        values.put("Language", getLanguage());
        values.put("ConsolidationLedgerText", getConsolidationLedgerText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationLedger") ) {
                final Object value = values.remove("ConsolidationLedger");
                if( (value == null) || (!value.equals(getConsolidationLedger())) ) {
                    setConsolidationLedger(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationLedgerText") ) {
                final Object value = values.remove("ConsolidationLedgerText");
                if( (value == null) || (!value.equals(getConsolidationLedgerText())) ) {
                    setConsolidationLedgerText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnLedger") ) {
                final Object value = (values).remove("to_CnsldtnLedger");
                if( value instanceof Map ) {
                    if( toCnsldtnLedger == null ) {
                        toCnsldtnLedger = new ConsolidationLedger();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnLedger.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationLedgerTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationLedgerTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationLedgerTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationLedgerTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnLedger != null ) {
            (values).put("to_CnsldtnLedger", toCnsldtnLedger);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationLedger</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnLedger</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ConsolidationLedger</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationLedger fetchCnsldtnLedger()
    {
        return fetchFieldAsSingle("to_CnsldtnLedger", ConsolidationLedger.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationLedger</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnLedger</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnLedger</b> of a queried <b>ConsolidationLedgerText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationLedger</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationLedger getCnsldtnLedgerOrFetch()
    {
        if( toCnsldtnLedger == null ) {
            toCnsldtnLedger = fetchCnsldtnLedger();
        }
        return toCnsldtnLedger;
    }

    /**
     * Retrieval of associated <b>ConsolidationLedger</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnLedger</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationLedgerText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnLedger</b> is already loaded, the result will
     *         contain the <b>ConsolidationLedger</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConsolidationLedger> getCnsldtnLedgerIfPresent()
    {
        return Option.of(toCnsldtnLedger);
    }

    /**
     * Overwrites the associated <b>ConsolidationLedger</b> entity for the loaded navigation property
     * <b>to_CnsldtnLedger</b>.
     *
     * @param value
     *            New <b>ConsolidationLedger</b> entity.
     */
    public void setCnsldtnLedger( final ConsolidationLedger value )
    {
        toCnsldtnLedger = value;
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationLedgerText instances.
     *
     */
    public final static class ConsolidationLedgerTextBuilder
    {

        private ConsolidationLedger toCnsldtnLedger;

        private ConsolidationLedgerText.ConsolidationLedgerTextBuilder toCnsldtnLedger(
            final ConsolidationLedger value )
        {
            toCnsldtnLedger = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnLedger</b> for <b>ConsolidationLedgerText</b> to single
         * <b>ConsolidationLedger</b>.
         *
         * @param value
         *            The ConsolidationLedger to build this ConsolidationLedgerText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationLedgerText.ConsolidationLedgerTextBuilder cnsldtnLedger( final ConsolidationLedger value )
        {
            return toCnsldtnLedger(value);
        }

    }

}
