/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationUnitField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationUnitLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationUnitSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Unit
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationUnitType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationUnit extends VdmEntity<ConsolidationUnit>
{

    /**
     * Selector for all available fields of ConsolidationUnit.
     *
     */
    public final static ConsolidationUnitSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @return Consolidation Unit
     */
    @Key
    @SerializedName( "ConsolidationUnit" )
    @JsonProperty( "ConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit" )
    private String consolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit</b> field to query operations.
     *
     */
    public final static ConsolidationUnitField<String> CONSOLIDATION_UNIT =
        new ConsolidationUnitField<String>("ConsolidationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit_Text</b>
     * </p>
     *
     * @return Consolidation Unit Description
     */
    @SerializedName( "ConsolidationUnit_Text" )
    @JsonProperty( "ConsolidationUnit_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit_Text" )
    private String consolidationUnit_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit_Text</b> field to query operations.
     *
     */
    public final static ConsolidationUnitField<String> CONSOLIDATION_UNIT_TEXT =
        new ConsolidationUnitField<String>("ConsolidationUnit_Text");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLocalCurrency</b>
     * </p>
     *
     * @return Consolidation Local Currency
     */
    @SerializedName( "ConsolidationUnitLocalCurrency" )
    @JsonProperty( "ConsolidationUnitLocalCurrency" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitLocalCurrency" )
    private String consolidationUnitLocalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitLocalCurrency</b> field to query operations.
     *
     */
    public final static ConsolidationUnitField<String> CONSOLIDATION_UNIT_LOCAL_CURRENCY =
        new ConsolidationUnitField<String>("ConsolidationUnitLocalCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLocalCurrency_Text</b>
     * </p>
     *
     * @return Transaction Currency Description
     */
    @SerializedName( "ConsolidationUnitLocalCurrency_Text" )
    @JsonProperty( "ConsolidationUnitLocalCurrency_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitLocalCurrency_Text" )
    private String consolidationUnitLocalCurrency_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitLocalCurrency_Text</b> field to query
     * operations.
     *
     */
    public final static ConsolidationUnitField<String> CONSOLIDATION_UNIT_LOCAL_CURRENCY_TEXT =
        new ConsolidationUnitField<String>("ConsolidationUnitLocalCurrency_Text");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static ConsolidationUnitField<String> COUNTRY = new ConsolidationUnitField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Country_Text</b>
     * </p>
     *
     * @return Customer/Supplier Country/Region Description
     */
    @SerializedName( "Country_Text" )
    @JsonProperty( "Country_Text" )
    @Nullable
    @ODataField( odataName = "Country_Text" )
    private String country_Text;
    /**
     * Use with available fluent helpers to apply the <b>Country_Text</b> field to query operations.
     *
     */
    public final static ConsolidationUnitField<String> COUNTRY_TEXT =
        new ConsolidationUnitField<String>("Country_Text");
    /**
     * Navigation property <b>to_CnsldtnUnitHier</b> for <b>ConsolidationUnit</b> to multiple
     * <b>ConsolidationUnitHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnUnitHier" )
    @JsonProperty( "to_CnsldtnUnitHier" )
    @ODataField( odataName = "to_CnsldtnUnitHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConsolidationUnitHier> toCnsldtnUnitHier;
    /**
     * Navigation property <b>to_CnsldtnUnitT</b> for <b>ConsolidationUnit</b> to multiple <b>ConsolidationUnitText</b>.
     *
     */
    @SerializedName( "to_CnsldtnUnitT" )
    @JsonProperty( "to_CnsldtnUnitT" )
    @ODataField( odataName = "to_CnsldtnUnitT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConsolidationUnitText> toCnsldtnUnitT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnUnitHier</b> navigation property to query operations.
     *
     */
    public final static ConsolidationUnitLink<ConsolidationUnitHier> TO_CNSLDTN_UNIT_HIER =
        new ConsolidationUnitLink<ConsolidationUnitHier>("to_CnsldtnUnitHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnUnitT</b> navigation property to query operations.
     *
     */
    public final static ConsolidationUnitLink<ConsolidationUnitText> TO_CNSLDTN_UNIT_T =
        new ConsolidationUnitLink<ConsolidationUnitText>("to_CnsldtnUnitT");

    @Nonnull
    @Override
    public Class<ConsolidationUnit> getType()
    {
        return ConsolidationUnit.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @param consolidationUnit
     *            Consolidation Unit
     */
    public void setConsolidationUnit( @Nullable final String consolidationUnit )
    {
        rememberChangedField("ConsolidationUnit", this.consolidationUnit);
        this.consolidationUnit = consolidationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit_Text</b>
     * </p>
     *
     * @param consolidationUnit_Text
     *            Consolidation Unit Description
     */
    public void setConsolidationUnit_Text( @Nullable final String consolidationUnit_Text )
    {
        rememberChangedField("ConsolidationUnit_Text", this.consolidationUnit_Text);
        this.consolidationUnit_Text = consolidationUnit_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLocalCurrency</b>
     * </p>
     *
     * @param consolidationUnitLocalCurrency
     *            Consolidation Local Currency
     */
    public void setConsolidationUnitLocalCurrency( @Nullable final String consolidationUnitLocalCurrency )
    {
        rememberChangedField("ConsolidationUnitLocalCurrency", this.consolidationUnitLocalCurrency);
        this.consolidationUnitLocalCurrency = consolidationUnitLocalCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLocalCurrency_Text</b>
     * </p>
     *
     * @param consolidationUnitLocalCurrency_Text
     *            Transaction Currency Description
     */
    public void setConsolidationUnitLocalCurrency_Text( @Nullable final String consolidationUnitLocalCurrency_Text )
    {
        rememberChangedField("ConsolidationUnitLocalCurrency_Text", this.consolidationUnitLocalCurrency_Text);
        this.consolidationUnitLocalCurrency_Text = consolidationUnitLocalCurrency_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Country_Text</b>
     * </p>
     *
     * @param country_Text
     *            Customer/Supplier Country/Region Description
     */
    public void setCountry_Text( @Nullable final String country_Text )
    {
        rememberChangedField("Country_Text", this.country_Text);
        this.country_Text = country_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationUnit";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationUnit", getConsolidationUnit());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationUnit", getConsolidationUnit());
        values.put("ConsolidationUnit_Text", getConsolidationUnit_Text());
        values.put("ConsolidationUnitLocalCurrency", getConsolidationUnitLocalCurrency());
        values.put("ConsolidationUnitLocalCurrency_Text", getConsolidationUnitLocalCurrency_Text());
        values.put("Country", getCountry());
        values.put("Country_Text", getCountry_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationUnit") ) {
                final Object value = values.remove("ConsolidationUnit");
                if( (value == null) || (!value.equals(getConsolidationUnit())) ) {
                    setConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnit_Text") ) {
                final Object value = values.remove("ConsolidationUnit_Text");
                if( (value == null) || (!value.equals(getConsolidationUnit_Text())) ) {
                    setConsolidationUnit_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitLocalCurrency") ) {
                final Object value = values.remove("ConsolidationUnitLocalCurrency");
                if( (value == null) || (!value.equals(getConsolidationUnitLocalCurrency())) ) {
                    setConsolidationUnitLocalCurrency(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitLocalCurrency_Text") ) {
                final Object value = values.remove("ConsolidationUnitLocalCurrency_Text");
                if( (value == null) || (!value.equals(getConsolidationUnitLocalCurrency_Text())) ) {
                    setConsolidationUnitLocalCurrency_Text(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("Country_Text") ) {
                final Object value = values.remove("Country_Text");
                if( (value == null) || (!value.equals(getCountry_Text())) ) {
                    setCountry_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnUnitHier") ) {
                final Object value = (values).remove("to_CnsldtnUnitHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnUnitHier == null ) {
                        toCnsldtnUnitHier = Lists.newArrayList();
                    } else {
                        toCnsldtnUnitHier = Lists.newArrayList(toCnsldtnUnitHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConsolidationUnitHier entity;
                        if( toCnsldtnUnitHier.size() > i ) {
                            entity = toCnsldtnUnitHier.get(i);
                        } else {
                            entity = new ConsolidationUnitHier();
                            toCnsldtnUnitHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnUnitT") ) {
                final Object value = (values).remove("to_CnsldtnUnitT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnUnitT == null ) {
                        toCnsldtnUnitT = Lists.newArrayList();
                    } else {
                        toCnsldtnUnitT = Lists.newArrayList(toCnsldtnUnitT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConsolidationUnitText entity;
                        if( toCnsldtnUnitT.size() > i ) {
                            entity = toCnsldtnUnitT.get(i);
                        } else {
                            entity = new ConsolidationUnitText();
                            toCnsldtnUnitT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationUnitField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationUnitField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationUnitField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationUnitField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnUnitHier != null ) {
            (values).put("to_CnsldtnUnitHier", toCnsldtnUnitHier);
        }
        if( toCnsldtnUnitT != null ) {
            (values).put("to_CnsldtnUnitT", toCnsldtnUnitT);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationUnitHier</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnUnitHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ConsolidationUnitHier</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationUnitHier> fetchCnsldtnUnitHier()
    {
        return fetchFieldAsList("to_CnsldtnUnitHier", ConsolidationUnitHier.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationUnitHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitHier</b> of a queried <b>ConsolidationUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationUnitHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationUnitHier> getCnsldtnUnitHierOrFetch()
    {
        if( toCnsldtnUnitHier == null ) {
            toCnsldtnUnitHier = fetchCnsldtnUnitHier();
        }
        return toCnsldtnUnitHier;
    }

    /**
     * Retrieval of associated <b>ConsolidationUnitHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitHier</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationUnit</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnUnitHier</b> is already loaded, the result will
     *         contain the <b>ConsolidationUnitHier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ConsolidationUnitHier>> getCnsldtnUnitHierIfPresent()
    {
        return Option.of(toCnsldtnUnitHier);
    }

    /**
     * Overwrites the list of associated <b>ConsolidationUnitHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnUnitHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitHier</b> of a queried <b>ConsolidationUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ConsolidationUnitHier</b> entities.
     */
    public void setCnsldtnUnitHier( @Nonnull final List<ConsolidationUnitHier> value )
    {
        if( toCnsldtnUnitHier == null ) {
            toCnsldtnUnitHier = Lists.newArrayList();
        }
        toCnsldtnUnitHier.clear();
        toCnsldtnUnitHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConsolidationUnitHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitHier</b> of a queried <b>ConsolidationUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ConsolidationUnitHier</b> entities.
     */
    public void addCnsldtnUnitHier( ConsolidationUnitHier... entity )
    {
        if( toCnsldtnUnitHier == null ) {
            toCnsldtnUnitHier = Lists.newArrayList();
        }
        toCnsldtnUnitHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ConsolidationUnitText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnUnitT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ConsolidationUnitText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationUnitText> fetchCnsldtnUnitT()
    {
        return fetchFieldAsList("to_CnsldtnUnitT", ConsolidationUnitText.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationUnitText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitT</b> of a queried <b>ConsolidationUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationUnitText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationUnitText> getCnsldtnUnitTOrFetch()
    {
        if( toCnsldtnUnitT == null ) {
            toCnsldtnUnitT = fetchCnsldtnUnitT();
        }
        return toCnsldtnUnitT;
    }

    /**
     * Retrieval of associated <b>ConsolidationUnitText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitT</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationUnit</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnUnitT</b> is already loaded, the result will
     *         contain the <b>ConsolidationUnitText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ConsolidationUnitText>> getCnsldtnUnitTIfPresent()
    {
        return Option.of(toCnsldtnUnitT);
    }

    /**
     * Overwrites the list of associated <b>ConsolidationUnitText</b> entities for the loaded navigation property
     * <b>to_CnsldtnUnitT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitT</b> of a queried <b>ConsolidationUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ConsolidationUnitText</b> entities.
     */
    public void setCnsldtnUnitT( @Nonnull final List<ConsolidationUnitText> value )
    {
        if( toCnsldtnUnitT == null ) {
            toCnsldtnUnitT = Lists.newArrayList();
        }
        toCnsldtnUnitT.clear();
        toCnsldtnUnitT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConsolidationUnitText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitT</b> of a queried <b>ConsolidationUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ConsolidationUnitText</b> entities.
     */
    public void addCnsldtnUnitT( ConsolidationUnitText... entity )
    {
        if( toCnsldtnUnitT == null ) {
            toCnsldtnUnitT = Lists.newArrayList();
        }
        toCnsldtnUnitT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationUnit instances.
     *
     */
    public final static class ConsolidationUnitBuilder
    {

        private List<ConsolidationUnitHier> toCnsldtnUnitHier = Lists.newArrayList();
        private List<ConsolidationUnitText> toCnsldtnUnitT = Lists.newArrayList();

        private ConsolidationUnit.ConsolidationUnitBuilder toCnsldtnUnitHier( final List<ConsolidationUnitHier> value )
        {
            toCnsldtnUnitHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnUnitHier</b> for <b>ConsolidationUnit</b> to multiple
         * <b>ConsolidationUnitHier</b>.
         *
         * @param value
         *            The ConsolidationUnitHiers to build this ConsolidationUnit with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationUnit.ConsolidationUnitBuilder cnsldtnUnitHier( ConsolidationUnitHier... value )
        {
            return toCnsldtnUnitHier(Lists.newArrayList(value));
        }

        private ConsolidationUnit.ConsolidationUnitBuilder toCnsldtnUnitT( final List<ConsolidationUnitText> value )
        {
            toCnsldtnUnitT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnUnitT</b> for <b>ConsolidationUnit</b> to multiple
         * <b>ConsolidationUnitText</b>.
         *
         * @param value
         *            The ConsolidationUnitTexts to build this ConsolidationUnit with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationUnit.ConsolidationUnitBuilder cnsldtnUnitT( ConsolidationUnitText... value )
        {
            return toCnsldtnUnitT(Lists.newArrayList(value));
        }

    }

}
