/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationUnitHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationUnitHierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationUnitHierOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationUnitHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Unit Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationUnitHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationUnitHier extends VdmEntity<ConsolidationUnitHier>
{

    /**
     * Selector for all available fields of ConsolidationUnitHier.
     *
     */
    public final static ConsolidationUnitHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitHierarchy</b>
     * </p>
     *
     * @return Hierarchy ID
     */
    @Key
    @SerializedName( "ConsolidationUnitHierarchy" )
    @JsonProperty( "ConsolidationUnitHierarchy" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitHierarchy" )
    private String consolidationUnitHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitHierarchy</b> field to query operations.
     *
     */
    public final static ConsolidationUnitHierField<String> CONSOLIDATION_UNIT_HIERARCHY =
        new ConsolidationUnitHierField<String>("ConsolidationUnitHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Hierarchy node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static ConsolidationUnitHierField<String> HIERARCHY_NODE =
        new ConsolidationUnitHierField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Hierarchy node description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static ConsolidationUnitHierField<String> HIERARCHY_NODE_TEXT =
        new ConsolidationUnitHierField<String>("HierarchyNode_Text");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid To Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static ConsolidationUnitHierField<LocalDateTime> VALIDITY_END_DATE =
        new ConsolidationUnitHierField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static ConsolidationUnitHierField<LocalDateTime> VALIDITY_START_DATE =
        new ConsolidationUnitHierField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Hierarchy parent node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static ConsolidationUnitHierField<String> PARENT_NODE =
        new ConsolidationUnitHierField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @return Consolidation Unit
     */
    @SerializedName( "ConsolidationUnit" )
    @JsonProperty( "ConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit" )
    private String consolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit</b> field to query operations.
     *
     */
    public final static ConsolidationUnitHierField<String> CONSOLIDATION_UNIT =
        new ConsolidationUnitHierField<String>("ConsolidationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit_Text</b>
     * </p>
     *
     * @return Consolidation Unit Description
     */
    @SerializedName( "ConsolidationUnit_Text" )
    @JsonProperty( "ConsolidationUnit_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit_Text" )
    private String consolidationUnit_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit_Text</b> field to query operations.
     *
     */
    public final static ConsolidationUnitHierField<String> CONSOLIDATION_UNIT_TEXT =
        new ConsolidationUnitHierField<String>("ConsolidationUnit_Text");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return Hierarchy Sequence Number
     */
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static ConsolidationUnitHierField<String> SEQUENCE_NUMBER =
        new ConsolidationUnitHierField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static ConsolidationUnitHierField<String> HIERARCHY_NODE_LEVEL =
        new ConsolidationUnitHierField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Hierarchy node type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static ConsolidationUnitHierField<String> NODE_TYPE =
        new ConsolidationUnitHierField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnUnit</b> for <b>ConsolidationUnitHier</b> to single <b>ConsolidationUnit</b>.
     *
     */
    @SerializedName( "to_CnsldtnUnit" )
    @JsonProperty( "to_CnsldtnUnit" )
    @ODataField( odataName = "to_CnsldtnUnit" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConsolidationUnit toCnsldtnUnit;
    /**
     * Navigation property <b>to_CnsldtnUnitHierT</b> for <b>ConsolidationUnitHier</b> to multiple
     * <b>ConsolidationUnitHierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnUnitHierT" )
    @JsonProperty( "to_CnsldtnUnitHierT" )
    @ODataField( odataName = "to_CnsldtnUnitHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConsolidationUnitHierText> toCnsldtnUnitHierT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnUnit</b> navigation property to query operations.
     *
     */
    public final static ConsolidationUnitHierOneToOneLink<ConsolidationUnit> TO_CNSLDTN_UNIT =
        new ConsolidationUnitHierOneToOneLink<ConsolidationUnit>("to_CnsldtnUnit");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnUnitHierT</b> navigation property to query
     * operations.
     *
     */
    public final static ConsolidationUnitHierLink<ConsolidationUnitHierText> TO_CNSLDTN_UNIT_HIER_T =
        new ConsolidationUnitHierLink<ConsolidationUnitHierText>("to_CnsldtnUnitHierT");

    @Nonnull
    @Override
    public Class<ConsolidationUnitHier> getType()
    {
        return ConsolidationUnitHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitHierarchy</b>
     * </p>
     *
     * @param consolidationUnitHierarchy
     *            Hierarchy ID
     */
    public void setConsolidationUnitHierarchy( @Nullable final String consolidationUnitHierarchy )
    {
        rememberChangedField("ConsolidationUnitHierarchy", this.consolidationUnitHierarchy);
        this.consolidationUnitHierarchy = consolidationUnitHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Hierarchy node description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Hierarchy parent node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @param consolidationUnit
     *            Consolidation Unit
     */
    public void setConsolidationUnit( @Nullable final String consolidationUnit )
    {
        rememberChangedField("ConsolidationUnit", this.consolidationUnit);
        this.consolidationUnit = consolidationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit_Text</b>
     * </p>
     *
     * @param consolidationUnit_Text
     *            Consolidation Unit Description
     */
    public void setConsolidationUnit_Text( @Nullable final String consolidationUnit_Text )
    {
        rememberChangedField("ConsolidationUnit_Text", this.consolidationUnit_Text);
        this.consolidationUnit_Text = consolidationUnit_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            Hierarchy Sequence Number
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationUnitHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationUnitHierarchy", getConsolidationUnitHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationUnitHierarchy", getConsolidationUnitHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ParentNode", getParentNode());
        values.put("ConsolidationUnit", getConsolidationUnit());
        values.put("ConsolidationUnit_Text", getConsolidationUnit_Text());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationUnitHierarchy") ) {
                final Object value = values.remove("ConsolidationUnitHierarchy");
                if( (value == null) || (!value.equals(getConsolidationUnitHierarchy())) ) {
                    setConsolidationUnitHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnit") ) {
                final Object value = values.remove("ConsolidationUnit");
                if( (value == null) || (!value.equals(getConsolidationUnit())) ) {
                    setConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnit_Text") ) {
                final Object value = values.remove("ConsolidationUnit_Text");
                if( (value == null) || (!value.equals(getConsolidationUnit_Text())) ) {
                    setConsolidationUnit_Text(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnUnit") ) {
                final Object value = (values).remove("to_CnsldtnUnit");
                if( value instanceof Map ) {
                    if( toCnsldtnUnit == null ) {
                        toCnsldtnUnit = new ConsolidationUnit();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnUnit.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnUnitHierT") ) {
                final Object value = (values).remove("to_CnsldtnUnitHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnUnitHierT == null ) {
                        toCnsldtnUnitHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnUnitHierT = Lists.newArrayList(toCnsldtnUnitHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConsolidationUnitHierText entity;
                        if( toCnsldtnUnitHierT.size() > i ) {
                            entity = toCnsldtnUnitHierT.get(i);
                        } else {
                            entity = new ConsolidationUnitHierText();
                            toCnsldtnUnitHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationUnitHierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationUnitHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationUnitHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationUnitHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnUnit != null ) {
            (values).put("to_CnsldtnUnit", toCnsldtnUnit);
        }
        if( toCnsldtnUnitHierT != null ) {
            (values).put("to_CnsldtnUnitHierT", toCnsldtnUnitHierT);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationUnit</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnUnit</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ConsolidationUnit</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationUnit fetchCnsldtnUnit()
    {
        return fetchFieldAsSingle("to_CnsldtnUnit", ConsolidationUnit.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnUnit</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnit</b> of a queried <b>ConsolidationUnitHier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationUnit</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationUnit getCnsldtnUnitOrFetch()
    {
        if( toCnsldtnUnit == null ) {
            toCnsldtnUnit = fetchCnsldtnUnit();
        }
        return toCnsldtnUnit;
    }

    /**
     * Retrieval of associated <b>ConsolidationUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnUnit</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationUnitHier</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnUnit</b> is already loaded, the result will
     *         contain the <b>ConsolidationUnit</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConsolidationUnit> getCnsldtnUnitIfPresent()
    {
        return Option.of(toCnsldtnUnit);
    }

    /**
     * Overwrites the associated <b>ConsolidationUnit</b> entity for the loaded navigation property
     * <b>to_CnsldtnUnit</b>.
     *
     * @param value
     *            New <b>ConsolidationUnit</b> entity.
     */
    public void setCnsldtnUnit( final ConsolidationUnit value )
    {
        toCnsldtnUnit = value;
    }

    /**
     * Fetches the <b>ConsolidationUnitHierText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnUnitHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ConsolidationUnitHierText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationUnitHierText> fetchCnsldtnUnitHierT()
    {
        return fetchFieldAsList("to_CnsldtnUnitHierT", ConsolidationUnitHierText.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationUnitHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitHierT</b> of a queried <b>ConsolidationUnitHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationUnitHierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationUnitHierText> getCnsldtnUnitHierTOrFetch()
    {
        if( toCnsldtnUnitHierT == null ) {
            toCnsldtnUnitHierT = fetchCnsldtnUnitHierT();
        }
        return toCnsldtnUnitHierT;
    }

    /**
     * Retrieval of associated <b>ConsolidationUnitHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitHierT</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationUnitHier</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnUnitHierT</b> is already loaded, the result will
     *         contain the <b>ConsolidationUnitHierText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ConsolidationUnitHierText>> getCnsldtnUnitHierTIfPresent()
    {
        return Option.of(toCnsldtnUnitHierT);
    }

    /**
     * Overwrites the list of associated <b>ConsolidationUnitHierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnUnitHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitHierT</b> of a queried <b>ConsolidationUnitHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ConsolidationUnitHierText</b> entities.
     */
    public void setCnsldtnUnitHierT( @Nonnull final List<ConsolidationUnitHierText> value )
    {
        if( toCnsldtnUnitHierT == null ) {
            toCnsldtnUnitHierT = Lists.newArrayList();
        }
        toCnsldtnUnitHierT.clear();
        toCnsldtnUnitHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConsolidationUnitHierText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitHierT</b> of a queried <b>ConsolidationUnitHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ConsolidationUnitHierText</b> entities.
     */
    public void addCnsldtnUnitHierT( ConsolidationUnitHierText... entity )
    {
        if( toCnsldtnUnitHierT == null ) {
            toCnsldtnUnitHierT = Lists.newArrayList();
        }
        toCnsldtnUnitHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationUnitHier instances.
     *
     */
    public final static class ConsolidationUnitHierBuilder
    {

        private ConsolidationUnit toCnsldtnUnit;
        private List<ConsolidationUnitHierText> toCnsldtnUnitHierT = Lists.newArrayList();

        private ConsolidationUnitHier.ConsolidationUnitHierBuilder toCnsldtnUnit( final ConsolidationUnit value )
        {
            toCnsldtnUnit = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnUnit</b> for <b>ConsolidationUnitHier</b> to single
         * <b>ConsolidationUnit</b>.
         *
         * @param value
         *            The ConsolidationUnit to build this ConsolidationUnitHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationUnitHier.ConsolidationUnitHierBuilder cnsldtnUnit( final ConsolidationUnit value )
        {
            return toCnsldtnUnit(value);
        }

        private ConsolidationUnitHier.ConsolidationUnitHierBuilder toCnsldtnUnitHierT(
            final List<ConsolidationUnitHierText> value )
        {
            toCnsldtnUnitHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnUnitHierT</b> for <b>ConsolidationUnitHier</b> to multiple
         * <b>ConsolidationUnitHierText</b>.
         *
         * @param value
         *            The ConsolidationUnitHierTexts to build this ConsolidationUnitHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationUnitHier.ConsolidationUnitHierBuilder cnsldtnUnitHierT( ConsolidationUnitHierText... value )
        {
            return toCnsldtnUnitHierT(Lists.newArrayList(value));
        }

    }

}
