/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationUnitTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationUnitTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationUnitTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Unit - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationUnitTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationUnitText extends VdmEntity<ConsolidationUnitText>
{

    /**
     * Selector for all available fields of ConsolidationUnitText.
     *
     */
    public final static ConsolidationUnitTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @return Consolidation Unit
     */
    @Key
    @SerializedName( "ConsolidationUnit" )
    @JsonProperty( "ConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit" )
    private String consolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit</b> field to query operations.
     *
     */
    public final static ConsolidationUnitTextField<String> CONSOLIDATION_UNIT =
        new ConsolidationUnitTextField<String>("ConsolidationUnit");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ConsolidationUnitTextField<String> LANGUAGE =
        new ConsolidationUnitTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitText</b>
     * </p>
     *
     * @return Consolidation Unit Description
     */
    @SerializedName( "ConsolidationUnitText" )
    @JsonProperty( "ConsolidationUnitText" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitText" )
    private String consolidationUnitText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitText</b> field to query operations.
     *
     */
    public final static ConsolidationUnitTextField<String> CONSOLIDATION_UNIT_TEXT =
        new ConsolidationUnitTextField<String>("ConsolidationUnitText");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLongText</b>
     * </p>
     *
     * @return Consolidation Unit Long Description
     */
    @SerializedName( "ConsolidationUnitLongText" )
    @JsonProperty( "ConsolidationUnitLongText" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitLongText" )
    private String consolidationUnitLongText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitLongText</b> field to query operations.
     *
     */
    public final static ConsolidationUnitTextField<String> CONSOLIDATION_UNIT_LONG_TEXT =
        new ConsolidationUnitTextField<String>("ConsolidationUnitLongText");
    /**
     * Navigation property <b>to_CnsldtnUnit</b> for <b>ConsolidationUnitText</b> to single <b>ConsolidationUnit</b>.
     *
     */
    @SerializedName( "to_CnsldtnUnit" )
    @JsonProperty( "to_CnsldtnUnit" )
    @ODataField( odataName = "to_CnsldtnUnit" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConsolidationUnit toCnsldtnUnit;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnUnit</b> navigation property to query operations.
     *
     */
    public final static ConsolidationUnitTextOneToOneLink<ConsolidationUnit> TO_CNSLDTN_UNIT =
        new ConsolidationUnitTextOneToOneLink<ConsolidationUnit>("to_CnsldtnUnit");

    @Nonnull
    @Override
    public Class<ConsolidationUnitText> getType()
    {
        return ConsolidationUnitText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @param consolidationUnit
     *            Consolidation Unit
     */
    public void setConsolidationUnit( @Nullable final String consolidationUnit )
    {
        rememberChangedField("ConsolidationUnit", this.consolidationUnit);
        this.consolidationUnit = consolidationUnit;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitText</b>
     * </p>
     *
     * @param consolidationUnitText
     *            Consolidation Unit Description
     */
    public void setConsolidationUnitText( @Nullable final String consolidationUnitText )
    {
        rememberChangedField("ConsolidationUnitText", this.consolidationUnitText);
        this.consolidationUnitText = consolidationUnitText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLongText</b>
     * </p>
     *
     * @param consolidationUnitLongText
     *            Consolidation Unit Long Description
     */
    public void setConsolidationUnitLongText( @Nullable final String consolidationUnitLongText )
    {
        rememberChangedField("ConsolidationUnitLongText", this.consolidationUnitLongText);
        this.consolidationUnitLongText = consolidationUnitLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationUnitText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationUnit", getConsolidationUnit());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationUnit", getConsolidationUnit());
        values.put("Language", getLanguage());
        values.put("ConsolidationUnitText", getConsolidationUnitText());
        values.put("ConsolidationUnitLongText", getConsolidationUnitLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationUnit") ) {
                final Object value = values.remove("ConsolidationUnit");
                if( (value == null) || (!value.equals(getConsolidationUnit())) ) {
                    setConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitText") ) {
                final Object value = values.remove("ConsolidationUnitText");
                if( (value == null) || (!value.equals(getConsolidationUnitText())) ) {
                    setConsolidationUnitText(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitLongText") ) {
                final Object value = values.remove("ConsolidationUnitLongText");
                if( (value == null) || (!value.equals(getConsolidationUnitLongText())) ) {
                    setConsolidationUnitLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnUnit") ) {
                final Object value = (values).remove("to_CnsldtnUnit");
                if( value instanceof Map ) {
                    if( toCnsldtnUnit == null ) {
                        toCnsldtnUnit = new ConsolidationUnit();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnUnit.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationUnitTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationUnitTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationUnitTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationUnitTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnUnit != null ) {
            (values).put("to_CnsldtnUnit", toCnsldtnUnit);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationUnit</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnUnit</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ConsolidationUnit</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationUnit fetchCnsldtnUnit()
    {
        return fetchFieldAsSingle("to_CnsldtnUnit", ConsolidationUnit.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnUnit</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnit</b> of a queried <b>ConsolidationUnitText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationUnit</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationUnit getCnsldtnUnitOrFetch()
    {
        if( toCnsldtnUnit == null ) {
            toCnsldtnUnit = fetchCnsldtnUnit();
        }
        return toCnsldtnUnit;
    }

    /**
     * Retrieval of associated <b>ConsolidationUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnUnit</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationUnitText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnUnit</b> is already loaded, the result will
     *         contain the <b>ConsolidationUnit</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConsolidationUnit> getCnsldtnUnitIfPresent()
    {
        return Option.of(toCnsldtnUnit);
    }

    /**
     * Overwrites the associated <b>ConsolidationUnit</b> entity for the loaded navigation property
     * <b>to_CnsldtnUnit</b>.
     *
     * @param value
     *            New <b>ConsolidationUnit</b> entity.
     */
    public void setCnsldtnUnit( final ConsolidationUnit value )
    {
        toCnsldtnUnit = value;
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationUnitText instances.
     *
     */
    public final static class ConsolidationUnitTextBuilder
    {

        private ConsolidationUnit toCnsldtnUnit;

        private ConsolidationUnitText.ConsolidationUnitTextBuilder toCnsldtnUnit( final ConsolidationUnit value )
        {
            toCnsldtnUnit = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnUnit</b> for <b>ConsolidationUnitText</b> to single
         * <b>ConsolidationUnit</b>.
         *
         * @param value
         *            The ConsolidationUnit to build this ConsolidationUnitText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationUnitText.ConsolidationUnitTextBuilder cnsldtnUnit( final ConsolidationUnit value )
        {
            return toCnsldtnUnit(value);
        }

    }

}
