/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationVersionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationVersionLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationVersionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Version
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationVersionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationVersion extends VdmEntity<ConsolidationVersion>
{

    /**
     * Selector for all available fields of ConsolidationVersion.
     *
     */
    public final static ConsolidationVersionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion</b>
     * </p>
     *
     * @return Consolidation Version
     */
    @Key
    @SerializedName( "ConsolidationVersion" )
    @JsonProperty( "ConsolidationVersion" )
    @Nullable
    @ODataField( odataName = "ConsolidationVersion" )
    private String consolidationVersion;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationVersion</b> field to query operations.
     *
     */
    public final static ConsolidationVersionField<String> CONSOLIDATION_VERSION =
        new ConsolidationVersionField<String>("ConsolidationVersion");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion_Text</b>
     * </p>
     *
     * @return Consolidation Version Description
     */
    @SerializedName( "ConsolidationVersion_Text" )
    @JsonProperty( "ConsolidationVersion_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationVersion_Text" )
    private String consolidationVersion_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationVersion_Text</b> field to query operations.
     *
     */
    public final static ConsolidationVersionField<String> CONSOLIDATION_VERSION_TEXT =
        new ConsolidationVersionField<String>("ConsolidationVersion_Text");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnReferenceVersion</b>
     * </p>
     *
     * @return Reference Version
     */
    @SerializedName( "CnsldtnReferenceVersion" )
    @JsonProperty( "CnsldtnReferenceVersion" )
    @Nullable
    @ODataField( odataName = "CnsldtnReferenceVersion" )
    private String cnsldtnReferenceVersion;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnReferenceVersion</b> field to query operations.
     *
     */
    public final static ConsolidationVersionField<String> CNSLDTN_REFERENCE_VERSION =
        new ConsolidationVersionField<String>("CnsldtnReferenceVersion");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnReferenceVersion_Text</b>
     * </p>
     *
     * @return Consolidation Version Description
     */
    @SerializedName( "CnsldtnReferenceVersion_Text" )
    @JsonProperty( "CnsldtnReferenceVersion_Text" )
    @Nullable
    @ODataField( odataName = "CnsldtnReferenceVersion_Text" )
    private String cnsldtnReferenceVersion_Text;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnReferenceVersion_Text</b> field to query operations.
     *
     */
    public final static ConsolidationVersionField<String> CNSLDTN_REFERENCE_VERSION_TEXT =
        new ConsolidationVersionField<String>("CnsldtnReferenceVersion_Text");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GroupCurrency</b>
     * </p>
     *
     * @return Group Currency of Consolidation Version
     */
    @SerializedName( "GroupCurrency" )
    @JsonProperty( "GroupCurrency" )
    @Nullable
    @ODataField( odataName = "GroupCurrency" )
    private String groupCurrency;
    /**
     * Use with available fluent helpers to apply the <b>GroupCurrency</b> field to query operations.
     *
     */
    public final static ConsolidationVersionField<String> GROUP_CURRENCY =
        new ConsolidationVersionField<String>("GroupCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>GroupCurrency_Text</b>
     * </p>
     *
     * @return Group Currency Description
     */
    @SerializedName( "GroupCurrency_Text" )
    @JsonProperty( "GroupCurrency_Text" )
    @Nullable
    @ODataField( odataName = "GroupCurrency_Text" )
    private String groupCurrency_Text;
    /**
     * Use with available fluent helpers to apply the <b>GroupCurrency_Text</b> field to query operations.
     *
     */
    public final static ConsolidationVersionField<String> GROUP_CURRENCY_TEXT =
        new ConsolidationVersionField<String>("GroupCurrency_Text");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnIsPlanVersion</b>
     * </p>
     *
     * @return Is Planning Version
     */
    @SerializedName( "CnsldtnIsPlanVersion" )
    @JsonProperty( "CnsldtnIsPlanVersion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CnsldtnIsPlanVersion" )
    private Boolean cnsldtnIsPlanVersion;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnIsPlanVersion</b> field to query operations.
     *
     */
    public final static ConsolidationVersionField<Boolean> CNSLDTN_IS_PLAN_VERSION =
        new ConsolidationVersionField<Boolean>("CnsldtnIsPlanVersion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnVersionType</b>
     * </p>
     *
     * @return Consolidation Version Type
     */
    @SerializedName( "CnsldtnVersionType" )
    @JsonProperty( "CnsldtnVersionType" )
    @Nullable
    @ODataField( odataName = "CnsldtnVersionType" )
    private String cnsldtnVersionType;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnVersionType</b> field to query operations.
     *
     */
    public final static ConsolidationVersionField<String> CNSLDTN_VERSION_TYPE =
        new ConsolidationVersionField<String>("CnsldtnVersionType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnVersionType_Text</b>
     * </p>
     *
     * @return Consolidation Version Type Description
     */
    @SerializedName( "CnsldtnVersionType_Text" )
    @JsonProperty( "CnsldtnVersionType_Text" )
    @Nullable
    @ODataField( odataName = "CnsldtnVersionType_Text" )
    private String cnsldtnVersionType_Text;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnVersionType_Text</b> field to query operations.
     *
     */
    public final static ConsolidationVersionField<String> CNSLDTN_VERSION_TYPE_TEXT =
        new ConsolidationVersionField<String>("CnsldtnVersionType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnVersionRunMode</b>
     * </p>
     *
     * @return Version Run Mode
     */
    @SerializedName( "CnsldtnVersionRunMode" )
    @JsonProperty( "CnsldtnVersionRunMode" )
    @Nullable
    @ODataField( odataName = "CnsldtnVersionRunMode" )
    private String cnsldtnVersionRunMode;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnVersionRunMode</b> field to query operations.
     *
     */
    public final static ConsolidationVersionField<String> CNSLDTN_VERSION_RUN_MODE =
        new ConsolidationVersionField<String>("CnsldtnVersionRunMode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnVersionHasAllKeyFigures</b>
     * </p>
     *
     * @return Version Has All Key Figures
     */
    @SerializedName( "CnsldtnVersionHasAllKeyFigures" )
    @JsonProperty( "CnsldtnVersionHasAllKeyFigures" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CnsldtnVersionHasAllKeyFigures" )
    private Boolean cnsldtnVersionHasAllKeyFigures;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnVersionHasAllKeyFigures</b> field to query operations.
     *
     */
    public final static ConsolidationVersionField<Boolean> CNSLDTN_VERSION_HAS_ALL_KEY_FIGURES =
        new ConsolidationVersionField<Boolean>("CnsldtnVersionHasAllKeyFigures");
    /**
     * Navigation property <b>to_CnsldtnVersionT</b> for <b>ConsolidationVersion</b> to multiple
     * <b>ConsolidationVersionText</b>.
     *
     */
    @SerializedName( "to_CnsldtnVersionT" )
    @JsonProperty( "to_CnsldtnVersionT" )
    @ODataField( odataName = "to_CnsldtnVersionT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConsolidationVersionText> toCnsldtnVersionT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnVersionT</b> navigation property to query operations.
     *
     */
    public final static ConsolidationVersionLink<ConsolidationVersionText> TO_CNSLDTN_VERSION_T =
        new ConsolidationVersionLink<ConsolidationVersionText>("to_CnsldtnVersionT");

    @Nonnull
    @Override
    public Class<ConsolidationVersion> getType()
    {
        return ConsolidationVersion.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion</b>
     * </p>
     *
     * @param consolidationVersion
     *            Consolidation Version
     */
    public void setConsolidationVersion( @Nullable final String consolidationVersion )
    {
        rememberChangedField("ConsolidationVersion", this.consolidationVersion);
        this.consolidationVersion = consolidationVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion_Text</b>
     * </p>
     *
     * @param consolidationVersion_Text
     *            Consolidation Version Description
     */
    public void setConsolidationVersion_Text( @Nullable final String consolidationVersion_Text )
    {
        rememberChangedField("ConsolidationVersion_Text", this.consolidationVersion_Text);
        this.consolidationVersion_Text = consolidationVersion_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnReferenceVersion</b>
     * </p>
     *
     * @param cnsldtnReferenceVersion
     *            Reference Version
     */
    public void setCnsldtnReferenceVersion( @Nullable final String cnsldtnReferenceVersion )
    {
        rememberChangedField("CnsldtnReferenceVersion", this.cnsldtnReferenceVersion);
        this.cnsldtnReferenceVersion = cnsldtnReferenceVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnReferenceVersion_Text</b>
     * </p>
     *
     * @param cnsldtnReferenceVersion_Text
     *            Consolidation Version Description
     */
    public void setCnsldtnReferenceVersion_Text( @Nullable final String cnsldtnReferenceVersion_Text )
    {
        rememberChangedField("CnsldtnReferenceVersion_Text", this.cnsldtnReferenceVersion_Text);
        this.cnsldtnReferenceVersion_Text = cnsldtnReferenceVersion_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GroupCurrency</b>
     * </p>
     *
     * @param groupCurrency
     *            Group Currency of Consolidation Version
     */
    public void setGroupCurrency( @Nullable final String groupCurrency )
    {
        rememberChangedField("GroupCurrency", this.groupCurrency);
        this.groupCurrency = groupCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>GroupCurrency_Text</b>
     * </p>
     *
     * @param groupCurrency_Text
     *            Group Currency Description
     */
    public void setGroupCurrency_Text( @Nullable final String groupCurrency_Text )
    {
        rememberChangedField("GroupCurrency_Text", this.groupCurrency_Text);
        this.groupCurrency_Text = groupCurrency_Text;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnIsPlanVersion</b>
     * </p>
     *
     * @param cnsldtnIsPlanVersion
     *            Is Planning Version
     */
    public void setCnsldtnIsPlanVersion( @Nullable final Boolean cnsldtnIsPlanVersion )
    {
        rememberChangedField("CnsldtnIsPlanVersion", this.cnsldtnIsPlanVersion);
        this.cnsldtnIsPlanVersion = cnsldtnIsPlanVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnVersionType</b>
     * </p>
     *
     * @param cnsldtnVersionType
     *            Consolidation Version Type
     */
    public void setCnsldtnVersionType( @Nullable final String cnsldtnVersionType )
    {
        rememberChangedField("CnsldtnVersionType", this.cnsldtnVersionType);
        this.cnsldtnVersionType = cnsldtnVersionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnVersionType_Text</b>
     * </p>
     *
     * @param cnsldtnVersionType_Text
     *            Consolidation Version Type Description
     */
    public void setCnsldtnVersionType_Text( @Nullable final String cnsldtnVersionType_Text )
    {
        rememberChangedField("CnsldtnVersionType_Text", this.cnsldtnVersionType_Text);
        this.cnsldtnVersionType_Text = cnsldtnVersionType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnVersionRunMode</b>
     * </p>
     *
     * @param cnsldtnVersionRunMode
     *            Version Run Mode
     */
    public void setCnsldtnVersionRunMode( @Nullable final String cnsldtnVersionRunMode )
    {
        rememberChangedField("CnsldtnVersionRunMode", this.cnsldtnVersionRunMode);
        this.cnsldtnVersionRunMode = cnsldtnVersionRunMode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnVersionHasAllKeyFigures</b>
     * </p>
     *
     * @param cnsldtnVersionHasAllKeyFigures
     *            Version Has All Key Figures
     */
    public void setCnsldtnVersionHasAllKeyFigures( @Nullable final Boolean cnsldtnVersionHasAllKeyFigures )
    {
        rememberChangedField("CnsldtnVersionHasAllKeyFigures", this.cnsldtnVersionHasAllKeyFigures);
        this.cnsldtnVersionHasAllKeyFigures = cnsldtnVersionHasAllKeyFigures;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationVersion";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationVersion", getConsolidationVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationVersion", getConsolidationVersion());
        values.put("ConsolidationVersion_Text", getConsolidationVersion_Text());
        values.put("CnsldtnReferenceVersion", getCnsldtnReferenceVersion());
        values.put("CnsldtnReferenceVersion_Text", getCnsldtnReferenceVersion_Text());
        values.put("GroupCurrency", getGroupCurrency());
        values.put("GroupCurrency_Text", getGroupCurrency_Text());
        values.put("CnsldtnIsPlanVersion", getCnsldtnIsPlanVersion());
        values.put("CnsldtnVersionType", getCnsldtnVersionType());
        values.put("CnsldtnVersionType_Text", getCnsldtnVersionType_Text());
        values.put("CnsldtnVersionRunMode", getCnsldtnVersionRunMode());
        values.put("CnsldtnVersionHasAllKeyFigures", getCnsldtnVersionHasAllKeyFigures());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationVersion") ) {
                final Object value = values.remove("ConsolidationVersion");
                if( (value == null) || (!value.equals(getConsolidationVersion())) ) {
                    setConsolidationVersion(((String) value));
                }
            }
            if( values.containsKey("ConsolidationVersion_Text") ) {
                final Object value = values.remove("ConsolidationVersion_Text");
                if( (value == null) || (!value.equals(getConsolidationVersion_Text())) ) {
                    setConsolidationVersion_Text(((String) value));
                }
            }
            if( values.containsKey("CnsldtnReferenceVersion") ) {
                final Object value = values.remove("CnsldtnReferenceVersion");
                if( (value == null) || (!value.equals(getCnsldtnReferenceVersion())) ) {
                    setCnsldtnReferenceVersion(((String) value));
                }
            }
            if( values.containsKey("CnsldtnReferenceVersion_Text") ) {
                final Object value = values.remove("CnsldtnReferenceVersion_Text");
                if( (value == null) || (!value.equals(getCnsldtnReferenceVersion_Text())) ) {
                    setCnsldtnReferenceVersion_Text(((String) value));
                }
            }
            if( values.containsKey("GroupCurrency") ) {
                final Object value = values.remove("GroupCurrency");
                if( (value == null) || (!value.equals(getGroupCurrency())) ) {
                    setGroupCurrency(((String) value));
                }
            }
            if( values.containsKey("GroupCurrency_Text") ) {
                final Object value = values.remove("GroupCurrency_Text");
                if( (value == null) || (!value.equals(getGroupCurrency_Text())) ) {
                    setGroupCurrency_Text(((String) value));
                }
            }
            if( values.containsKey("CnsldtnIsPlanVersion") ) {
                final Object value = values.remove("CnsldtnIsPlanVersion");
                if( (value == null) || (!value.equals(getCnsldtnIsPlanVersion())) ) {
                    setCnsldtnIsPlanVersion(((Boolean) value));
                }
            }
            if( values.containsKey("CnsldtnVersionType") ) {
                final Object value = values.remove("CnsldtnVersionType");
                if( (value == null) || (!value.equals(getCnsldtnVersionType())) ) {
                    setCnsldtnVersionType(((String) value));
                }
            }
            if( values.containsKey("CnsldtnVersionType_Text") ) {
                final Object value = values.remove("CnsldtnVersionType_Text");
                if( (value == null) || (!value.equals(getCnsldtnVersionType_Text())) ) {
                    setCnsldtnVersionType_Text(((String) value));
                }
            }
            if( values.containsKey("CnsldtnVersionRunMode") ) {
                final Object value = values.remove("CnsldtnVersionRunMode");
                if( (value == null) || (!value.equals(getCnsldtnVersionRunMode())) ) {
                    setCnsldtnVersionRunMode(((String) value));
                }
            }
            if( values.containsKey("CnsldtnVersionHasAllKeyFigures") ) {
                final Object value = values.remove("CnsldtnVersionHasAllKeyFigures");
                if( (value == null) || (!value.equals(getCnsldtnVersionHasAllKeyFigures())) ) {
                    setCnsldtnVersionHasAllKeyFigures(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnVersionT") ) {
                final Object value = (values).remove("to_CnsldtnVersionT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnVersionT == null ) {
                        toCnsldtnVersionT = Lists.newArrayList();
                    } else {
                        toCnsldtnVersionT = Lists.newArrayList(toCnsldtnVersionT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConsolidationVersionText entity;
                        if( toCnsldtnVersionT.size() > i ) {
                            entity = toCnsldtnVersionT.get(i);
                        } else {
                            entity = new ConsolidationVersionText();
                            toCnsldtnVersionT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationVersionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationVersionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationVersionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationVersionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnVersionT != null ) {
            (values).put("to_CnsldtnVersionT", toCnsldtnVersionT);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationVersionText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnVersionT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ConsolidationVersionText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationVersionText> fetchCnsldtnVersionT()
    {
        return fetchFieldAsList("to_CnsldtnVersionT", ConsolidationVersionText.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationVersionText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnVersionT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnVersionT</b> of a queried <b>ConsolidationVersion</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationVersionText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationVersionText> getCnsldtnVersionTOrFetch()
    {
        if( toCnsldtnVersionT == null ) {
            toCnsldtnVersionT = fetchCnsldtnVersionT();
        }
        return toCnsldtnVersionT;
    }

    /**
     * Retrieval of associated <b>ConsolidationVersionText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnVersionT</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationVersion</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnVersionT</b> is already loaded, the result will
     *         contain the <b>ConsolidationVersionText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ConsolidationVersionText>> getCnsldtnVersionTIfPresent()
    {
        return Option.of(toCnsldtnVersionT);
    }

    /**
     * Overwrites the list of associated <b>ConsolidationVersionText</b> entities for the loaded navigation property
     * <b>to_CnsldtnVersionT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnVersionT</b> of a queried <b>ConsolidationVersion</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ConsolidationVersionText</b> entities.
     */
    public void setCnsldtnVersionT( @Nonnull final List<ConsolidationVersionText> value )
    {
        if( toCnsldtnVersionT == null ) {
            toCnsldtnVersionT = Lists.newArrayList();
        }
        toCnsldtnVersionT.clear();
        toCnsldtnVersionT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConsolidationVersionText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnVersionT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnVersionT</b> of a queried <b>ConsolidationVersion</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ConsolidationVersionText</b> entities.
     */
    public void addCnsldtnVersionT( ConsolidationVersionText... entity )
    {
        if( toCnsldtnVersionT == null ) {
            toCnsldtnVersionT = Lists.newArrayList();
        }
        toCnsldtnVersionT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationVersion instances.
     *
     */
    public final static class ConsolidationVersionBuilder
    {

        private List<ConsolidationVersionText> toCnsldtnVersionT = Lists.newArrayList();

        private ConsolidationVersion.ConsolidationVersionBuilder toCnsldtnVersionT(
            final List<ConsolidationVersionText> value )
        {
            toCnsldtnVersionT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnVersionT</b> for <b>ConsolidationVersion</b> to multiple
         * <b>ConsolidationVersionText</b>.
         *
         * @param value
         *            The ConsolidationVersionTexts to build this ConsolidationVersion with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationVersion.ConsolidationVersionBuilder cnsldtnVersionT( ConsolidationVersionText... value )
        {
            return toCnsldtnVersionT(Lists.newArrayList(value));
        }

    }

}
