/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationVersionTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationVersionTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationVersionTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Version - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationVersionTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationVersionText extends VdmEntity<ConsolidationVersionText>
{

    /**
     * Selector for all available fields of ConsolidationVersionText.
     *
     */
    public final static ConsolidationVersionTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion</b>
     * </p>
     *
     * @return Consolidation Version
     */
    @Key
    @SerializedName( "ConsolidationVersion" )
    @JsonProperty( "ConsolidationVersion" )
    @Nullable
    @ODataField( odataName = "ConsolidationVersion" )
    private String consolidationVersion;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationVersion</b> field to query operations.
     *
     */
    public final static ConsolidationVersionTextField<String> CONSOLIDATION_VERSION =
        new ConsolidationVersionTextField<String>("ConsolidationVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ConsolidationVersionTextField<String> LANGUAGE =
        new ConsolidationVersionTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersionText</b>
     * </p>
     *
     * @return Consolidation Version Description
     */
    @SerializedName( "ConsolidationVersionText" )
    @JsonProperty( "ConsolidationVersionText" )
    @Nullable
    @ODataField( odataName = "ConsolidationVersionText" )
    private String consolidationVersionText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationVersionText</b> field to query operations.
     *
     */
    public final static ConsolidationVersionTextField<String> CONSOLIDATION_VERSION_TEXT =
        new ConsolidationVersionTextField<String>("ConsolidationVersionText");
    /**
     * Navigation property <b>to_CnsldtnVersion</b> for <b>ConsolidationVersionText</b> to single
     * <b>ConsolidationVersion</b>.
     *
     */
    @SerializedName( "to_CnsldtnVersion" )
    @JsonProperty( "to_CnsldtnVersion" )
    @ODataField( odataName = "to_CnsldtnVersion" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConsolidationVersion toCnsldtnVersion;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnVersion</b> navigation property to query operations.
     *
     */
    public final static ConsolidationVersionTextOneToOneLink<ConsolidationVersion> TO_CNSLDTN_VERSION =
        new ConsolidationVersionTextOneToOneLink<ConsolidationVersion>("to_CnsldtnVersion");

    @Nonnull
    @Override
    public Class<ConsolidationVersionText> getType()
    {
        return ConsolidationVersionText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion</b>
     * </p>
     *
     * @param consolidationVersion
     *            Consolidation Version
     */
    public void setConsolidationVersion( @Nullable final String consolidationVersion )
    {
        rememberChangedField("ConsolidationVersion", this.consolidationVersion);
        this.consolidationVersion = consolidationVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersionText</b>
     * </p>
     *
     * @param consolidationVersionText
     *            Consolidation Version Description
     */
    public void setConsolidationVersionText( @Nullable final String consolidationVersionText )
    {
        rememberChangedField("ConsolidationVersionText", this.consolidationVersionText);
        this.consolidationVersionText = consolidationVersionText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationVersionText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationVersion", getConsolidationVersion());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationVersion", getConsolidationVersion());
        values.put("Language", getLanguage());
        values.put("ConsolidationVersionText", getConsolidationVersionText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationVersion") ) {
                final Object value = values.remove("ConsolidationVersion");
                if( (value == null) || (!value.equals(getConsolidationVersion())) ) {
                    setConsolidationVersion(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationVersionText") ) {
                final Object value = values.remove("ConsolidationVersionText");
                if( (value == null) || (!value.equals(getConsolidationVersionText())) ) {
                    setConsolidationVersionText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnVersion") ) {
                final Object value = (values).remove("to_CnsldtnVersion");
                if( value instanceof Map ) {
                    if( toCnsldtnVersion == null ) {
                        toCnsldtnVersion = new ConsolidationVersion();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnVersion.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationVersionTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationVersionTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationVersionTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationVersionTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnVersion != null ) {
            (values).put("to_CnsldtnVersion", toCnsldtnVersion);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationVersion</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnVersion</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ConsolidationVersion</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationVersion fetchCnsldtnVersion()
    {
        return fetchFieldAsSingle("to_CnsldtnVersion", ConsolidationVersion.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationVersion</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnVersion</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnVersion</b> of a queried <b>ConsolidationVersionText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationVersion</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationVersion getCnsldtnVersionOrFetch()
    {
        if( toCnsldtnVersion == null ) {
            toCnsldtnVersion = fetchCnsldtnVersion();
        }
        return toCnsldtnVersion;
    }

    /**
     * Retrieval of associated <b>ConsolidationVersion</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnVersion</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationVersionText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnVersion</b> is already loaded, the result will
     *         contain the <b>ConsolidationVersion</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConsolidationVersion> getCnsldtnVersionIfPresent()
    {
        return Option.of(toCnsldtnVersion);
    }

    /**
     * Overwrites the associated <b>ConsolidationVersion</b> entity for the loaded navigation property
     * <b>to_CnsldtnVersion</b>.
     *
     * @param value
     *            New <b>ConsolidationVersion</b> entity.
     */
    public void setCnsldtnVersion( final ConsolidationVersion value )
    {
        toCnsldtnVersion = value;
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationVersionText instances.
     *
     */
    public final static class ConsolidationVersionTextBuilder
    {

        private ConsolidationVersion toCnsldtnVersion;

        private ConsolidationVersionText.ConsolidationVersionTextBuilder toCnsldtnVersion(
            final ConsolidationVersion value )
        {
            toCnsldtnVersion = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnVersion</b> for <b>ConsolidationVersionText</b> to single
         * <b>ConsolidationVersion</b>.
         *
         * @param value
         *            The ConsolidationVersion to build this ConsolidationVersionText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationVersionText.ConsolidationVersionTextBuilder cnsldtnVersion(
            final ConsolidationVersion value )
        {
            return toCnsldtnVersion(value);
        }

    }

}
