/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ControllingAreaField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ControllingAreaLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ControllingAreaSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Controlling Area
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ControllingAreaType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ControllingArea extends VdmEntity<ControllingArea>
{

    /**
     * Selector for all available fields of ControllingArea.
     *
     */
    public final static ControllingAreaSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> CONTROLLING_AREA =
        new ControllingAreaField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea_Text</b>
     * </p>
     *
     * @return Controlling Area Description
     */
    @SerializedName( "ControllingArea_Text" )
    @JsonProperty( "ControllingArea_Text" )
    @Nullable
    @ODataField( odataName = "ControllingArea_Text" )
    private String controllingArea_Text;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea_Text</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> CONTROLLING_AREA_TEXT =
        new ControllingAreaField<String>("ControllingArea_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new ControllingAreaField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnControllingAreaT</b> for <b>ControllingArea</b> to multiple
     * <b>ControllingAreaText</b>.
     *
     */
    @SerializedName( "to_CnsldtnControllingAreaT" )
    @JsonProperty( "to_CnsldtnControllingAreaT" )
    @ODataField( odataName = "to_CnsldtnControllingAreaT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ControllingAreaText> toCnsldtnControllingAreaT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnControllingAreaT</b> navigation property to query
     * operations.
     *
     */
    public final static ControllingAreaLink<ControllingAreaText> TO_CNSLDTN_CONTROLLING_AREA_T =
        new ControllingAreaLink<ControllingAreaText>("to_CnsldtnControllingAreaT");

    @Nonnull
    @Override
    public Class<ControllingArea> getType()
    {
        return ControllingArea.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea_Text</b>
     * </p>
     *
     * @param controllingArea_Text
     *            Controlling Area Description
     */
    public void setControllingArea_Text( @Nullable final String controllingArea_Text )
    {
        rememberChangedField("ControllingArea_Text", this.controllingArea_Text);
        this.controllingArea_Text = controllingArea_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ControllingArea";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ControllingArea", getControllingArea());
        values.put("ControllingArea_Text", getControllingArea_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ControllingArea_Text") ) {
                final Object value = values.remove("ControllingArea_Text");
                if( (value == null) || (!value.equals(getControllingArea_Text())) ) {
                    setControllingArea_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnControllingAreaT") ) {
                final Object value = (values).remove("to_CnsldtnControllingAreaT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnControllingAreaT == null ) {
                        toCnsldtnControllingAreaT = Lists.newArrayList();
                    } else {
                        toCnsldtnControllingAreaT = Lists.newArrayList(toCnsldtnControllingAreaT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ControllingAreaText entity;
                        if( toCnsldtnControllingAreaT.size() > i ) {
                            entity = toCnsldtnControllingAreaT.get(i);
                        } else {
                            entity = new ControllingAreaText();
                            toCnsldtnControllingAreaT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ControllingAreaField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ControllingAreaField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ControllingAreaField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ControllingAreaField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnControllingAreaT != null ) {
            (values).put("to_CnsldtnControllingAreaT", toCnsldtnControllingAreaT);
        }
        return values;
    }

    /**
     * Fetches the <b>ControllingAreaText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnControllingAreaT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ControllingAreaText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ControllingAreaText> fetchCnsldtnControllingAreaT()
    {
        return fetchFieldAsList("to_CnsldtnControllingAreaT", ControllingAreaText.class);
    }

    /**
     * Retrieval of associated <b>ControllingAreaText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnControllingAreaT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnControllingAreaT</b> of a queried <b>ControllingArea</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ControllingAreaText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ControllingAreaText> getCnsldtnControllingAreaTOrFetch()
    {
        if( toCnsldtnControllingAreaT == null ) {
            toCnsldtnControllingAreaT = fetchCnsldtnControllingAreaT();
        }
        return toCnsldtnControllingAreaT;
    }

    /**
     * Retrieval of associated <b>ControllingAreaText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnControllingAreaT</b>.
     * <p>
     * If the navigation property for an entity <b>ControllingArea</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnControllingAreaT</b> is already loaded, the
     *         result will contain the <b>ControllingAreaText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ControllingAreaText>> getCnsldtnControllingAreaTIfPresent()
    {
        return Option.of(toCnsldtnControllingAreaT);
    }

    /**
     * Overwrites the list of associated <b>ControllingAreaText</b> entities for the loaded navigation property
     * <b>to_CnsldtnControllingAreaT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnControllingAreaT</b> of a queried <b>ControllingArea</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ControllingAreaText</b> entities.
     */
    public void setCnsldtnControllingAreaT( @Nonnull final List<ControllingAreaText> value )
    {
        if( toCnsldtnControllingAreaT == null ) {
            toCnsldtnControllingAreaT = Lists.newArrayList();
        }
        toCnsldtnControllingAreaT.clear();
        toCnsldtnControllingAreaT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ControllingAreaText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnControllingAreaT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnControllingAreaT</b> of a queried <b>ControllingArea</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ControllingAreaText</b> entities.
     */
    public void addCnsldtnControllingAreaT( ControllingAreaText... entity )
    {
        if( toCnsldtnControllingAreaT == null ) {
            toCnsldtnControllingAreaT = Lists.newArrayList();
        }
        toCnsldtnControllingAreaT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ControllingArea instances.
     *
     */
    public final static class ControllingAreaBuilder
    {

        private List<ControllingAreaText> toCnsldtnControllingAreaT = Lists.newArrayList();

        private ControllingArea.ControllingAreaBuilder toCnsldtnControllingAreaT(
            final List<ControllingAreaText> value )
        {
            toCnsldtnControllingAreaT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnControllingAreaT</b> for <b>ControllingArea</b> to multiple
         * <b>ControllingAreaText</b>.
         *
         * @param value
         *            The ControllingAreaTexts to build this ControllingArea with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ControllingArea.ControllingAreaBuilder cnsldtnControllingAreaT( ControllingAreaText... value )
        {
            return toCnsldtnControllingAreaT(Lists.newArrayList(value));
        }

    }

}
