/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ControllingAreaTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ControllingAreaTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ControllingAreaTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Controlling Area - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ControllingAreaTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ControllingAreaText extends VdmEntity<ControllingAreaText>
{

    /**
     * Selector for all available fields of ControllingAreaText.
     *
     */
    public final static ControllingAreaTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ControllingAreaTextField<String> LANGUAGE = new ControllingAreaTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static ControllingAreaTextField<String> CONTROLLING_AREA =
        new ControllingAreaTextField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaText</b>
     * </p>
     *
     * @return Controlling Area Description
     */
    @SerializedName( "ControllingAreaText" )
    @JsonProperty( "ControllingAreaText" )
    @Nullable
    @ODataField( odataName = "ControllingAreaText" )
    private String controllingAreaText;
    /**
     * Use with available fluent helpers to apply the <b>ControllingAreaText</b> field to query operations.
     *
     */
    public final static ControllingAreaTextField<String> CONTROLLING_AREA_TEXT =
        new ControllingAreaTextField<String>("ControllingAreaText");
    /**
     * Navigation property <b>to_CnsldtnControllingArea</b> for <b>ControllingAreaText</b> to single
     * <b>ControllingArea</b>.
     *
     */
    @SerializedName( "to_CnsldtnControllingArea" )
    @JsonProperty( "to_CnsldtnControllingArea" )
    @ODataField( odataName = "to_CnsldtnControllingArea" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ControllingArea toCnsldtnControllingArea;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnControllingArea</b> navigation property to query
     * operations.
     *
     */
    public final static ControllingAreaTextOneToOneLink<ControllingArea> TO_CNSLDTN_CONTROLLING_AREA =
        new ControllingAreaTextOneToOneLink<ControllingArea>("to_CnsldtnControllingArea");

    @Nonnull
    @Override
    public Class<ControllingAreaText> getType()
    {
        return ControllingAreaText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaText</b>
     * </p>
     *
     * @param controllingAreaText
     *            Controlling Area Description
     */
    public void setControllingAreaText( @Nullable final String controllingAreaText )
    {
        rememberChangedField("ControllingAreaText", this.controllingAreaText);
        this.controllingAreaText = controllingAreaText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ControllingAreaText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ControllingArea", getControllingArea());
        values.put("ControllingAreaText", getControllingAreaText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ControllingAreaText") ) {
                final Object value = values.remove("ControllingAreaText");
                if( (value == null) || (!value.equals(getControllingAreaText())) ) {
                    setControllingAreaText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnControllingArea") ) {
                final Object value = (values).remove("to_CnsldtnControllingArea");
                if( value instanceof Map ) {
                    if( toCnsldtnControllingArea == null ) {
                        toCnsldtnControllingArea = new ControllingArea();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnControllingArea.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ControllingAreaTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ControllingAreaTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ControllingAreaTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ControllingAreaTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnControllingArea != null ) {
            (values).put("to_CnsldtnControllingArea", toCnsldtnControllingArea);
        }
        return values;
    }

    /**
     * Fetches the <b>ControllingArea</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnControllingArea</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ControllingArea</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ControllingArea fetchCnsldtnControllingArea()
    {
        return fetchFieldAsSingle("to_CnsldtnControllingArea", ControllingArea.class);
    }

    /**
     * Retrieval of associated <b>ControllingArea</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnControllingArea</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnControllingArea</b> of a queried <b>ControllingAreaText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ControllingArea</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ControllingArea getCnsldtnControllingAreaOrFetch()
    {
        if( toCnsldtnControllingArea == null ) {
            toCnsldtnControllingArea = fetchCnsldtnControllingArea();
        }
        return toCnsldtnControllingArea;
    }

    /**
     * Retrieval of associated <b>ControllingArea</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnControllingArea</b>.
     * <p>
     * If the navigation property for an entity <b>ControllingAreaText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnControllingArea</b> is already loaded, the result
     *         will contain the <b>ControllingArea</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ControllingArea> getCnsldtnControllingAreaIfPresent()
    {
        return Option.of(toCnsldtnControllingArea);
    }

    /**
     * Overwrites the associated <b>ControllingArea</b> entity for the loaded navigation property
     * <b>to_CnsldtnControllingArea</b>.
     *
     * @param value
     *            New <b>ControllingArea</b> entity.
     */
    public void setCnsldtnControllingArea( final ControllingArea value )
    {
        toCnsldtnControllingArea = value;
    }

    /**
     * Helper class to allow for fluent creation of ControllingAreaText instances.
     *
     */
    public final static class ControllingAreaTextBuilder
    {

        private ControllingArea toCnsldtnControllingArea;

        private ControllingAreaText.ControllingAreaTextBuilder toCnsldtnControllingArea( final ControllingArea value )
        {
            toCnsldtnControllingArea = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnControllingArea</b> for <b>ControllingAreaText</b> to single
         * <b>ControllingArea</b>.
         *
         * @param value
         *            The ControllingArea to build this ControllingAreaText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ControllingAreaText.ControllingAreaTextBuilder cnsldtnControllingArea( final ControllingArea value )
        {
            return toCnsldtnControllingArea(value);
        }

    }

}
