/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CostCenterField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CostCenterLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CostCenterSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Cost Center
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CostCenterType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CostCenter extends VdmEntity<CostCenter>
{

    /**
     * Selector for all available fields of CostCenter.
     *
     */
    public final static CostCenterSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Consolidation Cost Center
     */
    @Key
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COST_CENTER = new CostCenterField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter_Text</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "CostCenter_Text" )
    @JsonProperty( "CostCenter_Text" )
    @Nullable
    @ODataField( odataName = "CostCenter_Text" )
    private String costCenter_Text;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter_Text</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COST_CENTER_TEXT = new CostCenterField<String>("CostCenter_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Consolidation Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static CostCenterField<String> CONTROLLING_AREA = new CostCenterField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static CostCenterField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new CostCenterField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnCostCenterHier</b> for <b>CostCenter</b> to multiple <b>CostCenterHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnCostCenterHier" )
    @JsonProperty( "to_CnsldtnCostCenterHier" )
    @ODataField( odataName = "to_CnsldtnCostCenterHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CostCenterHier> toCnsldtnCostCenterHier;
    /**
     * Navigation property <b>to_CnsldtnCostCenterT</b> for <b>CostCenter</b> to multiple <b>CostCenterText</b>.
     *
     */
    @SerializedName( "to_CnsldtnCostCenterT" )
    @JsonProperty( "to_CnsldtnCostCenterT" )
    @ODataField( odataName = "to_CnsldtnCostCenterT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CostCenterText> toCnsldtnCostCenterT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCostCenterHier</b> navigation property to query
     * operations.
     *
     */
    public final static CostCenterLink<CostCenterHier> TO_CNSLDTN_COST_CENTER_HIER =
        new CostCenterLink<CostCenterHier>("to_CnsldtnCostCenterHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCostCenterT</b> navigation property to query
     * operations.
     *
     */
    public final static CostCenterLink<CostCenterText> TO_CNSLDTN_COST_CENTER_T =
        new CostCenterLink<CostCenterText>("to_CnsldtnCostCenterT");

    @Nonnull
    @Override
    public Class<CostCenter> getType()
    {
        return CostCenter.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Consolidation Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter_Text</b>
     * </p>
     *
     * @param costCenter_Text
     *            Description
     */
    public void setCostCenter_Text( @Nullable final String costCenter_Text )
    {
        rememberChangedField("CostCenter_Text", this.costCenter_Text);
        this.costCenter_Text = costCenter_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Consolidation Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CostCenter";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CostCenter", getCostCenter());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CostCenter", getCostCenter());
        values.put("CostCenter_Text", getCostCenter_Text());
        values.put("ControllingArea", getControllingArea());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("CostCenter_Text") ) {
                final Object value = values.remove("CostCenter_Text");
                if( (value == null) || (!value.equals(getCostCenter_Text())) ) {
                    setCostCenter_Text(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnCostCenterHier") ) {
                final Object value = (values).remove("to_CnsldtnCostCenterHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnCostCenterHier == null ) {
                        toCnsldtnCostCenterHier = Lists.newArrayList();
                    } else {
                        toCnsldtnCostCenterHier = Lists.newArrayList(toCnsldtnCostCenterHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CostCenterHier entity;
                        if( toCnsldtnCostCenterHier.size() > i ) {
                            entity = toCnsldtnCostCenterHier.get(i);
                        } else {
                            entity = new CostCenterHier();
                            toCnsldtnCostCenterHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnCostCenterT") ) {
                final Object value = (values).remove("to_CnsldtnCostCenterT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnCostCenterT == null ) {
                        toCnsldtnCostCenterT = Lists.newArrayList();
                    } else {
                        toCnsldtnCostCenterT = Lists.newArrayList(toCnsldtnCostCenterT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CostCenterText entity;
                        if( toCnsldtnCostCenterT.size() > i ) {
                            entity = toCnsldtnCostCenterT.get(i);
                        } else {
                            entity = new CostCenterText();
                            toCnsldtnCostCenterT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CostCenterField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CostCenterField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CostCenterField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CostCenterField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnCostCenterHier != null ) {
            (values).put("to_CnsldtnCostCenterHier", toCnsldtnCostCenterHier);
        }
        if( toCnsldtnCostCenterT != null ) {
            (values).put("to_CnsldtnCostCenterT", toCnsldtnCostCenterT);
        }
        return values;
    }

    /**
     * Fetches the <b>CostCenterHier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnCostCenterHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CostCenterHier</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CostCenterHier> fetchCnsldtnCostCenterHier()
    {
        return fetchFieldAsList("to_CnsldtnCostCenterHier", CostCenterHier.class);
    }

    /**
     * Retrieval of associated <b>CostCenterHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnCostCenterHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCostCenterHier</b> of a queried <b>CostCenter</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CostCenterHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CostCenterHier> getCnsldtnCostCenterHierOrFetch()
    {
        if( toCnsldtnCostCenterHier == null ) {
            toCnsldtnCostCenterHier = fetchCnsldtnCostCenterHier();
        }
        return toCnsldtnCostCenterHier;
    }

    /**
     * Retrieval of associated <b>CostCenterHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnCostCenterHier</b>.
     * <p>
     * If the navigation property for an entity <b>CostCenter</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCostCenterHier</b> is already loaded, the result
     *         will contain the <b>CostCenterHier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CostCenterHier>> getCnsldtnCostCenterHierIfPresent()
    {
        return Option.of(toCnsldtnCostCenterHier);
    }

    /**
     * Overwrites the list of associated <b>CostCenterHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnCostCenterHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCostCenterHier</b> of a queried <b>CostCenter</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CostCenterHier</b> entities.
     */
    public void setCnsldtnCostCenterHier( @Nonnull final List<CostCenterHier> value )
    {
        if( toCnsldtnCostCenterHier == null ) {
            toCnsldtnCostCenterHier = Lists.newArrayList();
        }
        toCnsldtnCostCenterHier.clear();
        toCnsldtnCostCenterHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CostCenterHier</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnCostCenterHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCostCenterHier</b> of a queried <b>CostCenter</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CostCenterHier</b> entities.
     */
    public void addCnsldtnCostCenterHier( CostCenterHier... entity )
    {
        if( toCnsldtnCostCenterHier == null ) {
            toCnsldtnCostCenterHier = Lists.newArrayList();
        }
        toCnsldtnCostCenterHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CostCenterText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnCostCenterT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CostCenterText</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CostCenterText> fetchCnsldtnCostCenterT()
    {
        return fetchFieldAsList("to_CnsldtnCostCenterT", CostCenterText.class);
    }

    /**
     * Retrieval of associated <b>CostCenterText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnCostCenterT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCostCenterT</b> of a queried <b>CostCenter</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CostCenterText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CostCenterText> getCnsldtnCostCenterTOrFetch()
    {
        if( toCnsldtnCostCenterT == null ) {
            toCnsldtnCostCenterT = fetchCnsldtnCostCenterT();
        }
        return toCnsldtnCostCenterT;
    }

    /**
     * Retrieval of associated <b>CostCenterText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnCostCenterT</b>.
     * <p>
     * If the navigation property for an entity <b>CostCenter</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCostCenterT</b> is already loaded, the result
     *         will contain the <b>CostCenterText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CostCenterText>> getCnsldtnCostCenterTIfPresent()
    {
        return Option.of(toCnsldtnCostCenterT);
    }

    /**
     * Overwrites the list of associated <b>CostCenterText</b> entities for the loaded navigation property
     * <b>to_CnsldtnCostCenterT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCostCenterT</b> of a queried <b>CostCenter</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CostCenterText</b> entities.
     */
    public void setCnsldtnCostCenterT( @Nonnull final List<CostCenterText> value )
    {
        if( toCnsldtnCostCenterT == null ) {
            toCnsldtnCostCenterT = Lists.newArrayList();
        }
        toCnsldtnCostCenterT.clear();
        toCnsldtnCostCenterT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CostCenterText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnCostCenterT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCostCenterT</b> of a queried <b>CostCenter</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CostCenterText</b> entities.
     */
    public void addCnsldtnCostCenterT( CostCenterText... entity )
    {
        if( toCnsldtnCostCenterT == null ) {
            toCnsldtnCostCenterT = Lists.newArrayList();
        }
        toCnsldtnCostCenterT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CostCenter instances.
     *
     */
    public final static class CostCenterBuilder
    {

        private List<CostCenterHier> toCnsldtnCostCenterHier = Lists.newArrayList();
        private List<CostCenterText> toCnsldtnCostCenterT = Lists.newArrayList();

        private CostCenter.CostCenterBuilder toCnsldtnCostCenterHier( final List<CostCenterHier> value )
        {
            toCnsldtnCostCenterHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCostCenterHier</b> for <b>CostCenter</b> to multiple <b>CostCenterHier</b>.
         *
         * @param value
         *            The CostCenterHiers to build this CostCenter with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CostCenter.CostCenterBuilder cnsldtnCostCenterHier( CostCenterHier... value )
        {
            return toCnsldtnCostCenterHier(Lists.newArrayList(value));
        }

        private CostCenter.CostCenterBuilder toCnsldtnCostCenterT( final List<CostCenterText> value )
        {
            toCnsldtnCostCenterT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCostCenterT</b> for <b>CostCenter</b> to multiple <b>CostCenterText</b>.
         *
         * @param value
         *            The CostCenterTexts to build this CostCenter with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CostCenter.CostCenterBuilder cnsldtnCostCenterT( CostCenterText... value )
        {
            return toCnsldtnCostCenterT(Lists.newArrayList(value));
        }

    }

}
