/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CostCenterTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CostCenterTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CostCenterTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Cost Center - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CostCenterTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CostCenterText extends VdmEntity<CostCenterText>
{

    /**
     * Selector for all available fields of CostCenterText.
     *
     */
    public final static CostCenterTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CostCenterTextField<String> LANGUAGE = new CostCenterTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Consolidation Cost Center
     */
    @Key
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static CostCenterTextField<String> COST_CENTER = new CostCenterTextField<String>("CostCenter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Consolidation Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static CostCenterTextField<String> CONTROLLING_AREA =
        new CostCenterTextField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterText</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "CostCenterText" )
    @JsonProperty( "CostCenterText" )
    @Nullable
    @ODataField( odataName = "CostCenterText" )
    private String costCenterText;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterText</b> field to query operations.
     *
     */
    public final static CostCenterTextField<String> COST_CENTER_TEXT =
        new CostCenterTextField<String>("CostCenterText");
    /**
     * Navigation property <b>to_CnsldtnCostCenter</b> for <b>CostCenterText</b> to single <b>CostCenter</b>.
     *
     */
    @SerializedName( "to_CnsldtnCostCenter" )
    @JsonProperty( "to_CnsldtnCostCenter" )
    @ODataField( odataName = "to_CnsldtnCostCenter" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CostCenter toCnsldtnCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCostCenter</b> navigation property to query
     * operations.
     *
     */
    public final static CostCenterTextOneToOneLink<CostCenter> TO_CNSLDTN_COST_CENTER =
        new CostCenterTextOneToOneLink<CostCenter>("to_CnsldtnCostCenter");

    @Nonnull
    @Override
    public Class<CostCenterText> getType()
    {
        return CostCenterText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Consolidation Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Consolidation Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterText</b>
     * </p>
     *
     * @param costCenterText
     *            Description
     */
    public void setCostCenterText( @Nullable final String costCenterText )
    {
        rememberChangedField("CostCenterText", this.costCenterText);
        this.costCenterText = costCenterText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CostCenterText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("CostCenter", getCostCenter());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("CostCenter", getCostCenter());
        values.put("ControllingArea", getControllingArea());
        values.put("CostCenterText", getCostCenterText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("CostCenterText") ) {
                final Object value = values.remove("CostCenterText");
                if( (value == null) || (!value.equals(getCostCenterText())) ) {
                    setCostCenterText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnCostCenter") ) {
                final Object value = (values).remove("to_CnsldtnCostCenter");
                if( value instanceof Map ) {
                    if( toCnsldtnCostCenter == null ) {
                        toCnsldtnCostCenter = new CostCenter();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnCostCenter.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CostCenterTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CostCenterTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CostCenterTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CostCenterTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnCostCenter != null ) {
            (values).put("to_CnsldtnCostCenter", toCnsldtnCostCenter);
        }
        return values;
    }

    /**
     * Fetches the <b>CostCenter</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnCostCenter</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CostCenter</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CostCenter fetchCnsldtnCostCenter()
    {
        return fetchFieldAsSingle("to_CnsldtnCostCenter", CostCenter.class);
    }

    /**
     * Retrieval of associated <b>CostCenter</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnCostCenter</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCostCenter</b> of a queried <b>CostCenterText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CostCenter</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CostCenter getCnsldtnCostCenterOrFetch()
    {
        if( toCnsldtnCostCenter == null ) {
            toCnsldtnCostCenter = fetchCnsldtnCostCenter();
        }
        return toCnsldtnCostCenter;
    }

    /**
     * Retrieval of associated <b>CostCenter</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnCostCenter</b>.
     * <p>
     * If the navigation property for an entity <b>CostCenterText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCostCenter</b> is already loaded, the result will
     *         contain the <b>CostCenter</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<CostCenter> getCnsldtnCostCenterIfPresent()
    {
        return Option.of(toCnsldtnCostCenter);
    }

    /**
     * Overwrites the associated <b>CostCenter</b> entity for the loaded navigation property
     * <b>to_CnsldtnCostCenter</b>.
     *
     * @param value
     *            New <b>CostCenter</b> entity.
     */
    public void setCnsldtnCostCenter( final CostCenter value )
    {
        toCnsldtnCostCenter = value;
    }

    /**
     * Helper class to allow for fluent creation of CostCenterText instances.
     *
     */
    public final static class CostCenterTextBuilder
    {

        private CostCenter toCnsldtnCostCenter;

        private CostCenterText.CostCenterTextBuilder toCnsldtnCostCenter( final CostCenter value )
        {
            toCnsldtnCostCenter = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCostCenter</b> for <b>CostCenterText</b> to single <b>CostCenter</b>.
         *
         * @param value
         *            The CostCenter to build this CostCenterText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CostCenterText.CostCenterTextBuilder cnsldtnCostCenter( final CostCenter value )
        {
            return toCnsldtnCostCenter(value);
        }

    }

}
