/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CustomerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CustomerLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CustomerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Customer
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CustomerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Customer extends VdmEntity<Customer>
{

    /**
     * Selector for all available fields of Customer.
     *
     */
    public final static CustomerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Consolidation Customer
     */
    @Key
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static CustomerField<String> CUSTOMER = new CustomerField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Customer_Text</b>
     * </p>
     *
     * @return Customer Description
     */
    @SerializedName( "Customer_Text" )
    @JsonProperty( "Customer_Text" )
    @Nullable
    @ODataField( odataName = "Customer_Text" )
    private String customer_Text;
    /**
     * Use with available fluent helpers to apply the <b>Customer_Text</b> field to query operations.
     *
     */
    public final static CustomerField<String> CUSTOMER_TEXT = new CustomerField<String>("Customer_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static CustomerField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new CustomerField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnCustomerHier</b> for <b>Customer</b> to multiple <b>CustomerHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnCustomerHier" )
    @JsonProperty( "to_CnsldtnCustomerHier" )
    @ODataField( odataName = "to_CnsldtnCustomerHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerHier> toCnsldtnCustomerHier;
    /**
     * Navigation property <b>to_CnsldtnCustomerT</b> for <b>Customer</b> to multiple <b>CustomerText</b>.
     *
     */
    @SerializedName( "to_CnsldtnCustomerT" )
    @JsonProperty( "to_CnsldtnCustomerT" )
    @ODataField( odataName = "to_CnsldtnCustomerT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerText> toCnsldtnCustomerT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCustomerHier</b> navigation property to query
     * operations.
     *
     */
    public final static CustomerLink<CustomerHier> TO_CNSLDTN_CUSTOMER_HIER =
        new CustomerLink<CustomerHier>("to_CnsldtnCustomerHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCustomerT</b> navigation property to query
     * operations.
     *
     */
    public final static CustomerLink<CustomerText> TO_CNSLDTN_CUSTOMER_T =
        new CustomerLink<CustomerText>("to_CnsldtnCustomerT");

    @Nonnull
    @Override
    public Class<Customer> getType()
    {
        return Customer.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Consolidation Customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Customer_Text</b>
     * </p>
     *
     * @param customer_Text
     *            Customer Description
     */
    public void setCustomer_Text( @Nullable final String customer_Text )
    {
        rememberChangedField("Customer_Text", this.customer_Text);
        this.customer_Text = customer_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Customer";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Customer", getCustomer());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Customer", getCustomer());
        values.put("Customer_Text", getCustomer_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Customer_Text") ) {
                final Object value = values.remove("Customer_Text");
                if( (value == null) || (!value.equals(getCustomer_Text())) ) {
                    setCustomer_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnCustomerHier") ) {
                final Object value = (values).remove("to_CnsldtnCustomerHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnCustomerHier == null ) {
                        toCnsldtnCustomerHier = Lists.newArrayList();
                    } else {
                        toCnsldtnCustomerHier = Lists.newArrayList(toCnsldtnCustomerHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerHier entity;
                        if( toCnsldtnCustomerHier.size() > i ) {
                            entity = toCnsldtnCustomerHier.get(i);
                        } else {
                            entity = new CustomerHier();
                            toCnsldtnCustomerHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnCustomerT") ) {
                final Object value = (values).remove("to_CnsldtnCustomerT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnCustomerT == null ) {
                        toCnsldtnCustomerT = Lists.newArrayList();
                    } else {
                        toCnsldtnCustomerT = Lists.newArrayList(toCnsldtnCustomerT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerText entity;
                        if( toCnsldtnCustomerT.size() > i ) {
                            entity = toCnsldtnCustomerT.get(i);
                        } else {
                            entity = new CustomerText();
                            toCnsldtnCustomerT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustomerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnCustomerHier != null ) {
            (values).put("to_CnsldtnCustomerHier", toCnsldtnCustomerHier);
        }
        if( toCnsldtnCustomerT != null ) {
            (values).put("to_CnsldtnCustomerT", toCnsldtnCustomerT);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerHier</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnCustomerHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerHier</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerHier> fetchCnsldtnCustomerHier()
    {
        return fetchFieldAsList("to_CnsldtnCustomerHier", CustomerHier.class);
    }

    /**
     * Retrieval of associated <b>CustomerHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnCustomerHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerHier</b> of a queried <b>Customer</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerHier> getCnsldtnCustomerHierOrFetch()
    {
        if( toCnsldtnCustomerHier == null ) {
            toCnsldtnCustomerHier = fetchCnsldtnCustomerHier();
        }
        return toCnsldtnCustomerHier;
    }

    /**
     * Retrieval of associated <b>CustomerHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnCustomerHier</b>.
     * <p>
     * If the navigation property for an entity <b>Customer</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCustomerHier</b> is already loaded, the result
     *         will contain the <b>CustomerHier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerHier>> getCnsldtnCustomerHierIfPresent()
    {
        return Option.of(toCnsldtnCustomerHier);
    }

    /**
     * Overwrites the list of associated <b>CustomerHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnCustomerHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerHier</b> of a queried <b>Customer</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerHier</b> entities.
     */
    public void setCnsldtnCustomerHier( @Nonnull final List<CustomerHier> value )
    {
        if( toCnsldtnCustomerHier == null ) {
            toCnsldtnCustomerHier = Lists.newArrayList();
        }
        toCnsldtnCustomerHier.clear();
        toCnsldtnCustomerHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerHier</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnCustomerHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerHier</b> of a queried <b>Customer</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerHier</b> entities.
     */
    public void addCnsldtnCustomerHier( CustomerHier... entity )
    {
        if( toCnsldtnCustomerHier == null ) {
            toCnsldtnCustomerHier = Lists.newArrayList();
        }
        toCnsldtnCustomerHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustomerText</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnCustomerT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerText</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerText> fetchCnsldtnCustomerT()
    {
        return fetchFieldAsList("to_CnsldtnCustomerT", CustomerText.class);
    }

    /**
     * Retrieval of associated <b>CustomerText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnCustomerT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerT</b> of a queried <b>Customer</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerText> getCnsldtnCustomerTOrFetch()
    {
        if( toCnsldtnCustomerT == null ) {
            toCnsldtnCustomerT = fetchCnsldtnCustomerT();
        }
        return toCnsldtnCustomerT;
    }

    /**
     * Retrieval of associated <b>CustomerText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnCustomerT</b>.
     * <p>
     * If the navigation property for an entity <b>Customer</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCustomerT</b> is already loaded, the result will
     *         contain the <b>CustomerText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerText>> getCnsldtnCustomerTIfPresent()
    {
        return Option.of(toCnsldtnCustomerT);
    }

    /**
     * Overwrites the list of associated <b>CustomerText</b> entities for the loaded navigation property
     * <b>to_CnsldtnCustomerT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerT</b> of a queried <b>Customer</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerText</b> entities.
     */
    public void setCnsldtnCustomerT( @Nonnull final List<CustomerText> value )
    {
        if( toCnsldtnCustomerT == null ) {
            toCnsldtnCustomerT = Lists.newArrayList();
        }
        toCnsldtnCustomerT.clear();
        toCnsldtnCustomerT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnCustomerT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerT</b> of a queried <b>Customer</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerText</b> entities.
     */
    public void addCnsldtnCustomerT( CustomerText... entity )
    {
        if( toCnsldtnCustomerT == null ) {
            toCnsldtnCustomerT = Lists.newArrayList();
        }
        toCnsldtnCustomerT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Customer instances.
     *
     */
    public final static class CustomerBuilder
    {

        private List<CustomerHier> toCnsldtnCustomerHier = Lists.newArrayList();
        private List<CustomerText> toCnsldtnCustomerT = Lists.newArrayList();

        private Customer.CustomerBuilder toCnsldtnCustomerHier( final List<CustomerHier> value )
        {
            toCnsldtnCustomerHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCustomerHier</b> for <b>Customer</b> to multiple <b>CustomerHier</b>.
         *
         * @param value
         *            The CustomerHiers to build this Customer with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Customer.CustomerBuilder cnsldtnCustomerHier( CustomerHier... value )
        {
            return toCnsldtnCustomerHier(Lists.newArrayList(value));
        }

        private Customer.CustomerBuilder toCnsldtnCustomerT( final List<CustomerText> value )
        {
            toCnsldtnCustomerT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCustomerT</b> for <b>Customer</b> to multiple <b>CustomerText</b>.
         *
         * @param value
         *            The CustomerTexts to build this Customer with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Customer.CustomerBuilder cnsldtnCustomerT( CustomerText... value )
        {
            return toCnsldtnCustomerT(Lists.newArrayList(value));
        }

    }

}
