/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CustomerGroupField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CustomerGroupLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CustomerGroupSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Customer Group
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CustomerGroupType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerGroup extends VdmEntity<CustomerGroup>
{

    /**
     * Selector for all available fields of CustomerGroup.
     *
     */
    public final static CustomerGroupSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @return Consolidation Customer Group
     */
    @Key
    @SerializedName( "CustomerGroup" )
    @JsonProperty( "CustomerGroup" )
    @Nullable
    @ODataField( odataName = "CustomerGroup" )
    private String customerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup</b> field to query operations.
     *
     */
    public final static CustomerGroupField<String> CUSTOMER_GROUP = new CustomerGroupField<String>("CustomerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup_Text</b>
     * </p>
     *
     * @return Customer Group Description
     */
    @SerializedName( "CustomerGroup_Text" )
    @JsonProperty( "CustomerGroup_Text" )
    @Nullable
    @ODataField( odataName = "CustomerGroup_Text" )
    private String customerGroup_Text;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup_Text</b> field to query operations.
     *
     */
    public final static CustomerGroupField<String> CUSTOMER_GROUP_TEXT =
        new CustomerGroupField<String>("CustomerGroup_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static CustomerGroupField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new CustomerGroupField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnCustomerGroupHier</b> for <b>CustomerGroup</b> to multiple
     * <b>CustomerGroupHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnCustomerGroupHier" )
    @JsonProperty( "to_CnsldtnCustomerGroupHier" )
    @ODataField( odataName = "to_CnsldtnCustomerGroupHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerGroupHier> toCnsldtnCustomerGroupHier;
    /**
     * Navigation property <b>to_CnsldtnCustomerGroupT</b> for <b>CustomerGroup</b> to multiple
     * <b>CustomerGroupText</b>.
     *
     */
    @SerializedName( "to_CnsldtnCustomerGroupT" )
    @JsonProperty( "to_CnsldtnCustomerGroupT" )
    @ODataField( odataName = "to_CnsldtnCustomerGroupT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerGroupText> toCnsldtnCustomerGroupT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCustomerGroupHier</b> navigation property to query
     * operations.
     *
     */
    public final static CustomerGroupLink<CustomerGroupHier> TO_CNSLDTN_CUSTOMER_GROUP_HIER =
        new CustomerGroupLink<CustomerGroupHier>("to_CnsldtnCustomerGroupHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCustomerGroupT</b> navigation property to query
     * operations.
     *
     */
    public final static CustomerGroupLink<CustomerGroupText> TO_CNSLDTN_CUSTOMER_GROUP_T =
        new CustomerGroupLink<CustomerGroupText>("to_CnsldtnCustomerGroupT");

    @Nonnull
    @Override
    public Class<CustomerGroup> getType()
    {
        return CustomerGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @param customerGroup
     *            Consolidation Customer Group
     */
    public void setCustomerGroup( @Nullable final String customerGroup )
    {
        rememberChangedField("CustomerGroup", this.customerGroup);
        this.customerGroup = customerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup_Text</b>
     * </p>
     *
     * @param customerGroup_Text
     *            Customer Group Description
     */
    public void setCustomerGroup_Text( @Nullable final String customerGroup_Text )
    {
        rememberChangedField("CustomerGroup_Text", this.customerGroup_Text);
        this.customerGroup_Text = customerGroup_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CustomerGroup";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CustomerGroup", getCustomerGroup());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CustomerGroup", getCustomerGroup());
        values.put("CustomerGroup_Text", getCustomerGroup_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CustomerGroup") ) {
                final Object value = values.remove("CustomerGroup");
                if( (value == null) || (!value.equals(getCustomerGroup())) ) {
                    setCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("CustomerGroup_Text") ) {
                final Object value = values.remove("CustomerGroup_Text");
                if( (value == null) || (!value.equals(getCustomerGroup_Text())) ) {
                    setCustomerGroup_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnCustomerGroupHier") ) {
                final Object value = (values).remove("to_CnsldtnCustomerGroupHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnCustomerGroupHier == null ) {
                        toCnsldtnCustomerGroupHier = Lists.newArrayList();
                    } else {
                        toCnsldtnCustomerGroupHier = Lists.newArrayList(toCnsldtnCustomerGroupHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerGroupHier entity;
                        if( toCnsldtnCustomerGroupHier.size() > i ) {
                            entity = toCnsldtnCustomerGroupHier.get(i);
                        } else {
                            entity = new CustomerGroupHier();
                            toCnsldtnCustomerGroupHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnCustomerGroupT") ) {
                final Object value = (values).remove("to_CnsldtnCustomerGroupT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnCustomerGroupT == null ) {
                        toCnsldtnCustomerGroupT = Lists.newArrayList();
                    } else {
                        toCnsldtnCustomerGroupT = Lists.newArrayList(toCnsldtnCustomerGroupT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerGroupText entity;
                        if( toCnsldtnCustomerGroupT.size() > i ) {
                            entity = toCnsldtnCustomerGroupT.get(i);
                        } else {
                            entity = new CustomerGroupText();
                            toCnsldtnCustomerGroupT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustomerGroupField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerGroupField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerGroupField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerGroupField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnCustomerGroupHier != null ) {
            (values).put("to_CnsldtnCustomerGroupHier", toCnsldtnCustomerGroupHier);
        }
        if( toCnsldtnCustomerGroupT != null ) {
            (values).put("to_CnsldtnCustomerGroupT", toCnsldtnCustomerGroupT);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerGroupHier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnCustomerGroupHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerGroupHier</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerGroupHier> fetchCnsldtnCustomerGroupHier()
    {
        return fetchFieldAsList("to_CnsldtnCustomerGroupHier", CustomerGroupHier.class);
    }

    /**
     * Retrieval of associated <b>CustomerGroupHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnCustomerGroupHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerGroupHier</b> of a queried <b>CustomerGroup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerGroupHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerGroupHier> getCnsldtnCustomerGroupHierOrFetch()
    {
        if( toCnsldtnCustomerGroupHier == null ) {
            toCnsldtnCustomerGroupHier = fetchCnsldtnCustomerGroupHier();
        }
        return toCnsldtnCustomerGroupHier;
    }

    /**
     * Retrieval of associated <b>CustomerGroupHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnCustomerGroupHier</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerGroup</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCustomerGroupHier</b> is already loaded, the
     *         result will contain the <b>CustomerGroupHier</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerGroupHier>> getCnsldtnCustomerGroupHierIfPresent()
    {
        return Option.of(toCnsldtnCustomerGroupHier);
    }

    /**
     * Overwrites the list of associated <b>CustomerGroupHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnCustomerGroupHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerGroupHier</b> of a queried <b>CustomerGroup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerGroupHier</b> entities.
     */
    public void setCnsldtnCustomerGroupHier( @Nonnull final List<CustomerGroupHier> value )
    {
        if( toCnsldtnCustomerGroupHier == null ) {
            toCnsldtnCustomerGroupHier = Lists.newArrayList();
        }
        toCnsldtnCustomerGroupHier.clear();
        toCnsldtnCustomerGroupHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerGroupHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnCustomerGroupHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerGroupHier</b> of a queried <b>CustomerGroup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerGroupHier</b> entities.
     */
    public void addCnsldtnCustomerGroupHier( CustomerGroupHier... entity )
    {
        if( toCnsldtnCustomerGroupHier == null ) {
            toCnsldtnCustomerGroupHier = Lists.newArrayList();
        }
        toCnsldtnCustomerGroupHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustomerGroupText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnCustomerGroupT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerGroupText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerGroupText> fetchCnsldtnCustomerGroupT()
    {
        return fetchFieldAsList("to_CnsldtnCustomerGroupT", CustomerGroupText.class);
    }

    /**
     * Retrieval of associated <b>CustomerGroupText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnCustomerGroupT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerGroupT</b> of a queried <b>CustomerGroup</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerGroupText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerGroupText> getCnsldtnCustomerGroupTOrFetch()
    {
        if( toCnsldtnCustomerGroupT == null ) {
            toCnsldtnCustomerGroupT = fetchCnsldtnCustomerGroupT();
        }
        return toCnsldtnCustomerGroupT;
    }

    /**
     * Retrieval of associated <b>CustomerGroupText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnCustomerGroupT</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerGroup</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCustomerGroupT</b> is already loaded, the result
     *         will contain the <b>CustomerGroupText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerGroupText>> getCnsldtnCustomerGroupTIfPresent()
    {
        return Option.of(toCnsldtnCustomerGroupT);
    }

    /**
     * Overwrites the list of associated <b>CustomerGroupText</b> entities for the loaded navigation property
     * <b>to_CnsldtnCustomerGroupT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerGroupT</b> of a queried <b>CustomerGroup</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerGroupText</b> entities.
     */
    public void setCnsldtnCustomerGroupT( @Nonnull final List<CustomerGroupText> value )
    {
        if( toCnsldtnCustomerGroupT == null ) {
            toCnsldtnCustomerGroupT = Lists.newArrayList();
        }
        toCnsldtnCustomerGroupT.clear();
        toCnsldtnCustomerGroupT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerGroupText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnCustomerGroupT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerGroupT</b> of a queried <b>CustomerGroup</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerGroupText</b> entities.
     */
    public void addCnsldtnCustomerGroupT( CustomerGroupText... entity )
    {
        if( toCnsldtnCustomerGroupT == null ) {
            toCnsldtnCustomerGroupT = Lists.newArrayList();
        }
        toCnsldtnCustomerGroupT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CustomerGroup instances.
     *
     */
    public final static class CustomerGroupBuilder
    {

        private List<CustomerGroupHier> toCnsldtnCustomerGroupHier = Lists.newArrayList();
        private List<CustomerGroupText> toCnsldtnCustomerGroupT = Lists.newArrayList();

        private CustomerGroup.CustomerGroupBuilder toCnsldtnCustomerGroupHier( final List<CustomerGroupHier> value )
        {
            toCnsldtnCustomerGroupHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCustomerGroupHier</b> for <b>CustomerGroup</b> to multiple
         * <b>CustomerGroupHier</b>.
         *
         * @param value
         *            The CustomerGroupHiers to build this CustomerGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerGroup.CustomerGroupBuilder cnsldtnCustomerGroupHier( CustomerGroupHier... value )
        {
            return toCnsldtnCustomerGroupHier(Lists.newArrayList(value));
        }

        private CustomerGroup.CustomerGroupBuilder toCnsldtnCustomerGroupT( final List<CustomerGroupText> value )
        {
            toCnsldtnCustomerGroupT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCustomerGroupT</b> for <b>CustomerGroup</b> to multiple
         * <b>CustomerGroupText</b>.
         *
         * @param value
         *            The CustomerGroupTexts to build this CustomerGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerGroup.CustomerGroupBuilder cnsldtnCustomerGroupT( CustomerGroupText... value )
        {
            return toCnsldtnCustomerGroupT(Lists.newArrayList(value));
        }

    }

}
