/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CustomerGroupTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CustomerGroupTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CustomerGroupTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Customer Group Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CustomerGroupTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerGroupText extends VdmEntity<CustomerGroupText>
{

    /**
     * Selector for all available fields of CustomerGroupText.
     *
     */
    public final static CustomerGroupTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CustomerGroupTextField<String> LANGUAGE = new CustomerGroupTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @return Consolidation Customer Group
     */
    @Key
    @SerializedName( "CustomerGroup" )
    @JsonProperty( "CustomerGroup" )
    @Nullable
    @ODataField( odataName = "CustomerGroup" )
    private String customerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup</b> field to query operations.
     *
     */
    public final static CustomerGroupTextField<String> CUSTOMER_GROUP =
        new CustomerGroupTextField<String>("CustomerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroupText</b>
     * </p>
     *
     * @return Customer Group Description
     */
    @SerializedName( "CustomerGroupText" )
    @JsonProperty( "CustomerGroupText" )
    @Nullable
    @ODataField( odataName = "CustomerGroupText" )
    private String customerGroupText;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroupText</b> field to query operations.
     *
     */
    public final static CustomerGroupTextField<String> CUSTOMER_GROUP_TEXT =
        new CustomerGroupTextField<String>("CustomerGroupText");
    /**
     * Navigation property <b>to_CnsldtnCustomerGroup</b> for <b>CustomerGroupText</b> to single <b>CustomerGroup</b>.
     *
     */
    @SerializedName( "to_CnsldtnCustomerGroup" )
    @JsonProperty( "to_CnsldtnCustomerGroup" )
    @ODataField( odataName = "to_CnsldtnCustomerGroup" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerGroup toCnsldtnCustomerGroup;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCustomerGroup</b> navigation property to query
     * operations.
     *
     */
    public final static CustomerGroupTextOneToOneLink<CustomerGroup> TO_CNSLDTN_CUSTOMER_GROUP =
        new CustomerGroupTextOneToOneLink<CustomerGroup>("to_CnsldtnCustomerGroup");

    @Nonnull
    @Override
    public Class<CustomerGroupText> getType()
    {
        return CustomerGroupText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @param customerGroup
     *            Consolidation Customer Group
     */
    public void setCustomerGroup( @Nullable final String customerGroup )
    {
        rememberChangedField("CustomerGroup", this.customerGroup);
        this.customerGroup = customerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroupText</b>
     * </p>
     *
     * @param customerGroupText
     *            Customer Group Description
     */
    public void setCustomerGroupText( @Nullable final String customerGroupText )
    {
        rememberChangedField("CustomerGroupText", this.customerGroupText);
        this.customerGroupText = customerGroupText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CustomerGroupText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("CustomerGroup", getCustomerGroup());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("CustomerGroup", getCustomerGroup());
        values.put("CustomerGroupText", getCustomerGroupText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("CustomerGroup") ) {
                final Object value = values.remove("CustomerGroup");
                if( (value == null) || (!value.equals(getCustomerGroup())) ) {
                    setCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("CustomerGroupText") ) {
                final Object value = values.remove("CustomerGroupText");
                if( (value == null) || (!value.equals(getCustomerGroupText())) ) {
                    setCustomerGroupText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnCustomerGroup") ) {
                final Object value = (values).remove("to_CnsldtnCustomerGroup");
                if( value instanceof Map ) {
                    if( toCnsldtnCustomerGroup == null ) {
                        toCnsldtnCustomerGroup = new CustomerGroup();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnCustomerGroup.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CustomerGroupTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerGroupTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerGroupTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerGroupTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnCustomerGroup != null ) {
            (values).put("to_CnsldtnCustomerGroup", toCnsldtnCustomerGroup);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerGroup</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnCustomerGroup</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerGroup</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerGroup fetchCnsldtnCustomerGroup()
    {
        return fetchFieldAsSingle("to_CnsldtnCustomerGroup", CustomerGroup.class);
    }

    /**
     * Retrieval of associated <b>CustomerGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnCustomerGroup</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerGroup</b> of a queried <b>CustomerGroupText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerGroup</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerGroup getCnsldtnCustomerGroupOrFetch()
    {
        if( toCnsldtnCustomerGroup == null ) {
            toCnsldtnCustomerGroup = fetchCnsldtnCustomerGroup();
        }
        return toCnsldtnCustomerGroup;
    }

    /**
     * Retrieval of associated <b>CustomerGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnCustomerGroup</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerGroupText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCustomerGroup</b> is already loaded, the result
     *         will contain the <b>CustomerGroup</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerGroup> getCnsldtnCustomerGroupIfPresent()
    {
        return Option.of(toCnsldtnCustomerGroup);
    }

    /**
     * Overwrites the associated <b>CustomerGroup</b> entity for the loaded navigation property
     * <b>to_CnsldtnCustomerGroup</b>.
     *
     * @param value
     *            New <b>CustomerGroup</b> entity.
     */
    public void setCnsldtnCustomerGroup( final CustomerGroup value )
    {
        toCnsldtnCustomerGroup = value;
    }

    /**
     * Helper class to allow for fluent creation of CustomerGroupText instances.
     *
     */
    public final static class CustomerGroupTextBuilder
    {

        private CustomerGroup toCnsldtnCustomerGroup;

        private CustomerGroupText.CustomerGroupTextBuilder toCnsldtnCustomerGroup( final CustomerGroup value )
        {
            toCnsldtnCustomerGroup = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCustomerGroup</b> for <b>CustomerGroupText</b> to single
         * <b>CustomerGroup</b>.
         *
         * @param value
         *            The CustomerGroup to build this CustomerGroupText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerGroupText.CustomerGroupTextBuilder cnsldtnCustomerGroup( final CustomerGroup value )
        {
            return toCnsldtnCustomerGroup(value);
        }

    }

}
