/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CustomerHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CustomerHierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CustomerHierOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CustomerHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Customer Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CustomerHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerHier extends VdmEntity<CustomerHier>
{

    /**
     * Selector for all available fields of CustomerHier.
     *
     */
    public final static CustomerHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @return Hierarchy ID
     */
    @Key
    @SerializedName( "AdditionalMasterDataHierarchy" )
    @JsonProperty( "AdditionalMasterDataHierarchy" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataHierarchy" )
    private String additionalMasterDataHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataHierarchy</b> field to query operations.
     *
     */
    public final static CustomerHierField<String> ADDITIONAL_MASTER_DATA_HIERARCHY =
        new CustomerHierField<String>("AdditionalMasterDataHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static CustomerHierField<String> HIERARCHY_NODE = new CustomerHierField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static CustomerHierField<String> HIERARCHY_NODE_TEXT =
        new CustomerHierField<String>("HierarchyNode_Text");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Validity End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static CustomerHierField<LocalDateTime> VALIDITY_END_DATE =
        new CustomerHierField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Parent Node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static CustomerHierField<String> PARENT_NODE = new CustomerHierField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Validity Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static CustomerHierField<LocalDateTime> VALIDITY_START_DATE =
        new CustomerHierField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Consolidation Customer
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static CustomerHierField<String> CUSTOMER = new CustomerHierField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Customer_Text</b>
     * </p>
     *
     * @return Customer Description
     */
    @SerializedName( "Customer_Text" )
    @JsonProperty( "Customer_Text" )
    @Nullable
    @ODataField( odataName = "Customer_Text" )
    private String customer_Text;
    /**
     * Use with available fluent helpers to apply the <b>Customer_Text</b> field to query operations.
     *
     */
    public final static CustomerHierField<String> CUSTOMER_TEXT = new CustomerHierField<String>("Customer_Text");
    /**
     * Constraints: Not nullable, Maximum length: 56
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return The sequenceNumber contained in this entity.
     */
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static CustomerHierField<String> SEQUENCE_NUMBER = new CustomerHierField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @return Consolidation Hierarchy Sequence Number
     */
    @SerializedName( "HierarchyNodeSequence" )
    @JsonProperty( "HierarchyNodeSequence" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeSequence" )
    private String hierarchyNodeSequence;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeSequence</b> field to query operations.
     *
     */
    public final static CustomerHierField<String> HIERARCHY_NODE_SEQUENCE =
        new CustomerHierField<String>("HierarchyNodeSequence");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Consolidation Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static CustomerHierField<String> HIERARCHY_NODE_LEVEL =
        new CustomerHierField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static CustomerHierField<String> NODE_TYPE = new CustomerHierField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnCustomer</b> for <b>CustomerHier</b> to single <b>Customer</b>.
     *
     */
    @SerializedName( "to_CnsldtnCustomer" )
    @JsonProperty( "to_CnsldtnCustomer" )
    @ODataField( odataName = "to_CnsldtnCustomer" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Customer toCnsldtnCustomer;
    /**
     * Navigation property <b>to_CnsldtnCustomerHierT</b> for <b>CustomerHier</b> to multiple <b>CustomerHierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnCustomerHierT" )
    @JsonProperty( "to_CnsldtnCustomerHierT" )
    @ODataField( odataName = "to_CnsldtnCustomerHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerHierText> toCnsldtnCustomerHierT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCustomer</b> navigation property to query operations.
     *
     */
    public final static CustomerHierOneToOneLink<Customer> TO_CNSLDTN_CUSTOMER =
        new CustomerHierOneToOneLink<Customer>("to_CnsldtnCustomer");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCustomerHierT</b> navigation property to query
     * operations.
     *
     */
    public final static CustomerHierLink<CustomerHierText> TO_CNSLDTN_CUSTOMER_HIER_T =
        new CustomerHierLink<CustomerHierText>("to_CnsldtnCustomerHierT");

    @Nonnull
    @Override
    public Class<CustomerHier> getType()
    {
        return CustomerHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @param additionalMasterDataHierarchy
     *            Hierarchy ID
     */
    public void setAdditionalMasterDataHierarchy( @Nullable final String additionalMasterDataHierarchy )
    {
        rememberChangedField("AdditionalMasterDataHierarchy", this.additionalMasterDataHierarchy);
        this.additionalMasterDataHierarchy = additionalMasterDataHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Consolidation Hierarchy Node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Consolidation Hierarchy Node Description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Consolidation Hierarchy Parent Node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Consolidation Customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Customer_Text</b>
     * </p>
     *
     * @param customer_Text
     *            Customer Description
     */
    public void setCustomer_Text( @Nullable final String customer_Text )
    {
        rememberChangedField("Customer_Text", this.customer_Text);
        this.customer_Text = customer_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 56
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            The sequenceNumber to set.
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @param hierarchyNodeSequence
     *            Consolidation Hierarchy Sequence Number
     */
    public void setHierarchyNodeSequence( @Nullable final String hierarchyNodeSequence )
    {
        rememberChangedField("HierarchyNodeSequence", this.hierarchyNodeSequence);
        this.hierarchyNodeSequence = hierarchyNodeSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Consolidation Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Consolidation Hierarchy Node Type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CustomerHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ParentNode", getParentNode());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("Customer", getCustomer());
        values.put("Customer_Text", getCustomer_Text());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("HierarchyNodeSequence", getHierarchyNodeSequence());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AdditionalMasterDataHierarchy") ) {
                final Object value = values.remove("AdditionalMasterDataHierarchy");
                if( (value == null) || (!value.equals(getAdditionalMasterDataHierarchy())) ) {
                    setAdditionalMasterDataHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Customer_Text") ) {
                final Object value = values.remove("Customer_Text");
                if( (value == null) || (!value.equals(getCustomer_Text())) ) {
                    setCustomer_Text(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeSequence") ) {
                final Object value = values.remove("HierarchyNodeSequence");
                if( (value == null) || (!value.equals(getHierarchyNodeSequence())) ) {
                    setHierarchyNodeSequence(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnCustomer") ) {
                final Object value = (values).remove("to_CnsldtnCustomer");
                if( value instanceof Map ) {
                    if( toCnsldtnCustomer == null ) {
                        toCnsldtnCustomer = new Customer();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnCustomer.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnCustomerHierT") ) {
                final Object value = (values).remove("to_CnsldtnCustomerHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnCustomerHierT == null ) {
                        toCnsldtnCustomerHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnCustomerHierT = Lists.newArrayList(toCnsldtnCustomerHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerHierText entity;
                        if( toCnsldtnCustomerHierT.size() > i ) {
                            entity = toCnsldtnCustomerHierT.get(i);
                        } else {
                            entity = new CustomerHierText();
                            toCnsldtnCustomerHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustomerHierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnCustomer != null ) {
            (values).put("to_CnsldtnCustomer", toCnsldtnCustomer);
        }
        if( toCnsldtnCustomerHierT != null ) {
            (values).put("to_CnsldtnCustomerHierT", toCnsldtnCustomerHierT);
        }
        return values;
    }

    /**
     * Fetches the <b>Customer</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnCustomer</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Customer</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Customer fetchCnsldtnCustomer()
    {
        return fetchFieldAsSingle("to_CnsldtnCustomer", Customer.class);
    }

    /**
     * Retrieval of associated <b>Customer</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnCustomer</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomer</b> of a queried <b>CustomerHier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Customer</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Customer getCnsldtnCustomerOrFetch()
    {
        if( toCnsldtnCustomer == null ) {
            toCnsldtnCustomer = fetchCnsldtnCustomer();
        }
        return toCnsldtnCustomer;
    }

    /**
     * Retrieval of associated <b>Customer</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnCustomer</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerHier</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCustomer</b> is already loaded, the result will
     *         contain the <b>Customer</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<Customer> getCnsldtnCustomerIfPresent()
    {
        return Option.of(toCnsldtnCustomer);
    }

    /**
     * Overwrites the associated <b>Customer</b> entity for the loaded navigation property <b>to_CnsldtnCustomer</b>.
     *
     * @param value
     *            New <b>Customer</b> entity.
     */
    public void setCnsldtnCustomer( final Customer value )
    {
        toCnsldtnCustomer = value;
    }

    /**
     * Fetches the <b>CustomerHierText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnCustomerHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerHierText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerHierText> fetchCnsldtnCustomerHierT()
    {
        return fetchFieldAsList("to_CnsldtnCustomerHierT", CustomerHierText.class);
    }

    /**
     * Retrieval of associated <b>CustomerHierText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnCustomerHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerHierT</b> of a queried <b>CustomerHier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerHierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerHierText> getCnsldtnCustomerHierTOrFetch()
    {
        if( toCnsldtnCustomerHierT == null ) {
            toCnsldtnCustomerHierT = fetchCnsldtnCustomerHierT();
        }
        return toCnsldtnCustomerHierT;
    }

    /**
     * Retrieval of associated <b>CustomerHierText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnCustomerHierT</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerHier</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCustomerHierT</b> is already loaded, the result
     *         will contain the <b>CustomerHierText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerHierText>> getCnsldtnCustomerHierTIfPresent()
    {
        return Option.of(toCnsldtnCustomerHierT);
    }

    /**
     * Overwrites the list of associated <b>CustomerHierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnCustomerHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerHierT</b> of a queried <b>CustomerHier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerHierText</b> entities.
     */
    public void setCnsldtnCustomerHierT( @Nonnull final List<CustomerHierText> value )
    {
        if( toCnsldtnCustomerHierT == null ) {
            toCnsldtnCustomerHierT = Lists.newArrayList();
        }
        toCnsldtnCustomerHierT.clear();
        toCnsldtnCustomerHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerHierText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnCustomerHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomerHierT</b> of a queried <b>CustomerHier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerHierText</b> entities.
     */
    public void addCnsldtnCustomerHierT( CustomerHierText... entity )
    {
        if( toCnsldtnCustomerHierT == null ) {
            toCnsldtnCustomerHierT = Lists.newArrayList();
        }
        toCnsldtnCustomerHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CustomerHier instances.
     *
     */
    public final static class CustomerHierBuilder
    {

        private Customer toCnsldtnCustomer;
        private List<CustomerHierText> toCnsldtnCustomerHierT = Lists.newArrayList();

        private CustomerHier.CustomerHierBuilder toCnsldtnCustomer( final Customer value )
        {
            toCnsldtnCustomer = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCustomer</b> for <b>CustomerHier</b> to single <b>Customer</b>.
         *
         * @param value
         *            The Customer to build this CustomerHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerHier.CustomerHierBuilder cnsldtnCustomer( final Customer value )
        {
            return toCnsldtnCustomer(value);
        }

        private CustomerHier.CustomerHierBuilder toCnsldtnCustomerHierT( final List<CustomerHierText> value )
        {
            toCnsldtnCustomerHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCustomerHierT</b> for <b>CustomerHier</b> to multiple
         * <b>CustomerHierText</b>.
         *
         * @param value
         *            The CustomerHierTexts to build this CustomerHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerHier.CustomerHierBuilder cnsldtnCustomerHierT( CustomerHierText... value )
        {
            return toCnsldtnCustomerHierT(Lists.newArrayList(value));
        }

    }

}
