/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CustomerSupplierCountryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CustomerSupplierCountryLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CustomerSupplierCountrySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Country/Region
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CustomerSupplierCountryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerSupplierCountry extends VdmEntity<CustomerSupplierCountry>
{

    /**
     * Selector for all available fields of CustomerSupplierCountry.
     *
     */
    public final static CustomerSupplierCountrySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region in Consolidation
     */
    @Key
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryField<String> COUNTRY =
        new CustomerSupplierCountryField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Country_Text</b>
     * </p>
     *
     * @return Customer/Supplier Country/Region Description
     */
    @SerializedName( "Country_Text" )
    @JsonProperty( "Country_Text" )
    @Nullable
    @ODataField( odataName = "Country_Text" )
    private String country_Text;
    /**
     * Use with available fluent helpers to apply the <b>Country_Text</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryField<String> COUNTRY_TEXT =
        new CustomerSupplierCountryField<String>("Country_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new CustomerSupplierCountryField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnCountryHier</b> for <b>CustomerSupplierCountry</b> to multiple
     * <b>CustomerSupplierCountryHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnCountryHier" )
    @JsonProperty( "to_CnsldtnCountryHier" )
    @ODataField( odataName = "to_CnsldtnCountryHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerSupplierCountryHier> toCnsldtnCountryHier;
    /**
     * Navigation property <b>to_CnsldtnCountryT</b> for <b>CustomerSupplierCountry</b> to multiple
     * <b>CustomerSupplierCountryText</b>.
     *
     */
    @SerializedName( "to_CnsldtnCountryT" )
    @JsonProperty( "to_CnsldtnCountryT" )
    @ODataField( odataName = "to_CnsldtnCountryT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerSupplierCountryText> toCnsldtnCountryT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCountryHier</b> navigation property to query
     * operations.
     *
     */
    public final static CustomerSupplierCountryLink<CustomerSupplierCountryHier> TO_CNSLDTN_COUNTRY_HIER =
        new CustomerSupplierCountryLink<CustomerSupplierCountryHier>("to_CnsldtnCountryHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCountryT</b> navigation property to query operations.
     *
     */
    public final static CustomerSupplierCountryLink<CustomerSupplierCountryText> TO_CNSLDTN_COUNTRY_T =
        new CustomerSupplierCountryLink<CustomerSupplierCountryText>("to_CnsldtnCountryT");

    @Nonnull
    @Override
    public Class<CustomerSupplierCountry> getType()
    {
        return CustomerSupplierCountry.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region in Consolidation
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Country_Text</b>
     * </p>
     *
     * @param country_Text
     *            Customer/Supplier Country/Region Description
     */
    public void setCountry_Text( @Nullable final String country_Text )
    {
        rememberChangedField("Country_Text", this.country_Text);
        this.country_Text = country_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CustomerSupplierCountry";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Country", getCountry());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Country", getCountry());
        values.put("Country_Text", getCountry_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("Country_Text") ) {
                final Object value = values.remove("Country_Text");
                if( (value == null) || (!value.equals(getCountry_Text())) ) {
                    setCountry_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnCountryHier") ) {
                final Object value = (values).remove("to_CnsldtnCountryHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnCountryHier == null ) {
                        toCnsldtnCountryHier = Lists.newArrayList();
                    } else {
                        toCnsldtnCountryHier = Lists.newArrayList(toCnsldtnCountryHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerSupplierCountryHier entity;
                        if( toCnsldtnCountryHier.size() > i ) {
                            entity = toCnsldtnCountryHier.get(i);
                        } else {
                            entity = new CustomerSupplierCountryHier();
                            toCnsldtnCountryHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnCountryT") ) {
                final Object value = (values).remove("to_CnsldtnCountryT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnCountryT == null ) {
                        toCnsldtnCountryT = Lists.newArrayList();
                    } else {
                        toCnsldtnCountryT = Lists.newArrayList(toCnsldtnCountryT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerSupplierCountryText entity;
                        if( toCnsldtnCountryT.size() > i ) {
                            entity = toCnsldtnCountryT.get(i);
                        } else {
                            entity = new CustomerSupplierCountryText();
                            toCnsldtnCountryT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CustomerSupplierCountryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerSupplierCountryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerSupplierCountryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerSupplierCountryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnCountryHier != null ) {
            (values).put("to_CnsldtnCountryHier", toCnsldtnCountryHier);
        }
        if( toCnsldtnCountryT != null ) {
            (values).put("to_CnsldtnCountryT", toCnsldtnCountryT);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerSupplierCountryHier</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnCountryHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerSupplierCountryHier</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerSupplierCountryHier> fetchCnsldtnCountryHier()
    {
        return fetchFieldAsList("to_CnsldtnCountryHier", CustomerSupplierCountryHier.class);
    }

    /**
     * Retrieval of associated <b>CustomerSupplierCountryHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnCountryHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCountryHier</b> of a queried <b>CustomerSupplierCountry</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerSupplierCountryHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerSupplierCountryHier> getCnsldtnCountryHierOrFetch()
    {
        if( toCnsldtnCountryHier == null ) {
            toCnsldtnCountryHier = fetchCnsldtnCountryHier();
        }
        return toCnsldtnCountryHier;
    }

    /**
     * Retrieval of associated <b>CustomerSupplierCountryHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnCountryHier</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerSupplierCountry</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCountryHier</b> is already loaded, the result
     *         will contain the <b>CustomerSupplierCountryHier</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerSupplierCountryHier>> getCnsldtnCountryHierIfPresent()
    {
        return Option.of(toCnsldtnCountryHier);
    }

    /**
     * Overwrites the list of associated <b>CustomerSupplierCountryHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnCountryHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCountryHier</b> of a queried <b>CustomerSupplierCountry</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerSupplierCountryHier</b> entities.
     */
    public void setCnsldtnCountryHier( @Nonnull final List<CustomerSupplierCountryHier> value )
    {
        if( toCnsldtnCountryHier == null ) {
            toCnsldtnCountryHier = Lists.newArrayList();
        }
        toCnsldtnCountryHier.clear();
        toCnsldtnCountryHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerSupplierCountryHier</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnCountryHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCountryHier</b> of a queried <b>CustomerSupplierCountry</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerSupplierCountryHier</b> entities.
     */
    public void addCnsldtnCountryHier( CustomerSupplierCountryHier... entity )
    {
        if( toCnsldtnCountryHier == null ) {
            toCnsldtnCountryHier = Lists.newArrayList();
        }
        toCnsldtnCountryHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustomerSupplierCountryText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnCountryT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerSupplierCountryText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerSupplierCountryText> fetchCnsldtnCountryT()
    {
        return fetchFieldAsList("to_CnsldtnCountryT", CustomerSupplierCountryText.class);
    }

    /**
     * Retrieval of associated <b>CustomerSupplierCountryText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnCountryT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCountryT</b> of a queried <b>CustomerSupplierCountry</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerSupplierCountryText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerSupplierCountryText> getCnsldtnCountryTOrFetch()
    {
        if( toCnsldtnCountryT == null ) {
            toCnsldtnCountryT = fetchCnsldtnCountryT();
        }
        return toCnsldtnCountryT;
    }

    /**
     * Retrieval of associated <b>CustomerSupplierCountryText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnCountryT</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerSupplierCountry</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCountryT</b> is already loaded, the result will
     *         contain the <b>CustomerSupplierCountryText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerSupplierCountryText>> getCnsldtnCountryTIfPresent()
    {
        return Option.of(toCnsldtnCountryT);
    }

    /**
     * Overwrites the list of associated <b>CustomerSupplierCountryText</b> entities for the loaded navigation property
     * <b>to_CnsldtnCountryT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCountryT</b> of a queried <b>CustomerSupplierCountry</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerSupplierCountryText</b> entities.
     */
    public void setCnsldtnCountryT( @Nonnull final List<CustomerSupplierCountryText> value )
    {
        if( toCnsldtnCountryT == null ) {
            toCnsldtnCountryT = Lists.newArrayList();
        }
        toCnsldtnCountryT.clear();
        toCnsldtnCountryT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerSupplierCountryText</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnCountryT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCountryT</b> of a queried <b>CustomerSupplierCountry</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerSupplierCountryText</b> entities.
     */
    public void addCnsldtnCountryT( CustomerSupplierCountryText... entity )
    {
        if( toCnsldtnCountryT == null ) {
            toCnsldtnCountryT = Lists.newArrayList();
        }
        toCnsldtnCountryT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CustomerSupplierCountry instances.
     *
     */
    public final static class CustomerSupplierCountryBuilder
    {

        private List<CustomerSupplierCountryHier> toCnsldtnCountryHier = Lists.newArrayList();
        private List<CustomerSupplierCountryText> toCnsldtnCountryT = Lists.newArrayList();

        private CustomerSupplierCountry.CustomerSupplierCountryBuilder toCnsldtnCountryHier(
            final List<CustomerSupplierCountryHier> value )
        {
            toCnsldtnCountryHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCountryHier</b> for <b>CustomerSupplierCountry</b> to multiple
         * <b>CustomerSupplierCountryHier</b>.
         *
         * @param value
         *            The CustomerSupplierCountryHiers to build this CustomerSupplierCountry with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerSupplierCountry.CustomerSupplierCountryBuilder cnsldtnCountryHier(
            CustomerSupplierCountryHier... value )
        {
            return toCnsldtnCountryHier(Lists.newArrayList(value));
        }

        private CustomerSupplierCountry.CustomerSupplierCountryBuilder toCnsldtnCountryT(
            final List<CustomerSupplierCountryText> value )
        {
            toCnsldtnCountryT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCountryT</b> for <b>CustomerSupplierCountry</b> to multiple
         * <b>CustomerSupplierCountryText</b>.
         *
         * @param value
         *            The CustomerSupplierCountryTexts to build this CustomerSupplierCountry with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerSupplierCountry.CustomerSupplierCountryBuilder cnsldtnCountryT(
            CustomerSupplierCountryText... value )
        {
            return toCnsldtnCountryT(Lists.newArrayList(value));
        }

    }

}
