/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CustomerSupplierCountryHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CustomerSupplierCountryHierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CustomerSupplierCountryHierOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CustomerSupplierCountryHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Country/Region Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CustomerSupplierCountryHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerSupplierCountryHier extends VdmEntity<CustomerSupplierCountryHier>
{

    /**
     * Selector for all available fields of CustomerSupplierCountryHier.
     *
     */
    public final static CustomerSupplierCountryHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @return Consolidation Hierarchy ID
     */
    @Key
    @SerializedName( "AdditionalMasterDataHierarchy" )
    @JsonProperty( "AdditionalMasterDataHierarchy" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataHierarchy" )
    private String additionalMasterDataHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataHierarchy</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryHierField<String> ADDITIONAL_MASTER_DATA_HIERARCHY =
        new CustomerSupplierCountryHierField<String>("AdditionalMasterDataHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Hierarchy node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryHierField<String> HIERARCHY_NODE =
        new CustomerSupplierCountryHierField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Hierarchy node description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryHierField<String> HIERARCHY_NODE_TEXT =
        new CustomerSupplierCountryHierField<String>("HierarchyNode_Text");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Validity End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryHierField<LocalDateTime> VALIDITY_END_DATE =
        new CustomerSupplierCountryHierField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Hierarchy parent node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryHierField<String> PARENT_NODE =
        new CustomerSupplierCountryHierField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Validity Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryHierField<LocalDateTime> VALIDITY_START_DATE =
        new CustomerSupplierCountryHierField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryHierField<String> COUNTRY =
        new CustomerSupplierCountryHierField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Country_Text</b>
     * </p>
     *
     * @return Customer/Supplier Country/Region Description
     */
    @SerializedName( "Country_Text" )
    @JsonProperty( "Country_Text" )
    @Nullable
    @ODataField( odataName = "Country_Text" )
    private String country_Text;
    /**
     * Use with available fluent helpers to apply the <b>Country_Text</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryHierField<String> COUNTRY_TEXT =
        new CustomerSupplierCountryHierField<String>("Country_Text");
    /**
     * Constraints: Not nullable, Maximum length: 56
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return The sequenceNumber contained in this entity.
     */
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryHierField<String> SEQUENCE_NUMBER =
        new CustomerSupplierCountryHierField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @return Hierarchy Sequence Number
     */
    @SerializedName( "HierarchyNodeSequence" )
    @JsonProperty( "HierarchyNodeSequence" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeSequence" )
    private String hierarchyNodeSequence;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeSequence</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryHierField<String> HIERARCHY_NODE_SEQUENCE =
        new CustomerSupplierCountryHierField<String>("HierarchyNodeSequence");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryHierField<String> HIERARCHY_NODE_LEVEL =
        new CustomerSupplierCountryHierField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Hierarchy node type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryHierField<String> NODE_TYPE =
        new CustomerSupplierCountryHierField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnCountry</b> for <b>CustomerSupplierCountryHier</b> to single
     * <b>CustomerSupplierCountry</b>.
     *
     */
    @SerializedName( "to_CnsldtnCountry" )
    @JsonProperty( "to_CnsldtnCountry" )
    @ODataField( odataName = "to_CnsldtnCountry" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerSupplierCountry toCnsldtnCountry;
    /**
     * Navigation property <b>to_CnsldtnCountryHierT</b> for <b>CustomerSupplierCountryHier</b> to multiple
     * <b>CustomerSuplrCntryHierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnCountryHierT" )
    @JsonProperty( "to_CnsldtnCountryHierT" )
    @ODataField( odataName = "to_CnsldtnCountryHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerSuplrCntryHierText> toCnsldtnCountryHierT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCountry</b> navigation property to query operations.
     *
     */
    public final static CustomerSupplierCountryHierOneToOneLink<CustomerSupplierCountry> TO_CNSLDTN_COUNTRY =
        new CustomerSupplierCountryHierOneToOneLink<CustomerSupplierCountry>("to_CnsldtnCountry");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCountryHierT</b> navigation property to query
     * operations.
     *
     */
    public final static CustomerSupplierCountryHierLink<CustomerSuplrCntryHierText> TO_CNSLDTN_COUNTRY_HIER_T =
        new CustomerSupplierCountryHierLink<CustomerSuplrCntryHierText>("to_CnsldtnCountryHierT");

    @Nonnull
    @Override
    public Class<CustomerSupplierCountryHier> getType()
    {
        return CustomerSupplierCountryHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @param additionalMasterDataHierarchy
     *            Consolidation Hierarchy ID
     */
    public void setAdditionalMasterDataHierarchy( @Nullable final String additionalMasterDataHierarchy )
    {
        rememberChangedField("AdditionalMasterDataHierarchy", this.additionalMasterDataHierarchy);
        this.additionalMasterDataHierarchy = additionalMasterDataHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Hierarchy node description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Hierarchy parent node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Country_Text</b>
     * </p>
     *
     * @param country_Text
     *            Customer/Supplier Country/Region Description
     */
    public void setCountry_Text( @Nullable final String country_Text )
    {
        rememberChangedField("Country_Text", this.country_Text);
        this.country_Text = country_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 56
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            The sequenceNumber to set.
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @param hierarchyNodeSequence
     *            Hierarchy Sequence Number
     */
    public void setHierarchyNodeSequence( @Nullable final String hierarchyNodeSequence )
    {
        rememberChangedField("HierarchyNodeSequence", this.hierarchyNodeSequence);
        this.hierarchyNodeSequence = hierarchyNodeSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CustomerSupplierCountryHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ParentNode", getParentNode());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("Country", getCountry());
        values.put("Country_Text", getCountry_Text());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("HierarchyNodeSequence", getHierarchyNodeSequence());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AdditionalMasterDataHierarchy") ) {
                final Object value = values.remove("AdditionalMasterDataHierarchy");
                if( (value == null) || (!value.equals(getAdditionalMasterDataHierarchy())) ) {
                    setAdditionalMasterDataHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("Country_Text") ) {
                final Object value = values.remove("Country_Text");
                if( (value == null) || (!value.equals(getCountry_Text())) ) {
                    setCountry_Text(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeSequence") ) {
                final Object value = values.remove("HierarchyNodeSequence");
                if( (value == null) || (!value.equals(getHierarchyNodeSequence())) ) {
                    setHierarchyNodeSequence(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnCountry") ) {
                final Object value = (values).remove("to_CnsldtnCountry");
                if( value instanceof Map ) {
                    if( toCnsldtnCountry == null ) {
                        toCnsldtnCountry = new CustomerSupplierCountry();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnCountry.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnCountryHierT") ) {
                final Object value = (values).remove("to_CnsldtnCountryHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnCountryHierT == null ) {
                        toCnsldtnCountryHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnCountryHierT = Lists.newArrayList(toCnsldtnCountryHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerSuplrCntryHierText entity;
                        if( toCnsldtnCountryHierT.size() > i ) {
                            entity = toCnsldtnCountryHierT.get(i);
                        } else {
                            entity = new CustomerSuplrCntryHierText();
                            toCnsldtnCountryHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustomerSupplierCountryHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CustomerSupplierCountryHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerSupplierCountryHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerSupplierCountryHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnCountry != null ) {
            (values).put("to_CnsldtnCountry", toCnsldtnCountry);
        }
        if( toCnsldtnCountryHierT != null ) {
            (values).put("to_CnsldtnCountryHierT", toCnsldtnCountryHierT);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerSupplierCountry</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnCountry</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerSupplierCountry</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerSupplierCountry fetchCnsldtnCountry()
    {
        return fetchFieldAsSingle("to_CnsldtnCountry", CustomerSupplierCountry.class);
    }

    /**
     * Retrieval of associated <b>CustomerSupplierCountry</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnCountry</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCountry</b> of a queried <b>CustomerSupplierCountryHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerSupplierCountry</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerSupplierCountry getCnsldtnCountryOrFetch()
    {
        if( toCnsldtnCountry == null ) {
            toCnsldtnCountry = fetchCnsldtnCountry();
        }
        return toCnsldtnCountry;
    }

    /**
     * Retrieval of associated <b>CustomerSupplierCountry</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnCountry</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerSupplierCountryHier</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCountry</b> is already loaded, the result will
     *         contain the <b>CustomerSupplierCountry</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerSupplierCountry> getCnsldtnCountryIfPresent()
    {
        return Option.of(toCnsldtnCountry);
    }

    /**
     * Overwrites the associated <b>CustomerSupplierCountry</b> entity for the loaded navigation property
     * <b>to_CnsldtnCountry</b>.
     *
     * @param value
     *            New <b>CustomerSupplierCountry</b> entity.
     */
    public void setCnsldtnCountry( final CustomerSupplierCountry value )
    {
        toCnsldtnCountry = value;
    }

    /**
     * Fetches the <b>CustomerSuplrCntryHierText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnCountryHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerSuplrCntryHierText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerSuplrCntryHierText> fetchCnsldtnCountryHierT()
    {
        return fetchFieldAsList("to_CnsldtnCountryHierT", CustomerSuplrCntryHierText.class);
    }

    /**
     * Retrieval of associated <b>CustomerSuplrCntryHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnCountryHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCountryHierT</b> of a queried <b>CustomerSupplierCountryHier</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerSuplrCntryHierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerSuplrCntryHierText> getCnsldtnCountryHierTOrFetch()
    {
        if( toCnsldtnCountryHierT == null ) {
            toCnsldtnCountryHierT = fetchCnsldtnCountryHierT();
        }
        return toCnsldtnCountryHierT;
    }

    /**
     * Retrieval of associated <b>CustomerSuplrCntryHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnCountryHierT</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerSupplierCountryHier</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCountryHierT</b> is already loaded, the result
     *         will contain the <b>CustomerSuplrCntryHierText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerSuplrCntryHierText>> getCnsldtnCountryHierTIfPresent()
    {
        return Option.of(toCnsldtnCountryHierT);
    }

    /**
     * Overwrites the list of associated <b>CustomerSuplrCntryHierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnCountryHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCountryHierT</b> of a queried <b>CustomerSupplierCountryHier</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerSuplrCntryHierText</b> entities.
     */
    public void setCnsldtnCountryHierT( @Nonnull final List<CustomerSuplrCntryHierText> value )
    {
        if( toCnsldtnCountryHierT == null ) {
            toCnsldtnCountryHierT = Lists.newArrayList();
        }
        toCnsldtnCountryHierT.clear();
        toCnsldtnCountryHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerSuplrCntryHierText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnCountryHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCountryHierT</b> of a queried <b>CustomerSupplierCountryHier</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerSuplrCntryHierText</b> entities.
     */
    public void addCnsldtnCountryHierT( CustomerSuplrCntryHierText... entity )
    {
        if( toCnsldtnCountryHierT == null ) {
            toCnsldtnCountryHierT = Lists.newArrayList();
        }
        toCnsldtnCountryHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CustomerSupplierCountryHier instances.
     *
     */
    public final static class CustomerSupplierCountryHierBuilder
    {

        private CustomerSupplierCountry toCnsldtnCountry;
        private List<CustomerSuplrCntryHierText> toCnsldtnCountryHierT = Lists.newArrayList();

        private CustomerSupplierCountryHier.CustomerSupplierCountryHierBuilder toCnsldtnCountry(
            final CustomerSupplierCountry value )
        {
            toCnsldtnCountry = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCountry</b> for <b>CustomerSupplierCountryHier</b> to single
         * <b>CustomerSupplierCountry</b>.
         *
         * @param value
         *            The CustomerSupplierCountry to build this CustomerSupplierCountryHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerSupplierCountryHier.CustomerSupplierCountryHierBuilder cnsldtnCountry(
            final CustomerSupplierCountry value )
        {
            return toCnsldtnCountry(value);
        }

        private CustomerSupplierCountryHier.CustomerSupplierCountryHierBuilder toCnsldtnCountryHierT(
            final List<CustomerSuplrCntryHierText> value )
        {
            toCnsldtnCountryHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCountryHierT</b> for <b>CustomerSupplierCountryHier</b> to multiple
         * <b>CustomerSuplrCntryHierText</b>.
         *
         * @param value
         *            The CustomerSuplrCntryHierTexts to build this CustomerSupplierCountryHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerSupplierCountryHier.CustomerSupplierCountryHierBuilder cnsldtnCountryHierT(
            CustomerSuplrCntryHierText... value )
        {
            return toCnsldtnCountryHierT(Lists.newArrayList(value));
        }

    }

}
