/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CustomerSupplierCountryTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CustomerSupplierCountryTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CustomerSupplierCountryTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Country/Region - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CustomerSupplierCountryTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerSupplierCountryText extends VdmEntity<CustomerSupplierCountryText>
{

    /**
     * Selector for all available fields of CustomerSupplierCountryText.
     *
     */
    public final static CustomerSupplierCountryTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryTextField<String> LANGUAGE =
        new CustomerSupplierCountryTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Customer/Supplier Country/Region
     */
    @Key
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryTextField<String> COUNTRY =
        new CustomerSupplierCountryTextField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCountryText</b>
     * </p>
     *
     * @return Customer/Supplier Country/Region Description
     */
    @SerializedName( "CustomerSupplierCountryText" )
    @JsonProperty( "CustomerSupplierCountryText" )
    @Nullable
    @ODataField( odataName = "CustomerSupplierCountryText" )
    private String customerSupplierCountryText;
    /**
     * Use with available fluent helpers to apply the <b>CustomerSupplierCountryText</b> field to query operations.
     *
     */
    public final static CustomerSupplierCountryTextField<String> CUSTOMER_SUPPLIER_COUNTRY_TEXT =
        new CustomerSupplierCountryTextField<String>("CustomerSupplierCountryText");
    /**
     * Navigation property <b>to_CnsldtnCountry</b> for <b>CustomerSupplierCountryText</b> to single
     * <b>CustomerSupplierCountry</b>.
     *
     */
    @SerializedName( "to_CnsldtnCountry" )
    @JsonProperty( "to_CnsldtnCountry" )
    @ODataField( odataName = "to_CnsldtnCountry" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerSupplierCountry toCnsldtnCountry;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCountry</b> navigation property to query operations.
     *
     */
    public final static CustomerSupplierCountryTextOneToOneLink<CustomerSupplierCountry> TO_CNSLDTN_COUNTRY =
        new CustomerSupplierCountryTextOneToOneLink<CustomerSupplierCountry>("to_CnsldtnCountry");

    @Nonnull
    @Override
    public Class<CustomerSupplierCountryText> getType()
    {
        return CustomerSupplierCountryText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Customer/Supplier Country/Region
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCountryText</b>
     * </p>
     *
     * @param customerSupplierCountryText
     *            Customer/Supplier Country/Region Description
     */
    public void setCustomerSupplierCountryText( @Nullable final String customerSupplierCountryText )
    {
        rememberChangedField("CustomerSupplierCountryText", this.customerSupplierCountryText);
        this.customerSupplierCountryText = customerSupplierCountryText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CustomerSupplierCountryText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("Country", getCountry());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("Country", getCountry());
        values.put("CustomerSupplierCountryText", getCustomerSupplierCountryText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("CustomerSupplierCountryText") ) {
                final Object value = values.remove("CustomerSupplierCountryText");
                if( (value == null) || (!value.equals(getCustomerSupplierCountryText())) ) {
                    setCustomerSupplierCountryText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnCountry") ) {
                final Object value = (values).remove("to_CnsldtnCountry");
                if( value instanceof Map ) {
                    if( toCnsldtnCountry == null ) {
                        toCnsldtnCountry = new CustomerSupplierCountry();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnCountry.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustomerSupplierCountryTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CustomerSupplierCountryTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerSupplierCountryTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerSupplierCountryTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnCountry != null ) {
            (values).put("to_CnsldtnCountry", toCnsldtnCountry);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerSupplierCountry</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnCountry</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerSupplierCountry</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerSupplierCountry fetchCnsldtnCountry()
    {
        return fetchFieldAsSingle("to_CnsldtnCountry", CustomerSupplierCountry.class);
    }

    /**
     * Retrieval of associated <b>CustomerSupplierCountry</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnCountry</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCountry</b> of a queried <b>CustomerSupplierCountryText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerSupplierCountry</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerSupplierCountry getCnsldtnCountryOrFetch()
    {
        if( toCnsldtnCountry == null ) {
            toCnsldtnCountry = fetchCnsldtnCountry();
        }
        return toCnsldtnCountry;
    }

    /**
     * Retrieval of associated <b>CustomerSupplierCountry</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnCountry</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerSupplierCountryText</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCountry</b> is already loaded, the result will
     *         contain the <b>CustomerSupplierCountry</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerSupplierCountry> getCnsldtnCountryIfPresent()
    {
        return Option.of(toCnsldtnCountry);
    }

    /**
     * Overwrites the associated <b>CustomerSupplierCountry</b> entity for the loaded navigation property
     * <b>to_CnsldtnCountry</b>.
     *
     * @param value
     *            New <b>CustomerSupplierCountry</b> entity.
     */
    public void setCnsldtnCountry( final CustomerSupplierCountry value )
    {
        toCnsldtnCountry = value;
    }

    /**
     * Helper class to allow for fluent creation of CustomerSupplierCountryText instances.
     *
     */
    public final static class CustomerSupplierCountryTextBuilder
    {

        private CustomerSupplierCountry toCnsldtnCountry;

        private CustomerSupplierCountryText.CustomerSupplierCountryTextBuilder toCnsldtnCountry(
            final CustomerSupplierCountry value )
        {
            toCnsldtnCountry = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCountry</b> for <b>CustomerSupplierCountryText</b> to single
         * <b>CustomerSupplierCountry</b>.
         *
         * @param value
         *            The CustomerSupplierCountry to build this CustomerSupplierCountryText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerSupplierCountryText.CustomerSupplierCountryTextBuilder cnsldtnCountry(
            final CustomerSupplierCountry value )
        {
            return toCnsldtnCountry(value);
        }

    }

}
