/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CustomerSupplierIndustryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CustomerSupplierIndustryLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CustomerSupplierIndustrySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Industry
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CustomerSupplierIndustryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerSupplierIndustry extends VdmEntity<CustomerSupplierIndustry>
{

    /**
     * Selector for all available fields of CustomerSupplierIndustry.
     *
     */
    public final static CustomerSupplierIndustrySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Industry</b>
     * </p>
     *
     * @return Industry
     */
    @Key
    @SerializedName( "Industry" )
    @JsonProperty( "Industry" )
    @Nullable
    @ODataField( odataName = "Industry" )
    private String industry;
    /**
     * Use with available fluent helpers to apply the <b>Industry</b> field to query operations.
     *
     */
    public final static CustomerSupplierIndustryField<String> INDUSTRY =
        new CustomerSupplierIndustryField<String>("Industry");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Industry_Text</b>
     * </p>
     *
     * @return Customer/Supplier Industry Description
     */
    @SerializedName( "Industry_Text" )
    @JsonProperty( "Industry_Text" )
    @Nullable
    @ODataField( odataName = "Industry_Text" )
    private String industry_Text;
    /**
     * Use with available fluent helpers to apply the <b>Industry_Text</b> field to query operations.
     *
     */
    public final static CustomerSupplierIndustryField<String> INDUSTRY_TEXT =
        new CustomerSupplierIndustryField<String>("Industry_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static CustomerSupplierIndustryField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new CustomerSupplierIndustryField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnIndustryT</b> for <b>CustomerSupplierIndustry</b> to multiple
     * <b>CustomerSupplierIndustryText</b>.
     *
     */
    @SerializedName( "to_CnsldtnIndustryT" )
    @JsonProperty( "to_CnsldtnIndustryT" )
    @ODataField( odataName = "to_CnsldtnIndustryT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerSupplierIndustryText> toCnsldtnIndustryT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnIndustryT</b> navigation property to query
     * operations.
     *
     */
    public final static CustomerSupplierIndustryLink<CustomerSupplierIndustryText> TO_CNSLDTN_INDUSTRY_T =
        new CustomerSupplierIndustryLink<CustomerSupplierIndustryText>("to_CnsldtnIndustryT");

    @Nonnull
    @Override
    public Class<CustomerSupplierIndustry> getType()
    {
        return CustomerSupplierIndustry.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Industry</b>
     * </p>
     *
     * @param industry
     *            Industry
     */
    public void setIndustry( @Nullable final String industry )
    {
        rememberChangedField("Industry", this.industry);
        this.industry = industry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Industry_Text</b>
     * </p>
     *
     * @param industry_Text
     *            Customer/Supplier Industry Description
     */
    public void setIndustry_Text( @Nullable final String industry_Text )
    {
        rememberChangedField("Industry_Text", this.industry_Text);
        this.industry_Text = industry_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CustomerSupplierIndustry";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Industry", getIndustry());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Industry", getIndustry());
        values.put("Industry_Text", getIndustry_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Industry") ) {
                final Object value = values.remove("Industry");
                if( (value == null) || (!value.equals(getIndustry())) ) {
                    setIndustry(((String) value));
                }
            }
            if( values.containsKey("Industry_Text") ) {
                final Object value = values.remove("Industry_Text");
                if( (value == null) || (!value.equals(getIndustry_Text())) ) {
                    setIndustry_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnIndustryT") ) {
                final Object value = (values).remove("to_CnsldtnIndustryT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnIndustryT == null ) {
                        toCnsldtnIndustryT = Lists.newArrayList();
                    } else {
                        toCnsldtnIndustryT = Lists.newArrayList(toCnsldtnIndustryT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerSupplierIndustryText entity;
                        if( toCnsldtnIndustryT.size() > i ) {
                            entity = toCnsldtnIndustryT.get(i);
                        } else {
                            entity = new CustomerSupplierIndustryText();
                            toCnsldtnIndustryT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CustomerSupplierIndustryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerSupplierIndustryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerSupplierIndustryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerSupplierIndustryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnIndustryT != null ) {
            (values).put("to_CnsldtnIndustryT", toCnsldtnIndustryT);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerSupplierIndustryText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnIndustryT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerSupplierIndustryText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerSupplierIndustryText> fetchCnsldtnIndustryT()
    {
        return fetchFieldAsList("to_CnsldtnIndustryT", CustomerSupplierIndustryText.class);
    }

    /**
     * Retrieval of associated <b>CustomerSupplierIndustryText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnIndustryT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnIndustryT</b> of a queried <b>CustomerSupplierIndustry</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerSupplierIndustryText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerSupplierIndustryText> getCnsldtnIndustryTOrFetch()
    {
        if( toCnsldtnIndustryT == null ) {
            toCnsldtnIndustryT = fetchCnsldtnIndustryT();
        }
        return toCnsldtnIndustryT;
    }

    /**
     * Retrieval of associated <b>CustomerSupplierIndustryText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnIndustryT</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerSupplierIndustry</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnIndustryT</b> is already loaded, the result will
     *         contain the <b>CustomerSupplierIndustryText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerSupplierIndustryText>> getCnsldtnIndustryTIfPresent()
    {
        return Option.of(toCnsldtnIndustryT);
    }

    /**
     * Overwrites the list of associated <b>CustomerSupplierIndustryText</b> entities for the loaded navigation property
     * <b>to_CnsldtnIndustryT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnIndustryT</b> of a queried <b>CustomerSupplierIndustry</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerSupplierIndustryText</b> entities.
     */
    public void setCnsldtnIndustryT( @Nonnull final List<CustomerSupplierIndustryText> value )
    {
        if( toCnsldtnIndustryT == null ) {
            toCnsldtnIndustryT = Lists.newArrayList();
        }
        toCnsldtnIndustryT.clear();
        toCnsldtnIndustryT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerSupplierIndustryText</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnIndustryT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnIndustryT</b> of a queried <b>CustomerSupplierIndustry</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerSupplierIndustryText</b> entities.
     */
    public void addCnsldtnIndustryT( CustomerSupplierIndustryText... entity )
    {
        if( toCnsldtnIndustryT == null ) {
            toCnsldtnIndustryT = Lists.newArrayList();
        }
        toCnsldtnIndustryT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CustomerSupplierIndustry instances.
     *
     */
    public final static class CustomerSupplierIndustryBuilder
    {

        private List<CustomerSupplierIndustryText> toCnsldtnIndustryT = Lists.newArrayList();

        private CustomerSupplierIndustry.CustomerSupplierIndustryBuilder toCnsldtnIndustryT(
            final List<CustomerSupplierIndustryText> value )
        {
            toCnsldtnIndustryT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnIndustryT</b> for <b>CustomerSupplierIndustry</b> to multiple
         * <b>CustomerSupplierIndustryText</b>.
         *
         * @param value
         *            The CustomerSupplierIndustryTexts to build this CustomerSupplierIndustry with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerSupplierIndustry.CustomerSupplierIndustryBuilder cnsldtnIndustryT(
            CustomerSupplierIndustryText... value )
        {
            return toCnsldtnIndustryT(Lists.newArrayList(value));
        }

    }

}
