/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CustomerSupplierIndustryTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CustomerSupplierIndustryTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CustomerSupplierIndustryTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Industry Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CustomerSupplierIndustryTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerSupplierIndustryText extends VdmEntity<CustomerSupplierIndustryText>
{

    /**
     * Selector for all available fields of CustomerSupplierIndustryText.
     *
     */
    public final static CustomerSupplierIndustryTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CustomerSupplierIndustryTextField<String> LANGUAGE =
        new CustomerSupplierIndustryTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Industry</b>
     * </p>
     *
     * @return Industry
     */
    @Key
    @SerializedName( "Industry" )
    @JsonProperty( "Industry" )
    @Nullable
    @ODataField( odataName = "Industry" )
    private String industry;
    /**
     * Use with available fluent helpers to apply the <b>Industry</b> field to query operations.
     *
     */
    public final static CustomerSupplierIndustryTextField<String> INDUSTRY =
        new CustomerSupplierIndustryTextField<String>("Industry");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierIndustryText</b>
     * </p>
     *
     * @return Customer/Supplier Industry Description
     */
    @SerializedName( "CustomerSupplierIndustryText" )
    @JsonProperty( "CustomerSupplierIndustryText" )
    @Nullable
    @ODataField( odataName = "CustomerSupplierIndustryText" )
    private String customerSupplierIndustryText;
    /**
     * Use with available fluent helpers to apply the <b>CustomerSupplierIndustryText</b> field to query operations.
     *
     */
    public final static CustomerSupplierIndustryTextField<String> CUSTOMER_SUPPLIER_INDUSTRY_TEXT =
        new CustomerSupplierIndustryTextField<String>("CustomerSupplierIndustryText");
    /**
     * Navigation property <b>to_CnsldtnIndustry</b> for <b>CustomerSupplierIndustryText</b> to single
     * <b>CustomerSupplierIndustry</b>.
     *
     */
    @SerializedName( "to_CnsldtnIndustry" )
    @JsonProperty( "to_CnsldtnIndustry" )
    @ODataField( odataName = "to_CnsldtnIndustry" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerSupplierIndustry toCnsldtnIndustry;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnIndustry</b> navigation property to query operations.
     *
     */
    public final static CustomerSupplierIndustryTextOneToOneLink<CustomerSupplierIndustry> TO_CNSLDTN_INDUSTRY =
        new CustomerSupplierIndustryTextOneToOneLink<CustomerSupplierIndustry>("to_CnsldtnIndustry");

    @Nonnull
    @Override
    public Class<CustomerSupplierIndustryText> getType()
    {
        return CustomerSupplierIndustryText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Industry</b>
     * </p>
     *
     * @param industry
     *            Industry
     */
    public void setIndustry( @Nullable final String industry )
    {
        rememberChangedField("Industry", this.industry);
        this.industry = industry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierIndustryText</b>
     * </p>
     *
     * @param customerSupplierIndustryText
     *            Customer/Supplier Industry Description
     */
    public void setCustomerSupplierIndustryText( @Nullable final String customerSupplierIndustryText )
    {
        rememberChangedField("CustomerSupplierIndustryText", this.customerSupplierIndustryText);
        this.customerSupplierIndustryText = customerSupplierIndustryText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CustomerSupplierIndustryText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("Industry", getIndustry());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("Industry", getIndustry());
        values.put("CustomerSupplierIndustryText", getCustomerSupplierIndustryText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Industry") ) {
                final Object value = values.remove("Industry");
                if( (value == null) || (!value.equals(getIndustry())) ) {
                    setIndustry(((String) value));
                }
            }
            if( values.containsKey("CustomerSupplierIndustryText") ) {
                final Object value = values.remove("CustomerSupplierIndustryText");
                if( (value == null) || (!value.equals(getCustomerSupplierIndustryText())) ) {
                    setCustomerSupplierIndustryText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnIndustry") ) {
                final Object value = (values).remove("to_CnsldtnIndustry");
                if( value instanceof Map ) {
                    if( toCnsldtnIndustry == null ) {
                        toCnsldtnIndustry = new CustomerSupplierIndustry();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnIndustry.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustomerSupplierIndustryTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CustomerSupplierIndustryTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerSupplierIndustryTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerSupplierIndustryTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnIndustry != null ) {
            (values).put("to_CnsldtnIndustry", toCnsldtnIndustry);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerSupplierIndustry</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnIndustry</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerSupplierIndustry</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerSupplierIndustry fetchCnsldtnIndustry()
    {
        return fetchFieldAsSingle("to_CnsldtnIndustry", CustomerSupplierIndustry.class);
    }

    /**
     * Retrieval of associated <b>CustomerSupplierIndustry</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnIndustry</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnIndustry</b> of a queried <b>CustomerSupplierIndustryText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerSupplierIndustry</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerSupplierIndustry getCnsldtnIndustryOrFetch()
    {
        if( toCnsldtnIndustry == null ) {
            toCnsldtnIndustry = fetchCnsldtnIndustry();
        }
        return toCnsldtnIndustry;
    }

    /**
     * Retrieval of associated <b>CustomerSupplierIndustry</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnIndustry</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerSupplierIndustryText</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnIndustry</b> is already loaded, the result will
     *         contain the <b>CustomerSupplierIndustry</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerSupplierIndustry> getCnsldtnIndustryIfPresent()
    {
        return Option.of(toCnsldtnIndustry);
    }

    /**
     * Overwrites the associated <b>CustomerSupplierIndustry</b> entity for the loaded navigation property
     * <b>to_CnsldtnIndustry</b>.
     *
     * @param value
     *            New <b>CustomerSupplierIndustry</b> entity.
     */
    public void setCnsldtnIndustry( final CustomerSupplierIndustry value )
    {
        toCnsldtnIndustry = value;
    }

    /**
     * Helper class to allow for fluent creation of CustomerSupplierIndustryText instances.
     *
     */
    public final static class CustomerSupplierIndustryTextBuilder
    {

        private CustomerSupplierIndustry toCnsldtnIndustry;

        private CustomerSupplierIndustryText.CustomerSupplierIndustryTextBuilder toCnsldtnIndustry(
            final CustomerSupplierIndustry value )
        {
            toCnsldtnIndustry = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnIndustry</b> for <b>CustomerSupplierIndustryText</b> to single
         * <b>CustomerSupplierIndustry</b>.
         *
         * @param value
         *            The CustomerSupplierIndustry to build this CustomerSupplierIndustryText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerSupplierIndustryText.CustomerSupplierIndustryTextBuilder cnsldtnIndustry(
            final CustomerSupplierIndustry value )
        {
            return toCnsldtnIndustry(value);
        }

    }

}
