/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CustomerTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CustomerTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.CustomerTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Customer Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CustomerTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerText extends VdmEntity<CustomerText>
{

    /**
     * Selector for all available fields of CustomerText.
     *
     */
    public final static CustomerTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CustomerTextField<String> LANGUAGE = new CustomerTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Consolidation Customer
     */
    @Key
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static CustomerTextField<String> CUSTOMER = new CustomerTextField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnCustomerText</b>
     * </p>
     *
     * @return Customer Description
     */
    @SerializedName( "CnsldtnCustomerText" )
    @JsonProperty( "CnsldtnCustomerText" )
    @Nullable
    @ODataField( odataName = "CnsldtnCustomerText" )
    private String cnsldtnCustomerText;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnCustomerText</b> field to query operations.
     *
     */
    public final static CustomerTextField<String> CNSLDTN_CUSTOMER_TEXT =
        new CustomerTextField<String>("CnsldtnCustomerText");
    /**
     * Navigation property <b>to_CnsldtnCustomer</b> for <b>CustomerText</b> to single <b>Customer</b>.
     *
     */
    @SerializedName( "to_CnsldtnCustomer" )
    @JsonProperty( "to_CnsldtnCustomer" )
    @ODataField( odataName = "to_CnsldtnCustomer" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Customer toCnsldtnCustomer;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnCustomer</b> navigation property to query operations.
     *
     */
    public final static CustomerTextOneToOneLink<Customer> TO_CNSLDTN_CUSTOMER =
        new CustomerTextOneToOneLink<Customer>("to_CnsldtnCustomer");

    @Nonnull
    @Override
    public Class<CustomerText> getType()
    {
        return CustomerText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Consolidation Customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnCustomerText</b>
     * </p>
     *
     * @param cnsldtnCustomerText
     *            Customer Description
     */
    public void setCnsldtnCustomerText( @Nullable final String cnsldtnCustomerText )
    {
        rememberChangedField("CnsldtnCustomerText", this.cnsldtnCustomerText);
        this.cnsldtnCustomerText = cnsldtnCustomerText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CustomerText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("Customer", getCustomer());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("Customer", getCustomer());
        values.put("CnsldtnCustomerText", getCnsldtnCustomerText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("CnsldtnCustomerText") ) {
                final Object value = values.remove("CnsldtnCustomerText");
                if( (value == null) || (!value.equals(getCnsldtnCustomerText())) ) {
                    setCnsldtnCustomerText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnCustomer") ) {
                final Object value = (values).remove("to_CnsldtnCustomer");
                if( value instanceof Map ) {
                    if( toCnsldtnCustomer == null ) {
                        toCnsldtnCustomer = new Customer();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnCustomer.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustomerTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnCustomer != null ) {
            (values).put("to_CnsldtnCustomer", toCnsldtnCustomer);
        }
        return values;
    }

    /**
     * Fetches the <b>Customer</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnCustomer</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Customer</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Customer fetchCnsldtnCustomer()
    {
        return fetchFieldAsSingle("to_CnsldtnCustomer", Customer.class);
    }

    /**
     * Retrieval of associated <b>Customer</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnCustomer</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnCustomer</b> of a queried <b>CustomerText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Customer</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Customer getCnsldtnCustomerOrFetch()
    {
        if( toCnsldtnCustomer == null ) {
            toCnsldtnCustomer = fetchCnsldtnCustomer();
        }
        return toCnsldtnCustomer;
    }

    /**
     * Retrieval of associated <b>Customer</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnCustomer</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnCustomer</b> is already loaded, the result will
     *         contain the <b>Customer</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<Customer> getCnsldtnCustomerIfPresent()
    {
        return Option.of(toCnsldtnCustomer);
    }

    /**
     * Overwrites the associated <b>Customer</b> entity for the loaded navigation property <b>to_CnsldtnCustomer</b>.
     *
     * @param value
     *            New <b>Customer</b> entity.
     */
    public void setCnsldtnCustomer( final Customer value )
    {
        toCnsldtnCustomer = value;
    }

    /**
     * Helper class to allow for fluent creation of CustomerText instances.
     *
     */
    public final static class CustomerTextBuilder
    {

        private Customer toCnsldtnCustomer;

        private CustomerText.CustomerTextBuilder toCnsldtnCustomer( final Customer value )
        {
            toCnsldtnCustomer = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnCustomer</b> for <b>CustomerText</b> to single <b>Customer</b>.
         *
         * @param value
         *            The Customer to build this CustomerText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerText.CustomerTextBuilder cnsldtnCustomer( final Customer value )
        {
            return toCnsldtnCustomer(value);
        }

    }

}
