/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.DistributionChannelField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.DistributionChannelLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.DistributionChannelSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Distribution Channel
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>DistributionChannelType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DistributionChannel extends VdmEntity<DistributionChannel>
{

    /**
     * Selector for all available fields of DistributionChannel.
     *
     */
    public final static DistributionChannelSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @Key
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static DistributionChannelField<String> DISTRIBUTION_CHANNEL =
        new DistributionChannelField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel_Text</b>
     * </p>
     *
     * @return Distribution Channel Description
     */
    @SerializedName( "DistributionChannel_Text" )
    @JsonProperty( "DistributionChannel_Text" )
    @Nullable
    @ODataField( odataName = "DistributionChannel_Text" )
    private String distributionChannel_Text;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel_Text</b> field to query operations.
     *
     */
    public final static DistributionChannelField<String> DISTRIBUTION_CHANNEL_TEXT =
        new DistributionChannelField<String>("DistributionChannel_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static DistributionChannelField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new DistributionChannelField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnDistributionChnlT</b> for <b>DistributionChannel</b> to multiple
     * <b>DistributionChannelText</b>.
     *
     */
    @SerializedName( "to_CnsldtnDistributionChnlT" )
    @JsonProperty( "to_CnsldtnDistributionChnlT" )
    @ODataField( odataName = "to_CnsldtnDistributionChnlT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DistributionChannelText> toCnsldtnDistributionChnlT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnDistributionChnlT</b> navigation property to query
     * operations.
     *
     */
    public final static DistributionChannelLink<DistributionChannelText> TO_CNSLDTN_DISTRIBUTION_CHNL_T =
        new DistributionChannelLink<DistributionChannelText>("to_CnsldtnDistributionChnlT");

    @Nonnull
    @Override
    public Class<DistributionChannel> getType()
    {
        return DistributionChannel.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel_Text</b>
     * </p>
     *
     * @param distributionChannel_Text
     *            Distribution Channel Description
     */
    public void setDistributionChannel_Text( @Nullable final String distributionChannel_Text )
    {
        rememberChangedField("DistributionChannel_Text", this.distributionChannel_Text);
        this.distributionChannel_Text = distributionChannel_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "DistributionChannel";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DistributionChannel", getDistributionChannel());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DistributionChannel", getDistributionChannel());
        values.put("DistributionChannel_Text", getDistributionChannel_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel_Text") ) {
                final Object value = values.remove("DistributionChannel_Text");
                if( (value == null) || (!value.equals(getDistributionChannel_Text())) ) {
                    setDistributionChannel_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnDistributionChnlT") ) {
                final Object value = (values).remove("to_CnsldtnDistributionChnlT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnDistributionChnlT == null ) {
                        toCnsldtnDistributionChnlT = Lists.newArrayList();
                    } else {
                        toCnsldtnDistributionChnlT = Lists.newArrayList(toCnsldtnDistributionChnlT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DistributionChannelText entity;
                        if( toCnsldtnDistributionChnlT.size() > i ) {
                            entity = toCnsldtnDistributionChnlT.get(i);
                        } else {
                            entity = new DistributionChannelText();
                            toCnsldtnDistributionChnlT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DistributionChannelField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DistributionChannelField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DistributionChannelField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DistributionChannelField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnDistributionChnlT != null ) {
            (values).put("to_CnsldtnDistributionChnlT", toCnsldtnDistributionChnlT);
        }
        return values;
    }

    /**
     * Fetches the <b>DistributionChannelText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnDistributionChnlT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DistributionChannelText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DistributionChannelText> fetchCnsldtnDistributionChnlT()
    {
        return fetchFieldAsList("to_CnsldtnDistributionChnlT", DistributionChannelText.class);
    }

    /**
     * Retrieval of associated <b>DistributionChannelText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnDistributionChnlT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDistributionChnlT</b> of a queried <b>DistributionChannel</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DistributionChannelText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DistributionChannelText> getCnsldtnDistributionChnlTOrFetch()
    {
        if( toCnsldtnDistributionChnlT == null ) {
            toCnsldtnDistributionChnlT = fetchCnsldtnDistributionChnlT();
        }
        return toCnsldtnDistributionChnlT;
    }

    /**
     * Retrieval of associated <b>DistributionChannelText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnDistributionChnlT</b>.
     * <p>
     * If the navigation property for an entity <b>DistributionChannel</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnDistributionChnlT</b> is already loaded, the
     *         result will contain the <b>DistributionChannelText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DistributionChannelText>> getCnsldtnDistributionChnlTIfPresent()
    {
        return Option.of(toCnsldtnDistributionChnlT);
    }

    /**
     * Overwrites the list of associated <b>DistributionChannelText</b> entities for the loaded navigation property
     * <b>to_CnsldtnDistributionChnlT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDistributionChnlT</b> of a queried <b>DistributionChannel</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DistributionChannelText</b> entities.
     */
    public void setCnsldtnDistributionChnlT( @Nonnull final List<DistributionChannelText> value )
    {
        if( toCnsldtnDistributionChnlT == null ) {
            toCnsldtnDistributionChnlT = Lists.newArrayList();
        }
        toCnsldtnDistributionChnlT.clear();
        toCnsldtnDistributionChnlT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DistributionChannelText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnDistributionChnlT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDistributionChnlT</b> of a queried <b>DistributionChannel</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DistributionChannelText</b> entities.
     */
    public void addCnsldtnDistributionChnlT( DistributionChannelText... entity )
    {
        if( toCnsldtnDistributionChnlT == null ) {
            toCnsldtnDistributionChnlT = Lists.newArrayList();
        }
        toCnsldtnDistributionChnlT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of DistributionChannel instances.
     *
     */
    public final static class DistributionChannelBuilder
    {

        private List<DistributionChannelText> toCnsldtnDistributionChnlT = Lists.newArrayList();

        private DistributionChannel.DistributionChannelBuilder toCnsldtnDistributionChnlT(
            final List<DistributionChannelText> value )
        {
            toCnsldtnDistributionChnlT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnDistributionChnlT</b> for <b>DistributionChannel</b> to multiple
         * <b>DistributionChannelText</b>.
         *
         * @param value
         *            The DistributionChannelTexts to build this DistributionChannel with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DistributionChannel.DistributionChannelBuilder cnsldtnDistributionChnlT(
            DistributionChannelText... value )
        {
            return toCnsldtnDistributionChnlT(Lists.newArrayList(value));
        }

    }

}
