/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.DistributionChannelTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.DistributionChannelTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.DistributionChannelTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Distribution Channel Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>DistributionChannelTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DistributionChannelText extends VdmEntity<DistributionChannelText>
{

    /**
     * Selector for all available fields of DistributionChannelText.
     *
     */
    public final static DistributionChannelTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static DistributionChannelTextField<String> LANGUAGE =
        new DistributionChannelTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @Key
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static DistributionChannelTextField<String> DISTRIBUTION_CHANNEL =
        new DistributionChannelTextField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannelText</b>
     * </p>
     *
     * @return Distribution Channel Description
     */
    @SerializedName( "DistributionChannelText" )
    @JsonProperty( "DistributionChannelText" )
    @Nullable
    @ODataField( odataName = "DistributionChannelText" )
    private String distributionChannelText;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannelText</b> field to query operations.
     *
     */
    public final static DistributionChannelTextField<String> DISTRIBUTION_CHANNEL_TEXT =
        new DistributionChannelTextField<String>("DistributionChannelText");
    /**
     * Navigation property <b>to_CnsldtnDistributionChannel</b> for <b>DistributionChannelText</b> to single
     * <b>DistributionChannel</b>.
     *
     */
    @SerializedName( "to_CnsldtnDistributionChannel" )
    @JsonProperty( "to_CnsldtnDistributionChannel" )
    @ODataField( odataName = "to_CnsldtnDistributionChannel" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DistributionChannel toCnsldtnDistributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnDistributionChannel</b> navigation property to query
     * operations.
     *
     */
    public final static DistributionChannelTextOneToOneLink<DistributionChannel> TO_CNSLDTN_DISTRIBUTION_CHANNEL =
        new DistributionChannelTextOneToOneLink<DistributionChannel>("to_CnsldtnDistributionChannel");

    @Nonnull
    @Override
    public Class<DistributionChannelText> getType()
    {
        return DistributionChannelText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannelText</b>
     * </p>
     *
     * @param distributionChannelText
     *            Distribution Channel Description
     */
    public void setDistributionChannelText( @Nullable final String distributionChannelText )
    {
        rememberChangedField("DistributionChannelText", this.distributionChannelText);
        this.distributionChannelText = distributionChannelText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "DistributionChannelText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("DistributionChannel", getDistributionChannel());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("DistributionChannelText", getDistributionChannelText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("DistributionChannelText") ) {
                final Object value = values.remove("DistributionChannelText");
                if( (value == null) || (!value.equals(getDistributionChannelText())) ) {
                    setDistributionChannelText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnDistributionChannel") ) {
                final Object value = (values).remove("to_CnsldtnDistributionChannel");
                if( value instanceof Map ) {
                    if( toCnsldtnDistributionChannel == null ) {
                        toCnsldtnDistributionChannel = new DistributionChannel();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnDistributionChannel.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DistributionChannelTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DistributionChannelTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DistributionChannelTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DistributionChannelTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnDistributionChannel != null ) {
            (values).put("to_CnsldtnDistributionChannel", toCnsldtnDistributionChannel);
        }
        return values;
    }

    /**
     * Fetches the <b>DistributionChannel</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnDistributionChannel</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>DistributionChannel</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DistributionChannel fetchCnsldtnDistributionChannel()
    {
        return fetchFieldAsSingle("to_CnsldtnDistributionChannel", DistributionChannel.class);
    }

    /**
     * Retrieval of associated <b>DistributionChannel</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnDistributionChannel</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDistributionChannel</b> of a queried <b>DistributionChannelText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DistributionChannel</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DistributionChannel getCnsldtnDistributionChannelOrFetch()
    {
        if( toCnsldtnDistributionChannel == null ) {
            toCnsldtnDistributionChannel = fetchCnsldtnDistributionChannel();
        }
        return toCnsldtnDistributionChannel;
    }

    /**
     * Retrieval of associated <b>DistributionChannel</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnDistributionChannel</b>.
     * <p>
     * If the navigation property for an entity <b>DistributionChannelText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnDistributionChannel</b> is already loaded, the
     *         result will contain the <b>DistributionChannel</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<DistributionChannel> getCnsldtnDistributionChannelIfPresent()
    {
        return Option.of(toCnsldtnDistributionChannel);
    }

    /**
     * Overwrites the associated <b>DistributionChannel</b> entity for the loaded navigation property
     * <b>to_CnsldtnDistributionChannel</b>.
     *
     * @param value
     *            New <b>DistributionChannel</b> entity.
     */
    public void setCnsldtnDistributionChannel( final DistributionChannel value )
    {
        toCnsldtnDistributionChannel = value;
    }

    /**
     * Helper class to allow for fluent creation of DistributionChannelText instances.
     *
     */
    public final static class DistributionChannelTextBuilder
    {

        private DistributionChannel toCnsldtnDistributionChannel;

        private DistributionChannelText.DistributionChannelTextBuilder toCnsldtnDistributionChannel(
            final DistributionChannel value )
        {
            toCnsldtnDistributionChannel = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnDistributionChannel</b> for <b>DistributionChannelText</b> to single
         * <b>DistributionChannel</b>.
         *
         * @param value
         *            The DistributionChannel to build this DistributionChannelText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DistributionChannelText.DistributionChannelTextBuilder cnsldtnDistributionChannel(
            final DistributionChannel value )
        {
            return toCnsldtnDistributionChannel(value);
        }

    }

}
