/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.DocumentTypeHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.DocumentTypeHierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.DocumentTypeHierOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.DocumentTypeHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Document Type Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>DocumentTypeHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DocumentTypeHier extends VdmEntity<DocumentTypeHier>
{

    /**
     * Selector for all available fields of DocumentTypeHier.
     *
     */
    public final static DocumentTypeHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocTypeHierarchy</b>
     * </p>
     *
     * @return Hierarchy ID
     */
    @Key
    @SerializedName( "ConsolidationDocTypeHierarchy" )
    @JsonProperty( "ConsolidationDocTypeHierarchy" )
    @Nullable
    @ODataField( odataName = "ConsolidationDocTypeHierarchy" )
    private String consolidationDocTypeHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationDocTypeHierarchy</b> field to query operations.
     *
     */
    public final static DocumentTypeHierField<String> CONSOLIDATION_DOC_TYPE_HIERARCHY =
        new DocumentTypeHierField<String>("ConsolidationDocTypeHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Hierarchy node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static DocumentTypeHierField<String> HIERARCHY_NODE =
        new DocumentTypeHierField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Hierarchy node description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static DocumentTypeHierField<String> HIERARCHY_NODE_TEXT =
        new DocumentTypeHierField<String>("HierarchyNode_Text");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid To Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static DocumentTypeHierField<LocalDateTime> VALIDITY_END_DATE =
        new DocumentTypeHierField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static DocumentTypeHierField<LocalDateTime> VALIDITY_START_DATE =
        new DocumentTypeHierField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Hierarchy parent node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static DocumentTypeHierField<String> PARENT_NODE = new DocumentTypeHierField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "ConsolidationDocumentType" )
    @JsonProperty( "ConsolidationDocumentType" )
    @Nullable
    @ODataField( odataName = "ConsolidationDocumentType" )
    private String consolidationDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationDocumentType</b> field to query operations.
     *
     */
    public final static DocumentTypeHierField<String> CONSOLIDATION_DOCUMENT_TYPE =
        new DocumentTypeHierField<String>("ConsolidationDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentType_Text</b>
     * </p>
     *
     * @return Document Type Description
     */
    @SerializedName( "ConsolidationDocumentType_Text" )
    @JsonProperty( "ConsolidationDocumentType_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationDocumentType_Text" )
    private String consolidationDocumentType_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationDocumentType_Text</b> field to query operations.
     *
     */
    public final static DocumentTypeHierField<String> CONSOLIDATION_DOCUMENT_TYPE_TEXT =
        new DocumentTypeHierField<String>("ConsolidationDocumentType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return Hierarchy Sequence Number
     */
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static DocumentTypeHierField<String> SEQUENCE_NUMBER =
        new DocumentTypeHierField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static DocumentTypeHierField<String> HIERARCHY_NODE_LEVEL =
        new DocumentTypeHierField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Hierarchy node type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static DocumentTypeHierField<String> NODE_TYPE = new DocumentTypeHierField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnDocumentType</b> for <b>DocumentTypeHier</b> to single
     * <b>ConsolidationDocumentType</b>.
     *
     */
    @SerializedName( "to_CnsldtnDocumentType" )
    @JsonProperty( "to_CnsldtnDocumentType" )
    @ODataField( odataName = "to_CnsldtnDocumentType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConsolidationDocumentType toCnsldtnDocumentType;
    /**
     * Navigation property <b>to_CnsldtnDocumentTypeHierT</b> for <b>DocumentTypeHier</b> to multiple
     * <b>DocumentTypeHierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnDocumentTypeHierT" )
    @JsonProperty( "to_CnsldtnDocumentTypeHierT" )
    @ODataField( odataName = "to_CnsldtnDocumentTypeHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DocumentTypeHierText> toCnsldtnDocumentTypeHierT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnDocumentType</b> navigation property to query
     * operations.
     *
     */
    public final static DocumentTypeHierOneToOneLink<ConsolidationDocumentType> TO_CNSLDTN_DOCUMENT_TYPE =
        new DocumentTypeHierOneToOneLink<ConsolidationDocumentType>("to_CnsldtnDocumentType");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnDocumentTypeHierT</b> navigation property to query
     * operations.
     *
     */
    public final static DocumentTypeHierLink<DocumentTypeHierText> TO_CNSLDTN_DOCUMENT_TYPE_HIER_T =
        new DocumentTypeHierLink<DocumentTypeHierText>("to_CnsldtnDocumentTypeHierT");

    @Nonnull
    @Override
    public Class<DocumentTypeHier> getType()
    {
        return DocumentTypeHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocTypeHierarchy</b>
     * </p>
     *
     * @param consolidationDocTypeHierarchy
     *            Hierarchy ID
     */
    public void setConsolidationDocTypeHierarchy( @Nullable final String consolidationDocTypeHierarchy )
    {
        rememberChangedField("ConsolidationDocTypeHierarchy", this.consolidationDocTypeHierarchy);
        this.consolidationDocTypeHierarchy = consolidationDocTypeHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Hierarchy node description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Hierarchy parent node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentType</b>
     * </p>
     *
     * @param consolidationDocumentType
     *            Document Type
     */
    public void setConsolidationDocumentType( @Nullable final String consolidationDocumentType )
    {
        rememberChangedField("ConsolidationDocumentType", this.consolidationDocumentType);
        this.consolidationDocumentType = consolidationDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentType_Text</b>
     * </p>
     *
     * @param consolidationDocumentType_Text
     *            Document Type Description
     */
    public void setConsolidationDocumentType_Text( @Nullable final String consolidationDocumentType_Text )
    {
        rememberChangedField("ConsolidationDocumentType_Text", this.consolidationDocumentType_Text);
        this.consolidationDocumentType_Text = consolidationDocumentType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            Hierarchy Sequence Number
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "DocumentTypeHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationDocTypeHierarchy", getConsolidationDocTypeHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationDocTypeHierarchy", getConsolidationDocTypeHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ParentNode", getParentNode());
        values.put("ConsolidationDocumentType", getConsolidationDocumentType());
        values.put("ConsolidationDocumentType_Text", getConsolidationDocumentType_Text());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationDocTypeHierarchy") ) {
                final Object value = values.remove("ConsolidationDocTypeHierarchy");
                if( (value == null) || (!value.equals(getConsolidationDocTypeHierarchy())) ) {
                    setConsolidationDocTypeHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("ConsolidationDocumentType") ) {
                final Object value = values.remove("ConsolidationDocumentType");
                if( (value == null) || (!value.equals(getConsolidationDocumentType())) ) {
                    setConsolidationDocumentType(((String) value));
                }
            }
            if( values.containsKey("ConsolidationDocumentType_Text") ) {
                final Object value = values.remove("ConsolidationDocumentType_Text");
                if( (value == null) || (!value.equals(getConsolidationDocumentType_Text())) ) {
                    setConsolidationDocumentType_Text(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnDocumentType") ) {
                final Object value = (values).remove("to_CnsldtnDocumentType");
                if( value instanceof Map ) {
                    if( toCnsldtnDocumentType == null ) {
                        toCnsldtnDocumentType = new ConsolidationDocumentType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnDocumentType.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnDocumentTypeHierT") ) {
                final Object value = (values).remove("to_CnsldtnDocumentTypeHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnDocumentTypeHierT == null ) {
                        toCnsldtnDocumentTypeHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnDocumentTypeHierT = Lists.newArrayList(toCnsldtnDocumentTypeHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DocumentTypeHierText entity;
                        if( toCnsldtnDocumentTypeHierT.size() > i ) {
                            entity = toCnsldtnDocumentTypeHierT.get(i);
                        } else {
                            entity = new DocumentTypeHierText();
                            toCnsldtnDocumentTypeHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DocumentTypeHierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DocumentTypeHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DocumentTypeHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DocumentTypeHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnDocumentType != null ) {
            (values).put("to_CnsldtnDocumentType", toCnsldtnDocumentType);
        }
        if( toCnsldtnDocumentTypeHierT != null ) {
            (values).put("to_CnsldtnDocumentTypeHierT", toCnsldtnDocumentTypeHierT);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationDocumentType</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnDocumentType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ConsolidationDocumentType</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationDocumentType fetchCnsldtnDocumentType()
    {
        return fetchFieldAsSingle("to_CnsldtnDocumentType", ConsolidationDocumentType.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationDocumentType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnDocumentType</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDocumentType</b> of a queried <b>DocumentTypeHier</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationDocumentType</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationDocumentType getCnsldtnDocumentTypeOrFetch()
    {
        if( toCnsldtnDocumentType == null ) {
            toCnsldtnDocumentType = fetchCnsldtnDocumentType();
        }
        return toCnsldtnDocumentType;
    }

    /**
     * Retrieval of associated <b>ConsolidationDocumentType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnDocumentType</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentTypeHier</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnDocumentType</b> is already loaded, the result
     *         will contain the <b>ConsolidationDocumentType</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConsolidationDocumentType> getCnsldtnDocumentTypeIfPresent()
    {
        return Option.of(toCnsldtnDocumentType);
    }

    /**
     * Overwrites the associated <b>ConsolidationDocumentType</b> entity for the loaded navigation property
     * <b>to_CnsldtnDocumentType</b>.
     *
     * @param value
     *            New <b>ConsolidationDocumentType</b> entity.
     */
    public void setCnsldtnDocumentType( final ConsolidationDocumentType value )
    {
        toCnsldtnDocumentType = value;
    }

    /**
     * Fetches the <b>DocumentTypeHierText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnDocumentTypeHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DocumentTypeHierText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocumentTypeHierText> fetchCnsldtnDocumentTypeHierT()
    {
        return fetchFieldAsList("to_CnsldtnDocumentTypeHierT", DocumentTypeHierText.class);
    }

    /**
     * Retrieval of associated <b>DocumentTypeHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnDocumentTypeHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDocumentTypeHierT</b> of a queried <b>DocumentTypeHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DocumentTypeHierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocumentTypeHierText> getCnsldtnDocumentTypeHierTOrFetch()
    {
        if( toCnsldtnDocumentTypeHierT == null ) {
            toCnsldtnDocumentTypeHierT = fetchCnsldtnDocumentTypeHierT();
        }
        return toCnsldtnDocumentTypeHierT;
    }

    /**
     * Retrieval of associated <b>DocumentTypeHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnDocumentTypeHierT</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentTypeHier</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnDocumentTypeHierT</b> is already loaded, the
     *         result will contain the <b>DocumentTypeHierText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DocumentTypeHierText>> getCnsldtnDocumentTypeHierTIfPresent()
    {
        return Option.of(toCnsldtnDocumentTypeHierT);
    }

    /**
     * Overwrites the list of associated <b>DocumentTypeHierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnDocumentTypeHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDocumentTypeHierT</b> of a queried <b>DocumentTypeHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DocumentTypeHierText</b> entities.
     */
    public void setCnsldtnDocumentTypeHierT( @Nonnull final List<DocumentTypeHierText> value )
    {
        if( toCnsldtnDocumentTypeHierT == null ) {
            toCnsldtnDocumentTypeHierT = Lists.newArrayList();
        }
        toCnsldtnDocumentTypeHierT.clear();
        toCnsldtnDocumentTypeHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DocumentTypeHierText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnDocumentTypeHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDocumentTypeHierT</b> of a queried <b>DocumentTypeHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DocumentTypeHierText</b> entities.
     */
    public void addCnsldtnDocumentTypeHierT( DocumentTypeHierText... entity )
    {
        if( toCnsldtnDocumentTypeHierT == null ) {
            toCnsldtnDocumentTypeHierT = Lists.newArrayList();
        }
        toCnsldtnDocumentTypeHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of DocumentTypeHier instances.
     *
     */
    public final static class DocumentTypeHierBuilder
    {

        private ConsolidationDocumentType toCnsldtnDocumentType;
        private List<DocumentTypeHierText> toCnsldtnDocumentTypeHierT = Lists.newArrayList();

        private DocumentTypeHier.DocumentTypeHierBuilder toCnsldtnDocumentType( final ConsolidationDocumentType value )
        {
            toCnsldtnDocumentType = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnDocumentType</b> for <b>DocumentTypeHier</b> to single
         * <b>ConsolidationDocumentType</b>.
         *
         * @param value
         *            The ConsolidationDocumentType to build this DocumentTypeHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentTypeHier.DocumentTypeHierBuilder cnsldtnDocumentType( final ConsolidationDocumentType value )
        {
            return toCnsldtnDocumentType(value);
        }

        private DocumentTypeHier.DocumentTypeHierBuilder toCnsldtnDocumentTypeHierT(
            final List<DocumentTypeHierText> value )
        {
            toCnsldtnDocumentTypeHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnDocumentTypeHierT</b> for <b>DocumentTypeHier</b> to multiple
         * <b>DocumentTypeHierText</b>.
         *
         * @param value
         *            The DocumentTypeHierTexts to build this DocumentTypeHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentTypeHier.DocumentTypeHierBuilder cnsldtnDocumentTypeHierT( DocumentTypeHierText... value )
        {
            return toCnsldtnDocumentTypeHierT(Lists.newArrayList(value));
        }

    }

}
