/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.DocumentTypeHierTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.DocumentTypeHierTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.DocumentTypeHierTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Doc Type HierNode - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>DocumentTypeHierTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DocumentTypeHierText extends VdmEntity<DocumentTypeHierText>
{

    /**
     * Selector for all available fields of DocumentTypeHierText.
     *
     */
    public final static DocumentTypeHierTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static DocumentTypeHierTextField<String> LANGUAGE = new DocumentTypeHierTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocTypeHierarchy</b>
     * </p>
     *
     * @return Hierarchy ID
     */
    @Key
    @SerializedName( "ConsolidationDocTypeHierarchy" )
    @JsonProperty( "ConsolidationDocTypeHierarchy" )
    @Nullable
    @ODataField( odataName = "ConsolidationDocTypeHierarchy" )
    private String consolidationDocTypeHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationDocTypeHierarchy</b> field to query operations.
     *
     */
    public final static DocumentTypeHierTextField<String> CONSOLIDATION_DOC_TYPE_HIERARCHY =
        new DocumentTypeHierTextField<String>("ConsolidationDocTypeHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Hierarchy node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static DocumentTypeHierTextField<String> HIERARCHY_NODE =
        new DocumentTypeHierTextField<String>("HierarchyNode");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid To Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static DocumentTypeHierTextField<LocalDateTime> VALIDITY_END_DATE =
        new DocumentTypeHierTextField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static DocumentTypeHierTextField<LocalDateTime> VALIDITY_START_DATE =
        new DocumentTypeHierTextField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeText</b>
     * </p>
     *
     * @return Hierarchy node description
     */
    @SerializedName( "HierarchyNodeText" )
    @JsonProperty( "HierarchyNodeText" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeText" )
    private String hierarchyNodeText;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeText</b> field to query operations.
     *
     */
    public final static DocumentTypeHierTextField<String> HIERARCHY_NODE_TEXT =
        new DocumentTypeHierTextField<String>("HierarchyNodeText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Hierarchy node type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static DocumentTypeHierTextField<String> NODE_TYPE = new DocumentTypeHierTextField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnDocumentTypeHier</b> for <b>DocumentTypeHierText</b> to single
     * <b>DocumentTypeHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnDocumentTypeHier" )
    @JsonProperty( "to_CnsldtnDocumentTypeHier" )
    @ODataField( odataName = "to_CnsldtnDocumentTypeHier" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DocumentTypeHier toCnsldtnDocumentTypeHier;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnDocumentTypeHier</b> navigation property to query
     * operations.
     *
     */
    public final static DocumentTypeHierTextOneToOneLink<DocumentTypeHier> TO_CNSLDTN_DOCUMENT_TYPE_HIER =
        new DocumentTypeHierTextOneToOneLink<DocumentTypeHier>("to_CnsldtnDocumentTypeHier");

    @Nonnull
    @Override
    public Class<DocumentTypeHierText> getType()
    {
        return DocumentTypeHierText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocTypeHierarchy</b>
     * </p>
     *
     * @param consolidationDocTypeHierarchy
     *            Hierarchy ID
     */
    public void setConsolidationDocTypeHierarchy( @Nullable final String consolidationDocTypeHierarchy )
    {
        rememberChangedField("ConsolidationDocTypeHierarchy", this.consolidationDocTypeHierarchy);
        this.consolidationDocTypeHierarchy = consolidationDocTypeHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeText</b>
     * </p>
     *
     * @param hierarchyNodeText
     *            Hierarchy node description
     */
    public void setHierarchyNodeText( @Nullable final String hierarchyNodeText )
    {
        rememberChangedField("HierarchyNodeText", this.hierarchyNodeText);
        this.hierarchyNodeText = hierarchyNodeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "DocumentTypeHierText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("ConsolidationDocTypeHierarchy", getConsolidationDocTypeHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ConsolidationDocTypeHierarchy", getConsolidationDocTypeHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("HierarchyNodeText", getHierarchyNodeText());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationDocTypeHierarchy") ) {
                final Object value = values.remove("ConsolidationDocTypeHierarchy");
                if( (value == null) || (!value.equals(getConsolidationDocTypeHierarchy())) ) {
                    setConsolidationDocTypeHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("HierarchyNodeText") ) {
                final Object value = values.remove("HierarchyNodeText");
                if( (value == null) || (!value.equals(getHierarchyNodeText())) ) {
                    setHierarchyNodeText(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnDocumentTypeHier") ) {
                final Object value = (values).remove("to_CnsldtnDocumentTypeHier");
                if( value instanceof Map ) {
                    if( toCnsldtnDocumentTypeHier == null ) {
                        toCnsldtnDocumentTypeHier = new DocumentTypeHier();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnDocumentTypeHier.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DocumentTypeHierTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DocumentTypeHierTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DocumentTypeHierTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DocumentTypeHierTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnDocumentTypeHier != null ) {
            (values).put("to_CnsldtnDocumentTypeHier", toCnsldtnDocumentTypeHier);
        }
        return values;
    }

    /**
     * Fetches the <b>DocumentTypeHier</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnDocumentTypeHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>DocumentTypeHier</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DocumentTypeHier fetchCnsldtnDocumentTypeHier()
    {
        return fetchFieldAsSingle("to_CnsldtnDocumentTypeHier", DocumentTypeHier.class);
    }

    /**
     * Retrieval of associated <b>DocumentTypeHier</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnDocumentTypeHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDocumentTypeHier</b> of a queried <b>DocumentTypeHierText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DocumentTypeHier</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DocumentTypeHier getCnsldtnDocumentTypeHierOrFetch()
    {
        if( toCnsldtnDocumentTypeHier == null ) {
            toCnsldtnDocumentTypeHier = fetchCnsldtnDocumentTypeHier();
        }
        return toCnsldtnDocumentTypeHier;
    }

    /**
     * Retrieval of associated <b>DocumentTypeHier</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnDocumentTypeHier</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentTypeHierText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnDocumentTypeHier</b> is already loaded, the
     *         result will contain the <b>DocumentTypeHier</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<DocumentTypeHier> getCnsldtnDocumentTypeHierIfPresent()
    {
        return Option.of(toCnsldtnDocumentTypeHier);
    }

    /**
     * Overwrites the associated <b>DocumentTypeHier</b> entity for the loaded navigation property
     * <b>to_CnsldtnDocumentTypeHier</b>.
     *
     * @param value
     *            New <b>DocumentTypeHier</b> entity.
     */
    public void setCnsldtnDocumentTypeHier( final DocumentTypeHier value )
    {
        toCnsldtnDocumentTypeHier = value;
    }

    /**
     * Helper class to allow for fluent creation of DocumentTypeHierText instances.
     *
     */
    public final static class DocumentTypeHierTextBuilder
    {

        private DocumentTypeHier toCnsldtnDocumentTypeHier;

        private DocumentTypeHierText.DocumentTypeHierTextBuilder toCnsldtnDocumentTypeHier(
            final DocumentTypeHier value )
        {
            toCnsldtnDocumentTypeHier = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnDocumentTypeHier</b> for <b>DocumentTypeHierText</b> to single
         * <b>DocumentTypeHier</b>.
         *
         * @param value
         *            The DocumentTypeHier to build this DocumentTypeHierText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentTypeHierText.DocumentTypeHierTextBuilder cnsldtnDocumentTypeHier( final DocumentTypeHier value )
        {
            return toCnsldtnDocumentTypeHier(value);
        }

    }

}
