/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.DocumentTypeHierTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.DocumentTypeHierText
 * DocumentTypeHierText} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class DocumentTypeHierTextByKeyFluentHelper
    extends
    FluentHelperByKey<DocumentTypeHierTextByKeyFluentHelper, DocumentTypeHierText, DocumentTypeHierTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.DocumentTypeHierText
     * DocumentTypeHierText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param consolidationDocTypeHierarchy
     *            Hierarchy ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code DocumentTypeHierText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code DocumentTypeHierText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param validityEndDate
     *            Valid To Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param hierarchyNode
     *            Hierarchy node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     */
    public DocumentTypeHierTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String language,
        final String consolidationDocTypeHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate )
    {
        super(servicePath, entityCollection);
        this.key.put("Language", language);
        this.key.put("ConsolidationDocTypeHierarchy", consolidationDocTypeHierarchy);
        this.key.put("HierarchyNode", hierarchyNode);
        this.key.put("ValidityEndDate", validityEndDate);
    }

    @Override
    @Nonnull
    protected Class<DocumentTypeHierText> getEntityClass()
    {
        return DocumentTypeHierText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
